/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.web.loan;

import java.util.EventObject;
import java.util.HashSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.common.PayerTypeEnum;
import kd.fi.er.common.ShowPageUtils;
import org.apache.commons.lang3.StringUtils;

public class LoanBiillAdvancePlugin
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryentity = (EntryGrid)this.getView().getControl("expenseentryentity");
        entryentity.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshRepaymentDate();
    }

    private void refreshRepaymentDate() {
        this.getModel().setValue("repaymentdate", (Object)CoreBaseBillServiceHelper.computeRepaymentDate((IDataModel)this.getModel()));
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String key = hyperLinkClickEvent.getFieldName();
        if ("applybillno".equals(key)) {
            int index = hyperLinkClickEvent.getRowIndex();
            String applybillno = (String)this.getModel().getValue("applybillno", index);
            if ("0".equals(applybillno)) {
                return;
            }
            QFilter[] filters = new QFilter[]{new QFilter("billno", "=", (Object)applybillno)};
            DynamicObject dailyloanbill = QueryServiceHelper.queryOne((String)"er_dailyapplybill", (String)"id", (QFilter[])filters);
            if (dailyloanbill != null) {
                Object pkValue = dailyloanbill.get("id");
                ShowPageUtils.openLinkedForm((Object)pkValue, (String)"er_dailyapplybill", (IFormView)this.getView());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "payertype": {
                this.setAdvanceTypeByAccPayerType();
                break;
            }
            case "expenseitem": {
                ChangeData[] valueSet = e.getChangeSet();
                Object propValue = valueSet[0].getNewValue();
                int rowIndex = valueSet[0].getRowIndex();
                String description = (String)this.getModel().getValue("description");
                if (!StringUtils.isEmpty((CharSequence)description) && !StringUtils.isBlank((CharSequence)description) || propValue == null || rowIndex != 0) break;
                String reimburseDiscription = ((DynamicObject)propValue).getString("reimbursediscription");
                this.getModel().setValue("description", (Object)reimburseDiscription);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((FormOperate)args.getSource()).getOperateKey()) {
            case "save": 
            case "submit": {
                this.setAdvanceTypeByAccPayerType();
            }
        }
    }

    private void setAdvanceTypeByAccPayerType() {
        DynamicObjectCollection accountEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("accountentry");
        HashSet<String> payerTypeSet = new HashSet<String>();
        payerTypeSet.add(PayerTypeEnum.PAYER.getType());
        payerTypeSet.add(PayerTypeEnum.OTHER.getType());
        int noAdvanceLength = payerTypeSet.size();
        for (DynamicObject accEntry : accountEntrys) {
            String payerType = accEntry.getString("payertype");
            if (payerType == null) continue;
            payerTypeSet.add(payerType);
        }
        if (payerTypeSet.size() > noAdvanceLength) {
            this.getModel().setValue("isadvance", (Object)true);
        } else {
            this.getModel().setValue("isadvance", (Object)false);
        }
    }
}

