/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.entryimport.datahandle;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.TextAreaProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.ComboEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.formplugin.budget.BudgetCommonUtil;
import org.apache.commons.lang3.StringUtils;

public class AbstractEntryModelDataHandler {
    private static final Log logger = LogFactory.getLog(AbstractEntryModelDataHandler.class);
    private String entryId = "";

    public AbstractEntryModelDataHandler(String entryId) {
        this.entryId = entryId;
    }

    public String getEntryId() {
        return this.entryId;
    }

    public void setEntryId(String entryId) {
        this.entryId = entryId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEntryData(IDataModel model, IFormView view, IPageCache pageCache, Map<String, Object> returnData) {
        String imptMethod = (String)returnData.get("imptmethod");
        this.imptMethod(model, imptMethod);
        List rowDatas = (List)returnData.get("rowDatas");
        Boolean isQueryBudgetFlag = BudgetCommonUtil.getIsQueryBudgetFlag(pageCache);
        BudgetCommonUtil.setIsQueryBudgetFlag(pageCache, false);
        ErCommonUtils.setIsBatchExcelImportExpenseEnry((IPageCache)pageCache, (boolean)true);
        StringBuilder errorInfo = new StringBuilder();
        for (int rowNum = 0; rowNum < rowDatas.size(); ++rowNum) {
            Map row = (Map)rowDatas.get(rowNum);
            if (rowNum == rowDatas.size() - 1) {
                ErCommonUtils.setIsBatchExcelImportExpenseEnry((IPageCache)pageCache, (boolean)false);
            }
            int rowIndex = model.createNewEntryRow(this.getEntryId());
            try {
                row.forEach((key, value) -> {
                    if (StringUtils.isBlank((CharSequence)value)) {
                        return;
                    }
                    this.setColumnData(row, rowIndex, (String)key, model, view, errorInfo);
                    this.setColumnData(row, rowIndex, 0, (String)key, model, view, errorInfo);
                });
            }
            catch (Exception e) {
                if (!this.getEntryId().isEmpty() && rowIndex < this.getEntryId().length()) {
                    model.deleteEntryRow(this.getEntryId(), rowIndex);
                }
                errorInfo.append(ResManager.loadKDString((String)"\u7b2c", (String)"AbstractEntryModelDataHandler_0", (String)"fi-er-formplugin", (Object[])new Object[0])).append((String)row.get("excelrow")).append(ResManager.loadKDString((String)"\u884c: ", (String)"AbstractEntryModelDataHandler_1", (String)"fi-er-formplugin", (Object[])new Object[0])).append(e.getMessage() == null ? e.toString() : e.getMessage()).append("\n");
                logger.info("EntryImport >> \u6570\u636e\u5bfc\u5165\u5b58\u5728\u5f02\u5e38 >> " + e);
            }
            finally {
                if (!"".equals(errorInfo.toString())) {
                    view.getPageCache().put("task_error", errorInfo.toString());
                }
            }
            if (rowNum % 3 != 1) continue;
            view.getPageCache().put("task_percent", String.valueOf(((float)rowNum - 1.0f) / (float)rowDatas.size() * 100.0f).replaceAll("\\.[0-9]*", ""));
        }
        if (!"".equals(errorInfo.toString())) {
            view.getPageCache().put("task_error", errorInfo.toString());
        }
        ErCommonUtils.setIsBatchExcelImportExpenseEnry((IPageCache)pageCache, (boolean)false);
        BudgetCommonUtil.setIsQueryBudgetFlag(pageCache, isQueryBudgetFlag);
        if (isQueryBudgetFlag.booleanValue()) {
            BudgetCommonUtil.buildBudgetAmountField(view);
        }
    }

    protected void imptMethod(IDataModel model, String imptMethod) {
        if (StringUtils.equals((CharSequence)"cover", (CharSequence)imptMethod)) {
            model.deleteEntryData(this.getEntryId());
        }
    }

    public void setColumnData(Map<String, String> row, int rowIndex, int parentIndex, String key, IDataModel model, IFormView view, StringBuilder errorInfo) {
    }

    public void setColumnData(Map<String, String> row, int rowIndex, String key, IDataModel model, IFormView view, StringBuilder errorInfo) {
        String value = row.get(key);
        String excelKey = key;
        if (StringUtils.isEmpty((CharSequence)value) || key.contains(".name")) {
            return;
        }
        if (key.endsWith(".id")) {
            int parentIndex = this.getEntryId().equals("entryentity") && model.getProperty("tripentry") != null ? model.getEntryCurrentRowIndex("tripentry") : -1;
            model.setValue(key.replace(".id", ""), (Object)value, rowIndex, parentIndex);
            return;
        }
        IDataEntityProperty property = model.getProperty(key = key.replace(".number", ""));
        if (property == null) {
            return;
        }
        this.dealWithPropType(row, rowIndex, excelKey, model, view, errorInfo, property);
    }

    protected void dealWithPropType(Map<String, String> row, int rowIndex, String key, IDataModel model, IFormView view, StringBuilder errorInfo, IDataEntityProperty property) {
        int parentIndex;
        String value = row.get(key);
        if (StringUtils.isEmpty((CharSequence)value) || key.contains(".name")) {
            return;
        }
        int n = parentIndex = this.getEntryId().equals("entryentity") && model.getProperty("tripentry") != null ? model.getEntryCurrentRowIndex("tripentry") : -1;
        if (key.endsWith(".id")) {
            model.setValue(key.replace(".id", ""), (Object)value, rowIndex, parentIndex);
            return;
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"sharemethod")) {
            return;
        }
        key = key.replace(".number", "");
        logger.info("---key---value---index---" + key + "," + value + "," + rowIndex);
        if (property instanceof TextAreaProp || "payterms".equals(key)) {
            Object text = null;
            text = "payterms".equals(key) ? (TextProp)property : (TextAreaProp)property;
            if (text.getMaxLenth() > 0 && value.length() > text.getMaxLenth()) {
                String tip = ResManager.loadKDString((String)"\u884c: \"%1$s\" \u5b57\u6bb5\u6570\u636e\u8d85\u51fa\u6700\u5927\u9650\u5236, \u5df2\u622a\u53d6\u6709\u6548\u90e8\u5206\u3002", (String)"AbstractEntryModelDataHandler_11", (String)"fi-er-formplugin", (Object[])new Object[0]);
                errorInfo.append(ResManager.loadKDString((String)"\u7b2c", (String)"AbstractEntryModelDataHandler_0", (String)"fi-er-formplugin", (Object[])new Object[0])).append(row.get("excelrow")).append(String.format(tip, property.getDisplayName().getLocaleValue())).append("\n");
                value = value.substring(0, text.getMaxLenth());
            }
            model.setValue(key, (Object)value, rowIndex, parentIndex);
        } else if (property instanceof ItemClassProp) {
            DynamicObject classItemBaseDataDym;
            ItemClassProp itemClassProp = (ItemClassProp)property;
            String typePropName = itemClassProp.getTypePropName();
            String dataType = row.get(typePropName);
            String dataTypeNumber = "";
            ItemClassTypeProp typeProp = (ItemClassTypeProp)model.getProperty(typePropName);
            List comboItems = typeProp.getComboItems();
            for (ValueMapItem item : comboItems) {
                if (!StringUtils.equals((CharSequence)dataType, (CharSequence)item.getName().getLocaleValue())) continue;
                dataTypeNumber = item.getValue();
                model.setValue(typePropName, (Object)item.getValue(), rowIndex, parentIndex);
                break;
            }
            String numberProperty = "number";
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)dataTypeNumber);
            if (dataEntityType instanceof BasedataEntityType) {
                numberProperty = ((BasedataEntityType)dataEntityType).getNumberProperty();
            }
            if ((classItemBaseDataDym = BusinessDataServiceHelper.loadSingleFromCache((String)dataTypeNumber, (String)"id", (QFilter[])new QFilter(numberProperty, "=", (Object)value).toArray())) != null) {
                model.setValue(key, classItemBaseDataDym.get("id"), rowIndex, parentIndex);
            } else {
                model.setItemValueByNumber(key, value, rowIndex);
            }
        } else if (property instanceof BasedataProp || property instanceof CurrencyProp) {
            QFilter qFilter = QFilter.of((String)"number=?", (Object[])new Object[]{value});
            BasedataProp baseProp = (BasedataProp)property;
            if (baseProp.getBaseEntityId().equals("er_tripexpenseitem")) {
                Object company = model.getValue("company");
                Long pk = ErCommonUtils.getPk((Object)company);
                Map queryDynamicObjectMap = BaseDataServiceHelper.queryBaseDataFromCache((String)"er_tripexpenseitem", (Long)pk, (QFilter)qFilter, (String)"id,number");
                if (queryDynamicObjectMap != null && !queryDynamicObjectMap.values().isEmpty()) {
                    model.setValue(key, ((DynamicObject)queryDynamicObjectMap.values().stream().findFirst().get()).get("id"), rowIndex, parentIndex);
                } else {
                    model.setItemValueByNumber(key, value, rowIndex);
                }
            } else if (baseProp.getBaseEntityId().equals("er_expenseitemedit")) {
                Object costcompany = model.getValue("costcompany");
                Long pk = ErCommonUtils.getPk((Object)costcompany);
                Map queryDynamicObjectMap = BaseDataServiceHelper.queryBaseDataFromCache((String)"er_expenseitemedit", (Long)pk, (QFilter)qFilter, (String)"id,number");
                if (queryDynamicObjectMap != null && !queryDynamicObjectMap.values().isEmpty()) {
                    model.setValue(key, ((DynamicObject)queryDynamicObjectMap.values().stream().findFirst().get()).get("id"), rowIndex, parentIndex);
                } else {
                    model.setItemValueByNumber(key, value, rowIndex);
                }
            } else {
                DynamicObject basedataDOFromCache = BusinessDataServiceHelper.loadSingleFromCache((String)baseProp.getBaseEntityId(), (String)"id", (QFilter[])new QFilter[]{qFilter});
                if (basedataDOFromCache != null) {
                    model.setValue(key, basedataDOFromCache.get("id"), rowIndex, parentIndex);
                } else {
                    model.setItemValueByNumber(key, value, rowIndex);
                }
            }
        } else if (property instanceof BooleanProp) {
            if ("\u662f".equals(value)) {
                model.setValue(key, (Object)Boolean.TRUE, rowIndex, parentIndex);
            } else {
                model.setValue(key, (Object)Boolean.FALSE, rowIndex, parentIndex);
            }
        } else if (property instanceof ComboProp) {
            ComboEdit type = (ComboEdit)view.getControl(key);
            ComboProp itemProp = (ComboProp)type.getProperty();
            List comboItems = itemProp.getComboItems();
            for (ValueMapItem item : comboItems) {
                if (!StringUtils.equals((CharSequence)value, (CharSequence)item.getName().getLocaleValue())) continue;
                model.setValue(key, (Object)item.getValue(), rowIndex, parentIndex);
                return;
            }
        } else if (property instanceof AmountProp || property instanceof DecimalProp) {
            BigDecimal amount = new BigDecimal(value);
            logger.info("---amount---index---" + amount + "," + rowIndex);
            model.setValue(key, (Object)amount, rowIndex, parentIndex);
            logger.info("---after set amount value---index---" + model.getValue(key, rowIndex, parentIndex) + "," + rowIndex);
        } else {
            model.setValue(key, (Object)value, rowIndex, parentIndex);
        }
        logger.info("---after set value---index---" + model.getValue(key, rowIndex, parentIndex) + "," + rowIndex);
    }
}

