/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.entryimport.datahandle;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.ExpenseItemServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErOrgUtils;
import kd.fi.er.formplugin.budget.BudgetCommonUtil;
import kd.fi.er.formplugin.entryimport.datahandle.AbstractEntryModelDataHandler;
import kd.fi.er.opplugin.daily.web.importplugin.utils.ImportUtils;
import org.apache.commons.lang3.StringUtils;

public class ExpenseEntryImportDataHandler
extends AbstractEntryModelDataHandler {
    private static final Log logger = LogFactory.getLog(ExpenseEntryImportDataHandler.class);
    private static final String ALGO = ExpenseItemServiceHelper.class.getName();

    public ExpenseEntryImportDataHandler() {
        super("expenseentryentity");
    }

    @Override
    public void setEntryData(IDataModel model, IFormView view, IPageCache pageCache, Map<String, Object> returnData) {
        Boolean isCurrency;
        Object imptMethod;
        Long forStart = System.currentTimeMillis();
        String billFormId = model.getDataEntityType().getName();
        if (ErEntityTypeUtils.isDailyLoanBill((String)billFormId)) {
            // empty if block
        }
        if ((imptMethod = returnData.get("imptmethod")) != null && "cover".equals(imptMethod)) {
            ArrayList<IDataEntityProperty> entries = new ArrayList<IDataEntityProperty>();
            entries.add(model.getProperty("expenseentryentity"));
            entries.add(model.getProperty("invoiceentry"));
            entries.add(model.getProperty("invoicemerge"));
            entries.add(model.getProperty("invoiceitementry"));
            for (IDataEntityProperty entry : entries) {
                if (entry == null) continue;
                model.deleteEntryData(entry.getName());
            }
        }
        IDataEntityProperty showType = model.getProperty("expensesassumeshowtypes");
        String compayShowType = "1";
        if (showType != null) {
            compayShowType = CommonServiceHelper.getBillCostOrgShowType((IFormView)view);
        }
        if ((isCurrency = (Boolean)model.getValue("iscurrency")) == null) {
            isCurrency = Boolean.FALSE;
        }
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        String currencyNum = "-1";
        if (currency != null) {
            currencyNum = currency.getString("number");
        }
        List rowDatas = (List)returnData.get("rowDatas");
        Boolean isQueryBudgetFlag = BudgetCommonUtil.getIsQueryBudgetFlag(pageCache);
        BudgetCommonUtil.setIsQueryBudgetFlag(pageCache, false);
        ErCommonUtils.setIsBatchExcelImportExpenseEnry((IPageCache)pageCache, (boolean)true);
        StringBuilder errorInfo = new StringBuilder();
        StringBuilder tipBuild = new StringBuilder();
        Map<Object, List<Map>> collect = rowDatas.stream().filter(item -> item.get("reimburser.number") != null).collect(Collectors.groupingBy(item -> (String)item.get("reimburser.number")));
        if (ErEntityTypeUtils.isContractBill((String)billFormId)) {
            BigDecimal prorataamount = null;
            if (!((Boolean)model.getValue("paybyrata")).booleanValue() && ((Map)rowDatas.get(0)).get("prorataamount") != null) {
                prorataamount = new BigDecimal((String)((Map)rowDatas.get(0)).get("prorataamount"));
                model.setValue("prorataamount", (Object)prorataamount);
                model.setValue("paybyrata", (Object)Boolean.TRUE);
            }
            if (!((Boolean)model.getValue("paybyrata")).booleanValue() && rowDatas.stream().anyMatch(item -> item.get("paypercent") != null)) {
                model.setValue("paybyrata", (Object)Boolean.TRUE);
            }
        }
        Map<String, Long> costDeptMap = this.buildCostDeptMap(rowDatas);
        Map<Long, Set<Long>> costDepAdminOrgRelationMap = this.buildCostDepAdminOrgReltionMap(costDeptMap);
        Map<Long, Set<Long>> depExpItemRelationMap = new HashMap<Long, Set<Long>>();
        Map firstRow = (Map)rowDatas.get(0);
        HashMap<String, Long> existsWLUnit = null;
        ArrayList<String> existsProductType = null;
        Map<Object, Object> nameTblMap = new HashMap();
        Map<String, Long> companyIdMap = null;
        if (ErEntityTypeUtils.isWithholdingBill((String)view.getEntityId()) || ErEntityTypeUtils.isCostEstimateBill((String)view.getEntityId())) {
            existsWLUnit = new HashMap<String, Long>();
            existsProductType = new ArrayList<String>();
            MainEntityType type = MetadataServiceHelper.getDataEntityType((String)view.getEntityId());
            ComboProp ComboProp2 = (ComboProp)type.findProperty("entrywltype");
            List comboItems = ComboProp2.getComboItems();
            nameTblMap = comboItems.stream().collect(Collectors.toMap(vi -> vi.getName().getLocaleValue(), vi -> vi.getValue()));
            Map<String, String> tblNameMap = comboItems.stream().collect(Collectors.toMap(vi -> vi.getValue(), vi -> vi.getName().getLocaleValue()));
            DynamicObject headCompany = (DynamicObject)model.getValue("costcompany");
            Map<Object, Object> finalNameTblMap = nameTblMap;
            BiFunction<Map, String, String> keyGetter = (item, which) -> {
                String lineCompany = (String)item.get("entrycostcompany.number");
                if (StringUtils.isBlank((CharSequence)lineCompany)) {
                    lineCompany = headCompany.getString("number");
                }
                if (which.equals("wl")) {
                    String tblName = (String)finalNameTblMap.get(item.get("entrywltype"));
                    return String.format("%1$s=%2$s", tblName, lineCompany);
                }
                if (which.equals("productType")) {
                    return lineCompany;
                }
                return lineCompany;
            };
            Map wlGroup = rowDatas.stream().filter(item -> StringUtils.isNotBlank((CharSequence)((CharSequence)item.get("entrywltype"))) && finalNameTblMap.containsKey(item.get("entrywltype")) && StringUtils.isNotBlank((CharSequence)((CharSequence)item.get("entrywlunit.number")))).collect(Collectors.groupingBy(item -> (String)keyGetter.apply((Map)item, "wl"), Collectors.mapping(item -> (String)item.get("entrywlunit.number"), Collectors.toSet())));
            Map productTypeGroup = rowDatas.stream().filter(item -> StringUtils.isNotBlank((CharSequence)((CharSequence)item.get("entryproducttype.number")))).collect(Collectors.groupingBy(item -> (String)keyGetter.apply((Map)item, "productType"), Collectors.mapping(item -> (String)item.get("entryproducttype.number"), Collectors.toSet())));
            Set companyNums = rowDatas.stream().filter(item -> StringUtils.isNotBlank((CharSequence)((CharSequence)item.get("entrycostcompany.number")))).map(item -> (String)item.get("entrycostcompany.number")).collect(Collectors.toSet());
            companyNums.add(headCompany.getString("number"));
            Map companysDyn = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("number", "in", companyNums)});
            companyIdMap = companysDyn.values().stream().collect(Collectors.toMap(item -> item.getString("number"), item -> ErCommonUtils.getPk((Object)item)));
            for (Map.Entry entry : wlGroup.entrySet()) {
                String entrywltype = entry.getKey();
                String[] keys = entrywltype.split("=");
                String wlType = keys[0];
                String companyNum = entrywltype.replace(wlType + "=", "");
                QFilter rangFilter = BaseDataServiceHelper.getBaseDataFilter((String)wlType, (Long)companyIdMap.get(companyNum));
                Map existsWL = BusinessDataServiceHelper.loadFromCache((String)wlType, (String)"id, number", (QFilter[])new QFilter[]{new QFilter("status", "=", (Object)"C"), new QFilter("number", "in", entry.getValue()), new QFilter("enable", "=", (Object)true), rangFilter});
                for (DynamicObject item2 : existsWL.values()) {
                    existsWLUnit.put(String.format("%1$s%2$s", tblNameMap.get(wlType), item2.getString("number")), ErCommonUtils.getPk((Object)item2));
                }
            }
            for (Map.Entry entry : productTypeGroup.entrySet()) {
                String company = entry.getKey();
                QFilter rangFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)companyIdMap.get(company));
                Map exists = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("number", "in", entry.getValue()), new QFilter("enable", "=", (Object)true), rangFilter});
                for (DynamicObject item3 : exists.values()) {
                    existsProductType.add(item3.getString("number"));
                }
            }
        }
        int rowPatchHandleIndex = 50;
        for (int rowNum = 0; rowNum < rowDatas.size(); ++rowNum) {
            depExpItemRelationMap = this.buildPatchDepExpItemRelationMapForSpeed(rowDatas, costDeptMap, costDepAdminOrgRelationMap, depExpItemRelationMap, rowPatchHandleIndex, rowNum);
            Map row = (Map)rowDatas.get(rowNum);
            String entryCurrency = (String)row.get("entrycurrency.number");
            Long oldCurrency = ErCommonUtils.getPk((Object)model.getValue("currency"));
            if (!(isCurrency.booleanValue() || entryCurrency == null || "".equals(entryCurrency.trim()) || entryCurrency.equals(currencyNum))) {
                model.setValue("iscurrency", (Object)Boolean.TRUE);
                isCurrency = Boolean.TRUE;
            }
            if (rowNum == rowDatas.size() - 1) {
                ErCommonUtils.setIsBatchExcelImportExpenseEnry((IPageCache)pageCache, (boolean)false);
            }
            if (ErEntityTypeUtils.isDailyReimburseBill((String)view.getEntityId()) && StringUtils.isNotEmpty((CharSequence)((CharSequence)row.get("reimburser.number"))) || ErEntityTypeUtils.isPublicReimburseBill((String)view.getEntityId()) && StringUtils.isNotEmpty((CharSequence)((CharSequence)row.get("pubreimburser.number")))) {
                DynamicObject company = model.getDataEntity().getDynamicObject("company");
                DynamicObject reimburser = null;
                reimburser = ErEntityTypeUtils.isDailyReimburseBill((String)view.getEntityId()) ? ImportUtils.getUserByNumber((String)((String)row.get("reimburser.number"))) : ImportUtils.getUserByNumber((String)((String)row.get("pubreimburser.number")));
                if (reimburser == null) {
                    errorInfo.append(ResManager.loadKDString((String)"\u7b2c", (String)"ExpenseEntryImportDataHandler_0", (String)"fi-er-formplugin", (Object[])new Object[0])).append((String)row.get("excelrow")).append(ResManager.loadKDString((String)"\u884c: ", (String)"ExpenseEntryImportDataHandler_9", (String)"fi-er-formplugin", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u62a5\u9500\u4eba\u4e0d\u5b58\u5728", (String)"ExpenseEntryImportDataHandler_21", (String)"fi-er-formplugin", (Object[])new Object[0])).append("\n");
                    break;
                }
                if (model.getDataEntity().get("applier") != null) {
                    DynamicObject applier = model.getDataEntity().getDynamicObject("applier");
                    if (ErEntityTypeUtils.isPublicReimburseBill((String)view.getEntityId())) {
                        collect = rowDatas.stream().filter(item -> item.get("pubreimburser.number") != null).collect(Collectors.groupingBy(item -> (String)item.get("pubreimburser.number")));
                    }
                    if (collect.size() > 1 || collect.get(applier.get("number")) == null) {
                        model.setValue("ismultireimburser", (Object)true);
                    }
                }
                if (company != null) {
                    String value = (String)ErCommonUtils.getEMParameter((long)((Long)company.getPkValue()), (String)"scopeofmultireimburser");
                    Boolean hacontine = true;
                    DynamicObjectCollection entryentity = reimburser.getDynamicObjectCollection("entryentity");
                    if ("0".equals(value)) {
                        DynamicObject org = model.getDataEntity().getDynamicObject("org");
                        if (org != null) {
                            for (DynamicObject item4 : entryentity) {
                                if (!org.get("number").equals(item4.getDynamicObject("dpt").get("number"))) continue;
                                hacontine = false;
                            }
                        }
                        if (hacontine.booleanValue()) {
                            errorInfo.append(ResManager.loadKDString((String)"\u7b2c", (String)"ExpenseEntryImportDataHandler_0", (String)"fi-er-formplugin", (Object[])new Object[0])).append((String)row.get("excelrow")).append(ResManager.loadKDString((String)"\u884c: ", (String)"ExpenseEntryImportDataHandler_9", (String)"fi-er-formplugin", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u5f53\u591a\u62a5\u9500\u5355\u9009\u62e9\u8303\u56f4\u4e3a\u201c\u672c\u90e8\u95e8\u201d\u65f6\uff0c\u4e0d\u5e94\u5bfc\u5165\u975e\u672c\u90e8\u95e8\u4eba\u5458\uff0c\u5bfc\u5165\u7684\u62a5\u9500\u4eba\u4e0d\u5728\u9009\u62e9\u8303\u56f4\u5185\u3002", (String)"ExpenseEntryImportDataHandler_22", (String)"fi-er-formplugin", (Object[])new Object[0])).append("\n");
                            break;
                        }
                    }
                    if ("1".equals(value)) {
                        List allOrgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)1L, Collections.singletonList((Long)company.getPkValue()), (boolean)true);
                        for (DynamicObject item4 : entryentity) {
                            DynamicObject dept = item4.getDynamicObject("dpt");
                            if (!allOrgList.contains(dept.getLong("masterid"))) continue;
                            hacontine = false;
                        }
                        if (hacontine.booleanValue()) {
                            errorInfo.append(ResManager.loadKDString((String)"\u7b2c", (String)"ExpenseEntryImportDataHandler_0", (String)"fi-er-formplugin", (Object[])new Object[0])).append((String)row.get("excelrow")).append(ResManager.loadKDString((String)"\u884c: ", (String)"ExpenseEntryImportDataHandler_9", (String)"fi-er-formplugin", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u5f53\u591a\u62a5\u9500\u5355\u9009\u62e9\u8303\u56f4\u4e3a\u201c\u672c\u516c\u53f8\u201d\u65f6\uff0c\u4e0d\u5e94\u8be5\u5bfc\u5165\u975e\u672c\u516c\u53f8\u4eba\u5458\uff0c\u5bfc\u5165\u7684\u62a5\u9500\u4eba\u4e0d\u5728\u9009\u62e9\u8303\u56f4\u5185\u3002", (String)"ExpenseEntryImportDataHandler_23", (String)"fi-er-formplugin", (Object[])new Object[0])).append("\n");
                            break;
                        }
                    }
                }
            }
            int rowIndex = model.createNewEntryRow("expenseentryentity");
            IDataEntityProperty itemFrom = model.getProperty("itemfrom");
            if (itemFrom != null) {
                model.setValue("itemfrom", (Object)"4", rowIndex);
            }
            if (null != existsProductType && row.containsKey("entryproducttype.number") && StringUtils.isNotBlank((CharSequence)((CharSequence)row.get("entryproducttype.number"))) && !existsProductType.contains(row.get("entryproducttype.number"))) {
                tipBuild.append(ResManager.loadKDString((String)"\u7269\u6599", (String)"ExpenseEntryExcelDataHandler_13", (String)"fi-er-formplugin", (Object[])new Object[0])).append((String)row.get("entryproducttype.number")).append(ResManager.loadKDString((String)"\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\u3002", (String)"ExpenseEntryExcelDataHandler_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
                this.concatErrorMsg(errorInfo, row, tipBuild);
                if (model.getEntryRowCount("expenseentryentity") <= rowIndex) continue;
                model.deleteEntryRow("expenseentryentity", rowIndex);
                continue;
            }
            String exceptionkey = "";
            String exceptionValue = "";
            try {
                List keys = row.keySet().stream().filter(item -> !StringUtils.equalsAny((CharSequence)item, (CharSequence[])new CharSequence[]{"deductibletax", "entrycostdept.number", "paypercent", "entrycostcompany.number", "entrywlunit.number", "entrywltype"})).collect(Collectors.toList());
                if (row.containsKey("entrywlunit.number")) {
                    keys.add(0, "entrywlunit.number");
                }
                if (row.containsKey("entrywltype")) {
                    keys.add(0, "entrywltype");
                }
                if (row.containsKey("entrycostcompany.number")) {
                    keys.add(0, "entrycostcompany.number");
                }
                if (row.containsKey("paypercent")) {
                    keys.add(0, "paypercent");
                }
                if (row.containsKey("entrycostdept.number")) {
                    keys.add(0, "entrycostdept.number");
                }
                if (row.containsKey("deductibletax")) {
                    keys.add("deductibletax");
                }
                for (int i = 0; i < keys.size(); ++i) {
                    String key = (String)keys.get(i);
                    String value = (String)row.get(key);
                    try {
                        QFilter qf;
                        BasedataProp baseProp;
                        BigDecimal taxrateValue;
                        BigDecimal paypercentValue;
                        if (StringUtils.isBlank((CharSequence)value) || value.contains(".name") || "expenseamount".equals(key) && "er_contractbill".equals(billFormId) && ((Boolean)model.getValue("paybyrata")).booleanValue()) continue;
                        if (key.contains(".number")) {
                            key = key.replace(".number", "");
                        }
                        if ("entrycostdept".equals(key) && "1".equals(compayShowType) || "entrycurrency".equals(key) && !isCurrency.booleanValue() || "exchangerate".equals(key) && (!isCurrency.booleanValue() || currencyNum.equals(row.get("entrycurrency.number")))) continue;
                        if ("paypercent".equals(key) && ((paypercentValue = new BigDecimal(value)).compareTo(BigDecimal.ZERO) < 0 || paypercentValue.compareTo(new BigDecimal("100")) > 0)) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6bd4\u4f8b\u8303\u56f40~100", (String)"ContractBillImportDataOp_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        }
                        if ("taxrate".equals(key) && ((taxrateValue = new BigDecimal(value)).compareTo(BigDecimal.ZERO) < 0 || taxrateValue.compareTo(new BigDecimal("100")) > 0)) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u7387\u8303\u56f40~100", (String)"ContractBillImportDataOp_2", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        }
                        if ("num".equals(key) && Integer.parseInt(value) <= 0) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u91cf\u8981\u22650", (String)"ContractBillImportDataOp_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        }
                        IDataEntityProperty property = model.getProperty(key);
                        if (property == null) continue;
                        QFilter qFCompany = new QFilter("number", "=", row.get("entrycostcompany.number"));
                        DynamicObject entrycostcompany = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{qFCompany});
                        if (entrycostcompany == null) {
                            entrycostcompany = (DynamicObject)model.getValue("costcompany");
                        }
                        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"std_project")) {
                            baseProp = (BasedataProp)property;
                            qf = QFilter.of((String)"number=?", (Object[])new Object[]{value}).and(QFilter.of((String)"isleaf=?", (Object[])new Object[]{Boolean.TRUE})).and("enable", "=", (Object)Boolean.TRUE);
                            qf.and(BaseDataServiceHelper.getBaseDataFilter((String)baseProp.getBaseEntityId(), (Long)((Long)entrycostcompany.getPkValue())));
                            DynamicObject basedataDOFromCache = BusinessDataServiceHelper.loadSingleFromCache((String)baseProp.getBaseEntityId(), (String)"id", (QFilter[])new QFilter[]{qf});
                            if (basedataDOFromCache == null) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u6b64\u9879\u76ee\u4e0d\u53ef\u7528", (String)"ContractBillImportDataOp_6", (String)"fi-er-opplugin", (Object[])new Object[0]));
                            }
                            model.beginInit();
                            model.setValue(key, basedataDOFromCache.get("id"), rowIndex);
                            model.endInit();
                            view.updateView(key, rowIndex);
                            continue;
                        }
                        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"expenseitem")) {
                            DynamicObject basedataDOFromCache;
                            List numbers;
                            DynamicObject projecttype;
                            baseProp = (BasedataProp)property;
                            qf = QFilter.of((String)"number=?", (Object[])new Object[]{value}).and(QFilter.of((String)"isleaf=?", (Object[])new Object[]{Boolean.TRUE})).and("enable", "=", (Object)Boolean.TRUE);
                            QFilter relBillFilter = ExpenseItemServiceHelper.getRelBillFilter((String)model.getDataEntityType().getName());
                            qf = qf.and(relBillFilter);
                            if (costDeptMap.containsKey(row.get("entrycostdept.number"))) {
                                Long entryCostDeptPK = costDeptMap.get(row.get("entrycostdept.number"));
                                ThreadCache.put((Object)"costDepAdminOrgRelationMap", costDepAdminOrgRelationMap);
                                ThreadCache.put((Object)"costDepExpItemRelationMap", depExpItemRelationMap);
                                QFilter relDeptFilter = ExpenseItemServiceHelper.getRelDeptFilter((Long)entryCostDeptPK);
                                qf = qf.and(relDeptFilter);
                            }
                            qf = qf.and(BaseDataServiceHelper.getBaseDataFilter((String)baseProp.getBaseEntityId(), (Long)((Long)entrycostcompany.getPkValue())));
                            if ((ErEntityTypeUtils.isContractBill((String)billFormId) || ErEntityTypeUtils.isCostEstimateBill((String)billFormId)) && (projecttype = (DynamicObject)model.getValue("projecttype")) != null && !(numbers = projecttype.getDynamicObjectCollection("entryentity").stream().map(a -> a.getLong("expenseitem.id")).collect(Collectors.toList())).isEmpty()) {
                                QFilter qFilter = new QFilter("id", "in", numbers);
                                qf = qf.and(qFilter);
                            }
                            if ((basedataDOFromCache = BusinessDataServiceHelper.loadSingleFromCache((String)baseProp.getBaseEntityId(), (String)"id,offset", (QFilter[])new QFilter[]{qf})) != null) {
                                model.beginInit();
                                model.setValue(key, basedataDOFromCache.get("id"), rowIndex);
                                model.endInit();
                                if (model.getProperty("offset") != null && StringUtils.isBlank((CharSequence)((CharSequence)row.get("offset")))) {
                                    model.setValue("offset", basedataDOFromCache.get("offset"), rowIndex);
                                }
                            } else {
                                throw new KDBizException(ResManager.loadKDString((String)"\u6b64\u8d39\u7528\u9879\u76ee\u4e0d\u53ef\u7528\u3002", (String)"ContractBillImportDataOp_5", (String)"fi-er-opplugin", (Object[])new Object[0]));
                            }
                            view.updateView(key, rowIndex);
                            continue;
                        }
                        if (property instanceof BasedataProp) {
                            if (null != existsWLUnit && key.equals("entrywlunit")) {
                                String typeName = (String)row.get("entrywltype");
                                String num = (String)row.get("entrywlunit.number");
                                String wlkey = String.format("%1$s%2$s", typeName, num);
                                if (StringUtils.isNotBlank((CharSequence)typeName) && null != nameTblMap && !nameTblMap.containsKey(typeName)) {
                                    this.concatErrorMsg(errorInfo, row, ResManager.loadKDString((String)"\u5f80\u6765\u7c7b\u578b\u4e0d\u6b63\u786e\u3002", (String)"PubReimburseBillInitImportHandle_03", (String)"fi-er-opplugin", (Object[])new Object[0]));
                                    if (model.getEntryRowCount("expenseentryentity") > rowIndex) {
                                        model.deleteEntryRow("expenseentryentity", rowIndex);
                                    }
                                    break;
                                }
                                if (!existsWLUnit.containsKey(wlkey)) {
                                    this.concatErrorMsg(errorInfo, row, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s\u7684%2$s\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\u3002", (String)"ContractBillImportDataOp_7", (String)"fi-er-opplugin", (Object[])new Object[0]), num, typeName));
                                    if (model.getEntryRowCount("expenseentryentity") > rowIndex) {
                                        model.deleteEntryRow("expenseentryentity", rowIndex);
                                    }
                                    break;
                                }
                                model.setValue(key, existsWLUnit.get(wlkey), rowIndex);
                                continue;
                            }
                            baseProp = (BasedataProp)property;
                            DynamicObject basedataDOFromCache = BusinessDataServiceHelper.loadSingleFromCache((String)baseProp.getBaseEntityId(), (String)"id", (QFilter[])new QFilter[]{QFilter.of((String)"number=?", (Object[])new Object[]{value})});
                            if (basedataDOFromCache != null) {
                                QFilter qFDept;
                                DynamicObject entrycostdept;
                                Long companyId = ErCommonUtils.getPk((Object)model.getValue("company"));
                                if (key.equals("entrycostdept")) {
                                    String msg;
                                    if (null != companyIdMap && null != companyIdMap.get(row.get("entrycostcompany.number"))) {
                                        ThreadCache.put((Object)"entrycostcompany.number", (Object)companyIdMap.get(row.get("entrycostcompany.number")));
                                    }
                                    if (!StringUtils.isEmpty((CharSequence)(msg = ImportUtils.checkCostDeptSelectInRange((long)ErCommonUtils.getPk((Object)model.getValue("applier")), (long)ErCommonUtils.getPk((Object)model.getValue("company")), (long)((Long)basedataDOFromCache.get("id")))))) {
                                        throw new KDBizException(msg);
                                    }
                                }
                                if (key.equals("entrycostcompany") && StringUtils.isNotBlank((CharSequence)value) && null != (entrycostdept = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{qFDept = new QFilter("number", "=", row.get("entrycostdept.number"))}))) {
                                    List costcompanyNumbers = ErOrgUtils.getCostCompanySelectable((Long)((Long)entrycostdept.get("id")), (Long)companyId);
                                    Object costCompanyScope = ErCommonUtils.getEMParameter((long)companyId, (String)"enablecostcompanyedit");
                                    if (!costcompanyNumbers.contains(value) && null != costCompanyScope && !costCompanyScope.toString().equals("2")) {
                                        String enablecostcompanyedit = costCompanyScope.toString();
                                        if ("0".equals(costCompanyScope)) {
                                            enablecostcompanyedit = ResManager.loadKDString((String)"\u4e0d\u53ef\u4fee\u6539", (String)"ContractBillImportDataOp_12", (String)"fi-er-formplugin", (Object[])new Object[0]);
                                        } else if ("1".equals(costCompanyScope)) {
                                            enablecostcompanyedit = ResManager.loadKDString((String)"\u59d4\u6258\u8303\u56f4\u5185\u4fee\u6539", (String)"ContractBillImportDataOp_13", (String)"fi-er-formplugin", (Object[])new Object[0]);
                                        }
                                        String msg = ErEntityTypeUtils.isCostEstimateBill((String)view.getEntityId()) ? String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6838\u7b97\u7ec4\u7ec7\u201c%s\u201d\u4e0d\u5728\u9009\u62e9\u8303\u56f4\u5185\u3002", (String)"ContractBillImportDataOp_10", (String)"fi-er-formplugin", (Object[])new Object[0]), enablecostcompanyedit) : String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u8d39\u7528\u627f\u62c5\u516c\u53f8\u201c%s\u201d\u4e0d\u5728\u9009\u62e9\u8303\u56f4\u5185\u3002", (String)"ContractBillImportDataOp_11", (String)"fi-er-formplugin", (Object[])new Object[0]), enablecostcompanyedit);
                                        this.concatErrorMsg(errorInfo, row, msg);
                                        if (model.getEntryRowCount("expenseentryentity") > rowIndex) {
                                            model.deleteEntryRow("expenseentryentity", rowIndex);
                                        }
                                        break;
                                    }
                                }
                                model.setValue(key, basedataDOFromCache.get("id"), rowIndex);
                            } else {
                                model.setItemValueByNumber(key, value, rowIndex);
                            }
                        }
                        if (key.equals("entrycostdept") && rowIndex == 0) {
                            Long newCurrency = ErCommonUtils.getPk((Object)model.getValue("currency"));
                            if (oldCurrency.longValue() != newCurrency.longValue()) break;
                        }
                        if (key.equals("deductibletax")) {
                            model.setValue(key, (Object)(StringUtils.equals((CharSequence)"\u5426", (CharSequence)((CharSequence)row.get("offset"))) ? BigDecimal.ZERO : new BigDecimal((String)row.get(key))), rowIndex);
                            continue;
                        }
                        super.setColumnData(row, rowIndex, key, model, view, errorInfo);
                        continue;
                    }
                    catch (Exception e) {
                        exceptionkey = key;
                        exceptionValue = value;
                        throw e;
                    }
                }
            }
            catch (Exception e) {
                if (model.getEntryRowCount("expenseentryentity") > rowIndex) {
                    model.deleteEntryRow("expenseentryentity", rowIndex);
                }
                errorInfo.append(ResManager.loadKDString((String)"\u7b2c", (String)"ExpenseEntryImportDataHandler_0", (String)"fi-er-formplugin", (Object[])new Object[0])).append((String)row.get("excelrow")).append(ResManager.loadKDString((String)"\u884c: ", (String)"ExpenseEntryImportDataHandler_9", (String)"fi-er-formplugin", (Object[])new Object[0])).append(String.format(ResManager.loadKDString((String)"EXCEL\u6570\u636e\u5bfc\u5165\uff1a\u5b57\u6bb5\u201c%1$s\u201d\u7684\u503c\u201c%2$s\u201d\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\u3002", (String)"ExpenseEntryImportDataHandler_50", (String)"fi-er-formplugin", (Object[])new Object[0]), exceptionkey, exceptionValue)).append(e.getMessage() == null ? e.toString() : e.getMessage()).append("\n");
                logger.info("EntryImport >> \u6570\u636e\u5bfc\u5165\u5b58\u5728\u5f02\u5e38 >> ", (Object)e);
            }
            if (rowNum % 3 != 1) continue;
            view.getPageCache().put("task_percent", String.valueOf(((float)rowNum - 1.0f) / (float)rowDatas.size() * 100.0f).replaceAll("\\.[0-9]*", ""));
        }
        if (!"".equals(errorInfo.toString())) {
            view.getPageCache().put("task_error", errorInfo.toString());
        }
        ErCommonUtils.setIsBatchExcelImportExpenseEnry((IPageCache)pageCache, (boolean)false);
        BudgetCommonUtil.setIsQueryBudgetFlag(pageCache, isQueryBudgetFlag);
        if (isQueryBudgetFlag.booleanValue()) {
            BudgetCommonUtil.buildBudgetAmountField(view);
        }
        logger.info("\u8d39\u7528\u660e\u7ec6\u5206\u5f55\u5bfc\u5165\u7ed3\u675f>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:ms").format(new Date()));
    }

    private void concatErrorMsg(StringBuilder errorInfo, Map<String, String> row, Object tip) {
        String msg = tip.toString();
        errorInfo.append(ResManager.loadKDString((String)"\u7b2c", (String)"ExpenseEntryImportDataHandler_0", (String)"fi-er-formplugin", (Object[])new Object[0])).append(row.get("excelrow")).append(ResManager.loadKDString((String)"\u884c: ", (String)"ExpenseEntryImportDataHandler_9", (String)"fi-er-formplugin", (Object[])new Object[0])).append(msg).append("\r\n");
        if (tip instanceof StringBuilder) {
            ((StringBuilder)tip).setLength(0);
        }
    }

    private Map<Long, Set<Long>> buildPatchDepExpItemRelationMapForSpeed(List<Map<String, String>> rowDatas, Map<String, Long> costDeptMap, Map<Long, Set<Long>> costDepAdminOrgRelationMap, Map<Long, Set<Long>> depExpItemRelationMap, int rowPatchHandleIndex, int rowNum) {
        if (rowNum % rowPatchHandleIndex == 0) {
            int patchStartIndex = rowNum;
            int patchEndIndex = patchStartIndex + rowPatchHandleIndex;
            HashMap<Long, Set<Long>> patchCostDepAdminOrgRelationMap = new HashMap<Long, Set<Long>>();
            for (int patchRowNum = patchStartIndex; patchRowNum < patchEndIndex && patchRowNum < rowDatas.size(); ++patchRowNum) {
                Long costDepID;
                Map<String, String> row = rowDatas.get(patchRowNum);
                String entrycostdeptNum = row.get("entrycostdept.number");
                if (!costDeptMap.containsKey(entrycostdeptNum) || !costDepAdminOrgRelationMap.containsKey(costDepID = costDeptMap.get(entrycostdeptNum))) continue;
                Set<Long> depRelAdminOrgs = costDepAdminOrgRelationMap.get(costDepID);
                patchCostDepAdminOrgRelationMap.putIfAbsent(costDepID, depRelAdminOrgs);
            }
            depExpItemRelationMap = this.buildExpItemRelationMap(patchCostDepAdminOrgRelationMap);
        }
        return depExpItemRelationMap;
    }

    private Map<Long, Set<Long>> buildExpItemRelationMap(Map<Long, Set<Long>> costDepAdminOrgRelationMap) {
        HashMap<Long, Set<Long>> depExpItemRelationMap = new HashMap<Long, Set<Long>>();
        ArrayList<Long> allOrgs = new ArrayList<Long>();
        Set<Long> costDepIds = costDepAdminOrgRelationMap.keySet();
        Collection<Set<Long>> relAmindOrgs = costDepAdminOrgRelationMap.values();
        allOrgs.addAll(costDepIds);
        relAmindOrgs.stream().forEach(relOrgs -> allOrgs.addAll((Collection<Long>)relOrgs));
        if (!allOrgs.isEmpty()) {
            SqlBuilder sb = new SqlBuilder();
            sb.append("select distinct fexpitemid,frelorgid from t_bd_expitemreldept where ", new Object[0]).appendIn("frelorgid", allOrgs.toArray());
            try (DataSet ds = DB.queryDataSet((String)ALGO, (DBRoute)DBRoute.basedata, (SqlBuilder)sb);){
                for (Row row : ds) {
                    Long expitemid = row.getLong("fexpitemid");
                    Long relorgid = row.getLong("frelorgid");
                    costDepAdminOrgRelationMap.entrySet().stream().forEach(entry -> {
                        Long costDep = (Long)entry.getKey();
                        Set relOrgIds = (Set)entry.getValue();
                        if (costDep.compareTo(relorgid) == 0 || relOrgIds.contains(relorgid)) {
                            Set depRelItem = depExpItemRelationMap.getOrDefault(costDep, new HashSet());
                            depRelItem.add(expitemid);
                            depExpItemRelationMap.putIfAbsent(costDep, depRelItem);
                        }
                    });
                }
            }
        }
        return depExpItemRelationMap;
    }

    private Map<Long, Set<Long>> buildCostDepAdminOrgReltionMap(Map<String, Long> costDeptMap) {
        List costDeptList = costDeptMap.values().stream().collect(Collectors.toList());
        Map costDepAdminOrgRelationMap = OrgUnitServiceHelper.getAdminOrgRelationMap(costDeptList, (boolean)true);
        costDeptMap.entrySet().stream().forEach(entry -> {
            Long relOrgId = (Long)entry.getValue();
            HashSet<Long> ids = new HashSet<Long>();
            ids.add(relOrgId);
            costDepAdminOrgRelationMap.put(relOrgId, ids);
        });
        return costDepAdminOrgRelationMap;
    }

    private Map<String, Long> buildCostDeptMap(List<Map<String, String>> rowDatas) {
        DynamicObject[] entrycostdepts;
        HashMap<String, Long> costDeptMap = new HashMap<String, Long>();
        HashSet<String> costDeptNumSets = new HashSet<String>();
        for (int rowNum = 0; rowNum < rowDatas.size(); ++rowNum) {
            Map<String, String> row = rowDatas.get(rowNum);
            if (!StringUtils.isNotEmpty((CharSequence)row.get("entrycostdept.number"))) continue;
            costDeptNumSets.add(row.get("entrycostdept.number"));
        }
        QFilter qFDeptPreQuery = new QFilter("number", "in", costDeptNumSets);
        for (DynamicObject entrycostdeptObj : entrycostdepts = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{qFDeptPreQuery})) {
            if (entrycostdeptObj.getPkValue() == null) continue;
            costDeptMap.put(entrycostdeptObj.getString("number"), (Long)entrycostdeptObj.getPkValue());
        }
        return costDeptMap;
    }

    private List<String> getExcludeOrgNumber(List<Long> org) {
        if (org == null || org.isEmpty()) {
            return new ArrayList<String>();
        }
        List<String> excludePattren = Arrays.asList("1", "2");
        Map dptOrgMap = BusinessDataServiceHelper.loadFromCache((Object[])org.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_org"));
        return dptOrgMap.values().stream().filter(dpt -> excludePattren.contains(dpt.getDynamicObject("orgpattern").getString("patterntype"))).map(dpt -> dpt.getString("number")).collect(Collectors.toList());
    }
}

