/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.entryimport.excelhandle;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.er.formplugin.entryimport.excelhandle.AbstractEntryExcelDataHandler;
import org.apache.commons.lang3.StringUtils;

public class AccountEntryExcelDataHandler
extends AbstractEntryExcelDataHandler {
    public AccountEntryExcelDataHandler() {
        super("accountentry");
    }

    @Override
    public void doConvert(List<Map<String, String>> returnData, StringBuilder errorInfo) {
        Object entityId;
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        String defaultPaymodeNum = "";
        DynamicObject defaultPayMode = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_settlementtype", (String)"id, name, number", (QFilter[])new QFilter[]{enableFilter, new QFilter("isdefault", "=", (Object)true)});
        if (defaultPayMode != null) {
            defaultPaymodeNum = defaultPayMode.getString("number");
        }
        HashSet<String> paymodeNumbers = new HashSet<String>(4);
        HashSet<String> payerbankNames = new HashSet<String>(4);
        HashSet<String> accountcurrencyNumbers = new HashSet<String>(4);
        HashMap<String, String> comboItems = new HashMap<String, String>(4);
        if (returnData.size() > 0 && (entityId = returnData.get(0).get("importentityid")) != null) {
            comboItems.putAll(this.getComboItems((String)entityId));
        }
        for (Map<String, String> rowData2 : returnData) {
            Object paymode = rowData2.get("paymode.number");
            if (StringUtils.isEmpty((CharSequence)paymode)) {
                paymode = defaultPaymodeNum;
                rowData2.put("paymode.number", (String)paymode);
            }
            paymodeNumbers.add((String)paymode);
            payerbankNames.add(rowData2.get("payerbank.name"));
            accountcurrencyNumbers.add(rowData2.get("accountcurrency.number"));
            String payertypeName = rowData2.get("payertype");
            rowData2.put("payertype", this.getPayertypeNumberByName(comboItems, payertypeName));
        }
        HashMap<String, String> bankNameMap = new HashMap<String, String>(payerbankNames.size());
        Map paymodeDyms = BusinessDataServiceHelper.loadFromCache((String)"bd_settlementtype", (String)"id, name, number", (QFilter[])new QFilter[]{new QFilter("number", "in", paymodeNumbers), enableFilter});
        for (Object paymodeDym : paymodeDyms.values()) {
            paymodeNumbers.remove(paymodeDym.getString("number"));
        }
        Map payerbankDyms = BusinessDataServiceHelper.loadFromCache((String)"bd_bebank", (String)"id, name, number", (QFilter[])new QFilter[]{new QFilter("name", "in", payerbankNames), enableFilter});
        for (DynamicObject payerbankDym : payerbankDyms.values()) {
            payerbankNames.remove(payerbankDym.getLocaleString("name").getLocaleValue());
            bankNameMap.put(payerbankDym.getLocaleString("name").getLocaleValue(), payerbankDym.getString("number"));
        }
        Map accountcurrencyDyms = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (String)"id, name, number", (QFilter[])new QFilter[]{new QFilter("number", "in", accountcurrencyNumbers), enableFilter});
        for (DynamicObject accCurrencyDym : accountcurrencyDyms.values()) {
            accountcurrencyNumbers.remove(accCurrencyDym.getString("number"));
        }
        returnData.forEach(rowData -> {
            if (!StringUtils.isEmpty((CharSequence)((CharSequence)rowData.get("paymode.number"))) && paymodeNumbers.contains(rowData.get("paymode.number"))) {
                this.buildErrorInfo(errorInfo, (String)rowData.get("excelrow"), ResManager.loadKDString((String)"\u652f\u4ed8\u65b9\u5f0f", (String)"AccountEntryExcelDataHandler_0", (String)"fi-er-formplugin", (Object[])new Object[0]), (String)rowData.get("paymode.number"), ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u201c\u652f\u4ed8\u65b9\u5f0f\u201d\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\u3002", (String)"AccountEntryExcelDataHandler_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if (!StringUtils.isEmpty((CharSequence)((CharSequence)rowData.get("payerbank.name"))) && payerbankNames.contains(rowData.get("payerbank.name"))) {
                this.buildErrorInfo(errorInfo, (String)rowData.get("excelrow"), ResManager.loadKDString((String)"\u6536\u6b3e\u94f6\u884c", (String)"AccountEntryExcelDataHandler_2", (String)"fi-er-formplugin", (Object[])new Object[0]), (String)rowData.get("payerbank.name"), ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u201c\u94f6\u884c\u8d26\u53f7\u201d\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\u3002", (String)"AccountEntryExcelDataHandler_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
            } else {
                rowData.put("payerbank.number", bankNameMap.get(rowData.get("payerbank.name")));
            }
            if (!StringUtils.isEmpty((CharSequence)((CharSequence)rowData.get("accountcurrency.number"))) && accountcurrencyNumbers.contains(rowData.get("accountcurrency.number"))) {
                this.buildErrorInfo(errorInfo, (String)rowData.get("excelrow"), ResManager.loadKDString((String)"\u6536\u6b3e\u5e01\u79cd", (String)"AccountEntryExcelDataHandler_4", (String)"fi-er-formplugin", (Object[])new Object[0]), (String)rowData.get("accountcurrency.number"), ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u201c\u5e01\u79cd\u201d\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\u3002", (String)"AccountEntryExcelDataHandler_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if (!StringUtils.isEmpty((CharSequence)((CharSequence)rowData.get("payertype"))) && !comboItems.containsKey(rowData.get("payertype"))) {
                this.buildErrorInfo(errorInfo, (String)rowData.get("excelrow"), ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u7c7b\u578b", (String)"AccountEntryExcelDataHandler_6", (String)"fi-er-formplugin", (Object[])new Object[0]), (String)rowData.get("payertype"), ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u201c\u6536\u6b3e\u4eba\u7c7b\u578b\u201d\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"AccountEntryExcelDataHandler_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        });
    }

    private String getPayertypeNumberByName(Map<String, String> map, String payertypeName) {
        if (payertypeName == null) {
            return "other";
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!payertypeName.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return payertypeName;
    }

    private Map<String, String> getComboItems(String entityId) {
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entityId);
        ComboProp ComboProp2 = (ComboProp)type.findProperty("payertype");
        List comboItems = ComboProp2.getComboItems();
        HashMap<String, String> map = new HashMap<String, String>();
        for (ValueMapItem comboItem : comboItems) {
            String value = comboItem.getValue();
            String titleName = comboItem.getName().getLocaleValue();
            map.put(value, titleName);
        }
        return map;
    }
}

