/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.simulator;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import org.apache.commons.lang3.StringUtils;

public class InvoiceCloudDataPushSimulatorForPCPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        AbstractGrid expenseEntryGrid = (AbstractGrid)this.getView().getControl("invoiceinfo");
        expenseEntryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("invoicetype", (Object)ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165", (String)"InvoiceCloudDataPushSimulatorForPCPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]), 0);
        DynamicObjectCollection invoiceDatas = QueryServiceHelper.query((String)"er_invoicedata_pre", (String)"id,number,name", (QFilter[])new QFilter[]{QFilter.of((String)"1=1", (Object[])new Object[0])});
        if (invoiceDatas.size() == 0) {
            return;
        }
        ArrayList invoiceDataLst = new ArrayList(invoiceDatas);
        invoiceDataLst.sort((v1, v2) -> v1.getString("number").compareTo(v2.getString("number")));
        int[] indexs = this.getModel().batchCreateNewEntryRow("invoiceinfo", invoiceDataLst.size());
        int i = 0;
        for (DynamicObject invoiceData : invoiceDataLst) {
            String invoicetype = invoiceData.getString("name");
            Long invoicetypeid = invoiceData.getLong("id");
            this.getModel().setValue("invoicetype", (Object)invoicetype, indexs[i]);
            this.getModel().setValue("invoicetypeid", (Object)invoicetypeid, indexs[i++]);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        int row = evt.getRow();
        switch (key) {
            case "invoiceinfo": {
                if (row == -1) {
                    return;
                }
                DynamicObject invoiceinfo = this.getModel().getEntryRowEntity("invoiceinfo", evt.getRow());
                Long invoiceDataId = invoiceinfo.getLong("invoicetypeid");
                String invoiceJson = "";
                if (invoiceDataId != null && invoiceDataId != 0L) {
                    DynamicObject invoicedata = BusinessDataServiceHelper.loadSingle((Object)invoiceinfo.getLong("invoicetypeid"), (String)"er_invoicedata_pre");
                    invoiceJson = invoicedata.getString("invoicejson_tag");
                }
                this.getModel().setValue("invoicedata_tag", (Object)invoiceJson);
                this.getModel().setValue("invoicedata", (Object)invoiceJson);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.clickOk();
                break;
            }
        }
    }

    private void clickOk() {
        JSONObject returnJsonObject;
        String invoiceData = (String)this.getModel().getValue("invoicedata_tag");
        if (StringUtils.isEmpty((CharSequence)invoiceData)) {
            this.getView().showErrorNotification("Please check invoice raw data.");
            return;
        }
        if (KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud()) {
            returnJsonObject = JSONObject.parseObject((String)invoiceData);
        } else {
            HashMap<String, String> returnMap = new HashMap<String, String>();
            returnMap.put("state", "0");
            returnMap.put("msg", invoiceData);
            returnJsonObject = JSONObject.parseObject((String)JSON.toJSONString(returnMap));
        }
        this.getView().returnDataToParent((Object)returnJsonObject);
        this.getView().close();
    }
}

