/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.orm.ORM;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.IInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.InvoiceVo2BoService.CopyInvoiceVOToInvoiceEntryBOServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.OffsetAmountInvoiceServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.beforeImportService.PubReimburseBeforeImportInvoiceServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.createInvoiceService.CreateInvoiceServiceI;
import kd.fi.er.business.invoicecloud.v2.service.impl.incrementalService.IncrementalServiceI;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.invoicecloud.v2.service.impl.mergeInvoiceService.MergeInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.preHandleInvoiceService.PreHandleInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.removeInvoiceService.RemoveInvoiceService;
import kd.fi.er.common.exception.invoice.InvoiceCloudException;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoicePlugin;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractImportInvoiceForReimByItemEntry
extends AbstractImportInvoicePlugin {
    protected static final String IMPORT_INVOICE_MERGEBY_ITEM = "importinvoicemergebyitem";
    protected static final String TRIP_IMPORT_MERGE = "invoice_add";

    @Override
    public void processInvoiceVO(InvoiceContext invoiceContext) throws InvoiceCloudException {
        IDataModel model = this.getModel();
        RemoveInvoiceService removeDuplicateInvoiceService = this.getRemoveDuplicateInvoiceServiceImpl(invoiceContext);
        PreHandleInvoiceService addInvoiceItemService = this.getPreHandleInvoiceServiceImpl(invoiceContext);
        CopyInvoiceVOToInvoiceEntryBOServiceImpl copyInvoiceVOToInvoiceEntryBOService = new CopyInvoiceVOToInvoiceEntryBOServiceImpl(invoiceContext, this.getView().getEntityId());
        OffsetAmountInvoiceServiceImpl offsetAmountInvoiceService = new OffsetAmountInvoiceServiceImpl(invoiceContext);
        MappingItemWithOrgInvoiceServiceImp mappingExpenseOrTripItemInvoiceService = new MappingItemWithOrgInvoiceServiceImp(invoiceContext, this.getBillType(), model.getDataEntity(true));
        MergeInvoiceService mergeInvoiceServiceImpl = this.getMergeInvoiceService(invoiceContext);
        IncrementalServiceI incrementServiceImpl = this.getIncrementalService(invoiceContext, this.getCurrentIndex());
        PubReimburseBeforeImportInvoiceServiceImpl afterImportInvoiceService = new PubReimburseBeforeImportInvoiceServiceImpl(invoiceContext, this.getView());
        CreateInvoiceServiceI createInvoiceEntryServiceImpl = this.getCreateInvoiceService(invoiceContext);
        IInvoiceService createExpenseOrTripItemService = this.getCreateExpenseOrTripItemService(invoiceContext);
        this.addProcessServices(new IInvoiceService[]{removeDuplicateInvoiceService, addInvoiceItemService, copyInvoiceVOToInvoiceEntryBOService, offsetAmountInvoiceService, mappingExpenseOrTripItemInvoiceService, mergeInvoiceServiceImpl, incrementServiceImpl, afterImportInvoiceService, createInvoiceEntryServiceImpl, createExpenseOrTripItemService});
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control cot = (Control)evt.getSource();
        String key = cot.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)IMPORT_INVOICE_MERGEBY_ITEM)) {
            this.checkInvoiceImport(evt, key);
        }
    }

    protected void checkInvoiceImport(BeforeClickEvent evt, String key) {
        DynamicObject selectedItem = this.getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        String invoiceCode = selectedItem.getString("invoiceno_entry");
        if (StringUtils.isNotBlank((CharSequence)invoiceCode)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u8d39\u7528\u5206\u5f55\u884c\u5df2\u6709\u5173\u8054\u53d1\u7968\u4fe1\u606f\uff0c\u8bf7\u9009\u62e9\u6216\u65b0\u5efa\u5176\u4ed6\u8d39\u7528\u5206\u5f55\u884c\u518d\u6309\u89c4\u5219\u5bfc\u5165\u53d1\u7968\u3002", (String)"AbstractImportInvoiceForReimPCByItemEntry_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public abstract IncrementalServiceI getIncrementalService(InvoiceContext var1, int var2);

    protected abstract int getCurrentIndex();

    protected Long getOrSetSelectedExpenseEntryId() {
        Long curExpenseEntryId = 0L;
        if (this.getModel().getProperty("expenseentryentity") != null) {
            EntryGrid expenseEntryGrid = (EntryGrid)this.getView().getControl("expenseentryentity");
            int[] selectRows = expenseEntryGrid.getSelectRows();
            if (selectRows == null || selectRows.length < 1 || selectRows.length > 1 || selectRows[0] < 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u884c\u6216\u9009\u4e2d\u591a\u884c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractImportInvoiceForReimByItemEntry_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            List selectRowList = Arrays.stream(selectRows).boxed().collect(Collectors.toList());
            DynamicObjectCollection expenseEntryCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
            if (expenseEntryCollection == null || expenseEntryCollection.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u5206\u5f55\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractImportInvoiceForReimByItemEntry_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            curExpenseEntryId = ((DynamicObject)expenseEntryCollection.get(((Integer)selectRowList.get(0)).intValue())).getLong("id");
            if (curExpenseEntryId == 0L) {
                curExpenseEntryId = ORM.create().genLongId((IDataEntityType)this.getModel().getDataEntityType());
                ((DynamicObject)expenseEntryCollection.get(selectRows[0])).set("id", (Object)curExpenseEntryId);
            }
        } else if (this.getModel().getProperty("tripentry") != null) {
            String billKind = (String)this.getModel().getValue("billkind");
            if (StringUtils.equals((CharSequence)billKind, (CharSequence)"1")) {
                EntryGrid tripExpenseEntry = (EntryGrid)this.getView().getControl("entryentity");
                int[] selectRows = tripExpenseEntry.getSelectRows();
                if (selectRows == null || selectRows.length < 1 || selectRows.length > 1 || selectRows[0] < 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u884c\u6216\u9009\u4e2d\u591a\u884c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractImportInvoiceForReimByItemEntry_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                }
                List selectRowList = Arrays.stream(selectRows).boxed().collect(Collectors.toList());
                DynamicObjectCollection expenseEntryCollection = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry").get(0)).getDynamicObjectCollection("entryentity");
                if (expenseEntryCollection == null || expenseEntryCollection.isEmpty()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u5206\u5f55\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractImportInvoiceForReimByItemEntry_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                }
                curExpenseEntryId = ((DynamicObject)expenseEntryCollection.get(((Integer)selectRowList.get(0)).intValue())).getLong("id");
                if (curExpenseEntryId == 0L) {
                    curExpenseEntryId = ORM.create().genLongId((IDataEntityType)this.getModel().getDataEntityType());
                    ((DynamicObject)expenseEntryCollection.get(selectRows[0])).set("id", (Object)curExpenseEntryId);
                }
            } else {
                DynamicObject selectedItem = this.getSelectedItem();
                if (selectedItem != null) {
                    curExpenseEntryId = (Long)selectedItem.getPkValue();
                    if (curExpenseEntryId == null) {
                        curExpenseEntryId = selectedItem.getLong("id");
                    }
                    if (curExpenseEntryId == null) {
                        return 0L;
                    }
                }
            }
        }
        return curExpenseEntryId;
    }

    protected DynamicObject getSelectedItem() {
        if (this.getModel().getProperty("expenseentryentity") != null) {
            EntryGrid expenseEntryGrid = (EntryGrid)this.getView().getControl("expenseentryentity");
            int[] selectRows = expenseEntryGrid.getSelectRows();
            if (selectRows == null || selectRows.length != 1 || selectRows[0] < 0) {
                return null;
            }
            int rowIndex = selectRows[0];
            DynamicObjectCollection expenseEntryCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
            if (expenseEntryCollection == null || expenseEntryCollection.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u5206\u5f55\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractImportInvoiceForReimByItemEntry_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            DynamicObject dynamicObject = (DynamicObject)expenseEntryCollection.get(rowIndex);
            if (dynamicObject.getLong("id") == 0L) {
                Long entryId = ORM.create().genLongId((IDataEntityType)this.getModel().getDataEntityType());
                dynamicObject.set("id", (Object)entryId);
            }
            return dynamicObject;
        }
        if (this.getModel().getProperty("tripentry") != null) {
            String billKind = (String)this.getModel().getValue("billkind");
            if (StringUtils.equals((CharSequence)billKind, (CharSequence)"1")) {
                EntryGrid tripExpenseEntry = (EntryGrid)this.getView().getControl("entryentity");
                int[] selectRows = tripExpenseEntry.getSelectRows();
                if (selectRows == null || selectRows.length != 1 || selectRows[0] < 0) {
                    return null;
                }
                int rowIndex = selectRows[0];
                DynamicObjectCollection expenseEntryCollection = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry").get(0)).getDynamicObjectCollection("entryentity");
                if (expenseEntryCollection == null || expenseEntryCollection.isEmpty()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u5206\u5f55\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractImportInvoiceForReimByItemEntry_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                }
                DynamicObject dynamicObject = (DynamicObject)expenseEntryCollection.get(rowIndex);
                if (dynamicObject.getLong("id") == 0L) {
                    Long entryId = ORM.create().genLongId((IDataEntityType)this.getModel().getDataEntityType());
                    dynamicObject.set("id", (Object)entryId);
                }
                return dynamicObject;
            }
            int tripRowIndex = this.getModel().getEntryCurrentRowIndex("tripentry");
            int tripItemRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject dynamicObject = (DynamicObject)((DynamicObject)this.getModel().getEntryEntity("tripentry").get(tripRowIndex)).getDynamicObjectCollection("entryentity").get(tripItemRowIndex);
            if (dynamicObject.getLong("id") == 0L) {
                Long entryId = ORM.create().genLongId((IDataEntityType)this.getModel().getDataEntityType());
                dynamicObject.set("id", (Object)entryId);
            }
            return dynamicObject;
        }
        return null;
    }
}

