/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2;

import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.form.IFormView;
import kd.bos.form.container.AdvContainer;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.kingdee.action.QueryBySerialNoAction;
import kd.fi.er.business.invoicecloud.util.InvoiceProcessUtil;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.impl.createInvoiceService.CreateInvoiceEntryServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.createInvoiceService.CreateInvoiceServiceI;
import kd.fi.er.business.invoicecloud.v2.service.impl.mergeInvoiceService.MergeInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.mergeInvoiceService.MergeInvoiceServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.mergeInvoiceService.MergeInvoicesInOneServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.preHandleInvoiceService.PreHandleInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.preHandleInvoiceService.PreHandleInvoiceServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.removeInvoiceService.RemoveDuplicateInvoiceServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.removeInvoiceService.RemoveInvoiceService;
import kd.fi.er.business.invoicecloud.v2.util.InvoiceJsonParseUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoiceForReimByItemEntry;
import kd.fi.er.formplugin.invoicecloud.v2.clientInterface.InvoicePcClientInterface;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractImportInvoiceForReimPCByItemEntry
extends AbstractImportInvoiceForReimByItemEntry
implements InvoicePcClientInterface {
    private static final Log log = LogFactory.getLog(AbstractImportInvoiceForReimPCByItemEntry.class);

    @Override
    protected String getCloseCallBackKey() {
        return "expenseimportinvoice";
    }

    @Override
    protected String getAnotherCloseCallBackKey() {
        return "mergebyitem";
    }

    @Override
    public void registerListener(EventObject e) {
        if (this.getControl("expenseimportinvoice") != null) {
            this.addClickListeners(new String[]{"expenseimportinvoice"});
        }
        if (this.getControl("mergebyitem") != null) {
            this.addClickListeners(new String[]{"mergebyitem"});
        }
    }

    @Override
    public void showInvoiceList(List<String> serialNos) {
    }

    public boolean isTrip() {
        return false;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String clickKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)this.getAnotherCloseCallBackKey(), (CharSequence)clickKey)) {
            DynamicObject selectedItem = this.getSelectedItem();
            if (selectedItem == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u67d0\u4e00\u884c\u8d39\u7528\u660e\u7ec6\u5206\u5f55\u540e\u518d\u5bfc\u5165\u53d1\u7968\u3002", (String)"AbstractImportInvoiceForReimPCByItemEntry_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            String invoiceCode = selectedItem.getString("invoiceno_entry");
            if (StringUtils.isNotBlank((CharSequence)invoiceCode)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u8d39\u7528\u5206\u5f55\u884c\u5df2\u6709\u5173\u8054\u53d1\u7968\u4fe1\u606f\uff0c\u8bf7\u9009\u62e9\u6216\u65b0\u5efa\u5176\u4ed6\u8d39\u7528\u5206\u5f55\u884c\u518d\u6309\u89c4\u5219\u5bfc\u5165\u53d1\u7968\u3002", (String)"AbstractImportInvoiceForReimPCByItemEntry_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    protected abstract boolean validateBeforeImport();

    protected void importInvoiceByExpenseOrTripItem(String entryIdentifier, String key) {
        if (!this.validateBeforeImport()) {
            return;
        }
        if (ErStdConfig.isDev() && !ErStdConfig.getShowImportInvoiceDataSimulatorPC()) {
            QueryBySerialNoAction action = new QueryBySerialNoAction("test");
            String apiReturnJson = action.execute();
            try {
                List invoiceVOs = InvoiceJsonParseUtils.parseInvoiceVO((String)apiReturnJson);
                this.executeProcess(invoiceVOs);
            }
            catch (Exception e) {
                log.info("\u5bfc\u5165\u53d1\u7968\u62a5\u9519\uff1a", (Object)e);
                this.getView().showErrorNotification(e.getMessage());
            }
            return;
        }
        String serialNo = this.getEntryInvoiceSerialNo(entryIdentifier);
        super.showSelectedInvoicePage(serialNo == null ? "" : serialNo, this.getExtView(), key);
    }

    private String getEntryInvoiceSerialNo(String entryIdentifier) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entryIdentifier);
        int[] selectedRows = entryGrid.getSelectRows();
        Long entryId = ErCommonUtils.getPk((Object)this.getModel().getEntryEntity(entryIdentifier).get(selectedRows[0]));
        Set invoiceIds = InvoiceUtils.mapInvoiceSet((DynamicObject)this.getModel().getDataEntity(true), (Long)entryId);
        String serialNo = this.getModel().getDataEntity(true).getDynamicObjectCollection("invoiceentry").stream().filter(v -> invoiceIds.contains(v.getPkValue())).map(v -> v.getString("serialno")).collect(Collectors.joining(","));
        return serialNo;
    }

    @Override
    public RemoveInvoiceService getRemoveDuplicateInvoiceServiceImpl(InvoiceContext invoiceContext) {
        return new RemoveDuplicateInvoiceServiceImpl(invoiceContext, this.getModel());
    }

    @Override
    public PreHandleInvoiceService getPreHandleInvoiceServiceImpl(InvoiceContext invoiceContext) {
        return new PreHandleInvoiceServiceImpl(invoiceContext);
    }

    @Override
    public CreateInvoiceServiceI getCreateInvoiceService(InvoiceContext invoiceContext) {
        return new CreateInvoiceEntryServiceImpl(invoiceContext, this.getModel());
    }

    @Override
    public String getTaxRegNum() {
        DynamicObject costCompanyDO = (DynamicObject)this.getModel().getValue("costcompany");
        if (costCompanyDO == null) {
            log.info("\u5f53\u524d\u5355\u636e\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a");
            return "";
        }
        String taxRegNum = KingdeeInvoiceCloudConfig.getTaxRegNum((long)((Long)costCompanyDO.getPkValue()));
        return taxRegNum;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String name = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"invoiceentry")) {
            AdvContainer invoiceHeadAdvCtn = (AdvContainer)this.getControl("invoice_entry_container");
            invoiceHeadAdvCtn.setCollapse(false);
        }
    }

    @Override
    protected boolean isUseExpenseDate() {
        return !this.isTrip();
    }

    @Override
    protected void loadAfterProcessUpdateData(InvoiceContext context) {
        InvoiceProcessUtil.refreshLinkage((IFormView)this.getExtView());
    }

    @Override
    public MergeInvoiceService getMergeInvoiceService(InvoiceContext invoiceContext) {
        if (this.checkCacheClickKey(this.getAnotherCloseCallBackKey())) {
            MergeInvoiceServiceImpl service = new MergeInvoiceServiceImpl(invoiceContext, this.getView().getEntityId(), this.getModel());
            service.setCurSelectedItem(this.getSelectedItem());
            return service;
        }
        Long selectRowId = this.getOrSetSelectedExpenseEntryId();
        if (selectRowId == null) {
            return null;
        }
        MergeInvoicesInOneServiceImpl service = new MergeInvoicesInOneServiceImpl(invoiceContext, selectRowId.longValue(), this.getModel());
        return service;
    }
}

