/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.AdvContainer;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.invoicecloud.kingdee.APIHelper;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.kingdee.action.QueryBySerialNoAction;
import kd.fi.er.business.invoicecloud.provider.param.req.ValidateInvocieReqParam;
import kd.fi.er.business.invoicecloud.provider.param.resp.ValidateInvocieRespParam;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.InvoiceFrom;
import kd.fi.er.business.invoicecloud.v2.service.impl.InvoiceVo2BoService.CopyInvoiceVOToInvoiceEntryBOServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.preHandleInvoiceService.PreHandleInvoiceService;
import kd.fi.er.business.invoicecloud.v2.util.InvoiceJsonParseUtils;
import kd.fi.er.business.pub.PublicBillUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.model.invoice.InvoiceVO;
import kd.fi.er.common.model.invoice.bo.InvoiceEntryBO;
import kd.fi.er.common.model.invoice.bo.InvoiceItemEntryBO;
import kd.fi.er.formplugin.invoicecloud.usecase.ShowInvoiceCloudPageUtil;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoiceForReimPlugin;
import kd.fi.er.formplugin.invoicecloud.v2.clientInterface.InvoicePcClientInterface;
import kd.fi.er.formplugin.invoicecloud.v2.service.model.InvoiceEvent;
import kd.fi.er.formplugin.invoicecloud.v2.service.utils.InvoicePluginUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractImportInvoiceForReimPCPlugin
extends AbstractImportInvoiceForReimPlugin
implements HyperLinkClickListener,
InvoicePcClientInterface {
    private static final Log log = LogFactory.getLog(AbstractImportInvoiceForReimPCPlugin.class);
    private static final String HEAD_IMPORT_INVOICE = "selectinvoice";
    private static final String HEAD_VIEW_INVOICE_LIST = "viewinvoice";
    public static final String EDIT_INVOICE = "editinvoice";

    @Override
    protected String getCloseCallBackKey() {
        return HEAD_IMPORT_INVOICE;
    }

    @Override
    protected void loadAfterProcessUpdateView() {
        super.loadAfterProcessUpdateView();
        this.showIfInvoiceInfo();
        this.updateInvoiceValidateSummary(this.getView());
    }

    private void showIfInvoiceInfo() {
        int entryRowCount = this.getModel().getEntryRowCount("invoiceentry");
        AdvContainer invoiceAdvContainer = (AdvContainer)this.getControl("invoice_entry_container");
        if (entryRowCount > 0) {
            invoiceAdvContainer.setCollapse(false);
        } else {
            invoiceAdvContainer.setCollapse(true);
        }
        PublicBillUtil.showInvoiceEntry((IFormView)this.getView());
    }

    @Override
    public void afterBindData(EventObject e) {
        Long costCompanyId;
        boolean invoiceIsEnabled;
        super.afterBindData(e);
        this.showIfInvoiceInfo();
        this.updateInvoiceValidateSummary(this.getView());
        Object costCompany = this.getModel().getValue("costcompany");
        if (costCompany != null && (invoiceIsEnabled = KingdeeInvoiceCloudConfig.isEnabled((long)(costCompanyId = ErCommonUtils.getPk((Object)costCompany))))) {
            this.updateAutomapinvoiceEnable();
            Boolean isAutoMapInvoice = (Boolean)this.getModel().getValue("automapinvoice");
            this.toggleAutoMapInvoice(isAutoMapInvoice);
        }
    }

    @Override
    protected void setDeleteAttachButtonVisible() {
        Long costCompanyId = ErCommonUtils.getPk((Object)this.getCostCompanyDO());
        boolean invoiceIsEnabled = costCompanyId == null ? false : KingdeeInvoiceCloudConfig.isEnabled((long)costCompanyId);
        this.getView().setVisible(Boolean.valueOf(invoiceIsEnabled), new String[]{"deleteattach"});
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        String itemEntryEntityKey = this.getItemEntryEntityKey();
        if (StringUtils.isNotEmpty((CharSequence)itemEntryEntityKey) && this.getControl(this.getItemEntryEntityKey()) != null) {
            ((EntryGrid)this.getControl(this.getItemEntryEntityKey())).addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        DynamicObject company;
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)this.getCloseCallBackKey()) && (company = this.getCompany(this.getModel().getDataEntity(true))) != null) {
            Long invoiceEntry = SystemParamterUtil.getInvoiceEntryCurrency((Long)((Long)company.getPkValue()));
            if (invoiceEntry == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8bbe\u7f6e\u7684\u201c\u53d1\u7968\u5e01\u79cd\u201d\u4e0d\u53ef\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u5bfc\u5165\u53d1\u7968\u7684\u5e01\u79cd\u3002", (String)"ImportInvoiceForTripReimPCPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            String selectPropties = "id,createorg,number,name,enable";
            DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)invoiceEntry, (String)"bd_currency", (String)selectPropties);
            if (currency != null && !currency.getBoolean("enable")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8bbe\u7f6e\u7684\u201c\u53d1\u7968\u5e01\u79cd\u201d\u4e0d\u53ef\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u5bfc\u5165\u53d1\u7968\u7684\u5e01\u79cd\u3002", (String)"ImportInvoiceForTripReimPCPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (ErStdConfig.isDev() && !ErStdConfig.getShowImportInvoiceDataSimulatorPC() && itemKey.equals(this.getCloseCallBackKey())) {
            QueryBySerialNoAction action = new QueryBySerialNoAction("test");
            String apiReturnJson = action.execute();
            try {
                List invoiceVOs = InvoiceJsonParseUtils.parseInvoiceVO((String)apiReturnJson);
                this.executeProcess(invoiceVOs);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                this.getView().showErrorNotification(e.getMessage());
            }
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)HEAD_IMPORT_INVOICE)) {
            this.showSelectedInvoicePage(String.join((CharSequence)",", this.getAllSerialNos()), this.getExtView(), itemKey);
        } else if (StringUtils.equals((CharSequence)itemKey, (CharSequence)HEAD_VIEW_INVOICE_LIST)) {
            this.showInvoiceList(this.getAllSerialNos());
        } else if (StringUtils.equals((CharSequence)itemKey, (CharSequence)EDIT_INVOICE)) {
            if (ErStdConfig.isDev()) {
                String invoiceJson = "{\"salerName\": \"new\u6df1\u5733\u5e02\u6df1\u6295\u7269\u4e1a\u53d1\u5c55\u6709\u9650\u516c\u53f8\",\"invoiceMoney\": \"64773.62\",\"proxyMark\": \"\",\"downloadUrl\": \"https://api.kingdee.com/kdrive/user/file/public?client_idu003d200242u0026file_idu003d67155291u0026scodeu003dYTZZekhfS1kwPXlpWnBGZzJySmJnu0026signu003dc639946c91cc28cd6e7ee5f458148ad380734440\",\"remark\": \"\u6295\u8d44\u5927\u53a614\u697cC\u533a\",\"authenticateFlag\": 1,\"payee\": \"\",\"checkStatus\": \"1\",\"salerTaxNo\": \"91440300279371676C\",\"invoiceType\": \"4\",\"invoiceNo\": \"new21433383\",\"buyerAddressPhone\": \"\u6df1\u5733\u5e02\u798f\u7530\u533a\u6df1\u5357\u5927\u905340009\u53f7\u6295\u8d44\u5927\u53a616\u697c83883106\",\"salerAccount\": \"\u4e2d\u4fe1\u94f6\u884c\u798f\u5357\u652f\u884c7441310182600028010\",\"originalGraphUrl\": \"http://api.kingdee.com/kdrive/user/file/thumbnail?client_idu003d200242u0026file_idu003d73257252u0026qualityu003d100u0026scodeu003dR1V2X04tdXlYUnNmekZjSmlrdEZmu0026signu003dba60245a62746871cd45eb914cc5b09a5835354du0026widthu003d800\",\"amount\": \"64773.62\",\"buyerTaxNo\": \"91440300664187170P\",\"validateMessage\": \"\u53d1\u7968\u62ac\u5934\u4e0e\u4f01\u4e1a\u540d\u79f0\u4e0d\u4e00\u81f4,\u53d1\u7968\u62ac\u5934\u4e0e\u4f01\u4e1a\u7a0e\u53f7\u4e0d\u4e00\u81f4\",\"drawer\": \"\",\"reviewer\": \"\",\"invoiceDate\": \"2019-10-01\",\"buyerName\": \"new\u6df1\u5733\u5e02\u8fdc\u81f4\u6295\u8d44\u6709\u9650\u516c\u53f8\",\"invoiceCode\": \"new4403181130\",\"serialNo\": \"e901bafdc2dc4a838f82e5f638f7992c0\",\"checkCode\": \"\",\"checkFlag\": 1,\"totalAmount\": \"68512.97\",\"salerAddressPhone\": \"\u6df1\u5733\u5e02\u798f\u7530\u533a\u6295\u8d44\u5927\u53a615\u697c 0755-83883283\",\"checkTime\": \"\",\"buyerAccount\": \"\u4e2d\u4fe1\u94f6\u884c\u798f\u5357\u652f\u884c7441310182600070147\",\"authenticateTime\": \"\",\"rotationAngle\": \"0\",\"snapshotUrl\": \"https://api.kingdee.com/kdrive/user/file/snapshot?client_idu003d200242u0026file_idu003d67155291u0026qualityu003d100u0026scodeu003dNnJrMSt2VUtKRktKK1pzMStNUnJTu0026signu003dfc02ef55ceb53a4b8b7de30493d50d7bf961ffb9u0026widthu003d800\",\"taxAmount\": \"3739.35\",\"totalAmountCn\": \"\",\"invoiceStatus\": \"0\",\"items\": [{\"unitPrice\": \"41996.2857142857\",\"taxRate\": \"0.050000\",\"unit\": \" \",\"num\": \"1.0000000000\",\"detailAmount\": \"41996.29\",\"specModel\": \" \",\"goodsCode\": \"3040502000000000000\",\"taxAmount\": \"2099.81\",\"goodsName\": \"*\u7ecf\u8425\u79df\u8d41*2019\u5e741\u6708\u623f\u5c4b\u79df\u91d1\"},{\"unitPrice\": \"16356.8207547170\",\"taxRate\": \"0.060000\",\"unit\": \" \",\"num\": \"1.0000000000\",\"detailAmount\": \"16356.82\",\"specModel\": \" \",\"goodsCode\": \"3040801000000000000\",\"taxAmount\": \"981.41\",\"goodsName\": \"*\u4f01\u4e1a\u7ba1\u7406\u670d\u52a1*2019\u5e741\u6708\u7ba1\u7406\u8d39\"},{\"unitPrice\": \"3644.0094339623\",\"taxRate\": \"0.060000\",\"unit\": \" \",\"num\": \"1.0000000000\",\"detailAmount\": \"364.40\",\"specModel\": \" \",\"goodsCode\": \"3040000000000000000\",\"taxAmount\": \"21.864\",\"goodsName\": \"*\u73b0\u4ee3\u670d\u52a1*2019\u5e741\u6708\u7a7a\u8c03\u670d\u52a1\u8d39\"},{\"unitPrice\": \"1.0000000000\",\"taxRate\": \"0.160000\",\"unit\": \" \",\"num\": \"2740.0000000000\",\"detailAmount\": \"8990.00\",\"specModel\": \" \",\"goodsCode\": \"1100101020000000000\",\"taxAmount\": \"1438.40\",\"goodsName\": \"*\u4f9b\u7535*2018\u5e7412\u6708\u7535\u8d39\"},{\"unitPrice\": \"3.2524271845\",\"taxRate\": \"0.030000\",\"unit\": \" \",\"num\": \"11.2200000000\",\"detailAmount\": \"36.50\",\"specModel\": \" \",\"goodsCode\": \"1100300000000000000\",\"taxAmount\": \"1.09\",\"goodsName\": \"*\u6c34\u51b0\u96ea*2018\u5e7412\u6708\u6c34\u8d39\"}],\"expenseStatus\": \"1\"}";
                InvoiceVO invoiceVO = (InvoiceVO)JSON.parseObject((String)invoiceJson, InvoiceVO.class);
                this.editInvoice(invoiceVO.getSerialNo(), invoiceVO);
                return;
            }
            int invoiceEntryRowIndex = this.getModel().getEntryCurrentRowIndex("invoiceentry");
            if (invoiceEntryRowIndex < 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u4e00\u884c\u53d1\u7968\uff0c\u518d\u8fdb\u884c\u7f16\u8f91\u3002", (String)"AbstractImportInvoiceForReimPCPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            } else if (StringUtils.isBlank((CharSequence)((String)this.getModel().getValue("serialno", invoiceEntryRowIndex)))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u53d1\u7968\u4e0d\u662f\u6765\u81ea\u53d1\u7968\u4e91\uff0c\u65e0\u6cd5\u4fee\u6539\u3002", (String)"AbstractImportInvoiceForReimPCPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            } else {
                this.showEditInvoicePage((String)this.getModel().getValue("serialno", invoiceEntryRowIndex));
            }
        }
        if (StringUtils.equals((CharSequence)"bar_syncattachment", (CharSequence)itemKey)) {
            InvoicePluginUtils.getInvoiceAttachments(this);
        }
        if (StringUtils.equals((CharSequence)"deleteattach", (CharSequence)itemKey)) {
            if (ErStdConfig.isDev()) {
                ClosedCallBackEvent event = new ClosedCallBackEvent((Object)this, "delete_attach_callback_key", null);
                InvoicePluginUtils.handleDeleteAttachment(this, new InvoiceEvent<ClosedCallBackEvent>(event));
                return;
            }
            this.showDeleteAttachPage();
        }
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hlcEvent) {
        String fieldName = hlcEvent.getFieldName();
        int rowIndex = hlcEvent.getRowIndex();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"invoiceno")) {
            Long poolId;
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            String invoiceFrom = (String)this.getModel().getValue("invoicefrom", rowIndex);
            if (StringUtils.equals((CharSequence)invoiceFrom, (CharSequence)InvoiceFrom.InvoiceCloud.getValue())) {
                DynamicObjectCollection invoiceMergeEntryDOs = new DynamicObjectCollection();
                boolean hasInvoiceMergeEntry = dataEntity.getDataEntityType().getProperties().containsKey((Object)"invoicemerge");
                if (hasInvoiceMergeEntry) {
                    invoiceMergeEntryDOs = dataEntity.getDynamicObjectCollection("invoicemerge");
                }
                String serialNo = (String)this.getModel().getValue("serialno", rowIndex);
                HashSet serialNos = Sets.newHashSet((Object[])new String[]{serialNo});
                Set serialNosFromInvoiceMergeEntry = invoiceMergeEntryDOs.stream().filter(invoiceMerge -> StringUtils.equals((CharSequence)invoiceMerge.getString("keyserialno"), (CharSequence)serialNo)).map(invoiceMerge -> invoiceMerge.getString("serialno_merge")).collect(Collectors.toSet());
                serialNos.addAll(serialNosFromInvoiceMergeEntry);
                this.showInvoiceList(new ArrayList<String>(serialNos));
            } else if (StringUtils.equals((CharSequence)invoiceFrom, (CharSequence)InvoiceFrom.ManualAdd.getValue()) && this.getModel().getProperty("billingpoolid") != null && (poolId = (Long)this.getModel().getValue("billingpoolid", rowIndex)) != null && poolId != 0L) {
                this.viewBillingPoolBill(poolId);
            }
        }
    }

    private void viewBillingPoolBill(Long poolId) {
        boolean exists = QueryServiceHelper.exists((String)"er_billingpool", (Object)poolId);
        if (exists) {
            BillShowParameter parameter = new BillShowParameter();
            parameter.setPkId((Object)poolId);
            parameter.setFormId("er_billingpool");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setHasRight(true);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    protected void showSingleLineImportInvoice(Boolean inoviceSwitch) {
        String entryName = this.getView().getEntityId();
        IFormView view = this.getView();
        if (ErEntityTypeUtils.isDailyReimburseBill((String)entryName)) {
            boolean isShow = StringUtils.equals((CharSequence)"B", (CharSequence)((String)view.getModel().getValue("specialbill")));
            view.setVisible(Boolean.valueOf(!isShow && inoviceSwitch != false), new String[]{HEAD_IMPORT_INVOICE});
            view.setVisible(Boolean.valueOf(isShow && inoviceSwitch != false), new String[]{"selectinvoicenomerge1"});
        } else {
            view.setVisible(inoviceSwitch, new String[]{HEAD_IMPORT_INVOICE});
        }
        this.getView().setVisible(inoviceSwitch, new String[]{"expenseimportinvoice"});
    }

    @Override
    protected void processWhenInvoiceIsEnable() {
    }

    @Override
    protected void processWhenInvoiceIsDisable() {
    }

    @Override
    public void showInvoiceList(List<String> serialNos) {
        serialNos.removeIf(serialNo -> StringUtils.isBlank((CharSequence)serialNo));
        String taxRegNum = this.getTaxRegNum();
        if (StringUtils.isBlank((CharSequence)taxRegNum)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7ec4\u7ec7\u7684\u53d1\u7968\u4e91\u914d\u7f6e\u3002", (String)"AbstractImportInvoiceForReimPCPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        ShowInvoiceCloudPageUtil.viewInvoiceLst_pc((AbstractFormPlugin)this, this.getModel(), serialNos, ErCommonUtils.getPk((Object)this.getCostCompanyDO()));
    }

    protected void showEditInvoicePage(String serialNo) {
        ShowInvoiceCloudPageUtil.showEditInvoicePC((AbstractFormPlugin)this, this.getModel(), serialNo, new CloseCallBack((IFormPlugin)this, EDIT_INVOICE));
    }

    @Override
    public void editInvoice(String oldSerialNo, InvoiceVO invoiceVO) {
        if (StringUtils.isEmpty((CharSequence)invoiceVO.getSerialNo())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u5e8f\u5217\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"AbstractImportInvoiceForReimPCPlugin_25", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection invoiceHeadDOs = dataEntity.getDynamicObjectCollection("invoiceentry");
        DynamicObjectCollection invoiceItemDOs = dataEntity.getDynamicObjectCollection("invoiceitementry");
        InvoiceContext invoiceContext = new InvoiceContext();
        this.buildInvoiceConfig(invoiceContext);
        invoiceContext.getInvoiceVOs().add(invoiceVO);
        PreHandleInvoiceService addInvoiceItemService = this.getPreHandleInvoiceServiceImpl(invoiceContext);
        CopyInvoiceVOToInvoiceEntryBOServiceImpl copyInvoiceVOToInvoiceEntryBOServiceImpl = new CopyInvoiceVOToInvoiceEntryBOServiceImpl(invoiceContext, this.getView().getEntityId());
        try {
            addInvoiceItemService.process();
            copyInvoiceVOToInvoiceEntryBOServiceImpl.process();
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
            log.error((Throwable)e);
            return;
        }
        InvoiceEntryBO invoiceEntryBO = (InvoiceEntryBO)invoiceContext.getInvoiceEntryBOs().get(0);
        List invoiceItemEntryBOs = invoiceContext.getInvoiceItemEntryBOs();
        for (int i = 0; i < invoiceHeadDOs.size(); ++i) {
            DynamicObject invoiceHeadDO = (DynamicObject)invoiceHeadDOs.get(i);
            String serialNo = invoiceHeadDO.getString("serialno");
            if (!StringUtils.equals((CharSequence)serialNo, (CharSequence)oldSerialNo)) continue;
            String invoiceType = invoiceHeadDO.getString("invoicetype");
            if (!StringUtils.equals((CharSequence)invoiceType, (CharSequence)invoiceEntryBO.getInvoiceType())) {
                log.info("\u53d1\u7968\u7c7b\u578b\u4e0d\u4e00\u81f4: old>>>" + invoiceType + "; new>>>" + invoiceEntryBO.getInvoiceType());
                this.editInvoiceByRemoveAndAdd(i, invoiceVO);
                return;
            }
            Long invoiceHeadEntryId = (Long)invoiceHeadDO.getPkValue();
            List oldInvoiceItemEntryDOs = invoiceItemDOs.stream().filter(invoiceItem -> Objects.equals(invoiceItem.getLong("invoiceheadentryid"), invoiceHeadEntryId)).collect(Collectors.toList());
            oldInvoiceItemEntryDOs.sort((a, b) -> Integer.compare(a.getInt("seq"), b.getInt("seq")));
            if (oldInvoiceItemEntryDOs.size() != invoiceItemEntryBOs.size()) {
                log.info("\u7f16\u8f91\u524d\u540e\u7684\u53d1\u7968\u660e\u7ec6\u6570\u91cf\u4e0d\u4e00\u6837\u591a: oldSize>>>" + oldInvoiceItemEntryDOs.size() + ";newSize>>>" + invoiceItemEntryBOs.size());
                this.editInvoiceByRemoveAndAdd(i, invoiceVO);
                return;
            }
            for (int itemIndex = 0; itemIndex < oldInvoiceItemEntryDOs.size(); ++itemIndex) {
                DynamicObject oldInvoiceItem = (DynamicObject)oldInvoiceItemEntryDOs.get(itemIndex);
                InvoiceItemEntryBO newInvoiceItem = (InvoiceItemEntryBO)invoiceItemEntryBOs.get(itemIndex);
                BigDecimal oldTaxRate = oldInvoiceItem.getBigDecimal("invoiceitemtaxrate");
                BigDecimal newTaxRate = newInvoiceItem.getInvoiceItemTaxRate();
                if (StringUtils.equals((CharSequence)oldInvoiceItem.getString("goodscode"), (CharSequence)newInvoiceItem.getGoodsCode()) && !(Math.abs(oldTaxRate.subtract(newTaxRate).doubleValue()) > 0.001)) continue;
                log.info("\u7f16\u8f91\u524d\u540e\u53d1\u7968\u660e\u7ec6\u7684\u7a0e\u7387\u6216\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e0d\u4e00\u81f4: oldGoodCode>>>" + oldInvoiceItem.getString("goodscode") + "new>>>" + newInvoiceItem.getGoodsCode());
                log.info("oldTaxRate>>>" + oldTaxRate + "; new>>>" + newTaxRate);
                this.editInvoiceByRemoveAndAdd(i, invoiceVO);
                return;
            }
            BigDecimal oldAirportConstrFeeAmount = invoiceHeadDO.getBigDecimal("invoiceairportconstfee");
            this.editInvoiceHeadEntry(model, invoiceEntryBO, i, invoiceHeadDO);
            this.editExptenseItemEntryAndInvoiceItemEntry(invoiceItemDOs, invoiceItemEntryBOs, invoiceHeadDO, oldAirportConstrFeeAmount);
        }
    }

    private void editExptenseItemEntryAndInvoiceItemEntry(DynamicObjectCollection invoiceItemDOs, List<InvoiceItemEntryBO> invoiceItemEntryBOs, DynamicObject invoiceHeadDO, BigDecimal oldAirportConstrFeeAmount) {
        Long invoiceHeadEntryId = (Long)invoiceHeadDO.getPkValue();
        int invoiceItemBOIndex = 0;
        for (int itemRowIndex = 0; itemRowIndex < invoiceItemDOs.size(); ++itemRowIndex) {
            DynamicObject oldInvoiceItemDO = (DynamicObject)invoiceItemDOs.get(itemRowIndex);
            if (!Objects.equals(oldInvoiceItemDO.getLong("invoiceheadentryid"), invoiceHeadEntryId)) continue;
            InvoiceItemEntryBO invoiceItemBO = invoiceItemEntryBOs.get(invoiceItemBOIndex);
            long expenseItemEntryId = oldInvoiceItemDO.getLong("itementryid");
            if (expenseItemEntryId != 0L) {
                InvoiceEditItemBean invoiceEditItemBean = new InvoiceEditItemBean();
                invoiceEditItemBean.setDeltaTaxAmount(invoiceItemBO.getInvoiceItemTaxAmout().subtract(oldInvoiceItemDO.getBigDecimal("invoiceitemtaxamout")));
                invoiceEditItemBean.setDeltaExcludeTaxAmount(invoiceItemBO.getExcludeAmount().subtract(oldInvoiceItemDO.getBigDecimal("excludeamount")));
                invoiceEditItemBean.setDeltaAirportConstructionFee(invoiceItemBO.getInvoiceEntryBO().getAirportConstructionFee().subtract(oldAirportConstrFeeAmount));
                invoiceEditItemBean.setDeltaTotalAmount(invoiceEditItemBean.deltaTaxAmount.add(invoiceEditItemBean.deltaExcludeTaxAmount));
                List<DynamicObject> invoiceHeadDOs = this.getInvoiceHeadDOsByItemEntryId(expenseItemEntryId);
                String joinInvoiceNo = invoiceHeadDOs.stream().map(head -> head.getString("invoiceno")).collect(Collectors.joining(","));
                String joinInvoiceCode = invoiceHeadDOs.stream().map(head -> head.getString("invoicecode")).collect(Collectors.joining(","));
                invoiceEditItemBean.setInvoiceNo(joinInvoiceNo);
                invoiceEditItemBean.setInvoiceCode(joinInvoiceCode);
                this.editExpenseOrTripItemEntry(expenseItemEntryId, invoiceEditItemBean);
            }
            this.getModel().setValue("unitprice", (Object)invoiceItemBO.getUnitPrice(), itemRowIndex);
            this.getModel().setValue("unit", (Object)invoiceItemBO.getUnit(), itemRowIndex);
            this.getModel().setValue("excludeamount", (Object)invoiceItemBO.getExcludeAmount(), itemRowIndex);
            this.getModel().setValue("specmodel", (Object)invoiceItemBO.getSpecModel(), itemRowIndex);
            this.getModel().setValue("invoiceitemtaxamout", (Object)invoiceItemBO.getInvoiceItemTaxAmout(), itemRowIndex);
            this.getModel().setValue("num", (Object)invoiceItemBO.getNum(), itemRowIndex);
            this.getModel().setValue("goodsname", (Object)invoiceItemBO.getGoodsName(), itemRowIndex);
            ++invoiceItemBOIndex;
        }
    }

    protected void editExpenseOrTripItemEntry(long expenseItemEntryId, InvoiceEditItemBean invoiceEditItemBean) {
    }

    private void editInvoiceHeadEntry(IDataModel model, InvoiceEntryBO invoiceEntryBO, int i, DynamicObject invoiceHeadDO) {
        boolean offsetAmountIsGTZero = invoiceHeadDO.getBigDecimal("offsetamount").compareTo(BigDecimal.valueOf(1.0E-6)) > 0;
        model.setValue("invoicecode", (Object)invoiceEntryBO.getInvoiceCode(), i);
        model.setValue("invoiceno", (Object)invoiceEntryBO.getInvoiceNo(), i);
        model.setValue("invoicedate", (Object)invoiceEntryBO.getInvoiceDate(), i);
        model.setValue("totalamount", (Object)invoiceEntryBO.getTotalAmount(), i);
        model.setValue("alltaxrate", (Object)invoiceEntryBO.getAllTaxRate(), i);
        model.setValue("taxrate_invoice", (Object)invoiceEntryBO.getTaxRate(), i);
        model.setValue("taxamount_invoice", (Object)invoiceEntryBO.getTaxAmount(), i);
        model.setValue("passengername", (Object)invoiceEntryBO.getPassengerName(), i);
        if (offsetAmountIsGTZero) {
            model.setValue("offsetamount", (Object)invoiceEntryBO.getTaxAmount(), i);
        }
        model.setValue("validatemessage", (Object)invoiceEntryBO.getValidateMessage(), i);
        String remarkInvoice = StringUtils.abbreviate((String)invoiceEntryBO.getRemark_Invoice(), (int)1024);
        model.setValue("remark_invoice", (Object)remarkInvoice, i);
        model.setValue("buyerorgname", (Object)invoiceEntryBO.getBuyerOrgName(), i);
        model.setValue("makeoutcompname", (Object)invoiceEntryBO.getMakeOutCompanyName(), i);
        model.setValue("serialno", (Object)invoiceEntryBO.getSerialNo(), i);
        model.setValue("invoiceairportconstfee", (Object)invoiceEntryBO.getAirportConstructionFee(), i);
    }

    private void editInvoiceByRemoveAndAdd(int invoiceEntryIndex, InvoiceVO invoiceVO) {
        log.info("\u901a\u8fc7\u5148\u5220\u9664\u540e\u5bfc\u5165\u7684\u5f62\u5f0f\u4fee\u6539\u53d1\u7968,\u5220\u9664\u5206\u5f55\u884c invoiceEntryIndex\uff1a" + invoiceEntryIndex);
        this.getModel().deleteEntryRow("invoiceentry", invoiceEntryIndex);
        this.executeProcess(Lists.newArrayList((Object[])new InvoiceVO[]{invoiceVO}));
    }

    protected String getShowInvoiceListOpKey() {
        return "showinvoicelist";
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)this.getShowInvoiceListOpKey())) {
            List<String> serialNos = this.getAllSerialNos();
            this.showInvoiceList(serialNos);
        } else if (operateKey.equals("validateallinvoice")) {
            this.valiateAllInvoice();
        } else if (operateKey.equals("validateselectedinvoice")) {
            this.valiateSelectedInvocie();
        }
    }

    public void valiateAllInvoice() {
        boolean invoiceCloudEnable = KingdeeInvoiceCloudConfig.isEnabled((long)((Long)this.getCostCompanyDO().getPkValue()));
        if (!invoiceCloudEnable) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8d39\u7528\u627f\u62c5\u516c\u53f8\u672a\u542f\u7528\u53d1\u7968\u4e91\uff0c\u8bf7\u5148\u542f\u7528\u3002", (String)"AbstractImportInvoiceForReimPCPlugin_15", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        int invoiceHeadCount = this.getModel().getDataEntity(true).getDynamicObjectCollection("invoiceentry").size();
        int[] invoiceRowIndexs = IntStream.range(0, invoiceHeadCount).toArray();
        if (invoiceHeadCount <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u65e0\u4efb\u4f55\u53d1\u7968\uff0c\u65e0\u9700\u67e5\u9a8c\u3002", (String)"AbstractImportInvoiceForReimPCPlugin_16", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        int[] notOkInvoiceHeadRowIndexs = this.getNotOkInvoiceHeadRowIndexIn(invoiceRowIndexs);
        if (notOkInvoiceHeadRowIndexs == null || notOkInvoiceHeadRowIndexs.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u6240\u6709\u53d1\u7968\u65e0\u9700\u518d\u67e5\u9a8c\u3002", (String)"AbstractImportInvoiceForReimPCPlugin_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        this.validateInvoice(notOkInvoiceHeadRowIndexs);
    }

    public void valiateSelectedInvocie() {
        boolean invoiceCloudEnable = KingdeeInvoiceCloudConfig.isEnabled((long)((Long)this.getCostCompanyDO().getPkValue()));
        if (!invoiceCloudEnable) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8d39\u7528\u627f\u62c5\u516c\u53f8\u672a\u542f\u7528\u53d1\u7968\u4e91\uff0c\u8bf7\u5148\u542f\u7528\u3002", (String)"AbstractImportInvoiceForReimPCPlugin_15", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        EntryGrid invoiceHeadEntryGrid = (EntryGrid)this.getControl("invoiceentry");
        int[] selectRows = invoiceHeadEntryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u67e5\u9a8c\u672a\u901a\u8fc7\u7684\u53d1\u7968\u3002", (String)"AbstractImportInvoiceForReimPCPlugin_17", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        int[] notOkInvoiceHeadRowIndexs = this.getNotOkInvoiceHeadRowIndexIn(selectRows);
        if (notOkInvoiceHeadRowIndexs == null || notOkInvoiceHeadRowIndexs.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u53d1\u7968\u65e0\u9700\u518d\u67e5\u9a8c\u3002", (String)"AbstractImportInvoiceForReimPCPlugin_18", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        this.validateInvoice(notOkInvoiceHeadRowIndexs);
    }

    private void validateInvoice(int[] notOkInvoiceHeadIndexs) {
        log.info("\u53d1\u7968\u67e5\u9a8c\u4e0d\u901a\u8fc7\u7684row Index:" + Arrays.toString(notOkInvoiceHeadIndexs));
        if (notOkInvoiceHeadIndexs == null || notOkInvoiceHeadIndexs.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u53d1\u7968\u5df2\u5168\u90e8\u67e5\u9a8c\u901a\u8fc7, \u65e0\u9700\u518d\u6b21\u67e5\u9a8c\u3002", (String)"AbstractImportInvoiceForReimPCPlugin_9", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection invoiceHeadDOs = dataEntity.getDynamicObjectCollection("invoiceentry");
        ValidateInvocieReqParam validateInvoiceReqParam = new ValidateInvocieReqParam();
        String taxRegNum = this.getTaxRegNum();
        validateInvoiceReqParam.setTaxRegNum(taxRegNum);
        validateInvoiceReqParam.setInvoiceCompanyId((Long)this.getCostCompanyDO().getPkValue());
        validateInvoiceReqParam.setBillId(APIHelper.getBillNoCachedInCloud((DynamicObject)dataEntity));
        validateInvoiceReqParam.setEntityName(dataEntity.getDataEntityType().getName());
        validateInvoiceReqParam.setRealBillId(Long.valueOf(dataEntity.getLong("id")));
        ArrayList notOkAfterValidateIndexs = Lists.newArrayList();
        for (int rowIndex : notOkInvoiceHeadIndexs) {
            ValidateInvocieRespParam validateResult;
            DynamicObject needValidateInvoiceDO = (DynamicObject)invoiceHeadDOs.get(rowIndex);
            validateInvoiceReqParam.setSerialNo(needValidateInvoiceDO.getString("serialno"));
            try {
                validateResult = APIHelper.validateInvoice((ValidateInvocieReqParam)validateInvoiceReqParam);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u67e5\u9a8c\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a%1$s\u3002", (String)"AbstractImportInvoiceForReimPCPlugin_22", (String)"fi-er-formplugin", (Object[])new Object[0]), e.getMessage()));
                return;
            }
            if (validateResult.isPass()) {
                int i;
                if (StringUtils.isEmpty((CharSequence)validateResult.getInvoiceVO().getSerialNo())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u5e8f\u5217\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"AbstractImportInvoiceForReimPCPlugin_25", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    continue;
                }
                this.getModel().setValue("ie_validatest", (Object)InvoiceVO.CheckStatus.OK.getValue(), rowIndex);
                this.getModel().setValue("serialno", (Object)validateResult.getInvoiceVO().getSerialNo(), rowIndex);
                if (this.getModel().getProperty("invoiceitemserialno") != null) {
                    DynamicObjectCollection invoiceItemDOs = dataEntity.getDynamicObjectCollection("invoiceitementry");
                    for (i = 0; i < invoiceItemDOs.size(); ++i) {
                        if (((DynamicObject)invoiceItemDOs.get(i)).getLong("invoiceheadentryid") == ((Long)needValidateInvoiceDO.getPkValue()).longValue()) {
                            ((DynamicObject)invoiceItemDOs.get(i)).set("invoiceitemserialno", (Object)validateResult.getInvoiceVO().getSerialNo());
                        }
                        ++i;
                    }
                }
                if (this.getModel().getProperty("invoiceexpserialno") == null) continue;
                DynamicObjectCollection invoiceExpDOs = dataEntity.getDynamicObjectCollection("invoiceandexpense");
                for (i = 0; i < invoiceExpDOs.size(); ++i) {
                    if (((DynamicObject)invoiceExpDOs.get(i)).getLong("invoiceentryid") == ((Long)needValidateInvoiceDO.getPkValue()).longValue()) {
                        ((DynamicObject)invoiceExpDOs.get(i)).set("invoiceexpserialno", (Object)validateResult.getInvoiceVO().getSerialNo());
                    }
                    ++i;
                }
                continue;
            }
            notOkAfterValidateIndexs.add(rowIndex);
        }
        this.updateInvoiceValidateSummary(this.getView());
        if (notOkAfterValidateIndexs.isEmpty()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5168\u90e8\u67e5\u9a8c\u901a\u8fc7\u3002", (String)"AbstractImportInvoiceForReimPCPlugin_19", (String)"fi-er-formplugin", (Object[])new Object[0]));
        } else {
            String notOkInvoiceNos = notOkAfterValidateIndexs.stream().map(index -> ((DynamicObject)invoiceHeadDOs.get(index.intValue())).getString("invoiceno")).collect(Collectors.joining("\u3001"));
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u201c%s\u201d\u67e5\u9a8c\u672a\u901a\u8fc7\u3002", (String)"AbstractImportInvoiceForReimPCPlugin_20", (String)"fi-er-formplugin", (Object[])new Object[0]), notOkInvoiceNos));
        }
        this.getView().invokeOperation("save");
    }

    public int[] getNotOkInvoiceHeadRowIndexIn(int[] invoiceHeadRowIndexs) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection invoiceHeadDOs = dataEntity.getDynamicObjectCollection("invoiceentry");
        int[] notOkInvoiceHeadIndexs = null;
        if (invoiceHeadDOs != null && !invoiceHeadDOs.isEmpty()) {
            notOkInvoiceHeadIndexs = Arrays.stream(invoiceHeadRowIndexs).filter(i -> StringUtils.equals((CharSequence)((DynamicObject)invoiceHeadDOs.get(i)).getString("ie_validatest"), (CharSequence)InvoiceVO.CheckStatus.NOT_OK.getValue()) || StringUtils.equals((CharSequence)((DynamicObject)invoiceHeadDOs.get(i)).getString("ie_validatest"), (CharSequence)InvoiceVO.CheckStatus.UNCHECK.getValue())).toArray();
        }
        return notOkInvoiceHeadIndexs;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("currency".equals(e.getProperty().getName())) {
            this.updateInvoiceValidateSummary(this.getView());
        }
    }

    private void toggleAutoMapInvoice(boolean isAutoMapInvoice) {
        this.getView().setVisible(Boolean.valueOf(!isAutoMapInvoice), new String[]{"mapinvoice", "importnotcreateitem", "mapinvoicebyinvoiceno"});
        this.getView().setVisible(Boolean.valueOf(!isAutoMapInvoice), new String[]{"mapinvoiceentry", "mapinvoicebyinvoicenoentr"});
        this.getView().setVisible(Boolean.valueOf(isAutoMapInvoice), new String[]{"merge"});
        this.showSingleLineImportInvoice(isAutoMapInvoice);
    }

    static class InvoiceEditItemBean {
        private BigDecimal deltaTotalAmount;
        private BigDecimal deltaAirportConstructionFee;
        private BigDecimal deltaTaxAmount;
        private BigDecimal deltaExcludeTaxAmount;
        private String invoiceCode;
        private String invoiceNo;

        InvoiceEditItemBean() {
        }

        public BigDecimal getDeltaTotalAmount() {
            return this.deltaTotalAmount;
        }

        public void setDeltaTotalAmount(BigDecimal deltaTotalAmount) {
            this.deltaTotalAmount = deltaTotalAmount;
        }

        public BigDecimal getDeltaAirportConstructionFee() {
            return this.deltaAirportConstructionFee;
        }

        public void setDeltaAirportConstructionFee(BigDecimal deltaAirportConstructionFee) {
            this.deltaAirportConstructionFee = deltaAirportConstructionFee;
        }

        public BigDecimal getDeltaTaxAmount() {
            return this.deltaTaxAmount;
        }

        public void setDeltaTaxAmount(BigDecimal deltaTaxAmount) {
            this.deltaTaxAmount = deltaTaxAmount;
        }

        public BigDecimal getDeltaExcludeTaxAmount() {
            return this.deltaExcludeTaxAmount;
        }

        public void setDeltaExcludeTaxAmount(BigDecimal deltaExcludeTaxAmount) {
            this.deltaExcludeTaxAmount = deltaExcludeTaxAmount;
        }

        public String getInvoiceCode() {
            return this.invoiceCode;
        }

        public void setInvoiceCode(String invoiceCode) {
            this.invoiceCode = invoiceCode;
        }

        public String getInvoiceNo() {
            return this.invoiceNo;
        }

        public void setInvoiceNo(String invoiceNo) {
            this.invoiceNo = invoiceNo;
        }
    }
}

