/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Submit;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.util.InvoiceTypeUtils;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.InvoiceFrom;
import kd.fi.er.business.invoicecloud.v2.service.IInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.InvoiceVo2BoService.CopyInvoiceVOToInvoiceEntryBOServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.OffsetAmountInvoiceServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.beforeImportService.BeforeImportInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.beforeImportService.PubReimburseBeforeImportInvoiceServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.createInvoiceService.CreateInvoiceServiceI;
import kd.fi.er.business.invoicecloud.v2.service.impl.mergeInvoiceService.MergeInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.preHandleInvoiceService.PreHandleInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.removeInvoiceService.RemoveInvoiceService;
import kd.fi.er.business.servicehelper.InvoiceServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.OperateOptionUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoicePlugin;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractImportInvoiceForReimPlugin
extends AbstractImportInvoicePlugin {
    private static final Log log = LogFactory.getLog(AbstractImportInvoiceForReimPlugin.class);
    private static final String INVOICE_SUBMIT_KEY = "invoice_Submit_Key";
    private static final String INVOICE_AFTER_SUBMIT_KEY = "invoice_After_Submit_Key";
    protected final String INVOICE_ATTACH_PANEL_MB = "invoiceattachpanel";
    public static final String DELETE_ATTACH_CALLBACK_KEY = "delete_attach_callback_key";
    protected final String DELETE_ATTACH = "deleteattach";
    protected final String DELETE_ATTACH_HYPERLINK = "deleteattach_hyperlink";
    protected final String QUERY_ATTACH_HYPERLINK = "queryattach_hyperlink";

    protected String getItemEntryEntityKey() {
        if (this.getModel().getProperty("expenseentryentity") != null) {
            return "expenseentryentity";
        }
        if (this.getModel().getProperty("tripentry") != null) {
            return "entryentity";
        }
        return "";
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"deleteattach_hyperlink", "queryattach_hyperlink"});
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateInvoiceLabelShow();
        this.setDeleteAttachButtonVisible();
        this.itemAmountEdit(null);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        IDataModel model = this.getModel();
        if (StringUtils.equals((CharSequence)name, (CharSequence)this.getCostCompanyKey())) {
            DynamicObject newCostCompanyDO = (DynamicObject)newValue;
            if (newValue != null) {
                boolean invoiceIsEnabled = KingdeeInvoiceCloudConfig.isEnabled((long)((Long)newCostCompanyDO.getPkValue()));
                if (invoiceIsEnabled) {
                    this.updateInvoiceValidateInfo((Long)newCostCompanyDO.getPkValue());
                }
                this.updateInvoiceLabelShow();
                InvoiceUtils.costChageRefreshItemTaxAmount((IDataModel)model, (long)((Long)newCostCompanyDO.getPkValue()));
            }
            this.setDeleteAttachButtonVisible();
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"company")) {
            DynamicObject newCompany = (DynamicObject)newValue;
            this.itemAmountEdit(newCompany);
        }
    }

    protected void updateInvoiceValidateInfo(Long companyId) {
        String result = ErStdConfig.get((String)"invoicecloud.configpattern");
        InvoiceCloudCfgBO cfgbo = KingdeeInvoiceCloudConfig.getConfig((Long)companyId);
        if (cfgbo == null) {
            return;
        }
        String companyName = KingdeeInvoiceCloudConfig.getCompanyNameBy((Long)companyId);
        String taxRegNum = KingdeeInvoiceCloudConfig.getTaxRegNum((long)companyId);
        List<Object> companyNames = Lists.newArrayList();
        List<Object> taxRegNums = Lists.newArrayList();
        if (companyName != null && companyName.contains("=")) {
            companyNames = Arrays.asList(companyName.split("=")).stream().map(v -> InvoiceUtils.removeSign((String)v)).collect(Collectors.toList());
            taxRegNums = Arrays.asList(taxRegNum.split("="));
        }
        IDataModel model = this.getModel();
        int invoiceCount = model.getEntryRowCount("invoiceentry");
        Set vatInvoice = InvoiceTypeUtils.loadVatInvoiceTypes();
        for (int rowIndex = 0; rowIndex < invoiceCount; ++rowIndex) {
            String invoiceType = (String)model.getValue("invoicetype", rowIndex);
            if (!vatInvoice.contains(invoiceType)) continue;
            if (StringUtils.isNotEmpty((CharSequence)result) && StringUtils.equals((CharSequence)result.trim(), (CharSequence)"2") && companyNames.size() > 1) {
                this.groupValidate(model, rowIndex, companyNames, taxRegNums);
                continue;
            }
            this.orgValidate(model, rowIndex, companyName, taxRegNum);
        }
    }

    private void groupValidate(IDataModel model, int rowIndex, List<String> companyNames, List<String> taxRegNums) {
        String buyerCompanyName = (String)model.getValue("buyerorgname", rowIndex);
        String buyerTaxNo = (String)model.getValue("buyertaxno", rowIndex);
        String personalInvoice = (String)model.getValue("personalinvoice", rowIndex);
        String passVerifyBuyerName = " ";
        String passVerifyBuyerTaxNo = " ";
        if (StringUtils.isNotBlank((CharSequence)buyerCompanyName)) {
            buyerCompanyName = InvoiceUtils.removeSign((String)buyerCompanyName);
            for (int i = 0; i < companyNames.size(); ++i) {
                String companyName = companyNames.get(i);
                if (!StringUtils.equals((CharSequence)companyName, (CharSequence)buyerCompanyName)) continue;
                passVerifyBuyerName = "1";
                if (!StringUtils.equals((CharSequence)taxRegNums.get(i), (CharSequence)buyerTaxNo)) continue;
                passVerifyBuyerTaxNo = "1";
                break;
            }
            if (!StringUtils.equals((CharSequence)personalInvoice, (CharSequence)"1")) {
                if (!StringUtils.equals((CharSequence)passVerifyBuyerName, (CharSequence)"1")) {
                    passVerifyBuyerName = "0";
                    passVerifyBuyerTaxNo = "0";
                }
                if (StringUtils.equals((CharSequence)passVerifyBuyerName, (CharSequence)"1") && !StringUtils.equals((CharSequence)passVerifyBuyerTaxNo, (CharSequence)"1")) {
                    passVerifyBuyerTaxNo = "0";
                }
            } else {
                passVerifyBuyerName = " ";
                passVerifyBuyerTaxNo = " ";
            }
        }
        this.validateMsg(passVerifyBuyerName, passVerifyBuyerTaxNo, rowIndex);
    }

    private void orgValidate(IDataModel model, int rowIndex, String companyName, String taxRegNum) {
        String buyerCompanyName = (String)model.getValue("buyerorgname", rowIndex);
        String buyerTaxNo = (String)model.getValue("buyertaxno", rowIndex);
        String personalInvoice = (String)model.getValue("personalinvoice", rowIndex);
        String passVerifyBuyerName = " ";
        String passVerifyBuyerTaxNo = " ";
        if (StringUtils.isNotBlank((CharSequence)buyerCompanyName)) {
            buyerCompanyName = InvoiceUtils.removeSign((String)buyerCompanyName);
            if (StringUtils.isNotBlank((CharSequence)(companyName = InvoiceUtils.removeSign((String)companyName))) && StringUtils.equals((CharSequence)companyName, (CharSequence)buyerCompanyName)) {
                passVerifyBuyerName = "1";
            } else if (!StringUtils.equals((CharSequence)personalInvoice, (CharSequence)"1")) {
                passVerifyBuyerName = "0";
            }
        }
        if (StringUtils.isNotBlank((CharSequence)taxRegNum) && StringUtils.equals((CharSequence)taxRegNum, (CharSequence)buyerTaxNo)) {
            passVerifyBuyerTaxNo = "1";
        } else if (!StringUtils.equals((CharSequence)personalInvoice, (CharSequence)"1")) {
            passVerifyBuyerTaxNo = "0";
        }
        if (StringUtils.equals((CharSequence)personalInvoice, (CharSequence)"1")) {
            passVerifyBuyerName = " ";
            passVerifyBuyerTaxNo = " ";
        }
        this.validateMsg(passVerifyBuyerName, passVerifyBuyerTaxNo, rowIndex);
    }

    private String validateMsg(String passVerifyBuyerName, String passVerifyBuyerTaxNo, int rowIndex) {
        IDataModel model = this.getModel();
        StringBuilder validateMsg = new StringBuilder();
        String sequenceNum = (String)this.getModel().getValue("sequencenum", rowIndex);
        if (StringUtils.equals((CharSequence)passVerifyBuyerName, (CharSequence)"0")) {
            validateMsg.append(ResManager.loadKDString((String)"\u53d1\u7968\u62ac\u5934\u4e0e\u4f01\u4e1a\u540d\u79f0\u4e0d\u4e00\u81f4\u3002", (String)"AbstractImportInvoiceForReimPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.equals((CharSequence)passVerifyBuyerTaxNo, (CharSequence)"0")) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{validateMsg})) {
                validateMsg.append('\uff0c');
            }
            validateMsg.append(ResManager.loadKDString((String)"\u53d1\u7968\u7a0e\u53f7\u4e0e\u4f01\u4e1a\u7a0e\u53f7\u4e0d\u4e00\u81f4", (String)"AbstractImportInvoiceForReimPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.equals((CharSequence)sequenceNum, (CharSequence)"1")) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{validateMsg})) {
                validateMsg.append('\uff0c');
            }
            validateMsg.append(ResManager.loadKDString((String)"\u53d1\u7968\u8fde\u53f7", (String)"AbstractImportInvoiceForReimPlugin_11", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
        model.setValue("validatemessage", (Object)validateMsg, rowIndex);
        model.setValue("passverifybuyername", (Object)passVerifyBuyerName, rowIndex);
        model.setValue("passverifybuyertaxno", (Object)passVerifyBuyerTaxNo, rowIndex);
        return validateMsg.toString();
    }

    @Override
    public void processInvoiceVO(InvoiceContext invoiceContext) {
        BeforeImportInvoiceService beforeImportServiceImpl = this.getBeforeImportInvoiceServiceImpl(invoiceContext);
        RemoveInvoiceService removeDuplicateInvoiceService = this.getRemoveDuplicateInvoiceServiceImpl(invoiceContext);
        PreHandleInvoiceService addInvoiceItemService = this.getPreHandleInvoiceServiceImpl(invoiceContext);
        CopyInvoiceVOToInvoiceEntryBOServiceImpl copyInvoiceVOToInvoiceEntryBOService = new CopyInvoiceVOToInvoiceEntryBOServiceImpl(invoiceContext, this.getView().getEntityId());
        OffsetAmountInvoiceServiceImpl offsetAmountInvoiceService = new OffsetAmountInvoiceServiceImpl(invoiceContext);
        IInvoiceService mappingExpenseOrTripItemInvoiceService = this.getMappingItemImpl(invoiceContext);
        MergeInvoiceService mergeInvoiceServiceImpl = this.getMergeInvoiceService(invoiceContext);
        IInvoiceService BeforeCreateItemServiceImpl = this.getBeforeCreateItemServiceImpl(invoiceContext);
        PubReimburseBeforeImportInvoiceServiceImpl beforeImportInvoiceService = new PubReimburseBeforeImportInvoiceServiceImpl(invoiceContext, this.getView());
        CreateInvoiceServiceI createInvoiceEntryServiceImpl = this.getCreateInvoiceService(invoiceContext);
        IInvoiceService createExpenseOrTripItemService = this.getCreateExpenseOrTripItemService(invoiceContext);
        IInvoiceService afterCreateExpenseOrTripItemService = this.getAfterCreateExpenseOrTripItemService(invoiceContext);
        this.addProcessServices(new IInvoiceService[]{beforeImportServiceImpl, removeDuplicateInvoiceService, addInvoiceItemService, copyInvoiceVOToInvoiceEntryBOService, offsetAmountInvoiceService, mappingExpenseOrTripItemInvoiceService, mergeInvoiceServiceImpl, BeforeCreateItemServiceImpl, beforeImportInvoiceService, createInvoiceEntryServiceImpl, createExpenseOrTripItemService, afterCreateExpenseOrTripItemService});
    }

    @Override
    protected void loadAfterProcessUpdateView() {
        super.loadAfterProcessUpdateView();
        InvoiceOffsetUtils.updateItemOffset((IFormView)this.getExtView());
    }

    @Override
    protected String getCostCompanyKey() {
        return "costcompany";
    }

    @Override
    public DynamicObject getCostCompanyDO() {
        DynamicObject costCompanyDO = (DynamicObject)this.getModel().getValue(this.getCostCompanyKey());
        return costCompanyDO;
    }

    @Override
    public String getTaxRegNum() {
        DynamicObject costCompanyDO = this.getCostCompanyDO();
        if (costCompanyDO == null) {
            log.info("\u5f53\u524d\u5355\u636e\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a");
            return "";
        }
        String taxRegNum = KingdeeInvoiceCloudConfig.getTaxRegNum((long)((Long)costCompanyDO.getPkValue()));
        return taxRegNum;
    }

    protected List<String> getAllSerialNos() {
        return InvoiceServiceHelper.getAllSerialNos((IDataModel)this.getModel());
    }

    protected List<String> getSerialNosByItemEntryId(Long entryId) {
        List<DynamicObject> invoiceHeadDOs = this.getInvoiceHeadDOsByItemEntryId(entryId);
        if (invoiceHeadDOs.isEmpty()) {
            return new ArrayList<String>(0);
        }
        List<String> serialNos = invoiceHeadDOs.stream().map(invoiceHead -> invoiceHead.getString("serialno")).collect(Collectors.toList());
        return serialNos;
    }

    protected List<DynamicObject> getInvoiceHeadDOsByItemEntryId(Long entryId) {
        if (Objects.equals(entryId, 0L)) {
            return Collections.emptyList();
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection invoiceHeadEntryDOs = dataEntity.getDynamicObjectCollection("invoiceentry");
        DynamicObjectCollection invoiceItemEntryDOs = dataEntity.getDynamicObjectCollection("invoiceitementry");
        Set invoiceHeadEntryIds = invoiceItemEntryDOs.stream().filter(invoiceItem -> Objects.equals(invoiceItem.getLong("itementryid"), entryId)).map(invoiceItem -> invoiceItem.getLong("invoiceheadentryid")).collect(Collectors.toSet());
        List<DynamicObject> invoiceHeadDOs = invoiceHeadEntryDOs.stream().filter(invoiceHead -> invoiceHeadEntryIds.contains(invoiceHead.getPkValue())).collect(Collectors.toList());
        return invoiceHeadDOs;
    }

    protected List<String> getSerialNosByInvoiceNoAndCode(Set<String> invoiceNos, Set<String> invoiceCodes) {
        List<String> serialNos = new ArrayList<String>();
        if (invoiceNos.isEmpty() || invoiceCodes.isEmpty()) {
            log.info("\u53d1\u7968\u53f7\u7801\u6216\u53d1\u7968\u4ee3\u7801\u4e3a\u7a7a, \u4e0d\u9700\u8981\u67e5\u8be2\u53d1\u7968\u5e8f\u5217\u53f7. invoiceNos: {}, invoiceCodes: {}", invoiceNos, invoiceCodes);
            return serialNos;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection invoiceHeadEntryDOs = dataEntity.getDynamicObjectCollection("invoiceentry");
        DynamicObjectCollection invoiceMergeEntryDOs = new DynamicObjectCollection();
        boolean hasInvoiceMergeEntry = dataEntity.getDataEntityType().getProperties().containsKey((Object)"invoicemerge");
        if (hasInvoiceMergeEntry) {
            invoiceMergeEntryDOs = dataEntity.getDynamicObjectCollection("invoicemerge");
        }
        if (invoiceHeadEntryDOs.isEmpty() || invoiceMergeEntryDOs.isEmpty()) {
            log.info("\u53d1\u7968\u4fe1\u606f\u5206\u5f55\u6216\u53d1\u7968\u5408\u5e76\u4fe1\u606f\u5206\u5f55\u4e3a\u7a7a, \u4e0d\u9700\u8981\u67e5\u8be2\u53d1\u7968\u5e8f\u5217\u53f7. invoiceHeadEntryDOs: {}, invoiceMergeEntryDOs: {}", (Object)invoiceHeadEntryDOs, (Object)invoiceMergeEntryDOs);
            return serialNos;
        }
        Set keySerialNos = invoiceHeadEntryDOs.stream().filter(invoiceHead -> invoiceNos.contains(invoiceHead.getString("invoiceno")) && invoiceCodes.contains(invoiceHead.getString("invoicecode"))).map(invoiceHead -> invoiceHead.getString("serialno")).collect(Collectors.toSet());
        if (keySerialNos.isEmpty()) {
            log.info("\u6839\u636e\u53d1\u7968\u53f7\u7801,\u53d1\u7968\u4ee3\u7801\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u53d1\u7968.\u53d1\u7968\u53f7\u7801:" + invoiceNos + ",\u53d1\u7968\u4ee3\u7801:" + invoiceCodes);
            return serialNos;
        }
        serialNos = invoiceMergeEntryDOs.stream().filter(invoiceMerge -> keySerialNos.contains(invoiceMerge.getString("keyserialno"))).map(invoiceMerge -> invoiceMerge.getString("serialno_merge")).collect(Collectors.toList());
        return serialNos;
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String entityName = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)entityName, (CharSequence)"invoiceentry")) {
            int[] rowIndexs = e.getRowIndexs();
            if (rowIndexs == null || rowIndexs.length == 0) {
                return;
            }
            DynamicObjectCollection invoiceHeadDOs = dataEntity.getDynamicObjectCollection("invoiceentry");
            ArrayList<Object> needDelHeadDOs = new ArrayList<Object>(rowIndexs.length);
            for (int rowIndex : rowIndexs) {
                if (rowIndex >= invoiceHeadDOs.size()) continue;
                needDelHeadDOs.add(invoiceHeadDOs.get(rowIndex));
            }
            boolean fromBusiTrip = needDelHeadDOs.stream().anyMatch(invoiceHead -> StringUtils.equals((CharSequence)invoiceHead.getString("invoicefrom"), (CharSequence)InvoiceFrom.TripBusiness.getValue()));
            boolean allowdeleteinvoice = Boolean.parseBoolean(this.getView().getPageCache().get("allowdeleteinvoice"));
            if (!allowdeleteinvoice && fromBusiTrip) {
                e.setCancel(true);
                if (Boolean.parseBoolean(this.getView().getPageCache().get("deleteentryentitynocheckinvoiceentry"))) {
                    return;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6708\u7ed3\u8ba2\u5355\u53d1\u7968\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"AbstractImportInvoiceForReimPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"unsubmit") || StringUtils.equals((CharSequence)key, (CharSequence)"noapproval")) {
            this.updateInvoiceCloudEnable();
        }
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.updateInvoiceLabelShow();
        }
    }

    protected void updateInvoiceLabelShow() {
        if (this.isPc()) {
            return;
        }
        if (this.getModel().getDataEntity(true).getDynamicObjectType().getProperties().get((Object)"invoiceentry") == null) {
            return;
        }
        boolean isShowInvoicePanel = false;
        DynamicObjectCollection invoiceEntryDOs = this.getModel().getDataEntity(true).getDynamicObjectCollection("invoiceentry");
        if (invoiceEntryDOs.size() > 0) {
            isShowInvoicePanel = true;
        } else {
            DynamicObject CostCompanyDO = this.getCostCompanyDO();
            if (CostCompanyDO != null) {
                int showInvoiceEntry;
                Long companyId = (Long)CostCompanyDO.getPkValue();
                boolean invoiceIsEnabled = KingdeeInvoiceCloudConfig.isEnabled((long)companyId);
                if (invoiceIsEnabled) {
                    isShowInvoicePanel = true;
                } else if (ErEntityTypeUtils.isTripReimburseBill((String)this.getModel().getDataEntityType().getName()) && (showInvoiceEntry = SystemParamterUtil.getloancheckparam((long)companyId, (String)"isusedmonthlyinvoiceentry")) == 1) {
                    isShowInvoicePanel = true;
                }
            }
        }
        this.invoicePanelForMob(isShowInvoicePanel);
    }

    protected abstract void setDeleteAttachButtonVisible();

    @Override
    protected void setInvoiceCloudEnable(boolean isEnable) {
        String key = this.invoiceCloudEnableKey();
        if (this.getModel().getDataEntityType().getProperty(key) != null) {
            this.getModel().setValue(key, (Object)isEnable);
        }
        this.getModel().setDataChanged(false);
    }

    @Override
    protected String invoiceCloudEnableKey() {
        String entityId = this.getView().getEntityId();
        if (ErEntityTypeUtils.isTripReimburseBill((String)entityId) || StringUtils.equals((CharSequence)entityId, (CharSequence)"er_tripreimexpenseitem_m")) {
            return "invoicecloudenable";
        }
        return "isenableinvoice";
    }

    protected void invoicePanelForMob(boolean isShow) {
        boolean isDataChange = this.getModel().getDataChanged();
        if (this.getModel().getDataEntityType().getProperty("isshowinvoicepanel") != null) {
            this.getModel().setValue("isshowinvoicepanel", (Object)isShow);
            this.getView().updateView("isshowinvoicepanel");
        }
        this.getModel().setDataChanged(isDataChange);
    }

    protected void itemAmountEdit(DynamicObject company) {
        IDataModel model = this.getModel();
        boolean isDataChange = model.getDataChanged();
        if (this.isPc()) {
            boolean allowEdit = true;
            allowEdit = company != null ? ErCommonUtils.isAllowEditTaxAndTaxrate((Long)ErCommonUtils.getPk((Object)company)) : ErCommonUtils.isAllowEditTaxAndTaxrate((Long)ErCommonUtils.getPk((Object)model.getValue("company")));
            if (model.getDataEntityType().getProperty("itemamountedit") != null) {
                this.getModel().setValue("itemamountedit", (Object)allowEdit);
            }
        } else if (model.getDataEntityType().getProperty("itemamountedit") != null) {
            model.setValue("itemamountedit", (Object)ErCommonUtils.isAllowEditTaxAndTaxrate((Long)this.billCompany4Mob()));
        }
        model.setDataChanged(isDataChange);
    }

    protected long billCompany4Mob() {
        IDataModel model = this.getModel();
        long companyid = 0L;
        if (model.getDataEntityType().getProperty("company") != null) {
            companyid = ErCommonUtils.getPk((Object)model.getValue("company"));
        }
        return companyid;
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.itemAmountEdit(null);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.itemAmountEdit(null);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit") && !operate.getOption().tryGetVariableValue("afterconfirm", new RefObject())) {
            String isValidate = (String)((Submit)args.getSource()).getOption().getVariables().get("isValidate");
            if (StringUtils.equals((CharSequence)isValidate, (CharSequence)"1")) {
                return;
            }
            IDataModel model = this.getModel();
            String entityId = this.getView().getEntityId();
            Object type = null;
            type = ErEntityTypeUtils.isPublicReimburseBill((String)entityId) ? InvoiceUtils.BillEntityType.PublicReimburse : (ErEntityTypeUtils.isDailyReimburseBill((String)entityId) ? InvoiceUtils.BillEntityType.DailyReimburse : (ErEntityTypeUtils.isTripReimburseBill((String)entityId) ? InvoiceUtils.BillEntityType.TripReimburse : (StringUtils.equals((CharSequence)entityId, (CharSequence)"er_checkingpaybill") ? InvoiceUtils.BillEntityType.CheckingPayBill : null)));
            if (type != null && model.getDataEntityType().getProperty("invoiceentry") != null) {
                this.invoiceAmountValidator(args, (InvoiceUtils.BillEntityType)type);
                ((Submit)args.getSource()).getOption().setVariableValue("isValidate", "1");
            }
        }
    }

    protected void invoiceAmountValidator(BeforeDoOperationEventArgs args, InvoiceUtils.BillEntityType type) {
        OperateOption option = ((Submit)args.getSource()).getOption();
        if (!Boolean.parseBoolean((String)option.getVariables().get(INVOICE_AFTER_SUBMIT_KEY))) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObject company = this.getCompany(dataEntity);
            Boolean mustCheck = SystemParamterUtil.isAmountOverInvoice((Long)ErCommonUtils.getPk((Object)company));
            ArrayList resultList = Lists.newArrayList();
            if (mustCheck.booleanValue()) {
                resultList.addAll(InvoiceUtils.checkAmount((Object)this.getModel(), (InvoiceUtils.BillEntityType)type));
            }
            String resultMsg = resultList.stream().collect(Collectors.joining("\uff1b"));
            this.invoiceShowTips(resultMsg, args);
        }
    }

    private void invoiceShowTips(String resultMsg, BeforeDoOperationEventArgs args) {
        OperateOption option = ((Submit)args.getSource()).getOption();
        if (StringUtils.isNotBlank((CharSequence)resultMsg) && !args.isCancel()) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(INVOICE_SUBMIT_KEY, (IFormPlugin)this);
            String message = String.format(ResManager.loadKDString((String)"%1$s\uff0c\u662f\u5426\u63d0\u4ea4\uff1f", (String)"AbstractImportInvoiceForReimPlugin_10", (String)"fi-er-formplugin", (Object[])new Object[0]), resultMsg);
            this.getView().showConfirm(message, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            args.setCancel(true);
            OperateOptionUtils.setCurrentOpration((IPageCache)this.getPageCache(), (OperateOption)option, (String)"invoice");
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Control) {
            Control ctl = (Control)source;
            String key = ctl.getKey();
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            switch (key) {
                case "deleteattach_hyperlink": {
                    this.setClickKey(DELETE_ATTACH_CALLBACK_KEY);
                    this.openInvoiceCloudDel(dataEntity.getPkValue().toString(), dataEntity.getDataEntityType().getName(), this.getView());
                    break;
                }
                case "queryattach_hyperlink": {
                    this.openInvoiceCloudQuery(dataEntity.getPkValue().toString(), dataEntity.getDataEntityType().getName(), this.getView());
                }
            }
            if ("vectorap111".equals(key) || "flex_arow111".equals(key)) {
                this.setVector(this.getView());
            }
        }
    }

    @Override
    protected DynamicObject getCompany(DynamicObject dataEntity) {
        return dataEntity.getDynamicObject("company");
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (INVOICE_SUBMIT_KEY.equalsIgnoreCase(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOptionUtils.getCurrentOpration((IPageCache)this.getPageCache(), (String)"invoice");
            operateOption.setVariableValue(INVOICE_AFTER_SUBMIT_KEY, "true");
            this.getView().invokeOperation("submit", operateOption);
        }
    }

    @Override
    protected long getInvoiceCurrency() {
        DynamicObject company = this.getCompany(this.getModel().getDataEntity(true));
        if (company != null) {
            Long companyId = ErCommonUtils.getPk((Object)company);
            log.info("\u7533\u8bf7\u4eba\u516c\u53f8ID\u4e3acompanyId\uff1a" + companyId);
            if (companyId != null) {
                return SystemParamterUtil.getInvoiceEntryCurrency((Long)companyId);
            }
        } else {
            log.info("\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a");
        }
        return 1L;
    }

    @Override
    protected boolean isUseExpenseDate() {
        return true;
    }

    protected void updateAutomapinvoiceEnable() {
        InvoiceUtils.updateAutomapinvoiceEnable((IFormView)this.getView(), (String[])new String[]{"automapinvoice"});
    }
}

