/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.AfterDeleteEntryEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FlexBeforeClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.IInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.InvoiceVo2BoService.CopyInvoiceVOToInvoiceEntryBOServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.OffsetAmountInvoiceServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.beforeImportService.PubReimburseBeforeImportInvoiceServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.createInvoiceService.CreateInvoiceServiceI;
import kd.fi.er.business.invoicecloud.v2.service.impl.preHandleInvoiceService.PreHandleInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.removeInvoiceService.RemoveInvoiceService;
import kd.fi.er.business.log.InvoiceLogUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.common.model.invoice.bill.BillOfInvoice;
import kd.fi.er.common.model.invoice.xh.SimpleXhInvoiceVO;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoiceNonautoPlugin;
import kd.fi.er.formplugin.invoicecloud.v2.ImportInvoiceForDailyReimMobPlugin;
import kd.fi.er.formplugin.invoicecloud.v2.clientInterface.InvoiceMobClientInterface;
import kd.fi.er.formplugin.invoicecloud.v2.service.model.InvoiceEvent;
import kd.fi.er.formplugin.invoicecloud.v2.service.utils.InvoicePluginUtils;
import kd.fi.er.formplugin.invoicecloud.v2.util.RelateExpenseOrTripItemAndInvoiceUtil;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractImportInvoiceNonautoMobPlugin
extends AbstractImportInvoiceNonautoPlugin
implements InvoiceMobClientInterface {
    private static final Log log = LogFactory.getLog(ImportInvoiceForDailyReimMobPlugin.class);

    @Override
    public void processInvoiceVO(InvoiceContext invoiceContext) {
        RemoveInvoiceService removeDuplicateInvoiceService = this.getRemoveDuplicateInvoiceServiceImpl(invoiceContext);
        if (this.check(invoiceContext)) {
            return;
        }
        PreHandleInvoiceService addInvoiceItemService = this.getPreHandleInvoiceServiceImpl(invoiceContext);
        CopyInvoiceVOToInvoiceEntryBOServiceImpl copyInvoiceVOToInvoiceEntryBOService = new CopyInvoiceVOToInvoiceEntryBOServiceImpl(invoiceContext, this.getView().getEntityId());
        if ("true".equals(this.getPageCache().get("supplementinvoice"))) {
            copyInvoiceVOToInvoiceEntryBOService.setSupplement(true);
        }
        OffsetAmountInvoiceServiceImpl offsetAmountInvoiceService = new OffsetAmountInvoiceServiceImpl(invoiceContext);
        PubReimburseBeforeImportInvoiceServiceImpl beforeImportInvoiceService = new PubReimburseBeforeImportInvoiceServiceImpl(invoiceContext, this.getView());
        CreateInvoiceServiceI createInvoiceEntryServiceImpl = this.getCreateInvoiceService(invoiceContext);
        this.addProcessServices(new IInvoiceService[]{removeDuplicateInvoiceService, addInvoiceItemService, copyInvoiceVOToInvoiceEntryBOService, offsetAmountInvoiceService, beforeImportInvoiceService, createInvoiceEntryServiceImpl});
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String name = e.getEntryProp().getName();
        this.afterDelete(name);
    }

    public void afterDeleteEntry(AfterDeleteEntryEventArgs e) {
        String name = e.getEntryProp().getName();
        this.afterDelete(name);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object automapinvoice;
        String key = e.getProperty().getName();
        if ("automapinvoice".equals(key) && Boolean.parseBoolean((automapinvoice = e.getChangeSet()[0].getNewValue()).toString())) {
            this.getModel().setValue("needsuppleinvoice", (Object)"0");
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        InvoiceUtils.updateAutomapinvoiceEnable((IFormView)this.getView(), (String[])new String[]{"automapinvoice"});
    }

    protected abstract BillOfInvoice getBillOfInvoice();

    protected abstract boolean check(InvoiceContext var1);

    @Override
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"relateimportlabelap", "relatelabelap"});
    }

    @Override
    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Control) {
            String key;
            Control ctl = (Control)source;
            switch (key = ctl.getKey()) {
                case "relatelabelap": {
                    String checkEntryEmptyMsg = this.checkEntryExistBeforeRelate();
                    if (StringUtils.isNotEmpty((CharSequence)checkEntryEmptyMsg)) {
                        this.getView().showTipNotification(checkEntryEmptyMsg);
                        return;
                    }
                    if (!this.checkBeforeRelate("invoiceentry")) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5bfc\u5165\u53d1\u7968\u3002", (String)"ErNoAutoMapMobPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.setBillEntryid();
                    this.setEntryid("invoiceentry");
                    MobileFormShowParameter showParameter = new MobileFormShowParameter();
                    showParameter.setFormId(this.getRelateFormId());
                    showParameter.getOpenStyle().setShowType(ShowType.Floating);
                    showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, this.getRelateFormId()));
                    this.getView().showForm((FormShowParameter)showParameter);
                    break;
                }
                case "relateimportlabelap": {
                    this.importInvoiceMob(key);
                }
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
    }

    public void beforeClick(BeforeClickEvent evt) {
    }

    public void flexBeforeClosed(FlexBeforeClosedEvent e) {
    }

    public void afterLoadData(EventObject e) {
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
    }

    protected boolean checkBeforeRelate(String entry) {
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(entry);
        return collection.size() > 0;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (Objects.equals(actionId, "IMPORT_INVOICE_IN_MOB")) {
            Object returnData = event.getReturnData();
            if (returnData instanceof JSONObject) {
                JSONObject importInvoiceReturnData = (JSONObject)returnData;
                log.info("\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91\u79fb\u52a8\u7aef\u8fd4\u56de\u8fc7\u6765\u7684\u6570\u636e\u4e3a:" + importInvoiceReturnData.toJSONString());
                SimpleXhInvoiceVO simpleXhInvoiceVO = (SimpleXhInvoiceVO)JSONObject.parseObject((String)importInvoiceReturnData.toJSONString(), SimpleXhInvoiceVO.class);
                InvoiceLogUtils.insertLog((InvoiceLogUtils.InvoiceOpType)InvoiceLogUtils.InvoiceOpType.WEB_REQUEST, (String)"", (String)ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91\u79fb\u52a8\u7aef\u8fd4\u56de", (String)"ImportInvoice_2", (String)"fi-er-formplugin", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91\u79fb\u52a8\u7aef\u8fd4\u56de\u8fc7\u6765\u7684\u6570\u636e\u4e3a:%s", (String)"ImportInvoice_3", (String)"fi-er-formplugin", (Object[])new Object[0]), importInvoiceReturnData.toJSONString()));
                if (simpleXhInvoiceVO.getInvoiceData() != null && !simpleXhInvoiceVO.getInvoiceData().isEmpty() && !this.handleXhInvoice(this, simpleXhInvoiceVO, this.getModel())) {
                    this.invoiceDeletePageRule(this.isDeleting());
                    return;
                }
                InvoicePluginUtils.saveAttachment(this, this.getView(), simpleXhInvoiceVO.getAttachData());
            } else if (ErStdConfig.getBoolean((String)"intranet") && ErStdConfig.getShowImportInvoiceDataSimulatorMOB()) {
                InvoicePluginUtils.mobTest(this, returnData);
            }
            log.info("\u5bfc\u5165\u53d1\u7968\uff0c\u5237\u65b0\u6309\u94ae\u63a7\u4ef6");
            this.invoiceDeletePageRule(this.isDeleting());
        }
        InvoicePluginUtils.handleDeleteAttachment(this, new InvoiceEvent<ClosedCallBackEvent>(event));
    }

    @Override
    public String getCustomeEventName() {
        return "alreadyBackFromInvoiceCloud";
    }

    @Override
    protected String getCloseCallBackKey() {
        return "relateimportlabelap";
    }

    @Override
    protected String getClickKey() {
        return "relateimportlabelap";
    }

    protected abstract String checkEntryExistBeforeRelate();

    protected abstract void setBillEntryid();

    protected void setEntryid(String entry) {
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(entry);
        String entity = this.getView().getEntityId() + "." + entry;
        collection.forEach(m -> {
            Long entryId = (Long)m.getPkValue();
            if (Objects.equals(entryId, 0L)) {
                entryId = ORM.create().genLongId(entity);
                m.set("id", (Object)entryId);
            }
        });
    }

    protected abstract String getRelateFormId();

    private void afterDelete(String name) {
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"invoiceentry")) {
            InvoiceUtils.updateAutomapinvoiceEnable((IFormView)this.getView(), (String[])new String[]{"automapinvoice"});
        }
        boolean autoMapInvoice = (Boolean)this.getModel().getValue("automapinvoice");
        if (Arrays.asList("invoiceentry", "expenseentryentity", "tripentry").contains(name) && !autoMapInvoice) {
            String entityId = this.getModel().getDataEntityType().getName();
            if (ErEntityTypeUtils.isDailyReimburseBill((String)entityId)) {
                RelateExpenseOrTripItemAndInvoiceUtil.clearDirtExpenseAndInvoiceEntry((IFormView)this.getView(), (BillOfInvoice)BillOfInvoice.DailyReimburseBill);
            } else if (ErEntityTypeUtils.isPublicReimburseBill((String)entityId)) {
                RelateExpenseOrTripItemAndInvoiceUtil.clearDirtExpenseAndInvoiceEntry((IFormView)this.getView(), (BillOfInvoice)BillOfInvoice.DailyReimburseBill);
            } else if (ErEntityTypeUtils.isTripReimburseBill((String)entityId)) {
                RelateExpenseOrTripItemAndInvoiceUtil.clearDirtExpenseAndInvoiceEntry((IFormView)this.getView(), (BillOfInvoice)BillOfInvoice.TripReimburseBill);
            }
        }
    }
}

