/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2;

import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.utils.ErStdConfig;

public class ERentrustReimburseImportPlugin
extends BatchImportPlugin {
    private static Set<String> ALL_BILL_SET;
    private static final Log classlogger;

    public List<ComboItem> getOverrideFieldsConfig() {
        List overrideFieldsConfig = super.getOverrideFieldsConfig();
        ArrayList<ComboItem> tripAreaOverrideFieldsConfig = new ArrayList<ComboItem>(3);
        for (ComboItem item : overrideFieldsConfig) {
            if (!"consignor".equals(item.getValue()) && !"trustee".equals(item.getValue())) continue;
            tripAreaOverrideFieldsConfig.add(item);
        }
        return tripAreaOverrideFieldsConfig;
    }

    public ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        Map billType = BusinessDataServiceHelper.loadFromCache((String)"er_billtype", (String)"name", null);
        Set allBillType = billType.values().stream().map(v -> ((OrmLocaleValue)v.get("name")).getLocaleValue_zh_CN()).collect(Collectors.toSet());
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        while (iterator.hasNext()) {
            ImportBillData data = iterator.next();
            JSONObject jsonData = data.getData();
            String startdate = jsonData.getString("startdate");
            String enddate = jsonData.getString("enddate");
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date start = format.parse(startdate);
                long startTime = start.getTime();
                Date end = format.parse(enddate);
                long endTime = end.getTime();
                if (startTime > endTime) {
                    logger.log(Integer.valueOf(data.getStartIndex()), ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u3002\u5f00\u59cb\u65f6\u95f4\u5e94\u5c0f\u4e8e\u7ed3\u675f\u65f6\u95f4\u3002", (String)"ERentrustReimburseImportPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    logger.fail();
                    iterator.remove();
                    continue;
                }
                jsonData.put("rentrustdate", (Object)(startdate + "~" + enddate));
                String bills = jsonData.getString("rentrustedscope");
                if (bills.length() <= 0) continue;
                Set billSet = Arrays.stream(bills.split(";")).collect(Collectors.toSet());
                boolean flag = ALL_BILL_SET.containsAll(billSet);
                if (!flag) {
                    logger.log(Integer.valueOf(data.getStartIndex()), ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u3002\u8bf7\u68c0\u67e5\u59d4\u6258\u8303\u56f4\u5b57\u6bb5\u662f\u5426\u586b\u5199\u6b63\u786e\u3002", (String)"ERentrustReimburseImportPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    logger.fail();
                    iterator.remove();
                    continue;
                }
                String consignororgId = jsonData.getJSONObject("consignor").getString("number");
                String trusteeId = jsonData.getJSONObject("trustee").getString("number");
                if (consignororgId != null && trusteeId != null) {
                    jsonData.put("consignororg", (Object)this.queryDeptrByUserId(consignororgId));
                    jsonData.put("trusteeorg", (Object)this.queryDeptrByUserId(trusteeId));
                }
                StringBuilder sbd = new StringBuilder();
                for (String billName : billSet) {
                    DynamicObject billtype = QueryServiceHelper.queryOne((String)"er_billtype", (String)"number", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)billName)});
                    sbd.append(billtype.get("number")).append(",");
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("importprop", (Object)"number");
                jsonObject.put("number", (Object)sbd.toString());
                jsonData.put("entrustedscope", (Object)jsonObject);
            }
            catch (ParseException e) {
                logger.log(Integer.valueOf(data.getStartIndex()), ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u3002\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\u3002", (String)"ERentrustReimburseImportPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                logger.fail();
                iterator.remove();
            }
        }
        return super.save(rowdatas, logger);
    }

    private JSONObject queryDeptrByUserId(String id) {
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"entryentity.ispartjob, entryentity.dpt", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)id)});
        if (user != null) {
            DynamicObjectCollection depts = user.getDynamicObjectCollection("entryentity");
            DynamicObject mainDept = null;
            for (DynamicObject row : depts) {
                mainDept = row.getDynamicObject("dpt");
                if (row.getBoolean("ispartjob")) continue;
                break;
            }
            JSONObject dpt = new JSONObject();
            if (mainDept == null) {
                return null;
            }
            dpt.put("importprop", (Object)"number");
            dpt.put("number", (Object)mainDept.getString("number"));
            dpt.put("name", (Object)mainDept.getLocaleString("name").toString());
            return dpt;
        }
        return null;
    }

    static {
        classlogger = LogFactory.getLog(ERentrustReimburseImportPlugin.class);
        String allBillStr = ErStdConfig.get((String)"ALL_BILL_SET");
        Set<Object> tamp = new HashSet(8);
        tamp = Arrays.stream(allBillStr.split(";")).collect(Collectors.toSet());
        ALL_BILL_SET = Collections.unmodifiableSet(tamp);
    }
}

