/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2;

import com.google.common.collect.Lists;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IMobileView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.formplugin.invoicecloud.usecase.ShowInvoiceCloudPageUtil;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoicePlugin;
import org.apache.commons.lang3.StringUtils;

public class ImportAttachmentPlugin
extends AbstractImportInvoicePlugin {
    protected static final String HEAD_IMPORT_INVOICE = "selectinvoice";
    protected static final String HEAD_VIEW_INVOICE = "viewinvoice";
    protected static final String HEAD_VIEW_ATTACH = "viewattach";
    protected static final String ATTACHMENT_PANEL = "attachmentpanel";
    protected static final String HEAD_DELETE_ATTACH = "deleteattach";
    private static final Log logger = LogFactory.getLog(ImportAttachmentPlugin.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (this.getControl("tbmain") != null) {
            this.addItemClickListeners(new String[]{"tbmain"});
        }
        if (this.getControl("bar_reim") != null) {
            this.addItemClickListeners(new String[]{"bar_reim"});
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject costCompany = this.getCostCompanyDO();
        this.setInvoiceCloudEnable(costCompany);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object invoiceCloudEnable = null;
        if (this.getModel().getDataEntityType().getProperty(this.invoiceCloudEnableKey()) != null) {
            invoiceCloudEnable = this.getModel().getValue(this.invoiceCloudEnableKey());
            boolean isPush = this.getModel().getDataEntity().getDataEntityState().isPushChanged();
            if (invoiceCloudEnable == null || isPush) {
                DynamicObject costCompany = this.getCostCompanyDO();
                this.setInvoiceCloudEnable(costCompany);
                invoiceCloudEnable = this.getModel().getValue(this.invoiceCloudEnableKey());
            }
        }
        this.setInvoiceFunctionVisibile(Boolean.TRUE.equals(invoiceCloudEnable));
    }

    private void setInvoiceFunctionVisibile(Boolean visible) {
        this.getView().setVisible(visible, new String[]{HEAD_IMPORT_INVOICE, HEAD_VIEW_INVOICE, HEAD_DELETE_ATTACH, HEAD_VIEW_ATTACH});
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setSkipNoField(true);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        String entityName = this.getModel().getDataEntity().getDataEntityType().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)HEAD_VIEW_INVOICE)) {
            if (ErEntityTypeUtils.isShareBill((String)entityName)) {
                return;
            }
            if (this.getModel().getProperty("invoiceattachinfo") != null && this.getView().getModel().getEntryRowCount("invoiceattachinfo") == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53d1\u7968\u9644\u4ef6\u6570\u636e\u3002", (String)"ImportAttachmentPlugin_1", (String)"fi-er-business", (Object[])new Object[0]));
                return;
            }
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)HEAD_IMPORT_INVOICE)) {
            this.showSelectedInvoicePage("", "1", this.getExtView());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)HEAD_VIEW_INVOICE) || StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)HEAD_VIEW_ATTACH)) {
            this.showInvoiceList(Lists.newArrayListWithExpectedSize((int)0));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)HEAD_DELETE_ATTACH)) {
            this.showDeleteAttachPage();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (StringUtils.equals((CharSequence)name, (CharSequence)this.getCostCompanyKey())) {
            this.setInvoiceCloudEnable((DynamicObject)newValue);
            if (this.getModel().getDataEntityType().getProperty(this.invoiceCloudEnableKey()) != null) {
                Object invoiceCloudEnable = this.getModel().getValue(this.invoiceCloudEnableKey());
                this.setInvoiceFunctionVisibile(Boolean.TRUE.equals(invoiceCloudEnable));
            }
        }
    }

    @Override
    protected String getCostCompanyKey() {
        return "costcompany";
    }

    protected void setInvoiceCloudEnable(DynamicObject costCompany) {
        boolean isEnable = false;
        if (costCompany != null) {
            isEnable = KingdeeInvoiceCloudConfig.isEnabled((long)((Long)costCompany.getPkValue()));
        }
        String proName = this.invoiceCloudEnableKey();
        if (this.getModel().getDataEntityType().getProperty(proName) != null) {
            this.getModel().setValue(proName, (Object)isEnable);
        }
    }

    @Override
    protected String invoiceCloudEnableKey() {
        return "isenableinvoice";
    }

    @Override
    protected String getCloseCallBackKey() {
        return HEAD_IMPORT_INVOICE;
    }

    @Override
    public void showInvoiceList(List<String> serialNos) {
        serialNos.removeIf(StringUtils::isBlank);
        String taxRegNum = this.getTaxRegNum();
        if (StringUtils.isBlank((CharSequence)taxRegNum)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7ec4\u7ec7\u7684\u53d1\u7968\u4e91\u914d\u7f6e\u3002", (String)"AbstractImportInvoiceForReimPCPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        ShowInvoiceCloudPageUtil.viewInvoiceLst_pc((AbstractFormPlugin)this, this.getModel(), serialNos, ErCommonUtils.getPk((Object)this.getCostCompanyDO()), "1");
    }

    @Override
    public boolean isPc() {
        return !"mobile".equals(RequestContext.get().getClient()) && !(this.getView() instanceof IMobileView);
    }

    @Override
    public void processInvoiceVO(InvoiceContext context) {
    }

    @Override
    public MappingItemWithOrgInvoiceServiceImp.BillType getBillType() {
        return null;
    }

    @Override
    public String getTaxRegNum() {
        DynamicObject costCompanyDO = this.getCostCompanyDO();
        if (costCompanyDO == null) {
            return "";
        }
        String taxRegNum = KingdeeInvoiceCloudConfig.getTaxRegNum((long)((Long)costCompanyDO.getPkValue()));
        return taxRegNum;
    }

    @Override
    protected boolean isUseExpenseDate() {
        return false;
    }

    @Override
    protected DynamicObject getCompany(DynamicObject dataEntity) {
        return dataEntity.getDynamicObject("company");
    }
}

