/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.AdvContainer;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.kingdee.action.QueryBySerialNoAction;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.IInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.invoicecloud.v2.util.InvoiceJsonParseUtils;
import kd.fi.er.business.invoicecloud.v2.util.SimpleRelateExpenseOrTripItemAndInvoiceUtil;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.common.model.invoice.bill.BillOfInvoice;
import kd.fi.er.common.model.invoice.bo.InvoiceEntryBO;
import kd.fi.er.common.model.invoice.bo.PropBo;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoiceSupplementPCPlugin;
import org.apache.commons.collections.CollectionUtils;

public class ImportInvoiceForDailyReimPCSupplementPlugin
extends AbstractImportInvoiceSupplementPCPlugin {
    private static final String CLOSE = "close";
    private static final String IMPORTINVOICE = "importInvoice";
    private static final String DELETEINVOICE = "deleteInvoice";
    private static final Set<String> LOCKSUPPLEMENTSTATUSSET = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"A", "B", "C", "D", "H", "I"}));
    private static final Log logger = LogFactory.getLog(ImportInvoiceForDailyReimPCSupplementPlugin.class);
    private static final String EXPENSEENTRYIDS = "expenseEntryIds";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"supplementinvoice"});
    }

    @Override
    public void afterBindData(EventObject e) {
        String billStatus = (String)this.getModel().getValue("billstatus");
        billStatus = (String)StringUtils.defaultIfBlank((CharSequence)billStatus, (CharSequence)"A");
        boolean needsuppleinvoice = (Boolean)this.getModel().getValue("needsuppleinvoice");
        AdvContainer invoiceAdvContainer = (AdvContainer)this.getControl("invoice_entry_container");
        if (!LOCKSUPPLEMENTSTATUSSET.contains(billStatus) && needsuppleinvoice) {
            invoiceAdvContainer.setCollapse(false);
        }
    }

    @Override
    protected String getCloseCallBackKey() {
        return "supplementinvoice";
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (StringUtils.equals((CharSequence)afterDoOperationEventArgs.getOperateKey(), (CharSequence)"saveinvoice")) {
            if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                this.setDeleteInvoice(false);
                this.setImportInvoice(false);
            } else if (Boolean.parseBoolean((String)((Save)afterDoOperationEventArgs.getSource()).getOption().getVariables().get("saveinvoice"))) {
                this.getPageCache().put(CLOSE, "noClose");
            }
        } else if (StringUtils.equals((CharSequence)afterDoOperationEventArgs.getOperateKey(), (CharSequence)"submitredoffset") || StringUtils.equals((CharSequence)afterDoOperationEventArgs.getOperateKey(), (CharSequence)"confirmchangeinvoice")) {
            this.setDeleteInvoice(false);
            this.setImportInvoice(false);
        }
    }

    public void loadData(LoadDataEventArgs e) {
        super.loadData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"automapinvoice") && ((Boolean)e.getChangeSet()[0].getNewValue()).booleanValue()) {
            this.getModel().setValue("needsuppleinvoice", (Object)false);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        StringBuilder info = this.invoiceChangeInfo();
        if (info.length() != 0) {
            info.append(",").append(ResManager.loadKDString((String)"\u5355\u636e\u672a\u4fdd\u5b58\uff0c\u786e\u5b9a\u662f\u5426\u4fdd\u5b58\u4fee\u6539\u3002", (String)"ImportInvoiceForDailyReimPCSupplementPlugin_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
            String close = this.getPageCache().get(CLOSE);
            if (close == null) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CLOSE, (IFormPlugin)this);
                this.getView().showConfirm(info.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                e.setCancel(true);
            } else {
                if (!StringUtils.equals((CharSequence)close, (CharSequence)CLOSE)) {
                    e.setCancel(true);
                }
                this.getPageCache().remove(CLOSE);
            }
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)CLOSE, (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("saveinvoice", "true");
                operateOption.setVariableValue(CLOSE, "true");
                this.getView().invokeOperation("saveinvoice", operateOption);
            } else {
                this.getPageCache().put(CLOSE, CLOSE);
            }
            this.getView().close();
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        Set expenseEntryIds;
        String key = evt.getItemKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"supplementinvoice") && (expenseEntryIds = SimpleRelateExpenseOrTripItemAndInvoiceUtil.getSeleteEntryId((IFormView)this.getView(), (BillOfInvoice)this.getBillOfInvoice())).isEmpty()) {
            evt.setCancel(true);
            return;
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (ErStdConfig.isDev() && !ErStdConfig.getShowImportInvoiceDataSimulatorPC() && StringUtils.equals((CharSequence)key, (CharSequence)"supplementinvoice")) {
            QueryBySerialNoAction action = new QueryBySerialNoAction("test");
            String apiReturnJson = action.execute();
            try {
                List invoiceVOs = InvoiceJsonParseUtils.parseInvoiceVO((String)apiReturnJson);
                this.executeProcess(invoiceVOs);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                this.getView().showErrorNotification(e.getMessage());
            }
            return;
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"supplementinvoice")) {
            this.showSelectedInvoicePage(this.getExtView(), key);
        }
    }

    @Override
    protected void loadAfterProcessUpdateData(InvoiceContext invoiceContext) {
        super.loadAfterProcessUpdateData(invoiceContext);
        Set newInvoiceIds = invoiceContext.getInvoiceEntryBOs().stream().map(v -> v.getEntryId()).collect(Collectors.toSet());
        List<DynamicObject> selectedItems = this.getSelectedItems();
        if (CollectionUtils.isNotEmpty(selectedItems)) {
            Set expenseIds = selectedItems.stream().map(item -> (Long)item.getPkValue()).collect(Collectors.toSet());
            if (invoiceContext.getInvoiceEntryBOs() != null && invoiceContext.getInvoiceEntryBOs().size() > 0) {
                ArrayList<PropBo> propBos = new ArrayList<PropBo>(invoiceContext.getInvoiceEntryBOs().size());
                for (InvoiceEntryBO invoiceEntryBO : invoiceContext.getInvoiceEntryBOs()) {
                    PropBo propBo = new PropBo();
                    propBo.setInvoiceEntryId(invoiceEntryBO.getEntryId());
                    propBo.setSerialNo(invoiceEntryBO.getSerialNo());
                    propBos.add(propBo);
                }
                InvoiceUtils.buildMapinfo((IDataModel)this.getModel(), expenseIds, propBos);
            }
            SimpleRelateExpenseOrTripItemAndInvoiceUtil.refreshExpenseField((IDataModel)this.getModel(), (BillOfInvoice)this.getBillOfInvoice(), expenseIds, newInvoiceIds);
        }
    }

    @Override
    protected void loadAfterProcessUpdateView() {
        super.loadAfterProcessUpdateView();
        this.updateInvoiceValidateSummary(this.getView());
        this.setImportInvoice(true);
    }

    @Override
    public MappingItemWithOrgInvoiceServiceImp.BillType getBillType() {
        return MappingItemWithOrgInvoiceServiceImp.BillType.ExpenseItem;
    }

    @Override
    public IInvoiceService getCreateExpenseOrTripItemService(InvoiceContext invoiceContext) {
        return null;
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        IDataModel model;
        DynamicObject dataEntity;
        Map nonRelation;
        String name = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"invoiceentry") && !"true".equals(this.getPageCache().get("unbindinvoice")) && (nonRelation = InvoiceUtils.nonAutoMapItemMapingInfo((DynamicObject)(dataEntity = (model = this.getModel()).getDataEntity(true)))) != null && !nonRelation.isEmpty()) {
            Set nonInvoice = nonRelation.keySet();
            DynamicObjectCollection invoiceHeadEntryDOs = dataEntity.getDynamicObjectCollection("invoiceentry");
            Set existInvoiceHeadEntryIds = invoiceHeadEntryDOs.stream().map(invoiceHeadDO -> (Long)invoiceHeadDO.getPkValue()).collect(Collectors.toSet());
            Set needDeleteInvoiceSet = nonInvoice.stream().filter(v -> !existInvoiceHeadEntryIds.contains(v)).collect(Collectors.toSet());
            SimpleRelateExpenseOrTripItemAndInvoiceUtil.deleteMapinfo((IDataModel)this.getModel(), needDeleteInvoiceSet);
            this.setDeleteInvoice(true);
        }
    }

    protected void setImportInvoice(boolean bool) {
        String billStatus = (String)this.getModel().getValue("billstatus");
        billStatus = (String)StringUtils.defaultIfBlank((CharSequence)billStatus, (CharSequence)"A");
        boolean needsuppleinvoice = (Boolean)this.getModel().getValue("needsuppleinvoice");
        if (!LOCKSUPPLEMENTSTATUSSET.contains(billStatus) && needsuppleinvoice) {
            this.getPageCache().put(IMPORTINVOICE, bool ? "1" : "0");
        }
    }

    protected void setDeleteInvoice(boolean bool) {
        String billStatus = (String)this.getModel().getValue("billstatus");
        billStatus = (String)StringUtils.defaultIfBlank((CharSequence)billStatus, (CharSequence)"A");
        boolean needsuppleinvoice = (Boolean)this.getModel().getValue("needsuppleinvoice");
        if (!LOCKSUPPLEMENTSTATUSSET.contains(billStatus) && needsuppleinvoice) {
            this.getPageCache().put(DELETEINVOICE, bool ? "1" : "0");
        }
    }

    protected boolean isImportInvoice() {
        String importInvoiceType = this.getPageCache().get(IMPORTINVOICE);
        return StringUtils.equals((CharSequence)importInvoiceType, (CharSequence)"1");
    }

    protected boolean isDeleteInvoice() {
        String deleteInvoiceType = this.getPageCache().get(DELETEINVOICE);
        return StringUtils.equals((CharSequence)deleteInvoiceType, (CharSequence)"1");
    }

    protected StringBuilder invoiceChangeInfo() {
        StringBuilder info = new StringBuilder();
        if (this.isImportInvoice()) {
            info.append(ResManager.loadKDString((String)"\u5df2\u5bfc\u5165\u53d1\u7968", (String)"ImportInvoiceForDailyReimPCSupplementPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
        if (this.isDeleteInvoice()) {
            if (info.length() != 0) {
                info = new StringBuilder();
                info.append(ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f\u5df2\u4fee\u6539\u3002", (String)"ImportInvoiceForDailyReimPCSupplementPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
            } else {
                info.append(ResManager.loadKDString((String)"\u5df2\u5220\u9664\u53d1\u7968", (String)"ImportInvoiceForDailyReimPCSupplementPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        }
        return info;
    }

    protected BillOfInvoice getBillOfInvoice() {
        return BillOfInvoice.DailyReimburseBill;
    }

    @Override
    protected String getClickKey() {
        return "supplementinvoice";
    }
}

