/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.invoicecloud.kingdee.action.QueryBySerialNoAction;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.IInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.invoicecloud.v2.util.InvoiceJsonParseUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.common.exception.invoice.InvoiceCloudException;
import kd.fi.er.common.model.invoice.bill.BillExpenseInfoFildKeyType;
import kd.fi.er.common.model.invoice.bill.BillOfInvoice;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoiceNonautoPCPlugin;
import kd.fi.er.formplugin.invoicecloud.v2.util.RelateExpenseOrTripItemAndInvoiceUtil;
import org.apache.commons.lang3.StringUtils;

public class ImportInvoiceForDailyReimPCWithoutExpenseItem
extends AbstractImportInvoiceNonautoPCPlugin
implements RowClickEventListener {
    private static final Log log = LogFactory.getLog(ImportInvoiceForDailyReimPCWithoutExpenseItem.class);
    private static final String BILLINGPOOL_SELECT_LAYOUT = "er_select_billingpool";
    private static final String ADD_INVOICE = "addinvoicerow";
    private static final String ACTION_SEL = "selectBillingPool";
    private static final String IMPORT_BILLINGPOOL = "importbilling";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap22"});
        this.addItemClickListeners(new String[]{"advcontoolbarap31"});
        this.addItemClickListeners(new String[]{"advcontoolbarap3"});
        AbstractGrid expenseEntryGrid = (AbstractGrid)this.getView().getControl("expenseentryentity");
        expenseEntryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)this.getCloseCallBackKey())) {
            if (!ErStdConfig.isUnitTest() && ErStdConfig.isDev() && !ErStdConfig.getShowImportInvoiceDataSimulatorPC()) {
                QueryBySerialNoAction action = new QueryBySerialNoAction("test");
                String apiReturnJson = action.execute();
                try {
                    List invoiceVOs = InvoiceJsonParseUtils.parseInvoiceVO((String)apiReturnJson);
                    this.executeProcess(invoiceVOs);
                }
                catch (InvoiceCloudException e) {
                    log.error((Throwable)e);
                }
            } else {
                this.showSelectedInvoicePage(this.getExtView(), itemKey);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)"mapinvoice") || StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)"mapinvoiceentry")) {
            RelateExpenseOrTripItemAndInvoiceUtil.mapExpenseEntryAndInvoiceEntry((IFormView)this.getView(), (BillOfInvoice)BillOfInvoice.DailyReimburseBill);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)"mapinvoicebyinvoiceno") || StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)"mapinvoicebyinvoicenoentr")) {
            this.mapExpenseEntryAndInvoiceEntryByInvoiceNo();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)IMPORT_BILLINGPOOL)) {
            this.showSelectBillingPool();
        }
    }

    @Override
    protected void loadAfterProcessUpdateView() {
        super.loadAfterProcessUpdateView();
        this.updateInvoiceValidateSummary(this.getView());
    }

    @Override
    public MappingItemWithOrgInvoiceServiceImp.BillType getBillType() {
        return MappingItemWithOrgInvoiceServiceImp.BillType.ExpenseItem;
    }

    @Override
    public IInvoiceService getCreateExpenseOrTripItemService(InvoiceContext invoiceContext) {
        return null;
    }

    public void entryRowClick(RowClickEvent evt) {
        Object source = evt.getSource();
        if (source instanceof EntryGrid) {
            EntryGrid grid = (EntryGrid)source;
            String entryKey = grid.getEntryKey();
            int[] rowIndexs = grid.getSelectRows();
            if (StringUtils.equals((CharSequence)entryKey, (CharSequence)BillOfInvoice.DailyReimburseBill.getExpenseEntryEntityName()) && rowIndexs != null) {
                RelateExpenseOrTripItemAndInvoiceUtil.selectedRelateInvoiceEntryByClickExpenseEntry((IFormView)this.getView(), (BillOfInvoice)BillOfInvoice.DailyReimburseBill);
            }
        }
    }

    private void mapExpenseEntryAndInvoiceEntryByInvoiceNo() {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection expenseEntryDOs = dataEntity.getDynamicObjectCollection("expenseentryentity");
        boolean noInvoiceNos = expenseEntryDOs.stream().allMatch(entry -> StringUtils.isBlank((CharSequence)entry.getString("invoiceno_entry")));
        DynamicObjectCollection invoiceEntryDOs = dataEntity.getDynamicObjectCollection("invoiceentry");
        if (noInvoiceNos || invoiceEntryDOs.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d39\u7528\u660e\u7ec6\u4e0e\u53d1\u7968\u4fe1\u606f\u65e0\u76f8\u540c\u7684\u53d1\u7968\u53f7\uff0c \u9700\u624b\u52a8\u5173\u8054\u3002", (String)"ImportInvoiceForDailyReimPCWithoutExpenseItem_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        List<String> invoiceNoList = invoiceEntryDOs.stream().map(entry -> entry.getString("invoiceno").trim()).collect(Collectors.toList());
        HashMap invoiceNoCounter = Maps.newHashMap();
        invoiceNoList.forEach(invoiceNo -> invoiceNoCounter.put(invoiceNo, invoiceNoCounter.getOrDefault(invoiceNo, 0) + 1));
        Set dupInvoiceNo = invoiceNoCounter.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(entry -> (String)entry.getKey()).collect(Collectors.toSet());
        DynamicObjectCollection invoceAndExpenseDOs = dataEntity.getDynamicObjectCollection("invoiceandexpense");
        Set mappedExpenseEntryIds = invoceAndExpenseDOs.stream().map(entry -> entry.getLong("expenseentryid")).collect(Collectors.toSet());
        HashSet unMappedInvoiceNoSetInExpenseEntry = expenseEntryDOs.stream().filter(entry -> !mappedExpenseEntryIds.contains(entry.getPkValue()) && StringUtils.isNotBlank((CharSequence)entry.getString("invoiceno_entry"))).flatMap(entry -> Arrays.stream(entry.getString("invoiceno_entry").split(","))).collect(Collectors.toSet());
        unMappedInvoiceNoSetInExpenseEntry = Sets.newHashSet(unMappedInvoiceNoSetInExpenseEntry);
        if (!dupInvoiceNo.isEmpty()) {
            boolean containDupInvoice = unMappedInvoiceNoSetInExpenseEntry.stream().anyMatch(invoiceNo -> dupInvoiceNo.contains(invoiceNo.trim()));
            log.info("\u76f8\u540c\u7684\u53d1\u7968\u53f7\u7801\u4e3a: " + dupInvoiceNo);
            if (containDupInvoice) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d39\u7528\u660e\u7ec6\u4e0e\u53d1\u7968\u4fe1\u606f\u65e0\u76f8\u540c\u7684\u53d1\u7968\u53f7\uff0c \u9700\u624b\u52a8\u5173\u8054\u3002", (String)"ImportInvoiceForDailyReimPCWithoutExpenseItem_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        unMappedInvoiceNoSetInExpenseEntry.removeAll(invoiceNoCounter.keySet());
        if (!unMappedInvoiceNoSetInExpenseEntry.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u53d1\u7968\u53f7\u7801\u5728\u53d1\u7968\u5206\u5f55\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u53d1\u7968\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u5173\u8054: %1$s", (String)"ImportInvoiceForDailyReimPCWithoutExpenseItem_8", (String)"fi-er-formplugin", (Object[])new Object[0]), StringUtils.join((Iterable)unMappedInvoiceNoSetInExpenseEntry, (String)",")));
            return;
        }
        long[] expenseEntryIds = ORM.create().genLongIds(this.getView().getEntityId(), expenseEntryDOs.size());
        for (int i = 0; i < expenseEntryDOs.size(); ++i) {
            DynamicObject expenseEntryDO = (DynamicObject)expenseEntryDOs.get(i);
            Long expenseEntryId = (Long)expenseEntryDO.getPkValue();
            if (Objects.equals(expenseEntryId, 0L)) {
                expenseEntryDO.set("id", (Object)expenseEntryIds[i]);
                expenseEntryId = expenseEntryIds[i];
            }
            ArrayList invoiceEntryIds = Lists.newArrayList();
            String unionInvoiceNos = expenseEntryDO.getString("invoiceno_entry");
            if (StringUtils.isNotBlank((CharSequence)unionInvoiceNos)) {
                for (String invoiceNo2 : unionInvoiceNos.split(",")) {
                    Long invoiceEntryIdByInvoiceNo = ImportInvoiceForDailyReimPCWithoutExpenseItem.getInvoiceEntryIdByInvoiceNo(invoiceEntryDOs, invoiceNo2 = invoiceNo2.trim());
                    if (invoiceEntryIdByInvoiceNo == null) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u53d1\u7968\u53f7\u7801\u5728\u53d1\u7968\u5206\u5f55\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u53d1\u7968\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u5173\u8054: %1$s", (String)"ImportInvoiceForDailyReimPCWithoutExpenseItem_8", (String)"fi-er-formplugin", (Object[])new Object[0]), invoiceNo2));
                        return;
                    }
                    invoiceEntryIds.add(invoiceEntryIdByInvoiceNo);
                }
            }
            if (!this.checkIsAllowMapTripOrExpenseEntry(invoiceEntryIds)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8d39\u7528\u660e\u7ec6\u5bf9\u5e94\u7684\u53d1\u7968\u5fc5\u987b\u662f\u540c\u4e00\u7c7b\u578b\u7684\u53d1\u7968\u3002", (String)"ImportInvoiceForDailyReimPCWithoutExpenseItem_3", (String)"fi-er-formplugin", (Object[])new Object[0]), i + 1));
                return;
            }
            this.mapExpenseEntryAndInvoiceEntryBy(Collections.singletonList(expenseEntryId), invoiceEntryIds);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7968\u53f7\u81ea\u52a8\u5173\u8054\u6210\u529f\u3002", (String)"ImportInvoiceForDailyReimPCWithoutExpenseItem_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
    }

    public static Long getInvoiceEntryIdByInvoiceNo(DynamicObjectCollection invoiceEntrys, String invoiceNo) {
        DynamicObject invoiceEntry = invoiceEntrys.stream().filter(entry -> StringUtils.equals((CharSequence)entry.getString("invoiceno").trim(), (CharSequence)invoiceNo.trim())).findFirst().orElse(null);
        return invoiceEntry == null ? null : (Long)invoiceEntry.getPkValue();
    }

    private void mapExpenseEntryAndInvoiceEntryBy(List<Long> expenseEntryIds, List<Long> invoiceEntryIds) {
        int i;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection invoiceAndExpenseEntrys = dataEntity.getDynamicObjectCollection("invoiceandexpense");
        DynamicObjectCollection invoiceEntrys = dataEntity.getDynamicObjectCollection("invoiceentry");
        DynamicObjectCollection expenseEntryDOs = dataEntity.getDynamicObjectCollection("expenseentryentity");
        ArrayList needDelIndexs = Lists.newArrayList();
        for (i = 0; i < invoiceAndExpenseEntrys.size(); ++i) {
            if (!expenseEntryIds.contains(((DynamicObject)invoiceAndExpenseEntrys.get(i)).getLong("expenseentryid"))) continue;
            needDelIndexs.add(i);
        }
        this.getModel().deleteEntryRows("invoiceandexpense", needDelIndexs.stream().mapToInt(Integer::intValue).toArray());
        for (i = 0; i < expenseEntryIds.size(); ++i) {
            for (int j = 0; j < invoiceEntryIds.size(); ++j) {
                int newRowIndex = this.getModel().createNewEntryRow("invoiceandexpense");
                this.getModel().setValue("expenseentryid", (Object)expenseEntryIds.get(i), newRowIndex);
                this.getModel().setValue("invoiceentryid", (Object)invoiceEntryIds.get(j), newRowIndex);
                if (this.getModel().getProperty("invoiceexpserialno") == null || j >= invoiceEntrys.size()) continue;
                this.getModel().setValue("invoiceexpserialno", ((DynamicObject)invoiceEntrys.get(j)).get("serialno"), newRowIndex);
            }
        }
        String unionInvoiceCode = invoiceEntrys.stream().filter(entry -> invoiceEntryIds.contains(entry.getPkValue())).map(entry -> entry.getString("invoicecode")).collect(Collectors.joining(","));
        String unionInvoiceNo = invoiceEntrys.stream().filter(entry -> invoiceEntryIds.contains(entry.getPkValue())).map(entry -> entry.getString("invoiceno")).collect(Collectors.joining(","));
        ItemFrom itemFrom = invoiceEntryIds.isEmpty() ? ItemFrom.Manual : ItemFrom.InvoiceCloud;
        for (int rowIndex = 0; rowIndex < expenseEntryDOs.size(); ++rowIndex) {
            DynamicObject expenseEntryDO = (DynamicObject)expenseEntryDOs.get(rowIndex);
            if (!expenseEntryIds.contains(ErCommonUtils.getPk((Object)expenseEntryDO))) continue;
            this.getModel().setValue("invoiceno_entry", (Object)InvoiceUtils.getLimitedInvoiceNo((String)unionInvoiceNo), rowIndex);
            this.getModel().setValue("invoicelink", (Object)InvoiceUtils.getLimitedInvoiceCode((String)unionInvoiceCode), rowIndex);
            InvoiceOffsetUtils.setModelValue((IDataModel)this.getModel(), (BillExpenseInfoFildKeyType)BillExpenseInfoFildKeyType.DailyReimburse, (int)rowIndex, (int)0);
            this.getModel().setValue("itemfrom", (Object)itemFrom.getValue(), rowIndex);
        }
        RelateExpenseOrTripItemAndInvoiceUtil.updateIsMapExpense((IFormView)this.getView(), (DynamicObject)dataEntity);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent eventSource) {
        if (!ThreadCache.exists((Object)"clickKey") && ACTION_SEL.equals(eventSource.getActionId())) {
            ThreadCache.put((Object)"clickKey", (Object)ACTION_SEL);
        }
        super.closedCallBack(eventSource);
    }

    private void showSelectBillingPool() {
        DynamicObjectCollection invoiceEntryDOs;
        Long pk;
        ListShowParameter showParameter = new ListShowParameter();
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960");
        styleCss.setHeight("580");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        showParameter.setLookUp(true);
        showParameter.setShowTitle(false);
        showParameter.setBillFormId(BILLINGPOOL_SELECT_LAYOUT);
        showParameter.setFormId("bos_listf7");
        HashMap<String, Object> customParam = new HashMap<String, Object>(2);
        DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
        Object company = this.getModel().getValue("costcompany");
        if (null != company) {
            pk = ErCommonUtils.getPk((Object)company);
            customParam.put("costcompany", pk);
        }
        if (properties.containsKey((Object)"billpayerid")) {
            pk = ErCommonUtils.getPk((Object)this.getModel().getValue("billpayerid"));
            customParam.put("billpayerid", pk);
        }
        if (CollectionUtils.isNotEmpty((Collection)(invoiceEntryDOs = this.getModel().getEntryEntity("invoiceentry")))) {
            List ids = invoiceEntryDOs.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getString("billingpoolid"))).map(item -> item.getLong("billingpoolid")).collect(Collectors.toList());
            customParam.put("billingpoolIds", ids);
        }
        showParameter.setCustomParams(customParam);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_SEL));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

