/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.IInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService.CreateTripItemEntryServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.incrementalService.IncrementalMergeExpenseOrTripItemInvoiceServiceImp;
import kd.fi.er.business.invoicecloud.v2.service.impl.incrementalService.IncrementalServiceI;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.common.model.invoice.bill.BillExpenseInfoFildKeyType;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoiceForReimPCByItemEntry;
import kd.fi.er.formplugin.invoicecloud.v2.validator.InvoiceValidator;
import kd.fi.er.formplugin.invoicecloud.v2.validator.TripCardInvoiceCurrencyValidator;
import org.apache.commons.lang3.StringUtils;

public class ImportInvoiceForTripReimPCByTripItemEntry
extends AbstractImportInvoiceForReimPCByItemEntry {
    private static final Log log = LogFactory.getLog(ImportInvoiceForTripReimPCByTripItemEntry.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"trip2advtoolbar"});
    }

    @Override
    public void beforeClick(BeforeClickEvent evt) {
        Object source = evt.getSource();
        if (source instanceof Label) {
            String key = ((Label)source).getKey();
            this.putClickKeyInCache(key);
            if (this.checkCacheClickKey(key)) {
                DynamicObject seletedItem = this.getSelectedItem();
                if (seletedItem == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u67d0\u4e00\u884c\u8d39\u7528\u660e\u7ec6\u5206\u5f55\u540e\u518d\u5bfc\u5165\u53d1\u7968\u3002", (String)"ImportInvoiceForTripReimPCByTripItemEntry_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                String invoiceCode = seletedItem.getString("invoiceno_entry");
                if (StringUtils.isNotBlank((CharSequence)invoiceCode)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u8d39\u7528\u5206\u5f55\u884c\u5df2\u6709\u5173\u8054\u53d1\u7968\u4fe1\u606f\uff0c\u8bf7\u9009\u62e9\u6216\u65b0\u5efa\u5176\u4ed6\u8d39\u7528\u5206\u5f55\u884c\u518d\u6309\u89c4\u5219\u5bfc\u5165\u53d1\u7968\u3002", (String)"ImportInvoiceForTripReimPCByTripItemEntry_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                }
            }
        }
    }

    @Override
    public IncrementalServiceI getIncrementalService(InvoiceContext invoiceContext, int index) {
        return new IncrementalMergeExpenseOrTripItemInvoiceServiceImp(invoiceContext, this.getModel(), true);
    }

    @Override
    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Label) {
            String key = ((Label)source).getKey();
            this.putClickKeyInCache(key);
            if (key.equals("expenseimportinvoice") || this.checkCacheClickKey(key)) {
                super.importInvoiceByExpenseOrTripItem("entryentity", key);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        this.putClickKeyInCache(evt.getItemKey());
        if ("expenseimportinvoice".equals(evt.getItemKey()) || this.checkCacheClickKey(evt.getItemKey())) {
            EntryGrid tripItemEntryGrid = (EntryGrid)this.getView().getControl("entryentity");
            int[] selectRows = tripItemEntryGrid.getSelectRows();
            if (selectRows != null && selectRows.length == 1) {
                super.importInvoiceByExpenseOrTripItem("entryentity", evt.getItemKey());
            } else if (selectRows != null && selectRows.length > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u540c\u65f6\u9009\u4e2d\u591a\u884c\u5dee\u65c5\u660e\u7ec6\u5bfc\u5165\u53d1\u7968\uff0c\u8bf7\u53ea\u9009\u4e2d\u4e00\u884c\u5dee\u65c5\u660e\u7ec6\u5206\u5f55\u540e\u518d\u5bfc\u5165\u53d1\u7968\u3002", (String)"ImportInvoiceForTripReimPCByTripItemEntry_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u67d0\u4e00\u884c\u8d39\u7528\u660e\u7ec6\u5206\u5f55\u540e\u518d\u5bfc\u5165\u53d1\u7968\u3002", (String)"ImportInvoiceForTripReimPCByTripItemEntry_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void putClickKeyInCache(String itemKey) {
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)this.getAnotherCloseCallBackKey())) {
            this.getPageCache().put("clickKey", itemKey);
        } else {
            this.getPageCache().remove("clickKey");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] valueDate = e.getChangeSet();
        Object newData = valueDate[0].getNewValue();
        int currentIndex = valueDate[0].getRowIndex();
        int tripIndex = valueDate[0].getParentRowIndex();
        Boolean needSuppleInvoice = (Boolean)this.getModel().getValue("needsuppleinvoice");
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"invoiceno_entry") && !needSuppleInvoice.booleanValue()) {
            InvoiceOffsetUtils.setModelValue((IDataModel)this.getModel(), (BillExpenseInfoFildKeyType)BillExpenseInfoFildKeyType.TripReimburse, (int)currentIndex, (int)tripIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"automapinvoice")) {
            if (((Boolean)newData).booleanValue()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"expenseimportinvoice", "mergebyitem"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"expenseimportinvoice", "mergebyitem"});
            }
        }
    }

    @Override
    public boolean isTrip() {
        return true;
    }

    @Override
    protected boolean validateBeforeImport() {
        return true;
    }

    @Override
    public IInvoiceService getCreateExpenseOrTripItemService(InvoiceContext invoiceContext) {
        CreateTripItemEntryServiceImpl service = new CreateTripItemEntryServiceImpl(invoiceContext, this.getModel(), this.isOrgOffset());
        if (this.checkCacheClickKey(this.getAnotherCloseCallBackKey())) {
            service.setCurSelectedItem(this.getSelectedItem());
        }
        return service;
    }

    @Override
    protected int getCurrentIndex() {
        String billKind = (String)this.getModel().getValue("billkind");
        if (StringUtils.equals((CharSequence)billKind, (CharSequence)"1")) {
            EntryGrid expenseEntryGrid = (EntryGrid)this.getView().getControl("entryentity");
            int[] selectRows = expenseEntryGrid.getSelectRows();
            if (selectRows != null && selectRows.length > 0) {
                return selectRows[0];
            }
        } else {
            return this.getModel().getEntryCurrentRowIndex("entryentity");
        }
        return 0;
    }

    @Override
    public MappingItemWithOrgInvoiceServiceImp.BillType getBillType() {
        return MappingItemWithOrgInvoiceServiceImp.BillType.TripItem;
    }

    @Override
    protected DynamicObject getCompany(DynamicObject dataEntity) {
        return dataEntity.getDynamicObject("company");
    }

    @Override
    protected void loadAfterProcessUpdateView() {
        super.loadAfterProcessUpdateView();
        this.getView().getModel().updateCache();
        this.getView().updateView("entryentity");
    }

    @Override
    protected List<InvoiceValidator> addInvoiceValidators() {
        return Collections.singletonList(new TripCardInvoiceCurrencyValidator());
    }
}

