/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.container.AdvContainer;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.invoicecloud.kingdee.InvoiceTypeEnum;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.common.model.invoice.bill.BillExpenseInfoFildKeyType;
import kd.fi.er.common.model.invoice.bill.BillOfInvoice;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoiceNonautoPCPlugin;
import kd.fi.er.formplugin.invoicecloud.v2.util.RelateExpenseOrTripItemAndInvoiceUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ImportInvoiceForTripReimPCWithoutExpenseItem
extends AbstractImportInvoiceNonautoPCPlugin
implements RowClickEventListener {
    private static final Log log = LogFactory.getLog(ImportInvoiceForTripReimPCWithoutExpenseItem.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap31"});
        AbstractGrid expenseEntryGrid = (AbstractGrid)this.getView().getControl(BillOfInvoice.TripReimburseBill.getExpenseEntryEntityName());
        expenseEntryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Boolean isAutoMapInvoice;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"expenseitem") && StringUtils.equals((CharSequence)((String)this.getModel().getValue("billkind")), (CharSequence)"0") && !(isAutoMapInvoice = (Boolean)this.getModel().getValue("automapinvoice")).booleanValue()) {
            this.updateIsMapExpense();
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        IDataModel model = this.getModel();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)"mapinvoice")) {
            DynamicObjectCollection tripEntry = model.getEntryEntity("tripentry");
            int tripEntryCount = tripEntry.size();
            if (tripEntryCount < 1) {
                log.info("\u5dee\u65c5\u62a5\u9500\u5355\u7684\u884c\u7a0b\u5206\u5f55\u6570\u91cf\u4e3a0, \u4e0d\u80fd\u5173\u8054\u53d1\u7968");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u884c\u7a0b\u3002", (String)"ImportInvoiceForTripReimPCWithoutExpenseItem_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            int tripInfoEntry = 0;
            for (int i = 0; i < tripEntry.size(); ++i) {
                DynamicObjectCollection expenseEntry = ((DynamicObject)tripEntry.get(i)).getDynamicObjectCollection("entryentity");
                tripInfoEntry += expenseEntry.size();
            }
            if (tripInfoEntry < 1) {
                log.info("\u5dee\u65c5\u62a5\u9500\u5355\u7684\u5dee\u65c5\u660e\u7ec6\u6570\u91cf\u4e3a0, \u4e0d\u80fd\u5173\u8054\u53d1\u7968");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u5dee\u65c5\u660e\u7ec6\u3002", (String)"ImportInvoiceForTripReimPCWithoutExpenseItem_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            int invoiceEntryCount = this.getModel().getEntryRowCount("invoiceentry");
            if (invoiceEntryCount < 1) {
                log.info("\u5dee\u65c5\u62a5\u9500\u5355\u7684\u53d1\u7968\u4fe1\u606f\u5206\u5f55\u6570\u91cf\u4e3a0, \u4e0d\u80fd\u5173\u8054\u8d39\u7528");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5bfc\u5165\u53d1\u7968\u4fe1\u606f\u3002", (String)"ImportInvoiceForTripReimPCWithoutExpenseItem_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            EntryGrid invoiceEntryGrid = (EntryGrid)this.getControl("invoiceentry");
            int[] selected = invoiceEntryGrid.getSelectRows();
            DynamicObjectCollection invoiceDobjEntry = model.getEntryEntity("invoiceentry");
            String billKind = (String)this.getModel().getValue("billkind");
            if (selected.length < 1 && StringUtils.equals((CharSequence)billKind, (CharSequence)"0")) {
                log.info("\u5f53\u524d\u9009\u4e2d\u53d1\u7968\u4fe1\u606f\u5206\u5f55\u4e3a0\u884c, \u4e0d\u80fd\u5173\u8054\u8d39\u7528");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d1\u7968\u4fe1\u606f\uff0c\u518d\u5173\u8054\u8d39\u7528\u3002", (String)"ImportInvoiceForTripReimPCWithoutExpenseItem_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            for (int i = 0; i < selected.length; ++i) {
                String invoicefrom = ((DynamicObject)invoiceDobjEntry.get(selected[i])).getString("invoicefrom");
                if (!StringUtils.equals((CharSequence)invoicefrom, (CharSequence)"3")) continue;
                log.info("\u5f53\u524d\u9009\u4e2d\u7684\u53d1\u7968\u4e2d\u5305\u542b\u5546\u65c5\u53d1\u7968, \u4e0d\u80fd\u5173\u8054\u8d39\u7528\uff1aselected[i]");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u53d1\u7968\u4e2d\u5305\u542b\u5546\u65c5\u53d1\u7968\uff0c\u4e0d\u80fd\u5173\u8054\u8d39\u7528\u3002\u8bf7\u5148\u53d6\u6d88\u9009\u62e9\u5546\u65c5\u53d1\u7968\uff0c\u518d\u5173\u8054\u8d39\u7528\u3002", (String)"ImportInvoiceForTripReimPCWithoutExpenseItem_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (CollectionUtils.isEmpty((Collection)invoiceDobjEntry) || selected.length == 0) {
                return;
            }
            Set invCurrencySet = Arrays.stream(selected).mapToObj(rowIndex -> (DynamicObject)invoiceDobjEntry.get(rowIndex)).map(invoiceEntry -> {
                DynamicObject invoiceCurrencyObj = invoiceEntry.getDynamicObject("invoicecurrency");
                if (invoiceCurrencyObj == null) {
                    return null;
                }
                return (Long)invoiceCurrencyObj.getPkValue();
            }).collect(Collectors.toSet());
            if (invCurrencySet.size() != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u8d39\u7528\u660e\u7ec6\u4e0e\u53d1\u7968\u4fe1\u606f\u884c\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u5173\u8054\u3002", (String)"ImportInvoiceForDailyReimPCWithoutExpenseItem_9", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Iterator invIterator = invCurrencySet.iterator();
            Long invCurrency = null;
            if (invIterator.hasNext()) {
                invCurrency = (Long)invIterator.next();
            }
            if (invCurrency == null || invCurrency == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u53d1\u7968\u4fe1\u606f\u884c\u5e01\u79cd\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u5173\u8054\u3002", (String)"ImportInvoiceForTripReimPCWithoutExpenseItem_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            List<Long> invoiceEntryIds = Arrays.stream(selected).mapToObj(index -> (Long)((DynamicObject)invoiceDobjEntry.get(index)).getPkValue()).collect(Collectors.toList());
            if (!this.checkIsAllowMapTripOrExpenseEntry(invoiceEntryIds)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u4e2d\u7684\u53d1\u7968\u5fc5\u987b\u662f\u540c\u4e00\u79cd\u7c7b\u578b\u3002", (String)"ImportInvoiceForTripReimPCWithoutExpenseItem_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)this.getClickKey())) {
            this.showSelectedInvoicePage(this.getExtView(), itemKey);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)"mapinvoice")) {
            this.setAllTripInfoId();
            String billKind = (String)this.getModel().getValue("billkind");
            if (StringUtils.equals((CharSequence)billKind, (CharSequence)"0")) {
                this.showTripMapInvoice();
            } else if (StringUtils.equals((CharSequence)billKind, (CharSequence)"1")) {
                RelateExpenseOrTripItemAndInvoiceUtil.mapExpenseEntryAndInvoiceEntry((IFormView)this.getView(), (BillOfInvoice)BillOfInvoice.TripReimburseBill);
                InvoiceOffsetUtils.computeAllItemOffsetAndSpecial((IDataModel)this.getModel());
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null && StringUtils.equals((CharSequence)"er_tripexpensemapinvoice", (CharSequence)actionId)) {
            Map returnMap = (Map)returnData;
            List selectedTripItemIds = (List)returnMap.get("selectedTripItemIds");
            String selectedInvoiceIdStr = (String)returnMap.get("selectedInvoiceIds");
            List<Long> selectedInvoiceIds = Arrays.asList(StringUtils.split((String)selectedInvoiceIdStr, (String)",")).stream().map(invoiceIdStr -> Long.parseLong(invoiceIdStr.trim())).collect(Collectors.toList());
            this.updateInvoiceEntryAndExpenseEntry(selectedTripItemIds, selectedInvoiceIds, true);
            this.updateIsMapExpense();
            this.updateInvoiceContainerCollapse();
            if (selectedTripItemIds.isEmpty()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5173\u8054\u6210\u529f\u3002", (String)"RelateExpenseOrTripItemAndInvoiceUtil_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            String info = InvoiceUtils.refreshTaxAmountShare((IDataModel)this.getModel(), (long)ErCommonUtils.getPk((Object)this.getCostCompanyDO()), selectedInvoiceIds, (List)selectedTripItemIds, (InvoiceUtils.BillEntityType)InvoiceUtils.BillEntityType.TripReimburse);
            this.getView().updateView("tripentry");
            if (StringUtils.isNotBlank((CharSequence)info)) {
                log.info("\u5dee\u65c5\u53d1\u7968\u624b\u52a8\u5173\u8054" + info);
                this.getView().showTipNotification(info);
            }
        }
    }

    private void updateInvoiceContainerCollapse() {
        int entryRowCount = this.getModel().getEntryRowCount("invoiceentry");
        AdvContainer invoiceAdvContainer = (AdvContainer)this.getControl("invoice_entry_container");
        if (entryRowCount > 0) {
            invoiceAdvContainer.setCollapse(false);
        }
    }

    private void updateInvoiceEntryAndExpenseEntry(List<Long> selectedTripItemIds, List<Long> selectedInvoiceIds, boolean needRefresh) {
        int i2;
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection invoiceAndExpense = dataEntity.getDynamicObjectCollection("invoiceandexpense");
        DynamicObjectCollection tripEntry = dataEntity.getDynamicObjectCollection("tripentry");
        DynamicObjectCollection invoiceEntry = dataEntity.getDynamicObjectCollection("invoiceentry");
        ArrayList needDelIndexs = Lists.newArrayList();
        for (i2 = 0; i2 < invoiceAndExpense.size(); ++i2) {
            DynamicObject relation = (DynamicObject)invoiceAndExpense.get(i2);
            Long invoiceId2 = relation.getLong("invoiceentryid");
            if (!selectedInvoiceIds.contains(invoiceId2)) continue;
            needDelIndexs.add(i2);
        }
        log.info(String.format("delete InvoiceAndExpense Entry lines : %s", ((Object)needDelIndexs).toString()));
        model.deleteEntryRows("invoiceandexpense", needDelIndexs.stream().mapToInt(i -> i).toArray());
        selectedInvoiceIds.stream().forEach(invoiceId -> selectedTripItemIds.stream().forEach(tripItemId -> {
            int newIndex = model.createNewEntryRow("invoiceandexpense");
            log.info(String.format("Create InvoiceAndExpense Entry line : %d , invoiceentryid : %d , tripItemId : %d", newIndex, invoiceId, tripItemId));
            model.setValue("invoiceentryid", invoiceId, newIndex);
            model.setValue("expenseentryid", tripItemId, newIndex);
        }));
        log.info("\u5f00\u59cb\u6267\u884c\u975e\u667a\u80fd\u5173\u8054\u53d1\u7968\u5faa\u73af");
        for (i2 = 0; i2 < tripEntry.size(); ++i2) {
            DynamicObjectCollection expenseEntry = ((DynamicObject)tripEntry.get(i2)).getDynamicObjectCollection("entryentity");
            for (int j = 0; j < expenseEntry.size(); ++j) {
                DynamicObject itemExpense = (DynamicObject)expenseEntry.get(j);
                String itemfrom = itemExpense.getString("itemfrom");
                Long curExpenseItemId = (Long)itemExpense.getPkValue();
                if (StringUtils.equals((CharSequence)itemfrom, (CharSequence)"3")) {
                    log.info("\u6765\u6e90\u4e3a\u5546\u65c5\u7684\u4e0d\u5904\u7406\u975e\u667a\u80fd\u53d1\u7968\u5173\u8054" + curExpenseItemId);
                    continue;
                }
                Set currentSelectedInvoiceIds = invoiceAndExpense.stream().filter(entry -> curExpenseItemId.longValue() == entry.getLong("expenseentryid")).map(entry -> entry.getLong("invoiceentryid")).collect(Collectors.toSet());
                String invoiceNo = invoiceEntry.stream().filter(invoiceItem -> currentSelectedInvoiceIds.contains(invoiceItem.getPkValue())).map(invoiceItem -> invoiceItem.getString("invoiceno")).collect(Collectors.joining(","));
                String invoiceCode = invoiceEntry.stream().filter(invoiceItem -> currentSelectedInvoiceIds.contains(invoiceItem.getPkValue())).map(invoiceItem -> invoiceItem.getString("invoicecode")).collect(Collectors.joining(","));
                log.info(curExpenseItemId + "\u5173\u8054\u7684\u53d1\u7968\u5206\u5f55id\uff1a " + currentSelectedInvoiceIds + "\uff0c\u5173\u8054\u7684\u53d1\u7968\u53f7\u7801\uff1a " + invoiceNo + "\uff0c\u5173\u8054\u7684\u53d1\u7968\u4ee3\u7801\uff1a " + invoiceCode);
                if (StringUtils.equals((CharSequence)itemfrom, (CharSequence)"1") || StringUtils.equals((CharSequence)itemfrom, (CharSequence)"0")) {
                    ItemFrom itemFrom = currentSelectedInvoiceIds.isEmpty() ? ItemFrom.Manual : ItemFrom.InvoiceCloud;
                    model.setValue("itemfrom", (Object)itemFrom.getValue(), j, i2);
                }
                model.setValue("invoicelink", (Object)InvoiceUtils.getLimitedInvoiceCode((String)invoiceCode), j, i2);
                model.setValue("invoiceno_entry", (Object)InvoiceUtils.getLimitedInvoiceNo((String)invoiceNo), j, i2);
                if (!needRefresh) continue;
                InvoiceOffsetUtils.setModelValue((IDataModel)this.getModel(), (BillExpenseInfoFildKeyType)BillExpenseInfoFildKeyType.TripReimburse, (int)j, (int)i2);
                InvoiceOffsetUtils.refreshInvoiceOffsetAndOutAmount((IFormView)this.getView(), (int)j, (int)i2);
            }
        }
        log.info("\u7ed3\u675f\u6267\u884c\u975e\u667a\u80fd\u5173\u8054\u53d1\u7968\u5faa\u73af");
    }

    private void updateIsMapExpense() {
        IDataModel model = this.getModel();
        String billKind = (String)model.getValue("billkind");
        if (StringUtils.equals((CharSequence)billKind, (CharSequence)"1")) {
            return;
        }
        DynamicObjectCollection invoiceAndExpense = model.getEntryEntity("invoiceandexpense");
        DynamicObjectCollection tripEntry = model.getEntryEntity("tripentry");
        DynamicObjectCollection invoiceEntry = model.getEntryEntity("invoiceentry");
        HashMap relationMap = Maps.newHashMap();
        tripEntry.stream().forEach(tripInfo -> {
            DynamicObjectCollection expenseEntry = tripInfo.getDynamicObjectCollection("entryentity");
            expenseEntry.stream().filter(expenseItem -> expenseItem.getDynamicObject("expenseitem") != null).forEach(expenseItem -> {
                String from = tripInfo.getDynamicObject("from").getLocaleString("name").toString();
                String to = tripInfo.getDynamicObject("to").getLocaleString("name").toString();
                String relation = from + "-" + to + "\uff1a";
                String expenseitem = expenseItem.getDynamicObject("expenseitem").getString("name");
                relation = relation + expenseitem;
                relationMap.put((Long)expenseItem.getPkValue(), relation);
            });
        });
        HashMap map = Maps.newHashMap();
        for (DynamicObject relation : invoiceAndExpense) {
            String tripInfo2;
            Long invoiceId = relation.getLong("invoiceentryid");
            Long expenseId = relation.getLong("expenseentryid");
            List expenseText = (List)map.get(invoiceId);
            if (expenseText == null) {
                expenseText = Lists.newArrayList();
            }
            if ((tripInfo2 = (String)relationMap.get(expenseId)) == null) continue;
            expenseText.add(relationMap.get(expenseId));
            map.put(invoiceId, expenseText);
        }
        log.info("\u5f00\u59cb\u5faa\u73af");
        for (int i = 0; i < invoiceEntry.size(); ++i) {
            Long invoiceId = (Long)((DynamicObject)invoiceEntry.get(i)).getPkValue();
            if (map.containsKey(invoiceId)) {
                List expenseText = (List)map.get(invoiceId);
                String text = expenseText.stream().filter(tripInfo -> StringUtils.isNotBlank((CharSequence)tripInfo)).collect(Collectors.joining("\uff1b"));
                model.setValue("mapexpenseinfo", (Object)text, i);
                model.setValue("ismapexpense", (Object)"1", i);
                continue;
            }
            model.setValue("mapexpenseinfo", (Object)"", i);
            model.setValue("ismapexpense", (Object)"0", i);
        }
        log.info("\u7ed3\u675f\u5faa\u73af");
    }

    private void showTripMapInvoice() {
        String selectedInvoiceIds;
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("formId", "er_tripexpensemapinvoice");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(param);
        EntryGrid invoiceEntryGrid = (EntryGrid)this.getControl("invoiceentry");
        int[] selected = invoiceEntryGrid.getSelectRows();
        DynamicObjectCollection invoiceEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("invoiceentry");
        StringBuilder selectedInvoiceInfoSb = new StringBuilder();
        StringBuilder selectedInvoiceIdsSb = new StringBuilder();
        long invoiceCurrency = 0L;
        for (int i = 0; i < selected.length; ++i) {
            DynamicObject invoiceItem = (DynamicObject)invoiceEntry.get(selected[i]);
            String invoiceType = InvoiceTypeEnum.getByValue((String)invoiceItem.getString("invoicetype")).getKey();
            String invoiceNo = invoiceItem.getString("invoiceno");
            selectedInvoiceInfoSb.append(invoiceType);
            selectedInvoiceInfoSb.append(invoiceNo);
            selectedInvoiceInfoSb.append(", ");
            selectedInvoiceIdsSb.append(invoiceItem.getPkValue());
            selectedInvoiceIdsSb.append(",");
            DynamicObject invoiceCurrencyObj = invoiceItem.getDynamicObject("invoicecurrency");
            if (invoiceCurrencyObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u53d1\u7968\u4fe1\u606f\u884c\u5e01\u79cd\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u5173\u8054\u3002", (String)"ImportInvoiceForTripReimPCWithoutExpenseItem_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            long selectInvCurrency = (Long)invoiceCurrencyObj.getPkValue();
            if (selectInvCurrency == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u53d1\u7968\u4fe1\u606f\u884c\u5e01\u79cd\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u5173\u8054\u3002", (String)"ImportInvoiceForTripReimPCWithoutExpenseItem_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            if (invoiceCurrency == 0L) {
                invoiceCurrency = selectInvCurrency;
                continue;
            }
            if (invoiceCurrency == selectInvCurrency) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u53d1\u7968\u4fe1\u606f\u884c\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u5173\u8054\u3002", (String)"ImportInvoiceForTripReimPCWithoutExpenseItem_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        String showSelectedInvoice = selectedInvoiceInfoSb.toString();
        if (showSelectedInvoice.endsWith(", ")) {
            showSelectedInvoice = showSelectedInvoice.substring(0, showSelectedInvoice.length() - 2);
        }
        if ((selectedInvoiceIds = selectedInvoiceIdsSb.toString()).endsWith(",")) {
            selectedInvoiceIds = selectedInvoiceIds.substring(0, selectedInvoiceIds.length() - 1);
        }
        log.info(String.format("Send selectedInvoiceIds : %s ", selectedInvoiceIds));
        showParameter.setCustomParam("showselectedinvoice", (Object)showSelectedInvoice);
        showParameter.setCustomParam("selectedInvoiceIds", (Object)selectedInvoiceIds);
        showParameter.setCustomParam("invoiceCurrency", (Object)invoiceCurrency);
        OpenStyle openStyle = showParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "er_tripexpensemapinvoice"));
        Map params = showParameter.getCustomParams();
        showParameter.setCustomParams(params);
        this.getView().showForm(showParameter);
    }

    private void setAllTripInfoId() {
        DynamicObjectCollection tripEntry = this.getModel().getEntryEntity("tripentry");
        tripEntry.stream().forEach(tripItem -> {
            this.setAndGetSelectedRowEntryId((DynamicObject)tripItem);
            DynamicObjectCollection expenseEntry = tripItem.getDynamicObjectCollection("entryentity");
            expenseEntry.stream().forEach(expenseItem -> this.setAndGetSelectedRowEntryId((DynamicObject)expenseItem));
        });
        this.getModel().setValue("tripentry", (Object)tripEntry);
    }

    private Long setAndGetSelectedRowEntryId(DynamicObject entryEntity) {
        Long entryId = (Long)entryEntity.getPkValue();
        if (Objects.equals(entryId, 0L)) {
            entryId = ORM.create().genLongId(this.getView().getEntityId());
            entryEntity.set("id", (Object)entryId);
        }
        return entryId;
    }

    @Override
    public MappingItemWithOrgInvoiceServiceImp.BillType getBillType() {
        return MappingItemWithOrgInvoiceServiceImp.BillType.TripItem;
    }

    public void entryRowClick(RowClickEvent evt) {
        Object source = evt.getSource();
        if (source instanceof EntryGrid) {
            EntryGrid grid = (EntryGrid)source;
            String entryKey = grid.getEntryKey();
            int[] rowIndexs = grid.getSelectRows();
            if (StringUtils.equals((CharSequence)entryKey, (CharSequence)BillOfInvoice.TripReimburseBill.getExpenseEntryEntityName()) && rowIndexs != null) {
                RelateExpenseOrTripItemAndInvoiceUtil.selectedRelateInvoiceEntryByClickExpenseEntry((IFormView)this.getView(), (BillOfInvoice)BillOfInvoice.TripReimburseBill);
            }
        }
    }
}

