/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2;

import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.utils.AttachmentCountUtils;

public class InvoiceAttachmentRemoveListener
implements UploadListener {
    private static final Log logger = LogFactory.getLog(InvoiceAttachmentRemoveListener.class);
    private static final String ATTACHMENT_PANEL = "attachmentpanel";
    private IDataModel dataModel;
    private AttachmentPanel attachmentPanel;

    public InvoiceAttachmentRemoveListener(AttachmentPanel attachmentPanel, IDataModel dataModel) {
        this.attachmentPanel = attachmentPanel;
        this.dataModel = dataModel;
    }

    @Deprecated
    public InvoiceAttachmentRemoveListener(IDataModel dataModel) {
        this.dataModel = dataModel;
    }

    public static void register(AttachmentPanel attachmentPanel, IDataModel dataModel) {
        boolean syncToBill = KingdeeInvoiceCloudConfig.syncInvoiceAttachmentToBill();
        if (attachmentPanel != null && syncToBill) {
            InvoiceAttachmentRemoveListener listener = new InvoiceAttachmentRemoveListener(attachmentPanel, dataModel);
            listener.attachmentPanel = attachmentPanel;
            attachmentPanel.addUploadListener((UploadListener)listener);
        }
    }

    public void afterRemove(UploadEvent evt) {
        super.afterRemove(evt);
        if (evt.getCallbackKey().equalsIgnoreCase(ATTACHMENT_PANEL)) {
            if (this.dataModel.getProperty("invoiceattachinfo") == null) {
                return;
            }
            Map urls = (Map)evt.getUrls()[0];
            String uid = (String)urls.get("uid");
            boolean isInvoiceAttach = uid.startsWith(AttachmentCountUtils.getAttachmentUidPrefix());
            if (isInvoiceAttach) {
                String realAttachNo = AttachmentCountUtils.getRealAttachNo((String)uid);
                DynamicObjectCollection entries = this.dataModel.getEntryEntity("invoiceattachinfo");
                HashSet<Integer> indexesToRemove = new HashSet<Integer>(entries.size());
                for (int i = 0; i < entries.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entries.get(i);
                    String entryAttachNo = entry.getString("attachno");
                    if (!entryAttachNo.equals(realAttachNo)) continue;
                    logger.info("\u9644\u4ef6\u9762\u677f\u5220\u9664\u9644\u4ef6\u5e8f\u5217\u53f7\uff1a" + uid + ", \u8054\u52a8\u5220\u9664\u53d1\u7968\u9644\u4ef6\u5206\u5f55\u884c index: " + i + ", entryAttachNo: " + entryAttachNo);
                    indexesToRemove.add(i);
                }
                if (indexesToRemove.size() > 0) {
                    this.dataModel.deleteEntryRows("invoiceattachinfo", indexesToRemove.stream().mapToInt(Integer::intValue).toArray());
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("ignorewarn", String.valueOf(true));
                    option.setVariableValue("ignoreinteraction", String.valueOf(true));
                    IFormView view = this.attachmentPanel.getView();
                    if (view != null) {
                        view.invokeOperation("save", option);
                    }
                }
            }
        }
    }
}

