/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.collection.one4one;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.model.invoice.xh.SimpleXhInvoiceVO;
import kd.fi.er.formplugin.invoicecloud.v2.clientInterface.InvoiceMobClientInterface;
import kd.fi.er.formplugin.invoicecloud.v2.collection.one4one.AbstractImportInvoiceForReimOne4One;
import kd.fi.er.formplugin.invoicecloud.v2.service.utils.InvoicePluginUtils;

public abstract class AbstractImportInvoiceForReimMobOne4One
extends AbstractImportInvoiceForReimOne4One
implements InvoiceMobClientInterface {
    private static final Log log = LogFactory.getLog(AbstractImportInvoiceForReimMobOne4One.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"importinvoiceonebyone"});
    }

    @Override
    public String getCustomeEventName() {
        return "alreadyBackFromInvoiceCloud";
    }

    @Override
    protected String getCloseCallBackKey() {
        return "importinvoiceonebyone";
    }

    @Override
    protected DynamicObject getCompany(DynamicObject dataEntity) {
        return dataEntity.getDynamicObject("company");
    }

    @Override
    public void click(EventObject evt) {
        Control ctl;
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Control && "importinvoiceonebyone".equalsIgnoreCase(key = (ctl = (Control)source).getKey())) {
            this.importInvoiceMob(key);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if (Objects.equals(actionId, "IMPORT_INVOICE_IN_MOB")) {
            Object returnData = event.getReturnData();
            if (returnData instanceof JSONObject) {
                JSONObject importInvoiceReturnData = (JSONObject)returnData;
                log.info("\u661f\u701a\u53d1\u7968\u4e91\u5bfc\u5165\u53d1\u7968\uff0creturnData: {}", (Object)importInvoiceReturnData);
                SimpleXhInvoiceVO simpleXhInvoiceVO = (SimpleXhInvoiceVO)JSONObject.parseObject((String)importInvoiceReturnData.toJSONString(), SimpleXhInvoiceVO.class);
                if (simpleXhInvoiceVO.getInvoiceData() != null && !simpleXhInvoiceVO.getInvoiceData().isEmpty() && !this.handleXhInvoice(this, simpleXhInvoiceVO, this.getModel())) {
                    this.invoiceDeletePageRule(this.isDeleting());
                    return;
                }
                InvoicePluginUtils.saveAttachment(this, this.getView(), simpleXhInvoiceVO.getAttachData());
            } else if (ErStdConfig.getBoolean((String)"intranet") && ErStdConfig.getShowImportInvoiceDataSimulatorMOB()) {
                InvoicePluginUtils.mobTest(this, returnData);
            }
            this.invoiceDeletePageRule(this.isDeleting());
        }
    }

    @Override
    protected String getClickKey() {
        return "importinvoiceonebyone";
    }
}

