/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.collection.one4one;

import java.math.BigDecimal;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.daily.reimburse.WriteOffTypeEnum;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.IInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.beforeImportService.BeforeImportInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.beforeImportService.DailyReimburseBeforeImportInvoiceServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.beforeImportService.DoNothingImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService.CreateExpenseItemEntryServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.pub.PublicBillUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.MobShowUtils;
import kd.fi.er.common.field.writeoffmoney.PublicContractWriteOffFields;
import kd.fi.er.formplugin.daily.mobile.common.CommonUtilHelper;
import kd.fi.er.formplugin.daily.mobile.util.CommonViewControlUtil;
import kd.fi.er.formplugin.daily.web.util.WriteOffMoneyUtils;
import kd.fi.er.formplugin.invoicecloud.v2.collection.one4one.AbstractImportInvoiceForReimMobOne4One;

public class ImportInvoiceForDailyReimMobOne4One
extends AbstractImportInvoiceForReimMobOne4One {
    private static final Log log = LogFactory.getLog(ImportInvoiceForDailyReimMobOne4One.class);

    @Override
    public BeforeImportInvoiceService getBeforeImportInvoiceServiceImpl(InvoiceContext invoiceContext) {
        return new DailyReimburseBeforeImportInvoiceServiceImpl(invoiceContext, this.getModel());
    }

    @Override
    public IInvoiceService getMappingItemImpl(InvoiceContext invoiceContext) {
        return new MappingItemWithOrgInvoiceServiceImp(invoiceContext, this.getBillType(), this.getModel().getDataEntity(true));
    }

    @Override
    public IInvoiceService getBeforeCreateItemServiceImpl(InvoiceContext invoiceContext) {
        return new DoNothingImpl(invoiceContext);
    }

    @Override
    public IInvoiceService getCreateExpenseOrTripItemService(InvoiceContext invoiceContext) {
        return new CreateExpenseItemEntryServiceImpl(invoiceContext, this.getModel(), this.isOrgOffset());
    }

    @Override
    public IInvoiceService getAfterCreateExpenseOrTripItemService(InvoiceContext invoiceContext) {
        return new DoNothingImpl(invoiceContext);
    }

    @Override
    public MappingItemWithOrgInvoiceServiceImp.BillType getBillType() {
        return MappingItemWithOrgInvoiceServiceImp.BillType.ExpenseItem;
    }

    @Override
    protected void loadAfterProcessUpdateData(InvoiceContext context) {
        super.loadAfterProcessUpdateData(context);
        this.refreshAccount();
        IDataModel dataModel = this.getModel();
        IFormView view = this.getView();
        if (ErEntityTypeUtils.isPublicReimburseBill((String)view.getEntityId())) {
            log.info("----\u8d70\u8fdb\u5bf9\u516c\u62a5\u9500\u5355\u79fb\u52a8\u7aef\u5bfc\u5165\u53d1\u7968\u540e\uff0c\u5237\u65b0\u5173\u8054\u5408\u540c\u5206\u5f55\u76f8\u5173\u503c\u65b9\u6cd5----");
            PublicBillUtil.setExpContactInfo((IDataModel)dataModel, (IFormView)view);
            PublicBillUtil.writeOffContract((IDataModel)dataModel, (PublicContractWriteOffFields)PublicContractWriteOffFields.getInstance());
            String writeOffType = (String)dataModel.getValue("writeofftype");
            if ("1".equals(writeOffType) && dataModel.getEntryRowCount("contractentry") > 0) {
                DynamicObjectCollection contracts = dataModel.getEntryEntity("contractentry");
                for (int i = 0; i < contracts.size(); ++i) {
                    PublicBillUtil.refreshContractCurrWriteAmount((IDataModel)dataModel, (BigDecimal)((DynamicObject)contracts.get(i)).getBigDecimal("contractwriteoff"), (int)i);
                }
            }
            PublicBillUtil.updateContractWriteoffView((IDataModel)dataModel, (IFormView)view);
        }
    }

    @Override
    protected void loadAfterProcessUpdateView() {
        super.loadAfterProcessUpdateView();
        this.updateInvoiceLabel();
        CommonViewControlUtil.setExpenseAmount(this.getModel(), this.getView());
        MobShowUtils.updateInvoiceCloudEnable((IDataModel)this.getModel(), (IFormView)this.getView());
        MobShowUtils.accountPageRules((IDataModel)this.getModel(), (IFormView)this.getView());
        InvoiceUtils.updateAutomapinvoiceEnable((IFormView)this.getView(), (String[])new String[]{"automapinvoice"});
    }

    private void updateInvoiceLabel() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection invoiceEntryDOs = dataEntity.getDynamicObjectCollection("invoiceentry");
        int invoiceCount = invoiceEntryDOs.stream().mapToInt(invoiceHead -> invoiceHead.getInt("count")).sum();
        BigDecimal invoiceTotalAmount = invoiceEntryDOs.stream().map(invoiceEntryDO -> invoiceEntryDO.getBigDecimal("totalamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        Label countLab = (Label)this.getControl("lbl_invoicecount");
        Label amountLab = (Label)this.getControl("lbl_totalamount");
        countLab.setText(String.valueOf(invoiceCount));
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        Integer amtprecision = 4;
        String sign = "\uffe5";
        if (currency != null) {
            sign = currency.getString("sign");
            amtprecision = currency.getInt("amtprecision");
        }
        String formatMoneyByUser = AmountUtils.formatMoneyByUser((Long)RequestContext.get().getCurrUserId(), (String)sign, (int)amtprecision, (BigDecimal)invoiceTotalAmount);
        amountLab.setText(formatMoneyByUser);
    }

    protected void refreshAccount() {
        IDataModel model = this.getModel();
        model.beginInit();
        String writeOffType = (String)model.getValue("writeofftype");
        WriteOffMoneyUtils.sortWriteOffEntry((IFormView)this.getView());
        WriteOffMoneyUtils.writeOffMoney((IDataModel)model, (String)writeOffType, (IFormView)this.getView());
        if (WriteOffTypeEnum.ORGI_WO.getValue().equalsIgnoreCase(writeOffType)) {
            int i;
            if (model.getEntryRowCount("writeoffmoney") > 0) {
                for (i = 0; i < model.getEntryRowCount("writeoffmoney"); ++i) {
                    BigDecimal woAmount = (BigDecimal)model.getValue("accloanamount", i);
                    AmountUtils.refreshCurrAmount((IDataModel)model, (BigDecimal)woAmount, (String)"curraccloanamount", (String)"loanexchangerate", (String)"writeoffquotetype", (int)i);
                }
            }
            if (model.getEntryRowCount("writeoffapply") > 0) {
                for (i = 0; i < model.getEntryRowCount("writeoffapply"); ++i) {
                    BigDecimal woApplyAmount = (BigDecimal)model.getValue("reimbursedamount", i);
                    AmountUtils.refreshCurrAmount((IDataModel)model, (BigDecimal)woApplyAmount, (String)"reimbursedcurramount", (String)"applyexchangerate", (String)"writeoffapplyquotetype", (int)i);
                }
            }
        }
        model.endInit();
        CommonUtilHelper.setWriteOffAmountLable(model, this.getView(), new boolean[0]);
        WriteOffMoneyUtils.refreshReceiveAmount((IDataModel)this.getModel(), (String)writeOffType, (IFormView)this.getView());
        CommonViewControlUtil.expensePageRules(model, this.getView());
        CommonViewControlUtil.setExpenseAmount(model, this.getView());
    }
}

