/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.mob;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.daily.service.ErMainPageDailyService;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.invoicepackage.util.QuickReimUtil;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.utils.ErOrgUtils;
import kd.fi.er.common.model.invoice.InvoiceAttachmentVo;
import kd.fi.er.common.model.invoice.InvoiceVO;
import kd.fi.er.common.model.invoice.xh.AttachData;
import kd.fi.er.formplugin.invoicecloud.usecase.ShowInvoiceCloudPageUtil;
import org.apache.commons.lang3.StringUtils;

public class ImportInvoiceInMainPageMobPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(ImportInvoiceInMainPageMobPlugin.class);
    private static final String MSCAN_TYPE = "mscantype";

    public void afterCreateNewData(EventObject e) {
        Long costCompanyId = ErOrgUtils.getCostCompanyId((AbstractFormPlugin)this, (ErMainPageDailyService)((ErMainPageDailyService)this.getView().getService(ErMainPageDailyService.class)));
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)costCompanyId);
        if (config != null) {
            ShowInvoiceCloudPageUtil.registCheckback(this);
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"mscaninvoice"});
        this.addClickListeners(new String[]{"mscaninvoice_cosmic"});
        this.addClickListeners(new String[]{"mscanquickreim"});
    }

    public void click(EventObject evt) {
        Long costCompanyId;
        Control ctl;
        Object source = evt.getSource();
        if (source instanceof Control && (StringUtils.equals((CharSequence)(ctl = (Control)source).getKey(), (CharSequence)"mscaninvoice") || StringUtils.equals((CharSequence)ctl.getKey(), (CharSequence)"mscanquickreim")) && (costCompanyId = ErOrgUtils.getCostCompanyId((AbstractFormPlugin)this, (ErMainPageDailyService)((ErMainPageDailyService)this.getView().getService(ErMainPageDailyService.class)))) != null) {
            boolean enableXhInvoice = KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud();
            this.getPageCache().put(MSCAN_TYPE, ctl.getKey());
            if (enableXhInvoice) {
                ShowInvoiceCloudPageUtil.showCosmicInvoiceListOnMob(this, "rim_inv_collect_mobile", "alreadyBackFromXHInvoiceCloud", ShowType.Floating, costCompanyId);
            } else {
                ShowInvoiceCloudPageUtil.importInvoiceFromInvoicePackageInMob(this, costCompanyId, null);
            }
        }
    }

    public void customEvent(CustomEventArgs e) {
        try {
            String eventName = e.getEventName();
            log.info("\u3010\u4e00\u952e\u62a5\u9500\u3011\u53d1\u7968\u52a9\u624b\u5df2\u5173\u95ed\uff0c\u89e6\u53d1: " + eventName);
            if ("alreadyBackFromInvoiceCloud".equalsIgnoreCase(eventName)) {
                String msg = e.getEventArgs();
                log.info("\u3010\u4e00\u952e\u62a5\u9500\u3011\u53d1\u7968\u52a9\u624b\u5df2\u5173\u95ed\uff0c\u8fd4\u56de: " + msg);
                JSONObject importInvoiceJson = JSON.parseObject((String)msg);
                if (importInvoiceJson.containsKey((Object)"version")) {
                    String serialNoStr = importInvoiceJson.getString("serialNo");
                    JSONObject option = importInvoiceJson.getJSONObject("option");
                    JSONArray certificateList = option.getJSONArray("certificateList");
                    if (StringUtils.isEmpty((CharSequence)serialNoStr) && certificateList.isEmpty()) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u3010\u4e00\u952e\u62a5\u9500\u3011\u672a\u63a5\u6536\u5230\u53d1\u7968\u4e91\u4f20\u9012\u7684\u6570\u636e\u3002", (String)"ImportInvoiceInMainPageMobPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    Long costCompanyId = ErOrgUtils.getCostCompanyId((AbstractFormPlugin)this, (ErMainPageDailyService)((ErMainPageDailyService)this.getView().getService(ErMainPageDailyService.class)));
                    InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)costCompanyId);
                    if (config == null) {
                        return;
                    }
                    List invoiceVOS = QuickReimUtil.queryInvoice((String)serialNoStr, (InvoiceCloudCfgBO)config, (IFormView)this.getView());
                    List attachmentVos = certificateList.toJavaList(InvoiceAttachmentVo.class);
                    if (CollectionUtils.isEmpty((Collection)invoiceVOS) && CollectionUtils.isEmpty((Collection)attachmentVos)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u3010\u4e00\u952e\u62a5\u9500\u3011\u672a\u63a5\u6536\u5230\u53d1\u7968\u4e91\u4f20\u9012\u7684\u6570\u636e\u3002", (String)"ImportInvoiceInMainPageMobPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    String mscanType = this.getPageCache().get(MSCAN_TYPE);
                    ShowInvoiceCloudPageUtil.openQuickReimList(invoiceVOS, attachmentVos, mscanType, this);
                }
            }
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c\u4e00\u952e\u62a5\u9500\u201dcustomEvent\u5f02\u5e38\uff1a%s\u3002", (String)"ImportInvoiceInMainPageMobPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]), ex));
            log.error((Throwable)ex);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        log.info("\u3010\u4e00\u952e\u62a5\u9500\u3011\u53d1\u7968\u52a9\u624b\u5df2\u5173\u95ed\uff0c\u89e6\u53d1: " + actionId);
        if (actionId != null && StringUtils.equals((CharSequence)actionId, (CharSequence)"alreadyBackFromXHInvoiceCloud")) {
            log.info("\u3010\u4e00\u952e\u62a5\u9500\u3011\u53d1\u7968\u52a9\u624b\u5df2\u5173\u95ed\uff0c\u8fd4\u56de: " + returnData);
            String returnJsonStr = JSON.toJSONString((Object)returnData);
            if (!this.isJsonStr(returnJsonStr) && StringUtils.contains((CharSequence)returnJsonStr, (CharSequence)"cancel")) {
                log.info("\u5df2\u9000\u51fa\u4e00\u952e\u62a5\u9500\u3002");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u9000\u51fa\u4e00\u952e\u62a5\u9500\u3002", (String)"ImportInvoiceInMainPageMobPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            JSONObject returnJsonOb = JSON.parseObject((String)returnJsonStr);
            JSONArray invoiceDataJson = returnJsonOb.getJSONArray("invoiceData");
            JSONArray attachDataJson = returnJsonOb.getJSONArray("attachData");
            List invoiceVOS = invoiceDataJson.toJavaList(InvoiceVO.class);
            List attachmentVos = attachDataJson.toJavaList(AttachData.class);
            if (CollectionUtils.isEmpty((Collection)invoiceVOS) && CollectionUtils.isEmpty((Collection)attachmentVos)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u3010\u4e00\u952e\u62a5\u9500\u3011\u672a\u63a5\u6536\u5230\u53d1\u7968\u4e91\u4f20\u9012\u7684\u6570\u636e\u3002", (String)"ImportInvoiceInMainPageMobPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            String mscanType = this.getPageCache().get(MSCAN_TYPE);
            ShowInvoiceCloudPageUtil.openQuickReimList(invoiceVOS, attachmentVos, mscanType, this);
        }
    }

    private boolean isJsonStr(String returnData) {
        if (StringUtils.isEmpty((CharSequence)returnData)) {
            return false;
        }
        return returnData.startsWith("{") && returnData.endsWith("}");
    }
}

