/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.mob.noautomap;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.fi.er.common.model.invoice.bill.BillOfInvoice;
import kd.fi.er.formplugin.invoicecloud.v2.mob.noautomap.ErAbsInvoiceRelateExpenseMobPlugin;
import kd.fi.er.formplugin.invoicecloud.v2.util.RelateExpenseOrTripItemAndInvoiceUtil;
import org.apache.commons.collections.CollectionUtils;

public class ChooseInvoiceMobPlugin
extends ErAbsInvoiceRelateExpenseMobPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addRowClick("invoiceentry");
        this.addClickListeners(new String[]{"cancel", "confrim"});
        this.addSearchListener("invoicesearchap");
    }

    @Override
    public void afterBindData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List ids = (List)formShowParameter.getCustomParams().get("expenseEntryIds");
        if (CollectionUtils.isNotEmpty((Collection)ids)) {
            this.selectedRelateInvoiceEntryByClickExpenseEntry(ids);
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Control && "confrim".equals(((Control)evt.getSource()).getKey())) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String parentViewId = formShowParameter.getParentPageId();
            List<Long> expenseIds = this.getSelectedRowEntryId(this.getView().getViewNoPlugin(parentViewId));
            List<Long> invoiceIds = this.getChooseIds("invoiceentry");
            HashMap<String, List<Long>> map = new HashMap<String, List<Long>>(4);
            map.put(this.getBillType().getExpenseEntryEntityName(), expenseIds);
            map.put("invoiceentry", invoiceIds);
            IFormView tripView = this.getView().getViewNoPlugin(formShowParameter.getParentPageId());
            IFormView billView = tripView.getViewNoPlugin(tripView.getFormShowParameter().getParentPageId());
            String msg = RelateExpenseOrTripItemAndInvoiceUtil.checkRelate((IFormView)billView, (BillOfInvoice)this.getBillType(), expenseIds, invoiceIds);
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                this.getView().showTipNotification(msg);
            } else {
                tripView.returnDataToParent(map);
                tripView.close();
                this.getView().sendFormAction(tripView);
                this.getView().close();
            }
        } else if (evt.getSource() instanceof Control && "cancel".equals(((Control)evt.getSource()).getKey())) {
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object val = e.getChangeSet()[0].getNewValue();
        if ("chooseall".equals(name) && Boolean.TRUE.equals(val)) {
            this.choose("invoiceentry", true);
        } else if ("chooseall".equals(name) && Boolean.FALSE.equals(val)) {
            this.choose("invoiceentry", false);
        }
    }

    @Override
    protected void createExpense(String search) {
    }

    @Override
    protected void chooseExpense(String entry, boolean all) {
    }

    @Override
    protected void selectedRelateInvoiceEntryByClickExpenseEntry() {
    }

    @Override
    protected BillOfInvoice getBillType() {
        String billType = (String)this.getView().getFormShowParameter().getCustomParams().get("billType");
        if (BillOfInvoice.TripReimburseBill.name().equals(billType)) {
            return BillOfInvoice.TripReimburseBill;
        }
        return BillOfInvoice.DailyReimburseBill;
    }

    @Override
    protected IFormView getBillView() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        IFormView tripView = this.getView().getViewNoPlugin(formShowParameter.getParentPageId());
        IFormView billView = tripView.getViewNoPlugin(tripView.getFormShowParameter().getParentPageId());
        return billView;
    }
}

