/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.mob.noautomap;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.MobileSearch;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.invoicecloud.util.InvoiceTypeComboBoxUtil;
import kd.fi.er.common.model.invoice.bill.BillOfInvoice;
import org.apache.commons.lang3.StringUtils;

public abstract class ErAbsInvoiceRelateExpenseMobPlugin
extends AbstractFormPlugin
implements MobileSearchTextChangeListener,
RowClickEventListener {
    private static final String EXPENSE_ENTRY_NAME = "expenseentryentity";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        ComboEdit comboEdit;
        MainEntityType mainEntityType = this.getModel().getDataEntityType();
        if (mainEntityType.getProperty(EXPENSE_ENTRY_NAME) != null) {
            this.createExpense(null);
        }
        if (mainEntityType.getProperty("invoiceentry") != null) {
            this.createInovoices(this.getBillView(), null);
        }
        if ((comboEdit = (ComboEdit)this.getView().getControl("invoicetype")) != null) {
            List loadInvoiceTypesComboItems = InvoiceTypeComboBoxUtil.loadInvoiceTypesComboItems((int)1);
            comboEdit.setComboItems(loadInvoiceTypesComboItems);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Control && "labelap".equals(((Control)evt.getSource()).getKey()) || evt.getSource() instanceof Control && "invoicelabelap".equals(((Control)evt.getSource()).getKey())) {
            String key = ((Control)evt.getSource()).getKey();
            String cacheKey = this.getView().getFormShowParameter().getFormId() + "_" + key;
            String entry = "labelap".equals(key) ? EXPENSE_ENTRY_NAME : "invoiceentry";
            IPageCache pageCache = this.getView().getPageCache();
            Label label = (Label)this.getControl(key);
            if (StringUtils.isEmpty((CharSequence)pageCache.get(cacheKey)) || "0".equals(pageCache.get(cacheKey))) {
                if (EXPENSE_ENTRY_NAME.equals(entry)) {
                    this.chooseExpense(entry, true);
                } else {
                    this.choose(entry, true);
                }
                pageCache.put(cacheKey, "1");
                label.setText(ResManager.loadKDString((String)"\u53d6\u6d88\u5168\u9009", (String)"ErInvoiceRelateExpenseMobPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                if (EXPENSE_ENTRY_NAME.equals(entry)) {
                    this.selectedRelateInvoiceEntryByClickExpenseEntry();
                }
            } else {
                if (EXPENSE_ENTRY_NAME.equals(entry)) {
                    this.chooseExpense(entry, false);
                } else {
                    this.choose(entry, false);
                }
                pageCache.put(cacheKey, "0");
                label.setText(ResManager.loadKDString((String)"\u5168\u9009", (String)"ErInvoiceRelateExpenseMobPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void click(MobileSearchTextChangeEvent mobileSearchTextChangeEvent) {
        String key;
        MobileSearch search = (MobileSearch)mobileSearchTextChangeEvent.getSource();
        switch (key = search.getKey()) {
            case "invoicesearchap": {
                this.createInovoices(this.getBillView(), mobileSearchTextChangeEvent.getText());
            }
        }
    }

    private void createInovoices(IFormView billView, String search) {
        this.createData(billView, "invoiceentry", Arrays.asList("invoicetype", "totalamount", "invoiceno", "invoicedate"), search);
    }

    protected abstract void createExpense(String var1);

    protected List<Long> getChooseIds(String entry) {
        int[] exIndexs = ((CardEntry)this.getControl(entry)).getSelectRows();
        ArrayList<Long> ids = new ArrayList<Long>(exIndexs.length);
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(entry);
        for (int i : exIndexs) {
            ids.add(((DynamicObject)collection.get(i)).getLong(entry + "entryid"));
        }
        return ids;
    }

    protected void createData(IFormView billView, String entry, List<String> fields, String search) {
        this.getModel().deleteEntryData(entry);
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        DataEntityPropertyCollection expensePropertys = this.getModel().getEntryEntity(entry).getDynamicObjectType().getProperties();
        HashMap<String, Object> oldMap = new HashMap<String, Object>(8);
        Object oldCollection = billView.getModel().getDataEntity(true).getDynamicObjectCollection(entry);
        DataEntityPropertyCollection oldPropertys = oldCollection.getDynamicObjectType().getProperties();
        for (String expenseField : fields) {
            map.put(expenseField, expensePropertys.get((Object)expenseField));
            oldMap.put(expenseField, oldPropertys.get((Object)expenseField));
        }
        if (StringUtils.isNotEmpty((CharSequence)search)) {
            String searchProperty = "expenseitem.name";
            List<Object> invoiceTypes = new ArrayList(0);
            if ("invoiceentry".equals(entry)) {
                searchProperty = "invoiceno";
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"er_invoicetype", (String)"number", (QFilter[])new QFilter[]{new QFilter("name", "like", (Object)("%" + search + "%"))});
                invoiceTypes = collection.stream().map(m -> m.getString("number")).collect(Collectors.toList());
            }
            String seaProperty = searchProperty;
            ArrayList finalInvoiceTypes = invoiceTypes;
            oldCollection = oldCollection.stream().filter(m -> m.getString(seaProperty) != null && m.getString(seaProperty).contains(search) || finalInvoiceTypes.size() > 0 && finalInvoiceTypes.contains(m.getString("invoicetype"))).collect(Collectors.toList());
        }
        if (oldCollection.size() == 0) {
            return;
        }
        int size = oldCollection.size();
        this.getModel().batchCreateNewEntryRow(entry, size);
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(entry);
        for (int i = 0; i < size; ++i) {
            DynamicObject dyn = (DynamicObject)collection.get(i);
            DynamicObject oldDyn = (DynamicObject)oldCollection.get(i);
            for (Map.Entry ent : map.entrySet()) {
                String key = (String)ent.getKey();
                Object val = ((IDataEntityProperty)oldMap.get(key)).getValueFast((Object)oldDyn);
                ((IDataEntityProperty)ent.getValue()).setValueFast((Object)dyn, val);
            }
            dyn.set(entry + "entryid", (Object)oldDyn.getLong("id"));
            if ("invoiceentry".equals(entry)) {
                dyn.set("invoicecurrency", oldDyn.get("invoicecurrency"));
                continue;
            }
            dyn.set("entrycurrency", oldDyn.get("entrycurrency"));
        }
        this.getView().updateView(entry);
    }

    protected void addRowClick(String entry) {
        AbstractGrid invoiceentry = (AbstractGrid)this.getView().getControl(entry);
        if (invoiceentry != null) {
            invoiceentry.addRowClickListener((RowClickEventListener)this);
        }
    }

    protected void addSearchListener(String mobileSearch) {
        MobileSearch invoicesearchap = (MobileSearch)this.getView().getControl(mobileSearch);
        if (invoicesearchap != null) {
            invoicesearchap.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
        }
    }

    protected abstract void chooseExpense(String var1, boolean var2);

    protected void choose(String entry, boolean all) {
        EntryGrid invoiceHeadGrid = (EntryGrid)this.getView().getControl(entry);
        if (!all) {
            int[] a = new int[]{};
            invoiceHeadGrid.selectRows(a, -1);
        } else {
            DynamicObjectCollection invoiceHeadEntryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(entry);
            ArrayList invoiceHeadRowIndexs = Lists.newArrayListWithExpectedSize((int)invoiceHeadEntryEntity.size());
            for (int i = 0; i < invoiceHeadEntryEntity.size(); ++i) {
                invoiceHeadRowIndexs.add(i);
            }
            int[] invoiceRows = invoiceHeadRowIndexs.stream().mapToInt(Integer::intValue).toArray();
            invoiceHeadGrid.selectRows(invoiceRows, -1);
        }
    }

    List<Long> getSelectedRowEntryId(IFormView view) {
        EntryGrid grid = (EntryGrid)view.getControl(EXPENSE_ENTRY_NAME);
        int[] rowIndexs = grid.getSelectRows();
        DynamicObjectCollection expenseEntryEntity = view.getModel().getDataEntity(true).getDynamicObjectCollection(EXPENSE_ENTRY_NAME);
        if (CollectionUtils.isEmpty((Collection)expenseEntryEntity)) {
            return new ArrayList<Long>();
        }
        List<Long> expenseEntryIds = Arrays.stream(rowIndexs).mapToObj(rowIndex -> (DynamicObject)expenseEntryEntity.get(rowIndex)).filter(expenseEntry -> !Objects.equals(expenseEntry.getLong("expenseentryentityentryid"), 0L)).map(entry -> entry.getLong("expenseentryentityentryid")).collect(Collectors.toList());
        return expenseEntryIds;
    }

    protected abstract void selectedRelateInvoiceEntryByClickExpenseEntry();

    void selectedRelateInvoiceEntryByClickExpenseEntry(List<Long> expenseEntryIds) {
        List invoiceHeadEntryIds = this.getBillView().getModel().getDataEntity(true).getDynamicObjectCollection("invoiceandexpense").stream().filter(entry -> expenseEntryIds.contains(entry.getLong("expenseentryid"))).map(entry -> entry.getLong("invoiceentryid")).collect(Collectors.toList());
        DynamicObjectCollection invoiceHeadEntryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("invoiceentry");
        ArrayList invoiceHeadRowIndexs = Lists.newArrayList();
        for (int i = 0; i < invoiceHeadEntryEntity.size(); ++i) {
            if (!invoiceHeadEntryIds.contains(((DynamicObject)invoiceHeadEntryEntity.get(i)).getLong("invoiceentryentryid"))) continue;
            invoiceHeadRowIndexs.add(i);
        }
        if (invoiceHeadRowIndexs != null && invoiceHeadRowIndexs.size() > 0) {
            EntryGrid invoiceHeadGrid = (EntryGrid)this.getView().getControl("invoiceentry");
            int[] invoiceRows = invoiceHeadRowIndexs.stream().mapToInt(Integer::intValue).toArray();
            invoiceHeadGrid.selectRows(invoiceRows, -1);
        }
    }

    protected abstract BillOfInvoice getBillType();

    protected abstract IFormView getBillView();
}

