/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.InvoiceService;
import kd.fi.er.business.invoicecloud.kingdee.XhInvoiceServiceHelper;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.common.model.invoice.InvoiceVO;
import kd.fi.er.common.model.invoice.xh.QueryInvoiceDetailParam;
import kd.fi.er.common.model.invoice.xh.SimpleXhInvoiceVO;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoicePlugin;
import kd.fi.er.formplugin.invoicecloud.v2.service.InvoiceFormPluginService;
import kd.fi.er.formplugin.invoicecloud.v2.service.model.InvoiceEvent;
import kd.fi.er.formplugin.invoicecloud.v2.service.utils.DeleteAttachmentByDeleteInvoiceUtil;
import kd.fi.er.formplugin.invoicecloud.v2.service.utils.InvoicePluginUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class XHInvoicePluginService
implements InvoiceFormPluginService {
    private static final Log log = LogFactory.getLog(XHInvoicePluginService.class);

    @Override
    public void afterImportInvoicePC(AbstractImportInvoicePlugin plugin, InvoiceEvent event) {
        ClosedCallBackEvent closedCallBackEvent = (ClosedCallBackEvent)event.getEvent();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData instanceof JSONObject) {
            JSONObject importInvoiceReturnData = (JSONObject)returnData;
            String jsonString = importInvoiceReturnData.toJSONString();
            SimpleXhInvoiceVO simpleXhInvoiceVO = (SimpleXhInvoiceVO)JSONObject.parseObject((String)jsonString, SimpleXhInvoiceVO.class);
            if (simpleXhInvoiceVO == null) {
                return;
            }
            List invoiceData = simpleXhInvoiceVO.getInvoiceData();
            if (invoiceData == null) {
                JSONArray data = importInvoiceReturnData.getJSONArray("data");
                if (data != null) {
                    List invoiceVOS = data.toJavaList(InvoiceVO.class);
                    simpleXhInvoiceVO.setInvoiceData(invoiceVOS);
                } else {
                    return;
                }
            }
            if (!simpleXhInvoiceVO.getInvoiceData().isEmpty() && !this.handleInvoice(plugin, simpleXhInvoiceVO, jsonString)) {
                return;
            }
            InvoicePluginUtils.saveAttachment(plugin, plugin.getView(), simpleXhInvoiceVO.getAttachData());
        }
    }

    @Override
    public void afterEditInvoicePC(AbstractImportInvoicePlugin plugin, InvoiceEvent event) {
        ClosedCallBackEvent closedCallBackEvent = (ClosedCallBackEvent)event.getEvent();
        IFormView view = plugin.getView();
        Object returnData = closedCallBackEvent.getReturnData();
        JSONObject returnJson = (JSONObject)returnData;
        log.info("\u4fee\u6539\u53d1\u7968\u540e\uff0c\u53d1\u7968\u4e91\u8fd4\u56de\u7684\u6570\u636e-\uff1a{}", (Object)returnJson.toJSONString());
        String serialNo = returnJson.getJSONObject("data").getJSONObject("data").getString("serialNo");
        IPageCache cache = view.getPageCache();
        String oldSerialNo = cache.get("oldSerialNo");
        cache.remove("oldSerialNo");
        if (StringUtils.isBlank((CharSequence)serialNo)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u8fd4\u56de\u6570\u636e\u7ed3\u6784\u6709\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractImportInvoicePlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)oldSerialNo)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u4fee\u6539\u7684\u53d1\u7968\u6d41\u6c34\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractImportInvoicePlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        log.info("serialNo:" + serialNo + "; oldSerialNo:" + oldSerialNo);
        DynamicObjectCollection invoiceEntryDOs = view.getModel().getEntryEntity("invoiceentry");
        Optional<DynamicObject> invoiceEntryOp = invoiceEntryDOs.stream().filter(invoice -> StringUtils.equals((CharSequence)invoice.getString("serialno"), (CharSequence)oldSerialNo)).findFirst();
        if (!invoiceEntryOp.isPresent()) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u6839\u636e\u4fee\u6539\u524d\u7684\u6d41\u6c34\u53f7\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u53d1\u7968\u5206\u5f55\u3002", (String)"AbstractImportInvoicePlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        try {
            QueryInvoiceDetailParam param = InvoiceUtils.buildQueryInvoiceDetailParam((AbstractFormPlugin)plugin, (DynamicObject)plugin.getCostCompanyDO(), Collections.singletonList(serialNo));
            if (param != null) {
                List invoiceVOs = XhInvoiceServiceHelper.queryInvoiceDetail((QueryInvoiceDetailParam)param, null);
                plugin.editInvoice(oldSerialNo, (InvoiceVO)invoiceVOs.get(0));
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            view.showErrorNotification(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u8fd4\u56de\u6570\u636e\u7ed3\u6784\u6709\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractImportInvoicePlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void afterDeleteAttachmentPC(AbstractImportInvoicePlugin plugin, InvoiceEvent event) {
        List attachVos = InvoiceService.getInstanceService().queryAttachments((AbstractFormPlugin)plugin);
        Set tempDelete = DeleteAttachmentByDeleteInvoiceUtil.getTempDeleteSerialno(plugin.getExtView());
        log.info("\u4e34\u65f6\u5220\u9664\u7684\u53d1\u7968\u6d41\u6c34\u53f7\uff1a {}", (Object)tempDelete);
        attachVos.removeIf(m -> tempDelete.contains(m.getSerialNo()));
        InvoicePluginUtils.updateAttachments((AbstractFormPlugin)plugin, plugin.getView(), true, attachVos);
    }

    @Override
    public void afterImportInvoiceMob(AbstractImportInvoicePlugin plugin, InvoiceEvent event) {
    }

    @Override
    public void afterEditInvoiceMob(AbstractImportInvoicePlugin plugin, InvoiceEvent event) {
    }

    @Override
    public void afterDeleteAttachmentMob(AbstractImportInvoicePlugin plugin, InvoiceEvent event) {
    }

    private boolean handleInvoice(AbstractImportInvoicePlugin plugin, SimpleXhInvoiceVO simpleXhInvoiceVO, String jsonString) {
        List queryInvoiceDetail = simpleXhInvoiceVO.getInvoiceData();
        if (CollectionUtils.isNotEmpty((Collection)queryInvoiceDetail)) {
            log.info("\u4e8c\u5f00\u7f13\u5b58\u53d1\u7968\u4e91\u8fd4\u56de\u7684\u53d1\u7968json");
            plugin.getAfterSelectInvoicePluginProxy().callReplace(p -> {
                p.cacheJsonFromInvoiceCloud(jsonString);
                return null;
            });
            log.info("end \u4e8c\u5f00\u7f13\u5b58\u53d1\u7968\u4e91\u8fd4\u56de\u7684\u53d1\u7968json");
            plugin.executeProcess(queryInvoiceDetail);
            return true;
        }
        return false;
    }
}

