/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.tripbusi;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.kingdee.InvoiceTypeEnum;

public class ErTripReSelectedInvoice
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(ErTripReSelectedInvoice.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok", "btn_cancel"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        IFormView tripBillView = parentView.getParentView();
        IDataModel model = view.getModel();
        IDataModel tripBillModel = tripBillView.getModel();
        DynamicObjectCollection invoiceEntry = tripBillModel.getEntryEntity("invoiceentry");
        model.setValue("currency", tripBillModel.getValue("currency"));
        invoiceEntry.forEach(invoiceInfo -> {
            String invoicefrom = invoiceInfo.getString("invoicefrom");
            if (!StringUtils.equals((CharSequence)invoicefrom, (CharSequence)"3")) {
                int index = model.createNewEntryRow("invoiceentry");
                this.initInvoiceInfo(index, (DynamicObject)invoiceInfo);
            }
        });
    }

    public void afterBindData(EventObject e) {
        super.beforeBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String selectedInvoiceIds = (String)customParams.get("selectedInvoiceIds");
        DynamicObjectCollection invoiceEntryNew = this.getModel().getDataEntity(true).getDynamicObjectCollection("invoiceentry");
        int size = invoiceEntryNew.size();
        ArrayList selectedIndex = Lists.newArrayListWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            DynamicObject invoiceItem = (DynamicObject)invoiceEntryNew.get(i);
            if (selectedInvoiceIds == null || StringUtils.isBlank((CharSequence)selectedInvoiceIds) || !StringUtils.contains((CharSequence)selectedInvoiceIds, (CharSequence)String.valueOf(invoiceItem.getPkValue()))) continue;
            selectedIndex.add(i);
        }
        EntryGrid invoiceHeadGrid = (EntryGrid)this.getView().getControl("invoiceentry");
        int[] invoiceRows = selectedIndex.stream().mapToInt(Integer::intValue).toArray();
        invoiceHeadGrid.selectRows(invoiceRows, -1);
    }

    private void initInvoiceInfo(int index, DynamicObject invoceInfo) {
        IDataModel model = this.getModel();
        model.setValue("invoicetype", invoceInfo.get("invoicetype"), index);
        model.setValue("invoicecode", invoceInfo.get("invoicecode"), index);
        model.setValue("invoiceno", invoceInfo.get("invoiceno"), index);
        model.setValue("invoicedate", invoceInfo.get("invoicedate"), index);
        model.setValue("totalamount", invoceInfo.get("totalamount"), index);
        model.setValue("mapexpenseinfo", invoceInfo.get("mapexpenseinfo"), index);
        DynamicObject invoiceItem = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("invoiceentry").get(index);
        invoiceItem.set("id", invoceInfo.get("id"));
        log.info(String.format("Show invoiceno : %s , invoiceID : %s", invoceInfo.get("invoiceno"), invoceInfo.get("id")));
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"btn_ok")) {
            EntryGrid invoiceEntry = (EntryGrid)this.getControl("invoiceentry");
            int[] selected = invoiceEntry.getSelectRows();
            if (selected.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d1\u7968\u4fe1\u606f\uff0c\u518d\u5173\u8054\u8d39\u7528\u3002", (String)"ErTripReSelectedInvoice_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObjectCollection invoiceDobjEntry = this.getModel().getEntryEntity("invoiceentry");
            String invoiceType = ((DynamicObject)invoiceDobjEntry.get(selected[0])).getString("invoicetype");
            for (int i = 1; i < selected.length; ++i) {
                String invoiceTypeCompare = ((DynamicObject)invoiceDobjEntry.get(selected[i])).getString("invoicetype");
                if (StringUtils.equalsIgnoreCase((CharSequence)invoiceTypeCompare, (CharSequence)invoiceType)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u9009\u62e9\u540c\u4e00\u7c7b\u578b\u7684\u53d1\u7968\uff0c\u518d\u5173\u8054\u8d39\u7528\u3002", (String)"ErTripReSelectedInvoice_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)"btn_ok", (CharSequence)key)) {
            HashMap<String, String> returnParam = new HashMap<String, String>();
            EntryGrid invoiceEntry = (EntryGrid)this.getControl("invoiceentry");
            int[] selected = invoiceEntry.getSelectRows();
            DynamicObjectCollection invoiceItemEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("invoiceentry");
            StringBuilder selectedInvoiceIds = new StringBuilder();
            StringBuilder showSelectedInvoice = new StringBuilder();
            for (int i = 0; i < selected.length; ++i) {
                DynamicObject invoiceItem = (DynamicObject)invoiceItemEntrys.get(selected[i]);
                String invoiceType = InvoiceTypeEnum.getByValue((String)invoiceItem.getString("invoicetype")).getKey();
                String invoiceNo = invoiceItem.getString("invoiceno");
                String inoiceInfo = invoiceType + invoiceNo;
                selectedInvoiceIds.append(",").append(invoiceItem.getPkValue());
                showSelectedInvoice.append(inoiceInfo);
                if (i == selected.length - 1) continue;
                showSelectedInvoice.append(", ");
            }
            returnParam.put("showselectedinvoice", showSelectedInvoice.toString());
            returnParam.put("selectedInvoiceIds", selectedInvoiceIds.toString());
            this.getView().returnDataToParent(returnParam);
            this.getView().close();
        }
    }
}

