/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.tripbusi;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.bill.IBillPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.AdvContainer;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.APIHelper;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.kingdee.QueryInvoiceDetailBO;
import kd.fi.er.business.invoicecloud.kingdee.action.QueryBySerialNoAction;
import kd.fi.er.business.invoicecloud.util.InvoiceProcessUtil;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.IInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.invoicecloud.v2.util.InvoiceJsonParseUtils;
import kd.fi.er.business.servicehelper.InvoiceServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.common.model.invoice.bill.BillOfInvoice;
import kd.fi.er.formplugin.invoicecloud.usecase.ShowInvoiceCloudPageUtil;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoiceForReimPCPlugin;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoiceNonautoPCPlugin;
import kd.fi.er.formplugin.invoicecloud.v2.service.model.InvoiceEvent;
import kd.fi.er.formplugin.invoicecloud.v2.service.utils.InvoicePluginUtils;
import kd.fi.er.formplugin.invoicecloud.v2.util.RelateExpenseOrTripItemAndInvoiceUtil;
import org.apache.commons.lang3.StringUtils;

public class ImportInvoiceForCheckingPayBillPlugin
extends AbstractImportInvoiceNonautoPCPlugin
implements IBillPlugin,
RowClickEventListener {
    private static final Log log = LogFactory.getLog(AbstractImportInvoiceForReimPCPlugin.class);
    private static final int MAX_THREAD = 4;
    private static final String BATCH_UPLOAD_IMAGE = "batchuploadimage";
    private static final String INVOICE_CLOUD_UPLOAD = "invoicecloudupload";
    private static final String UPLOAD_INVOICE_ATTACHMENT = "uploadinvoiceattachment";
    private static final String HEAD_VIEW_INVOICE_LIST = "viewinvoice";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap22", "mapinvoice"});
        AbstractGrid expenseEntryGrid = (AbstractGrid)this.getView().getControl("entryentity");
        expenseEntryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (ErStdConfig.isDev() && !ErStdConfig.getShowImportInvoiceDataSimulatorPC() && key.equals(this.getCloseCallBackKey())) {
            QueryBySerialNoAction action = new QueryBySerialNoAction("test");
            String apiReturnJson = action.execute();
            try {
                List invoiceVOs = InvoiceJsonParseUtils.parseInvoiceVO((String)apiReturnJson);
                this.executeProcess(invoiceVOs);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                this.getView().showErrorNotification(e.getMessage());
            }
            return;
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)this.getCloseCallBackKey())) {
            this.showSelectedInvoicePage(this.getExtView(), key);
        } else if (StringUtils.equals((CharSequence)"mapinvoice", (CharSequence)key)) {
            this.selectUpdateMapping();
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)BATCH_UPLOAD_IMAGE)) {
            this.selectUploadImage();
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)HEAD_VIEW_INVOICE_LIST)) {
            this.showInvoiceList(this.getAllSerialNos());
        } else if (StringUtils.equals((CharSequence)"deleteattach", (CharSequence)key)) {
            if (ErStdConfig.isDev()) {
                ClosedCallBackEvent event = new ClosedCallBackEvent((Object)this, "delete_attach_callback_key", null);
                InvoicePluginUtils.handleDeleteAttachment(this, new InvoiceEvent<ClosedCallBackEvent>(event));
                return;
            }
            this.showDeleteAttachPage();
        }
    }

    @Override
    public void showInvoiceList(List<String> serialNos) {
        serialNos.removeIf(serialNo -> StringUtils.isBlank((CharSequence)serialNo));
        String taxRegNum = this.getTaxRegNum();
        if (StringUtils.isBlank((CharSequence)taxRegNum)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7ec4\u7ec7\u7684\u53d1\u7968\u4e91\u914d\u7f6e\u3002", (String)"AbstractImportInvoiceForReimPCPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        ShowInvoiceCloudPageUtil.viewInvoiceLst_pc((AbstractFormPlugin)this, this.getModel(), serialNos, ErCommonUtils.getPk((Object)this.getCostCompanyDO()));
    }

    @Override
    public String getTaxRegNum() {
        DynamicObject costCompanyDO = this.getCostCompanyDO();
        if (costCompanyDO == null) {
            log.info("\u5f53\u524d\u5355\u636e\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a");
            return "";
        }
        String taxRegNum = KingdeeInvoiceCloudConfig.getTaxRegNum((long)((Long)costCompanyDO.getPkValue()));
        return taxRegNum;
    }

    private List<String> getAllSerialNos() {
        return InvoiceServiceHelper.getAllSerialNos((IDataModel)this.getModel());
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        if (StringUtils.equals((CharSequence)"mapinvoice", (CharSequence)key)) {
            int i;
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            int invoiceCount = this.getModel().getEntryRowCount("invoiceentry");
            if (invoiceCount <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5bfc\u5165\u53d1\u7968\u4fe1\u606f\u3002", (String)"ImportInvoiceForCheckingPayBillPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            int itemCount = this.getModel().getEntryRowCount("entryentity");
            if (itemCount <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u660e\u7ec6\u3002", (String)"ImportInvoiceForCheckingPayBillPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            EntryGrid itemEntryCtrl = (EntryGrid)this.getControl("entryentity");
            int[] selectedItem = itemEntryCtrl.getSelectRows();
            if (selectedItem != null && selectedItem.length <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ed3\u7b97\u5355\u660e\u7ec6\uff0c\u518d\u5173\u8054\u53d1\u7968\u3002", (String)"ImportInvoiceForCheckingPayBillPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObjectCollection invoiceEntry = this.getModel().getEntryEntity("invoiceentry");
            EntryGrid invoiceEntryCtrl = (EntryGrid)this.getControl("invoiceentry");
            int[] selectedInvoice = invoiceEntryCtrl.getSelectRows();
            DynamicObjectCollection itemEntrys = dataEntity.getDynamicObjectCollection("entryentity");
            List expenseEntryIds = Arrays.stream(selectedItem).mapToObj(index -> this.setAndGetSelectedRowEntryId((DynamicObject)itemEntrys.get(index))).collect(Collectors.toList());
            Map invoiceAndItemMap = InvoiceUtils.nonAutoMapInvoiceMappingInfo((DynamicObject)dataEntity);
            boolean isNoMap = true;
            for (i = 0; i < expenseEntryIds.size(); ++i) {
                if (invoiceAndItemMap.get(expenseEntryIds.get(i)) == null) continue;
                isNoMap = false;
                break;
            }
            if (isNoMap && (selectedInvoice == null || selectedInvoice.length <= 0)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u53d1\u7968\u4fe1\u606f\u5206\u5f55\uff0c\u518d\u8fdb\u884c\u5173\u8054\u3002", (String)"ImportInvoiceForCheckingPayBillPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (selectedInvoice != null) {
                for (i = 0; i < selectedInvoice.length; ++i) {
                    String invoicefrom = ((DynamicObject)invoiceEntry.get(selectedInvoice[i])).getString("invoicefrom");
                    if (!StringUtils.equals((CharSequence)invoicefrom, (CharSequence)"3")) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u53d1\u7968\u4e2d\u5305\u542b\u5546\u65c5\u53d1\u7968\uff0c\u4e0d\u80fd\u5173\u8054\u8d39\u7528\u3002\u8bf7\u5148\u53d6\u6d88\u9009\u62e9\u5546\u65c5\u53d1\u7968\uff0c\u518d\u5173\u8054\u8d39\u7528\u3002", (String)"ImportInvoiceForCheckingPayBillPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                List<Long> invoiceEntryIds = Arrays.stream(selectedInvoice).mapToObj(index -> (Long)((DynamicObject)invoiceEntry.get(index)).getPkValue()).collect(Collectors.toList());
                if (!this.checkIsAllowMapTripOrExpenseEntry(invoiceEntryIds)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u4e2d\u7684\u53d1\u7968\u5fc5\u987b\u4e3a\u540c\u4e00\u7c7b\u578b\u3002", (String)"ImportInvoiceForCheckingPayBillPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
            }
        } else if (StringUtils.equals((CharSequence)BATCH_UPLOAD_IMAGE, (CharSequence)key)) {
            DynamicObject costCompanyDO = this.getCostCompanyDO();
            InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)ErCommonUtils.getPk((Object)costCompanyDO));
            if (config == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u542f\u7528\u53d1\u7968\u4e91\uff0c\u8bf7\u5148\u542f\u7528\u3002", (String)"ImportInvoiceForCheckingPayBillPlugin_15", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            EntryGrid itemEntryCtrl = (EntryGrid)this.getControl("entryentity");
            int[] selectedItem = itemEntryCtrl.getSelectRows();
            if (selectedItem != null && selectedItem.length <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ed3\u7b97\u5355\u660e\u7ec6\uff0c\u518d\u70b9\u51fb\u4e00\u952e\u4e0a\u4f20\u673a\u7968\u884c\u7a0b\u5355\u3002", (String)"ImportInvoiceForCheckingPayBillPlugin_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    private void selectUploadImage() {
        log.info("\u4e00\u952e\u4e0a\u4f20\u673a\u7968\u884c\u7a0b\u5355\uff0c\u5f00\u59cbselectUploadImage" + System.currentTimeMillis());
        final IDataModel model = this.getModel();
        final IFormView view = this.getView();
        final DynamicObject dataEntity = model.getDataEntity();
        final DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        EntryGrid itemEntryCtrl = (EntryGrid)this.getControl("entryentity");
        int[] selectedItem = itemEntryCtrl.getSelectRows();
        StringBuilder buf = new StringBuilder();
        ArrayList<String> ordernumList = new ArrayList<String>(selectedItem.length);
        for (int index : selectedItem) {
            String checkingbillnum;
            DynamicObject entry = (DynamicObject)entryentity.get(index);
            Boolean travelbill = entry.getBoolean("travelbill");
            Boolean isuploadinvoicecloud = entry.getBoolean("isuploadinvoicecloud");
            if (!travelbill.booleanValue() || isuploadinvoicecloud.booleanValue() || !StringUtils.isNotBlank((CharSequence)(checkingbillnum = entry.getString("checkingbillnum")))) continue;
            ordernumList.add(checkingbillnum);
        }
        if (ordernumList.size() == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5df2\u4e0a\u4f20\u53d1\u7968\u4e91\u6216\u4e0d\u662f\u884c\u7a0b\u5355\uff0c\u8bf7\u9009\u62e9\u672a\u4e0a\u4f20\u7684\u884c\u7a0b\u5355\u3002", (String)"ImportInvoiceForCheckingPayBillPlugin_14", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qFilter = new QFilter("ordernum", "in", ordernumList);
        DynamicObjectCollection planecheckingbills = QueryServiceHelper.query((String)"er_planecheckingbill", (String)"id,settlemain,ordernum,downloadlink,allorderbase.reimbursenum", (QFilter[])new QFilter[]{qFilter});
        final ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(planecheckingbills.size());
        for (DynamicObject bill : planecheckingbills) {
            billList.add(bill);
        }
        String ignoreStr = buf.toString();
        if (StringUtils.isNotBlank((CharSequence)ignoreStr)) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u7ed3\u7b97\u5355\u5173\u8054\u4fe1\u606f\u7b2c%1$s\u884c\u6240\u5bf9\u5e94\u7684\u673a\u7968\u7ed3\u7b97\u5355\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u4e0a\u4f20\u3002", (String)"ImportInvoiceForCheckingPayBillPlugin_9", (String)"fi-er-formplugin", (Object[])new Object[0]), ignoreStr));
        }
        if (billList.size() == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5305\u542b\u884c\u7a0b\u5355\u7684\u6570\u636e\u3002", (String)"ImportInvoiceForCheckingPayBillPlugin_12", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        final IPageCache pageCache = this.getPageCache();
        pageCache.remove("task_percent");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("formId", "er_progressbar");
        paramMap.put("showType", ShowType.Modal);
        paramMap.put("needCallBack", Boolean.TRUE);
        ShowPageUtils.showWebForm(paramMap, (AbstractFormPlugin)this);
        log.info("\u4e00\u952e\u4e0a\u4f20\u673a\u7968\u884c\u7a0b\u5355\uff0c\u5f00\u542f\u7ebf\u7a0b\u524d" + System.currentTimeMillis());
        ThreadService.execute((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int size = billList.size();
                int errsize = 0;
                pageCache.put("size", String.valueOf(size));
                StringBuilder serialNoStr = new StringBuilder();
                try {
                    String pkValue = dataEntity.getPkValue().toString();
                    String billNo = dataEntity.getString("billno");
                    Long costCompany = ErCommonUtils.getPk((Object)dataEntity.getDynamicObject("company"));
                    String bxdKey = "er_checkingpaybill" + pkValue;
                    final String userKey = APIHelper.getCommonUserKey((Long)costCompany, (String)bxdKey, (String)billNo);
                    int entrySize = entryentity.size();
                    HashMap<Object, Object> resMap = new HashMap<Object, Object>();
                    ArrayList<Future> futureList = new ArrayList<Future>(billList.size());
                    int i = 0;
                    try {
                        for (DynamicObject dynamicObject : billList) {
                            final String orderNum = dynamicObject.getString("ordernum");
                            final String downloadLink = dynamicObject.getString("downloadlink");
                            if (StringUtils.isBlank((CharSequence)downloadLink)) {
                                log.info(String.format("\u4e00\u952e\u4e0a\u4f20\u673a\u7968\u884c\u7a0b\u5355\uff0c\u7ed3\u7b97\u5355\u53f7\u4e3a%s\u7684\u4e0b\u8f7d\u5730\u5740\u4e3a\u7a7a", orderNum));
                                ++errsize;
                                continue;
                            }
                            resMap.put(orderNum, "");
                            Future submit = ThreadService.submit((Callable)new Callable<Tuple<String, String>>(){
                                final String poolDownloadLink;
                                final String poolOrderNum;
                                {
                                    this.poolDownloadLink = downloadLink;
                                    this.poolOrderNum = orderNum;
                                }

                                @Override
                                public Tuple<String, String> call() {
                                    try {
                                        String serialNo = APIHelper.uploadImage((String)this.poolDownloadLink, (String)userKey);
                                        Tuple result = Tuple.create((Object)this.poolOrderNum, (Object)serialNo);
                                        return result;
                                    }
                                    catch (Exception e) {
                                        log.error(String.format("\u4e00\u952e\u4e0a\u4f20\u673a\u7968\u884c\u7a0b\u5355\uff0c\u8ba2\u5355\u53f7\u4e3a%s\u4e0a\u4f20\u91c7\u96c6\u63a5\u53e3\u5f02\u5e38" + e.getMessage(), this.poolOrderNum));
                                        return null;
                                    }
                                }
                            }, (TaskType)TaskType.ER_INVOICE_TASK, (RequestContext)RequestContext.get());
                            futureList.add(submit);
                        }
                        for (Future future : futureList) {
                            Tuple result = (Tuple)future.get();
                            if (null != result) {
                                resMap.put(result.item1, result.item2);
                            }
                            if (++i % 3 != 1) continue;
                            pageCache.put("task_percent", String.valueOf(((float)i - 1.0f) / (float)size * 100.0f).replaceAll("\\.[0-9]*", ""));
                        }
                        for (Map.Entry entry : resMap.entrySet()) {
                            String ordernum = (String)entry.getKey();
                            String serialNo = (String)entry.getValue();
                            if (StringUtils.isNotBlank((CharSequence)serialNo)) {
                                serialNoStr.append(serialNo).append(',');
                                for (int j = 0; j < entrySize; ++j) {
                                    DynamicObject dynamicObject = (DynamicObject)entryentity.get(j);
                                    if (!StringUtils.equals((CharSequence)ordernum, (CharSequence)dynamicObject.getString("checkingbillnum")) || !dynamicObject.getBoolean("travelbill")) continue;
                                    model.setValue("isuploadinvoicecloud", (Object)true, j);
                                }
                                continue;
                            }
                            log.error(String.format("\u4e00\u952e\u4e0a\u4f20\u673a\u7968\u884c\u7a0b\u5355\uff0c\u8ba2\u5355\u53f7\u4e3a%s\u5b58\u5728\u8fd4\u56de\u7684\u53d1\u7968\u5e8f\u5217\u53f7\u4e3a\u7a7a", ordernum));
                            ++errsize;
                        }
                    }
                    catch (Exception e) {
                        ++errsize;
                        String string = RequestContext.get().getTraceId();
                        String errTraceId = pageCache.get("errTraceId");
                        pageCache.put("errTraceId", string + errTraceId);
                        log.error("\u4e00\u952e\u4e0a\u4f20\u673a\u7968\u884c\u7a0b\u5355,\u7ebf\u7a0b\u6c60\u4efb\u52a1\u6267\u884c\u5f02\u5e38" + e.getMessage());
                    }
                    finally {
                        if (i % 3 == 1) {
                            pageCache.put("task_percent", String.valueOf(((float)i - 1.0f) / (float)size * 100.0f).replaceAll("\\.[0-9]*", ""));
                        }
                    }
                    log.info("\u4e00\u952e\u4e0a\u4f20\u673a\u7968\u884c\u7a0b\u5355\uff0c\u67e5\u8be2\u53d1\u7968\u6d41\u6c34\u53f7\u5b8c\u6210" + System.currentTimeMillis());
                    QueryInvoiceDetailBO queryInvoiceDetailBO = InvoicePluginUtils.buildQueryInvoiceDetailBO(ImportInvoiceForCheckingPayBillPlugin.this, serialNoStr.toString());
                    List list = APIHelper.queryInvoiceDetailBySerialNo((QueryInvoiceDetailBO)queryInvoiceDetailBO);
                    ImportInvoiceForCheckingPayBillPlugin.this.executeProcess(list);
                }
                catch (Exception e) {
                    String traceId = RequestContext.get().getTraceId();
                    String errTraceId = pageCache.get("errTraceId");
                    pageCache.put("errTraceId", traceId + errTraceId);
                    log.error("\u4e00\u952e\u4e0a\u4f20\u673a\u7968\u884c\u7a0b\u5355\u5931\u8d25" + e);
                }
                finally {
                    log.info("\u4e00\u952e\u4e0a\u4f20\u673a\u7968\u884c\u7a0b\u5355\uff0c\u7ebf\u7a0bfinally" + System.currentTimeMillis());
                    pageCache.put("errsize", String.valueOf(errsize));
                    view.getActionResult();
                    pageCache.put("task_percent", "100");
                }
            }
        }, (TaskType)TaskType.ER_TRIP_TASK, (RequestContext)RequestContext.get());
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        IPageCache pageCache = this.getPageCache();
        pageCache.remove("task_percent");
        if ("er_progressbar".equals(actionId)) {
            IFormView view = this.getView();
            String type = pageCache.get("type");
            if (StringUtils.isNotEmpty((CharSequence)type)) {
                if (StringUtils.isNotEmpty((CharSequence)pageCache.get("error"))) {
                    view.showErrorNotification(pageCache.get("error"));
                } else if (StringUtils.isNotEmpty((CharSequence)pageCache.get("success"))) {
                    view.showSuccessNotification(pageCache.get("success"));
                } else if (StringUtils.isNotEmpty((CharSequence)pageCache.get("remind"))) {
                    view.showTipNotification(pageCache.get("remind"));
                }
                pageCache.remove("error");
                pageCache.remove("success");
                pageCache.remove("remind");
                pageCache.remove("type");
                if ("attach".equals(type)) {
                    AttachmentPanel filePanel = (AttachmentPanel)view.getControl("attachmentpanel");
                    this.getModel().setValue("annexnum", (Object)filePanel.getAttachmentData().size());
                    view.updateView("annexnum");
                    view.updateView("attachmentpanel");
                } else if ("invoice".equals(type)) {
                    view.updateView("entryentity");
                    view.updateView("invoiceentry");
                }
            } else {
                String errTraceId = pageCache.get("errTraceId");
                pageCache.remove("errTraceId");
                log.info("\u4e00\u952e\u4e0a\u4f20\u673a\u7968\u884c\u7a0b\u5355\uff0cclosedCallBack" + System.currentTimeMillis() + "errTraceId:" + errTraceId);
                String size = pageCache.get("size");
                String errsize = pageCache.get("errsize");
                pageCache.remove("size");
                pageCache.remove("errsize");
                log.info(new Date() + "\u8fdb\u5165closedCallBack\u4e2d\uff1berrTraceId\u4e3a\uff1a" + errTraceId);
                try {
                    if (Integer.parseInt(size) > 0 && Integer.parseInt(errsize) > 0) {
                        view.showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0a\u4f20\u5b8c\u6210\u3002\u5171\u4e0a\u4f20%1$s\u6761\uff0c\u4e0a\u4f20\u5931\u8d25%2$s\u6761\u3002", (String)"ImportInvoiceForCheckingPayBillPlugin_11", (String)"fi-er-formplugin", (Object[])new Object[0]), size, errsize));
                    } else if (Integer.parseInt(size) > 0) {
                        view.showSuccessNotification(String.format(ResManager.loadKDString((String)"\u4e0a\u4f20\u6210\u529f\u3002", (String)"ImportInvoiceForCheckingPayBillPlugin_13", (String)"fi-er-formplugin", (Object[])new Object[0]), size, errsize));
                    }
                }
                catch (Exception ex) {
                    log.error((Throwable)ex);
                }
                view.updateView();
            }
        }
    }

    protected void selectUpdateMapping() {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        EntryGrid invoiceEntryCtrl = (EntryGrid)this.getControl("invoiceentry");
        int[] selectedInvoice = invoiceEntryCtrl.getSelectRows();
        EntryGrid itemEntryCtrl = (EntryGrid)this.getControl("entryentity");
        int[] selectedItem = itemEntryCtrl.getSelectRows();
        DynamicObjectCollection itemEntrys = dataEntity.getDynamicObjectCollection("entryentity");
        List<Long> expenseEntryIds = Arrays.stream(selectedItem).mapToObj(index -> this.setAndGetSelectedRowEntryId((DynamicObject)itemEntrys.get(index))).collect(Collectors.toList());
        DynamicObjectCollection invoiceEntrys = dataEntity.getDynamicObjectCollection("invoiceentry");
        List<Long> invoiceEntryIds = Arrays.stream(selectedInvoice).mapToObj(index -> this.setAndGetSelectedRowEntryId((DynamicObject)invoiceEntrys.get(index))).collect(Collectors.toList());
        String msg = RelateExpenseOrTripItemAndInvoiceUtil.checkRelate((IFormView)this.getView(), (BillOfInvoice)BillOfInvoice.CheckingPayBill, expenseEntryIds, invoiceEntryIds);
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            this.getView().showTipNotification(msg);
            return;
        }
        this.updateMappingInvoiceAndItem(expenseEntryIds, invoiceEntryIds);
    }

    protected List<Long> deleteUpdateMapping(int[] deleteIndex, String key) {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection itemEntrys = dataEntity.getDynamicObjectCollection(key);
        return Arrays.stream(deleteIndex).mapToObj(index -> this.setAndGetSelectedRowEntryId((DynamicObject)itemEntrys.get(index))).collect(Collectors.toList());
    }

    protected void updateMappingInvoiceAndItem(List<Long> expenseEntryIds, List<Long> invoiceEntryIds) {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection invoiceAndExpenseEntrys = dataEntity.getDynamicObjectCollection("invoiceandexpense");
        ArrayList needDelItemIndexs = Lists.newArrayListWithExpectedSize((int)invoiceAndExpenseEntrys.size());
        ArrayList needDelInvoiceIndexs = Lists.newArrayListWithExpectedSize((int)invoiceAndExpenseEntrys.size());
        for (int i = 0; i < invoiceAndExpenseEntrys.size(); ++i) {
            DynamicObject itemMappingInfo = (DynamicObject)invoiceAndExpenseEntrys.get(i);
            if (expenseEntryIds.contains(itemMappingInfo.getLong("expenseentryid"))) {
                needDelItemIndexs.add(i);
            }
            if (!expenseEntryIds.contains(itemMappingInfo.getLong("invoiceentryid"))) continue;
            needDelInvoiceIndexs.add(i);
        }
        if (!needDelItemIndexs.isEmpty()) {
            model.deleteEntryRows("invoiceandexpense", needDelItemIndexs.stream().mapToInt(Integer::intValue).toArray());
        } else if (!needDelInvoiceIndexs.isEmpty()) {
            model.deleteEntryRows("invoiceentryid", needDelInvoiceIndexs.stream().mapToInt(Integer::intValue).toArray());
        }
        DynamicObjectCollection invoiceEntrys = dataEntity.getDynamicObjectCollection("invoiceentry");
        for (int i = 0; i < expenseEntryIds.size(); ++i) {
            for (int j = 0; j < invoiceEntryIds.size(); ++j) {
                int newRowIndex = this.getModel().createNewEntryRow("invoiceandexpense");
                this.getModel().setValue("expenseentryid", (Object)expenseEntryIds.get(i), newRowIndex);
                this.getModel().setValue("invoiceentryid", (Object)invoiceEntryIds.get(j), newRowIndex);
                if (this.getModel().getProperty("invoiceexpserialno") == null || j >= invoiceEntrys.size()) continue;
                this.getModel().setValue("invoiceexpserialno", ((DynamicObject)invoiceEntrys.get(j)).get("serialno"), newRowIndex);
            }
        }
        if (!expenseEntryIds.isEmpty()) {
            if (invoiceEntryIds.isEmpty()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5173\u8054\u6210\u529f\u3002", (String)"ImportInvoiceForCheckingPayBillPlugin_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
            } else {
                List result = InvoiceUtils.checkAmount((Object)model, (InvoiceUtils.BillEntityType)InvoiceUtils.BillEntityType.CheckingPayBill);
                if (!result.isEmpty()) {
                    this.getView().showTipNotification((String)result.get(0));
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5173\u8054\u6210\u529f\u3002", (String)"ImportInvoiceForCheckingPayBillPlugin_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private Long setAndGetSelectedRowEntryId(DynamicObject entryEntity) {
        Long entryId = (Long)entryEntity.getPkValue();
        if (Objects.equals(entryId, 0L)) {
            entryId = ORM.create().genLongId(entryEntity.getDataEntityType());
            entryEntity.set("id", (Object)entryId);
        }
        return entryId;
    }

    public void entryRowClick(RowClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"entryentity")) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            EntryGrid itemEntryCtrl = (EntryGrid)this.getControl("entryentity");
            int[] selectedItem = itemEntryCtrl.getSelectRows();
            DynamicObjectCollection itemEntrys = dataEntity.getDynamicObjectCollection("entryentity");
            List expenseEntryIds = Arrays.stream(selectedItem).mapToObj(index -> this.setAndGetSelectedRowEntryId((DynamicObject)itemEntrys.get(index))).collect(Collectors.toList());
            DynamicObjectCollection invoiceAndExpenseEntrys = dataEntity.getDynamicObjectCollection("invoiceandexpense");
            List invoiceEntryIds = invoiceAndExpenseEntrys.stream().filter(entry -> expenseEntryIds.contains(entry.getLong("expenseentryid"))).map(entry -> entry.getLong("invoiceentryid")).collect(Collectors.toList());
            DynamicObjectCollection invoiceEntrys = dataEntity.getDynamicObjectCollection("invoiceentry");
            ArrayList needSelectInvoiceIndexs = Lists.newArrayListWithExpectedSize((int)invoiceEntrys.size());
            for (int i = 0; i < invoiceEntrys.size(); ++i) {
                if (!invoiceEntryIds.contains(((DynamicObject)invoiceEntrys.get(i)).getPkValue())) continue;
                needSelectInvoiceIndexs.add(i);
            }
            EntryGrid invoiceHeadGrid = (EntryGrid)this.getView().getControl("invoiceentry");
            int[] invoiceRows = needSelectInvoiceIndexs.stream().mapToInt(Integer::intValue).toArray();
            invoiceHeadGrid.selectRows(invoiceRows, -1);
        }
    }

    private void delNotTavelBillData(int[] deleteIndex, DynamicObjectCollection invoiceentries, DynamicObjectCollection entryentities) {
        List notTravelBills = entryentities.stream().filter(dynamicObject -> !dynamicObject.getBoolean("travelbill")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(notTravelBills)) {
            return;
        }
        for (int index : deleteIndex) {
            DynamicObject invoiceentry = (DynamicObject)invoiceentries.get(index);
            String invoiceno = invoiceentry.getString("invoiceno");
            for (DynamicObject entry : entryentities) {
                String invoicenum = entry.getString("invoicenum_tag");
                if (StringUtils.isEmpty((CharSequence)invoicenum)) {
                    entry.set("isuploadinvoicecloud", (Object)false);
                    entry.set("match", (Object)false);
                    continue;
                }
                if (!invoicenum.contains(invoiceno)) continue;
                String[] invoiceNums = invoicenum.split(",");
                ArrayList<String> invoiceNumList = new ArrayList<String>(Arrays.asList(invoiceNums));
                invoiceNumList.remove(invoiceno);
                if (CollectionUtils.isEmpty(invoiceNumList)) {
                    entry.set("invoicenum", (Object)"");
                    entry.set("invoicenum_tag", (Object)"");
                    continue;
                }
                entry.set("invoicenum", (Object)invoiceNumList.get(0));
                entry.set("invoicenum_tag", (Object)String.join((CharSequence)",", invoiceNumList));
            }
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        String server;
        super.afterBindData(e);
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        DynamicObject company = dataEntity.getDynamicObject("appliercompany");
        int isbatchuploadimage = 0;
        int invoiceCloudUpload = 0;
        if (company != null) {
            isbatchuploadimage = SystemParamterUtil.getloancheckparam((long)ErCommonUtils.getPk((Object)company), (String)BATCH_UPLOAD_IMAGE);
            invoiceCloudUpload = SystemParamterUtil.getloancheckparam((long)ErCommonUtils.getPk((Object)company), (String)INVOICE_CLOUD_UPLOAD);
        }
        if (("CHAILVYIHAO".equalsIgnoreCase(server = dataEntity.getString("server")) || "ZHONGXING".equalsIgnoreCase(server)) && isbatchuploadimage == 1) {
            model.setValue("isbatchuploadimage", (Object)true);
        }
        if ("CHAILVYIHAO".equalsIgnoreCase(server) && invoiceCloudUpload == 1) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"oneclickuploadinvoice"});
            this.getView().setVisible(Boolean.FALSE, new String[]{UPLOAD_INVOICE_ATTACHMENT});
        } else if ("CHAILVYIHAO".equalsIgnoreCase(server) && invoiceCloudUpload == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"oneclickuploadinvoice"});
            this.getView().setVisible(Boolean.TRUE, new String[]{UPLOAD_INVOICE_ATTACHMENT});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"oneclickuploadinvoice"});
            this.getView().setVisible(Boolean.FALSE, new String[]{UPLOAD_INVOICE_ATTACHMENT});
        }
        this.getModel().setDataChanged(false);
        int invoiceEntryCount = this.getModel().getEntryRowCount("invoiceentry");
        AdvContainer invoiceAdvContainer = (AdvContainer)this.getControl("invoice_entry_container");
        if (invoiceEntryCount < 1) {
            invoiceAdvContainer.setCollapse(true);
        } else {
            invoiceAdvContainer.setCollapse(false);
        }
        this.setDeleteAttachButtonVisible();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        Long id = (Long)this.getModel().getValue("id");
        if (id == null || id.equals(0L)) {
            id = ORM.create().genLongId((IDataEntityType)this.getModel().getDataEntityType());
            this.getModel().setValue("id", (Object)id);
        }
    }

    protected void setDeleteAttachButtonVisible() {
        Long costCompanyId = ErCommonUtils.getPk((Object)this.getCostCompanyDO());
        boolean invoiceIsEnabled = costCompanyId == null ? false : KingdeeInvoiceCloudConfig.isEnabled((long)costCompanyId);
        this.getView().setVisible(Boolean.valueOf(invoiceIsEnabled), new String[]{"deleteattach"});
    }

    @Override
    protected String getCostCompanyKey() {
        return "company";
    }

    @Override
    public MappingItemWithOrgInvoiceServiceImp.BillType getBillType() {
        return null;
    }

    @Override
    public IInvoiceService getCreateExpenseOrTripItemService(InvoiceContext invoiceContext) {
        return null;
    }

    @Override
    protected DynamicObject getCompany(DynamicObject dataEntity) {
        return dataEntity.getDynamicObject("appliercompany");
    }

    @Override
    protected void loadAfterProcessUpdateView() {
        super.loadAfterProcessUpdateView();
        InvoiceProcessUtil.updateInvoiceContainerCollapse((IFormView)this.getExtView());
    }

    @Override
    public DynamicObject getCostCompanyDO() {
        return (DynamicObject)this.getModel().getValue(this.getCostCompanyKey());
    }
}

