/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.validator;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.invoicecloud.provider.param.DataModelProxy;
import kd.fi.er.business.invoicecloud.provider.param.FormViewProxy;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.common.model.invoice.InvoiceProcessMessage;
import kd.fi.er.common.model.invoice.InvoiceProcessResult;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoiceForReimByItemEntry;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoiceSupplementMobPlugin;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoiceSupplementPCPlugin;
import kd.fi.er.formplugin.invoicecloud.v2.expensepool.ImportInvoiceForPoolPCInOneExpenseItem;
import kd.fi.er.formplugin.invoicecloud.v2.validator.InvoiceValidator;

public class InvoiceCurrencyValidator
implements InvoiceValidator {
    private static final Log log = LogFactory.getLog(InvoiceValidator.class);

    @Override
    public void validator(FormViewProxy viewProxy, DataModelProxy dataModelProxy, InvoiceContext context) {
        List invoiceVOs = context.getInvoiceVOs();
        Class importInvoiceClass = context.getImportInvoiceClass();
        Long invoiceCurrencyId = context.getInvoiceConfig().getInvoiceCurrencyId();
        if (AbstractImportInvoiceForReimByItemEntry.class.isAssignableFrom(importInvoiceClass)) {
            DynamicObject selectItem = (DynamicObject)context.getSelectItem().get(0);
            Object itemFrom = selectItem.get("itemfrom");
            HashSet<Long> currencyIdSet = new HashSet<Long>();
            boolean hasNot30 = invoiceVOs.stream().anyMatch(vo -> !vo.getInvoiceType().equals("30"));
            if (hasNot30) {
                currencyIdSet.add(invoiceCurrencyId);
            }
            if (ItemFrom.InvoiceCloud.getValue().equals(itemFrom)) {
                currencyIdSet.add((Long)selectItem.getDynamicObject("entrycurrency").getPkValue());
            }
            Set invoiceCurrencyIdSet = invoiceVOs.stream().filter(vo -> vo.getInvoiceType().equals("30")).map(vo -> vo.getCurrencyId()).collect(Collectors.toSet());
            currencyIdSet.addAll(invoiceCurrencyIdSet);
            if (currencyIdSet.size() >= 2) {
                InvoiceProcessResult processResult = new InvoiceProcessResult();
                InvoiceProcessMessage processMessage = new InvoiceProcessMessage();
                processMessage.setLevel("error");
                processMessage.setMessage(ResManager.loadKDString((String)"\u8981\u5bfc\u5165\u7684\u53d1\u7968\u7684\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u8bf7\u5728\u53d1\u7968\u52a9\u624b\u4fee\u6539\u53d1\u7968\u5e01\u79cd\u540e\u518d\u5bfc\u5165\u3002", (String)"InvoiceCurrencyValidator_0", (String)"fi-er-business", (Object[])new Object[0]));
                processResult.getProcessResult().add(processMessage);
                context.getInvoiceResult().put(this.getClass().getName(), processResult);
            }
        } else if (AbstractImportInvoiceSupplementMobPlugin.class.isAssignableFrom(importInvoiceClass) || AbstractImportInvoiceSupplementPCPlugin.class.isAssignableFrom(importInvoiceClass)) {
            HashSet currencyIdSet = new HashSet();
            Set invoiceCurrencyIdSet = invoiceVOs.stream().filter(vo -> vo.getInvoiceType().equals("30")).map(vo -> vo.getCurrencyId()).collect(Collectors.toSet());
            List selectItems = context.getSelectItem();
            if (selectItems == null || selectItems.isEmpty()) {
                log.error("selectItems is null,skip invoiceCurrencyValidator......");
                return;
            }
            DynamicObject dynamicObject = (DynamicObject)selectItems.get(0);
            if (dynamicObject.getDynamicObjectType().getProperty("entrycurrency") == null) {
                log.error("entrycurrency is null,skip invoiceCurrencyValidator......");
                return;
            }
            Set entryCurrencySet = selectItems.stream().map(item -> (Long)item.getDynamicObject("entrycurrency").getPkValue()).collect(Collectors.toSet());
            currencyIdSet.addAll(entryCurrencySet);
            currencyIdSet.addAll(invoiceCurrencyIdSet);
            if (currencyIdSet.size() >= 2) {
                InvoiceProcessResult processResult = new InvoiceProcessResult();
                InvoiceProcessMessage processMessage = new InvoiceProcessMessage();
                processMessage.setLevel("error");
                processMessage.setMessage(ResManager.loadKDString((String)"\u8981\u5bfc\u5165\u7684\u53d1\u7968\u7684\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u8bf7\u5728\u53d1\u7968\u52a9\u624b\u4fee\u6539\u53d1\u7968\u5e01\u79cd\u540e\u518d\u5bfc\u5165\u3002", (String)"InvoiceCurrencyValidator_0", (String)"fi-er-business", (Object[])new Object[0]));
                processResult.getProcessResult().add(processMessage);
                context.getInvoiceResult().put(this.getClass().getName(), processResult);
            }
        } else if (ImportInvoiceForPoolPCInOneExpenseItem.class.isAssignableFrom(importInvoiceClass)) {
            DynamicObject currency;
            HashSet<Long> currencyIdSet = new HashSet<Long>();
            int invoiceEntryCount = dataModelProxy.getEntryRowCount("invoiceentry");
            if (invoiceEntryCount > 0 && (currency = (DynamicObject)dataModelProxy.getValue("currency")) != null) {
                currencyIdSet.add((Long)currency.getPkValue());
            }
            Set invoiceCurrencyIdSet = invoiceVOs.stream().filter(vo -> vo.getInvoiceType().equals("30")).map(vo -> vo.getCurrencyId()).collect(Collectors.toSet());
            boolean hasNot30 = invoiceVOs.stream().anyMatch(vo -> !vo.getInvoiceType().equals("30"));
            if (hasNot30) {
                currencyIdSet.add(invoiceCurrencyId);
            }
            currencyIdSet.addAll(invoiceCurrencyIdSet);
            if (currencyIdSet.size() >= 2) {
                InvoiceProcessResult processResult = new InvoiceProcessResult();
                InvoiceProcessMessage processMessage = new InvoiceProcessMessage();
                processMessage.setLevel("error");
                processMessage.setMessage(ResManager.loadKDString((String)"\u8981\u5bfc\u5165\u7684\u53d1\u7968\u7684\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u8bf7\u5728\u53d1\u7968\u52a9\u624b\u4fee\u6539\u53d1\u7968\u5e01\u79cd\u540e\u518d\u5bfc\u5165\u3002", (String)"InvoiceCurrencyValidator_0", (String)"fi-er-business", (Object[])new Object[0]));
                processResult.getProcessResult().add(processMessage);
                context.getInvoiceResult().put(this.getClass().getName(), processResult);
            }
        }
    }
}

