/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.invoicecloud.provider.param.DataModelProxy;
import kd.fi.er.business.invoicecloud.provider.param.FormViewProxy;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.model.invoice.InvoiceProcessMessage;
import kd.fi.er.common.model.invoice.InvoiceProcessResult;
import kd.fi.er.formplugin.invoicecloud.v2.validator.InvoiceValidator;

public class TripCardInvoiceCurrencyValidator
implements InvoiceValidator {
    @Override
    public void validator(FormViewProxy viewProxy, DataModelProxy dataModelProxy, InvoiceContext context) {
        int tripIndex;
        DynamicObject tripCurrency;
        Object companyId;
        boolean currencyShowInTrip;
        if (dataModelProxy.getProperty("billkind") == null || !"0".equals(dataModelProxy.getValue("billkind"))) {
            return;
        }
        List invoiceVOs = context.getInvoiceVOs();
        List invoice30 = invoiceVOs.stream().filter(vo -> vo.getInvoiceType().equals("30")).collect(Collectors.toList());
        DynamicObject company = (DynamicObject)dataModelProxy.getValue("company");
        if (company != null && (currencyShowInTrip = SystemParamterUtil.getIsCurrencyShowinTripentry((long)((Long)(companyId = company.getPkValue())))) && (tripCurrency = (DynamicObject)dataModelProxy.getValue("tripcurrency", tripIndex = dataModelProxy.getEntryCurrentRowIndex("tripentry"))) != null) {
            Long tripCurrencyId = (Long)tripCurrency.getPkValue();
            ILocaleString localeName = tripCurrency.getLocaleString("name");
            String currencyName = localeName.getLocaleValue();
            String currencyNumber = tripCurrency.getString("number");
            String currencyCover = currencyName + currencyNumber;
            boolean notIdentificateCurrency = invoice30.stream().anyMatch(vo -> vo.getCurrencyId() == null || vo.getCurrencyId() == 0L);
            List notSameCurrencyIds = invoice30.stream().filter(vo -> vo.getCurrencyId() != null && vo.getCurrencyId() != 0L && !vo.getCurrencyId().equals(tripCurrencyId)).map(vo -> vo.getCurrencyId()).collect(Collectors.toList());
            ArrayList<String> invoiceCurrencyList = new ArrayList<String>();
            if (notIdentificateCurrency) {
                String blankStr = ResManager.loadKDString((String)"\u4e3a\u7a7a", (String)"TripCardInvoiceCurrencyValidator_1", (String)"fi-er-formplugin", (Object[])new Object[0]);
                invoiceCurrencyList.add(blankStr);
            }
            if (!notSameCurrencyIds.isEmpty()) {
                QFilter filter = new QFilter("id", "in", notSameCurrencyIds);
                Map notSameCurrencyMap = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (String)"name", (QFilter[])new QFilter[]{filter});
                List notSameCurrency = notSameCurrencyMap.values().stream().map(currency -> currency.getString("name")).collect(Collectors.toList());
                invoiceCurrencyList.addAll(notSameCurrency);
            }
            if (!invoiceCurrencyList.isEmpty()) {
                String invoiceCurrencyStr = invoiceCurrencyList.stream().collect(Collectors.joining("\u3001"));
                String msgResource = ResManager.loadKDString((String)"\u672c\u6b21\u5bfc\u5165\u7684\u6d77\u5916\u5f62\u5f0f\u53d1\u7968\u4e2d\u5b58\u5728\u53d1\u7968\u5e01\u79cd(%1s)\u4e0e\u62a5\u9500\u5355\u7684\u884c\u7a0b\u5e01\u79cd(%2s)\u4e0d\u4e00\u81f4\uff0c\u8bf7\u5728\"\u53d1\u7968\u52a9\u624b\"\u754c\u9762\u4fee\u6539\u5bf9\u5e94\u5e01\u79cd\u540e\u518d\u5bfc\u5165\u3002", (String)"TripCardInvoiceCurrencyValidator_0", (String)"fi-er-formplugin", (Object[])new Object[0]);
                String msg = String.format(msgResource, invoiceCurrencyStr, currencyCover);
                InvoiceProcessResult processResult = new InvoiceProcessResult();
                InvoiceProcessMessage processMessage = new InvoiceProcessMessage();
                processMessage.setLevel("error");
                processMessage.setMessage(msg);
                processResult.getProcessResult().add(processMessage);
                context.getInvoiceResult().put(this.getClass().getName(), processResult);
            }
        }
    }
}

