/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mealapplicationbill.web.plugin;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.er.business.bean.CostDeptF7ChangePram;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.CreditLevelServiceHelper;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.common.model.UserCurrentDeptInfo;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostCompanyF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostDeptF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeExpenseItemF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeProjectF7SelectListener;
import kd.fi.er.model.FormModel;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ErMealApplicationBillPlugin
extends AbstractBillPlugIn
implements RowClickEventListener,
BeforeF7SelectListener {
    protected IPageCache pageCache;

    public void initialize() {
        this.pageCache = this.getPageCache();
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"changeapplier", "creditlevel"});
        this.setCostDeptF7Filter();
        this.setCostCompanyF7Filter();
        String number = this.getModel().getDataEntityType().getName();
        BasedataEdit entryexpenseitemF7 = (BasedataEdit)this.getControl("headexpenseitem");
        if (null != entryexpenseitemF7) {
            entryexpenseitemF7.addBeforeF7SelectListener((BeforeF7SelectListener)new BeforeExpenseItemF7SelectListener(this.getView(), number, "costdept"));
        }
        this.setProjectF7Filter();
    }

    protected void setCostDeptF7Filter() {
        BasedataEdit costDeptF7 = (BasedataEdit)this.getControl("costdept");
        if (costDeptF7 != null) {
            BeforeCostDeptF7SelectListener beforeCostDeptF7SelectListener = new BeforeCostDeptF7SelectListener(this.getModel());
            costDeptF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostDeptF7SelectListener);
        }
    }

    protected void setCostCompanyF7Filter() {
        boolean isNotRelated;
        BasedataEdit costCompanyF7 = (BasedataEdit)this.getControl("costcompany");
        Object costDept = this.getModel().getValue("costdept");
        Object company = this.getModel().getValue("company");
        int showType = ErCommonUtils.getExpenseAssumeShowTypes((long)ErCommonUtils.getPk((Object)this.getModel().getValue("company")));
        boolean bl = isNotRelated = "2".equals(ErStdConfig.get((String)"Costcompany Unbinding")) && showType == 1;
        if (!isNotRelated && costCompanyF7 != null && costDept != null) {
            BeforeCostCompanyF7SelectListener beforeCostCompanyF7SelectListener = new BeforeCostCompanyF7SelectListener(ErCommonUtils.getPk((Object)costDept), ErCommonUtils.getPk((Object)company));
            costCompanyF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCompanyF7SelectListener);
        }
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getView().getModel();
        Long currentUserID = 0L;
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        if (pageCache.get("consignorId") != null) {
            currentUserID = Long.valueOf(pageCache.get("consignorId"));
            pageCache.remove("consignorId");
        } else {
            RequestContext requestContext = RequestContext.get();
            currentUserID = Long.valueOf(requestContext.getUserId());
        }
        Map billMap = CoreBaseBillServiceHelper.createNewData((Long)currentUserID);
        Map custom = this.getView().getFormShowParameter().getCustomParams();
        Object parameterStr = custom.get("userInfo");
        if (parameterStr != null && StringUtils.isNotBlank((String)parameterStr.toString())) {
            UserCurrentDeptInfo userInfo = (UserCurrentDeptInfo)JSON.parseObject((String)parameterStr.toString(), UserCurrentDeptInfo.class);
            billMap = CoreBaseBillServiceHelper.createNewData((Long)userInfo.getUserId(), (Long)userInfo.getDeptId());
        }
        CoreBaseBillServiceHelper.extService((IFormView)this.getView(), (Map)billMap);
        CoreBaseBillServiceHelper.initObjByMap((Object)model, (Map)billMap);
        Object entryCurrency = model.getValue("entrycurrency");
        if (entryCurrency == null) {
            model.setValue("entrycurrency", model.getValue("currency"));
        }
        if (model.getValue("company") == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"CoreBaseBillEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]), MessageTypes.Permission, new ConfirmCallBackListener("ok", (IFormPlugin)this));
        }
        if (model.getValue("costcompany") == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"CoreBaseBillEdit_1", (String)"fi-er-formplugin", (Object[])new Object[0]), MessageTypes.Permission, new ConfirmCallBackListener("ok", (IFormPlugin)this));
        }
        Object currency = model.getValue("currency");
        if (model.getValue("company") != null && currency == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u672c\u4f4d\u5e01\u3002", (String)"CoreBaseBillEdit_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterBindData(EventObject e) {
        this.initUserInfo();
        IDataModel model = this.getModel();
    }

    protected void initUserInfo() {
        IDataModel model = this.getModel();
        String applierStr = null;
        String deptStr = null;
        String applierPicUrl = null;
        String costDeptStr = null;
        String positionStr = null;
        String costCompanyStr = null;
        DynamicObject applier = (DynamicObject)model.getValue("applier");
        DynamicObject dept = (DynamicObject)model.getValue("org");
        positionStr = model.getValue("applierpositionstr").toString();
        DynamicObject costDept = (DynamicObject)model.getValue("costdept");
        DynamicObject costCompany = (DynamicObject)model.getValue("costcompany");
        String telStr = (String)model.getValue("tel");
        if (applier != null) {
            applierStr = applier.getLocaleString("name").getLocaleValue();
            applierPicUrl = ErCommonUtils.getUserImageFullPath((Long)((Long)applier.getPkValue()));
        }
        if (dept != null) {
            deptStr = dept.getLocaleString("name").getLocaleValue();
        }
        if (costDept != null) {
            costDeptStr = costDept.getLocaleString("name").getLocaleValue();
        }
        if (costCompany != null) {
            costCompanyStr = costCompany.getLocaleString("name").getLocaleValue();
        }
        ((Label)this.getControl("applierv")).setText(applierStr);
        ((Label)this.getControl("orgv")).setText(deptStr);
        telStr = this.pageCache.get("newtel") != null ? this.pageCache.get("newtel") : telStr;
        model.setValue("tel", (Object)telStr);
        ((Label)this.getControl("telv")).setText(telStr);
        ((Label)this.getControl("costdeptv")).setText(costDeptStr);
        ((Label)this.getControl("applierpositionv")).setText(positionStr);
        ((Label)this.getControl("costcompanyv")).setText(costCompanyStr);
        Image applierPic = (Image)this.getControl("applierpic");
        applierPic.setUrl(applierPicUrl);
        if (applier != null) {
            String appilerIdStr = String.valueOf(applier.getPkValue());
            String creditlevelStr = CreditLevelServiceHelper.getCreditLevelByUserAndView((Object)appilerIdStr, (IFormView)this.getView());
            if (StringUtils.isEmpty((String)creditlevelStr)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"creditlevel"});
            } else {
                ((Label)this.getControl("creditlevel")).setText(creditlevelStr);
            }
        }
    }

    public void afterLoadData(EventObject e) {
        CoreBaseBillServiceHelper.setFromStatus((AbstractFormPlugin)this);
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "changeapplier": {
                HashMap<String, String> customParam = new HashMap<String, String>();
                customParam.put("showProps", "applierprops");
                FormModel formModel = new FormModel("er_changeapplier", ResManager.loadKDString((String)"\u4e2a\u4eba\u4fe1\u606f", (String)"CoreBaseBillEdit_3", (String)"fi-er-formplugin", (Object[])new Object[0]), "1", true, customParam);
                formModel.setShowType(ShowType.Modal);
                ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
                break;
            }
            case "creditlevel": {
                DynamicObject applier = (DynamicObject)this.getModel().getValue("applier");
                CreditLevelServiceHelper.showCreditFilesForm((IFormView)this.getView(), (String)String.valueOf(applier.getPkValue()));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        IDataModel model = this.getView().getModel();
        if ("er_changeapplier".equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            Map map = (Map)closedCallBackEvent.getReturnData();
            long deptId = Long.parseLong(map.get("deptId").toString());
            String userId = map.get("consignorId").toString();
            String newtel = map.get("newtel").toString();
            DynamicObject applier = (DynamicObject)model.getValue("applier");
            String applierId = applier.getPkValue().toString();
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            if (!applierId.equals(userId)) {
                model.setValue("applier", (Object)Long.valueOf(userId));
                String applierPicUrl = ErCommonUtils.getUserImageFullPath((Long)Long.valueOf(userId));
                Image applierPic = (Image)this.getControl("applierpic");
                applierPic.setUrl(applierPicUrl);
                model.setValue("tel", (Object)newtel);
                ((Label)this.getView().getControl("telv")).setText(newtel);
                pageCache.put("consignorId", userId);
                applier = (DynamicObject)model.getValue("applier");
                String applierStr = null;
                if (applier != null) {
                    applierStr = applier.getLocaleString("name").getLocaleValue();
                    ((Label)this.getControl("applierv")).setText(applierStr);
                }
            }
            model.setValue("applierpositionstr", (Object)((String)map.get("newPositionStr")));
            ((Label)this.getView().getControl("applierpositionv")).setText((String)map.get("newPositionStr"));
            model.setValue("company", map.get("newCompanyId"));
            model.setValue("org", (Object)deptId);
            model.setValue("costdept", (Object)deptId);
            pageCache.put("newtel", newtel);
            Long currencyId = BaseCurrencyServiceHelper.getBaseCurrencyId((Object)model.getValue("company"), (Object)model.getValue("costcompany"));
            model.setValue("currency", (Object)currencyId);
            String creditlevelStr = CreditLevelServiceHelper.getCreditLevelByUserAndView((Object)userId, (IFormView)this.getView());
            if (StringUtils.isEmpty((String)creditlevelStr)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"creditlevel"});
            } else {
                ((Label)this.getControl("creditlevel")).setText(creditlevelStr);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        DynamicObject company = (DynamicObject)model.getValue("company");
        DynamicObject costCompany = (DynamicObject)model.getValue("costcompany");
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        switch (propName) {
            case "costcompany": 
            case "company": {
                if (propValue == null) {
                    this.getModel().setValue(propName, valueSet[0].getOldValue());
                    break;
                }
                String billtype = (String)model.getValue("formid");
                if (ErEntityTypeUtils.isDailyVehicleBill((String)billtype)) {
                    return;
                }
                Long oldCurrency = ErCommonUtils.getPk((Object)model.getValue("currency"));
                if (company == null || company.getPkValue() == null) break;
                Long baseCurrencyId = BaseCurrencyServiceHelper.getBaseCurrencyId((Object)company, (Object)costCompany);
                if (baseCurrencyId == null || baseCurrencyId.compareTo(0L) == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u672c\u4f4d\u5e01\u3002", (String)"DailyBillServiceHelper_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                }
                if (oldCurrency != null && oldCurrency.equals(baseCurrencyId)) break;
                model.setValue("currency", (Object)baseCurrencyId);
                break;
            }
            case "costdept": {
                this.costDeptChange(propName, (DynamicObject)propValue);
                break;
            }
            case "currency": {
                DynamicObject entryCurrency = (DynamicObject)model.getValue("entrycurrency");
                if (entryCurrency == null || currency == null || company == null) break;
                Long srcCurrencyId = (Long)entryCurrency.getPkValue();
                Long targetCurrencyId = (Long)currency.getPkValue();
                Map exchangerateMap = CommonServiceHelper.getExchangeRateFromSysParams((Object)company, (Object)costCompany, (Long)srcCurrencyId, (Long)targetCurrencyId, (Object)model);
                BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangerateMap.get("exchangeRate")), (Object)BigDecimal.ONE);
                String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangerateMap.get("quoteType")), (Object)"0");
                model.setValue("exchangerate", (Object)exchangeRate);
                model.setValue("stdexpquotetype", (Object)quoteType);
                break;
            }
            case "exchangerate": 
            case "dinneramount": {
                DynamicObject tripCurrency = (DynamicObject)model.getValue("entrycurrency");
                Map exchangeRateAndQuoteType = CommonServiceHelper.getExchangeRateFromSysParams((Object)company, (Object)costCompany, (Long)tripCurrency.getLong("id"), (Long)currency.getLong("id"), (Object)model);
                int currencyPrecision = AmountUtils.getCurrencyPrecision((IDataModel)model, (String)"currency");
                Object dinneramount = model.getValue("dinneramount");
                BigDecimal tripAmount = AmountUtils.getCurrencyAmount((BigDecimal)(dinneramount == null ? BigDecimal.ZERO : BigDecimal.valueOf(Double.parseDouble(String.valueOf(dinneramount)))), (BigDecimal)((BigDecimal)model.getValue("exchangerate")), (int)currencyPrecision, (String)((String)exchangeRateAndQuoteType.get("quoteType")));
                model.setValue("tripamount", (Object)tripAmount);
                model.setValue("stdexpquotetype", exchangeRateAndQuoteType.get("quoteType"));
                break;
            }
            case "org": {
                this.deptChange((DynamicObject)propValue);
            }
        }
    }

    protected void costDeptChange(String propName, DynamicObject costDept) {
        if (costDept == null) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject company = (DynamicObject)model.getValue("company");
        if (company == null) {
            return;
        }
        int showType = ErCommonUtils.getExpenseAssumeShowTypes((long)((Long)company.getPkValue()));
        model.setValue("expensesassumeshowtypes", (Object)String.valueOf(showType));
        boolean isNotRelated = "2".equals(ErStdConfig.get((String)"Costcompany Unbinding")) && showType == 1;
        DynamicObject costCompany = (DynamicObject)model.getValue("costcompany");
        if (!isNotRelated) {
            CostDeptF7ChangePram costDeptF7ChangePram = new CostDeptF7ChangePram(Boolean.TRUE, (Object)costDept, (Object)costCompany, (Object)company);
            Long costCompanyId = CoreBaseBillServiceHelper.getAccountOrgId((CostDeptF7ChangePram)costDeptF7ChangePram);
            model.setValue("costcompany", (Object)costCompanyId);
            if (costCompanyId == null || costCompanyId.compareTo(Long.valueOf("0")) == 0) {
                return;
            }
        }
    }

    protected void deptChange(DynamicObject dept) {
        if (dept != null) {
            IDataModel model = this.getModel();
            Long newCompanyId = CoreBaseBillServiceHelper.initCompanyByDept((Long)((Long)dept.getPkValue()));
            model.setValue("company", (Object)newCompanyId);
        }
        this.refreshBaseInfoLabel("org", dept);
    }

    protected void refreshBaseInfoLabel(String propName, Object propValue) {
        String propStr = null;
        if (propValue instanceof DynamicObject) {
            ILocaleString name = ((DynamicObject)propValue).getLocaleString("name");
            propStr = name.getLocaleValue();
        } else if (propValue instanceof String) {
            propStr = (String)propValue;
        }
        Label propControl = (Label)this.getControl(propName + "V");
        if (propControl != null) {
            propControl.setText(propStr);
        }
    }

    private void setProjectF7Filter() {
        Object applier;
        BasedataEdit projectF7 = (BasedataEdit)this.getControl("headproject");
        if (projectF7 != null && (applier = this.getModel().getValue("applier")) != null) {
            projectF7.addBeforeF7SelectListener((BeforeF7SelectListener)new BeforeProjectF7SelectListener(ErCommonUtils.getPk((Object)applier), ErCommonUtils.getPk((Object)this.getModel().getValue("company"))));
        }
    }
}

