/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mob.costcompany;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Submit;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErCostCenterUtil;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostCenterF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostCompanyF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostDeptF7SelectListener;
import kd.fi.er.formplugin.mob.costcompany.ICostCompanyProp;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractFirstPageCostCompanyMobPlugin
extends AbstractBillPlugIn
implements ICostCompanyProp {
    private static final Map<String, String> entryKeyByHeads = new HashMap<String, String>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.setCostDeptF7Filter();
        this.setCostCompanyF7Filter();
        this.costCenterF7Filter();
    }

    private void costCenterF7Filter() {
        BasedataEdit costCenterF7 = (BasedataEdit)this.getControl("std_costcenter");
        BasedataEdit entryCostCenterF7 = (BasedataEdit)this.getControl("std_entrycostcenter");
        BeforeCostCenterF7SelectListener beforeCostCenterF7SelectListener = new BeforeCostCenterF7SelectListener(this.getView());
        if (costCenterF7 != null) {
            costCenterF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCenterF7SelectListener);
        }
        if (entryCostCenterF7 != null) {
            entryCostCenterF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCenterF7SelectListener);
        }
    }

    protected void setCostDeptF7Filter() {
        BasedataEdit costDeptF7 = (BasedataEdit)this.getControl("costdept");
        if (costDeptF7 != null) {
            BeforeCostDeptF7SelectListener beforeCostDeptF7SelectListener = new BeforeCostDeptF7SelectListener(this.getModel());
            costDeptF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostDeptF7SelectListener);
        }
    }

    protected void setCostCompanyF7Filter() {
        BasedataEdit costCompanyF7 = (BasedataEdit)this.getControl("costcompany");
        Object costDept = this.getModel().getValue("costdept");
        Object company = this.getModel().getValue("company");
        if (costCompanyF7 != null && costDept != null && company != null) {
            BeforeCostCompanyF7SelectListener beforeCostCompanyF7SelectListener = new BeforeCostCompanyF7SelectListener(ErCommonUtils.getPk((Object)costDept), ErCommonUtils.getPk((Object)company));
            costCompanyF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCompanyF7SelectListener);
        }
    }

    public void afterBindData(EventObject e) {
        boolean dataChanged = this.getModel().getDataChanged();
        this.setCostCompanyShowType();
        this.getModel().setDataChanged(dataChanged);
        ErCostCenterUtil.dealCostCenter((IFormView)this.getView());
        this.costCenterShowRule();
    }

    private void costCenterShowRule() {
        Long companyPk;
        IFormView parentView;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object company = model.getValue("company");
        if (company == null && (parentView = view.getParentView()) != null) {
            company = parentView.getModel().getValue("company");
        }
        if ((companyPk = ErCommonUtils.getPk((Object)company)) == null) {
            return;
        }
        int expenseAssumeShowTypes = ErCommonUtils.getExpenseAssumeShowTypes((long)companyPk);
        if (ErCommonUtils.getCostOrgUseMode((Long)companyPk).equals("0")) {
            return;
        }
        for (Map.Entry next : ErCostCenterUtil.COSTDEPT_COSTCENTER_MAP.entrySet()) {
            CardEntry cardEntry;
            String key = (String)next.getKey();
            ThreeTuple itemMapping = (ThreeTuple)next.getValue();
            if (expenseAssumeShowTypes == 1 && (cardEntry = (CardEntry)this.getControl(key)) != null) {
                cardEntry.setChildVisible(false, 0, new String[]{(String)itemMapping.item3});
            }
            if (expenseAssumeShowTypes != 2 || !key.equals("head")) continue;
            view.setVisible(Boolean.valueOf(false), new String[]{(String)itemMapping.item3});
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.setCostCompanyShowType();
    }

    public void afterLoadData(EventObject e) {
        this.setCostCompanyShowType();
    }

    private void setCostCompanyShowType(DynamicObject company) {
        if (company == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7533\u8bf7\u4eba\u516c\u53f8\u3002", (String)"AbstractFirstPageCostCompanyMobPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        int costCompanyshowType = ErCommonUtils.getExpenseAssumeShowTypes((long)((Long)company.getPkValue()));
        this.getModel().setValue("expensesassumeshowtypes", (Object)costCompanyshowType);
    }

    private void setCostCompanyShowType() {
        IDataModel model = this.getModel();
        DynamicObject company = (DynamicObject)model.getValue("company");
        this.setCostCompanyShowType(company);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        String name = e.getProperty().getName();
        String costCompanyshowType = CommonServiceHelper.getBillCostOrgShowType((IFormView)this.getView());
        Object newValue = e.getChangeSet()[0].getNewValue();
        String entrycost_property = entryKeyByHeads.get(name);
        if (entrycost_property != null) {
            DynamicObject newCostDO;
            if (newValue == null) {
                model.setValue(name, e.getChangeSet()[0].getOldValue());
            }
            DynamicObject newValueId = (newCostDO = (DynamicObject)newValue) == null ? newCostDO : (Long)newCostDO.getPkValue();
            int entryRowCount = model.getEntryRowCount(this.getExpenseEntryName());
            if (StringUtils.equals((CharSequence)costCompanyshowType, (CharSequence)"1")) {
                for (int i = 0; i < entryRowCount; ++i) {
                    model.setValue(entrycost_property, (Object)newValueId, i);
                }
            } else if (StringUtils.equals((CharSequence)costCompanyshowType, (CharSequence)"2")) {
                if (entryRowCount > 0) {
                    model.setValue(entrycost_property, (Object)newValueId, 0);
                }
            } else if (StringUtils.equals((CharSequence)costCompanyshowType, (CharSequence)"3") && StringUtils.equals((CharSequence)"costcompany", (CharSequence)name)) {
                for (int i = 0; i < entryRowCount; ++i) {
                    model.setValue("entrycostcompany", (Object)newValueId, i);
                }
            }
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"company")) {
            this.setCostCompanyShowType((DynamicObject)newValue);
        }
        if ("entrycostdept".equals(name)) {
            this.checkExpenseItem((DynamicObject)e.getChangeSet()[0].getNewValue(), e.getChangeSet()[0].getRowIndex());
        }
    }

    protected abstract void checkExpenseItem(DynamicObject var1, int var2);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        block6: {
            StringBuilder sb;
            block8: {
                boolean costCenterMode;
                DataEntityPropertyCollection properties;
                block7: {
                    Object source = args.getSource();
                    sb = new StringBuilder();
                    if (!(source instanceof Submit) || !((Submit)source).getOperateKey().equals("submit")) break block6;
                    IDataModel model = this.getModel();
                    properties = model.getDataEntity().getDataEntityType().getProperties();
                    String costCompanyshowType = CommonServiceHelper.getBillCostOrgShowType((IFormView)this.getView());
                    costCenterMode = ErCostCenterUtil.checkCompanyMode((IFormView)this.getView());
                    if (!StringUtils.equals((CharSequence)costCompanyshowType, (CharSequence)"1")) break block7;
                    Object costDept = this.getModel().getValue("costdept");
                    Object costCompany = this.getModel().getValue("costcompany");
                    if (costDept == null) {
                        sb.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u8d39\u7528\u627f\u62c5\u90e8\u95e8\";", (String)"AbstractFirstPageCostCompanyMobPlugin_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    }
                    if (costCompany == null) {
                        sb.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u8d39\u7528\u627f\u62c5\u516c\u53f8\";", (String)"AbstractFirstPageCostCompanyMobPlugin_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    }
                    if (!costCenterMode) break block8;
                    ThreeTuple head = (ThreeTuple)ErCostCenterUtil.COSTDEPT_COSTCENTER_MAP.get("head");
                    String item3 = (String)head.item3;
                    IDataEntityProperty std_costcenterDT = (IDataEntityProperty)properties.get((Object)item3);
                    if (std_costcenterDT == null || model.getValue(item3) != null) break block8;
                    sb.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\"\u6210\u672c\u4e2d\u5fc3\";", (String)"AbstractFirstPageCostCompanyMobPlugin_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    break block8;
                }
                int entryRowCount = this.getModel().getEntryRowCount(this.getExpenseEntryName());
                ThreeTuple costCenterMapping = (ThreeTuple)ErCostCenterUtil.COSTDEPT_COSTCENTER_MAP.get(this.getExpenseEntryName());
                for (int i = 0; i < entryRowCount; ++i) {
                    EntryProp expenseEntryPropDT;
                    DataEntityPropertyCollection expenseEntryPropProperties;
                    IDataEntityProperty entryCostCenterDT;
                    Object costDept = this.getModel().getValue("entrycostdept", i);
                    Object costCompany = this.getModel().getValue("entrycostcompany", i);
                    if (costDept == null) {
                        sb.append(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u5f55\u7b2c%d\u884c\u4e0a\u7684\u201c%s\u201d\u5b57\u6bb5;", (String)"AbstractFirstPageCostCompanyMobPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]), i + 1, ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u90e8\u95e8", (String)"AbstractFirstPageCostCompanyMobPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0])));
                    }
                    if (costCompany == null) {
                        sb.append(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u5f55\u7b2c%d\u884c\u4e0a\u7684\u201c%s\u201d\u5b57\u6bb5;", (String)"AbstractFirstPageCostCompanyMobPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]), i + 1, ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8", (String)"AbstractFirstPageCostCompanyMobPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0])));
                    }
                    if (!costCenterMode) continue;
                    ThreeTuple expenseMapping = (ThreeTuple)ErCostCenterUtil.COSTDEPT_COSTCENTER_MAP.get(this.getExpenseEntryName());
                    IDataEntityProperty expenseEntryDT = (IDataEntityProperty)properties.get((Object)this.getExpenseEntryName());
                    if (expenseEntryDT == null || (entryCostCenterDT = (IDataEntityProperty)(expenseEntryPropProperties = (expenseEntryPropDT = (EntryProp)expenseEntryDT).getDynamicCollectionItemPropertyType().getProperties()).get(expenseMapping.item3)) == null || this.getModel().getValue((String)expenseMapping.item3, i) != null) continue;
                    sb.append(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u5f55\u7b2c%d\u884c\u4e0a\u7684\u201c%s\u201d\u5b57\u6bb5;", (String)"AbstractFirstPageCostCompanyMobPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]), i + 1, ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3", (String)"AbstractFirstPageCostCompanyMobPlugin_9", (String)"fi-er-formplugin", (Object[])new Object[0])));
                }
            }
            if (sb.length() > 0) {
                String msg = sb.substring(0, sb.length() - 1);
                args.setCancel(true);
                this.getView().showErrorNotification(msg);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        if (this.getExpenseEntryName().equals(entryName)) {
            int[] rowIndexs;
            for (int row : rowIndexs = e.getRowIndexs()) {
                String costCompanyshowType;
                if (row != 0) continue;
                int count = this.getModel().getEntryRowCount(this.getExpenseEntryName());
                if (count <= 0) break;
                Object costDept = this.getModel().getValue("entrycostdept", 0);
                Object costCompany = this.getModel().getValue("entrycostcompany", 0);
                if (costDept != null && costCompany != null && StringUtils.equalsAny((CharSequence)(costCompanyshowType = CommonServiceHelper.getBillCostOrgShowType((IFormView)this.getView())), (CharSequence[])new CharSequence[]{"2", "3"})) {
                    this.getModel().beginInit();
                    this.getModel().setValue("costdept", ((DynamicObject)costDept).getPkValue());
                    this.getModel().endInit();
                    this.getView().updateView("costdept");
                    this.getModel().setValue("costcompany", ((DynamicObject)costCompany).getPkValue());
                }
                Object costCenter = null;
                if (this.getModel().getProperty("std_entrycostcenter") == null) {
                    if (this.getModel().getProperty("entrycostcenter") != null) {
                        costCenter = this.getModel().getValue("entrycostcenter", 0);
                    }
                } else {
                    costCenter = this.getModel().getValue("std_entrycostcenter", 0);
                }
                if (costCenter == null) break;
                this.getModel().setValue("std_costcenter", costCenter);
                break;
            }
        }
    }

    static {
        entryKeyByHeads.put("costdept", "entrycostdept");
        entryKeyByHeads.put("costcompany", "entrycostcompany");
    }
}

