/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.utils.ErCommonUtils;

public class DailyVehicleSelectPlugin
extends AbstractMobBillPlugIn
implements RowClickEventListener {
    private static Log logger = LogFactory.getLog(DailyVehicleSelectPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((CardEntry)this.getControl("entryentity")).addRowClickListener((RowClickEventListener)this);
    }

    public void beforeBindData(EventObject e) {
        this.showData();
    }

    private void showData() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        List bills = (List)parameter.getCustomParams().get("bills");
        if (bills == null) {
            logger.info("bills is null");
            return;
        }
        if (bills.isEmpty()) {
            logger.info("bills is empty");
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        int size = bills.size();
        model.batchCreateNewEntryRow("entryentity", size);
        for (int idx = 0; idx < size; ++idx) {
            model.setValue("billid", ((Map)bills.get(idx)).get("id"), idx);
            model.setValue("billNo", ((Map)bills.get(idx)).get("billNo"), idx);
            model.setValue("title", ((Map)bills.get(idx)).get("title"), idx);
            model.setValue("info", ((Map)bills.get(idx)).get("info"), idx);
            model.setValue("infol", (Object)TripCommonUtil.convertToDate((String)((Map)bills.get(idx)).get("infol").toString()), idx);
            model.setValue("from", ((Map)bills.get(idx)).get("from"), idx);
            model.setValue("to", ((Map)bills.get(idx)).get("to"), idx);
            model.setValue("fromDate", ((Map)bills.get(idx)).get("fromDate"), idx);
            model.setValue("fromDatel", ((Map)bills.get(idx)).get("fromDatel"), idx);
            model.setValue("toDate", ((Map)bills.get(idx)).get("toDate"), idx);
            model.setValue("toDatel", ((Map)bills.get(idx)).get("toDatel"), idx);
        }
    }

    public static List<Map<String, Object>> getData(String vehicletype, String number) {
        QFilter qFilter = DailyVehicleSelectPlugin.getFilter(vehicletype);
        DynamicObjectCollection queryDatas = QueryServiceHelper.query((String)"er_dailyvehiclebill", (String)"id,description,billno,startdate,enddate,createtime,from,to,vehiclecity.id,vehiclecity.name", (QFilter[])new QFilter[]{qFilter});
        logger.info("DailyVehicleSelectPlugin getFilter query value is:" + qFilter);
        if (queryDatas == null || queryDatas.size() == 0) {
            return new ArrayList<Map<String, Object>>(2);
        }
        QFilter qA = new QFilter("enable", "=", (Object)"1");
        QFilter qB = new QFilter("vehicletype", "=", (Object)vehicletype);
        QFilter qC = new QFilter("server", "=", (Object)number);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"er_trip_vehicle_setting", (String)"number,name,vehicletype,datenum", (QFilter[])new QFilter[]{qA, qB, qC});
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>(queryDatas.size());
        int len = queryDatas.size();
        for (int i = 0; i < len; ++i) {
            HashMap<String, Object> m = new HashMap<String, Object>(9);
            DynamicObject queryData = (DynamicObject)queryDatas.get(i);
            m.put("id", queryData.get("id"));
            m.put("billNo", queryData.get("billno"));
            m.put("title", queryData.get("description"));
            Date startdate = queryData.getDate("startdate");
            logger.info("DailyVehicleSelectPlugin queryid:" + queryData.get("id") + "--querybillno:" + queryData.get("billno") + "startDate value is:" + startdate + "startDate value is togetString:" + queryData.get("startdate"));
            SimpleDateFormat df = new SimpleDateFormat("MM-dd");
            if (startdate != null) {
                String format = df.format(startdate);
                m.put("info", format);
                m.put("infol", startdate);
                m.put("fromdate", format);
                m.put("fromdatel", startdate);
            }
            m.put("from", queryData.getString("from"));
            m.put("to", queryData.getString("to"));
            m.put("vehiclecity_id", queryData.getLong("vehiclecity.id"));
            df = new SimpleDateFormat("yyyy-MM-dd");
            Date enddate = queryData.getDate("enddate");
            if (enddate != null) {
                m.put("todate", df.format(enddate));
                m.put("todatel", enddate);
            }
            ArrayList<Date> dates = new ArrayList<Date>();
            dates.add(startdate);
            dates.add(enddate);
            if (null != dynamicObject && null != dynamicObject.get("datenum") && 0 != dynamicObject.getInt("datenum")) {
                Integer datenum = dynamicObject.getInt("datenum");
                Date date = new Date();
                Date sdate = TripCommonUtil.addDayByDate((Date)((Date)Collections.min(dates)), (int)(-datenum.intValue()));
                Date edate = TripCommonUtil.addDayByDate((Date)((Date)Collections.max(dates)), (int)datenum);
                if (sdate.after(date) || edate.before(date)) {
                    logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u9009\u62e9\u7528\u8f66\u7533\u8bf7\u5355\uff0c\u65f6\u95f4\u4e0d\u5728\u5728\u9009\u62e9\u8303\u56f4\u5185\uff1a{} {} ,dates:{}", new Object[]{sdate, edate, dates});
                    continue;
                }
            }
            ret.add(m);
        }
        return ret;
    }

    private static QFilter getFilter(String vehicletype) {
        RequestContext requestContext = RequestContext.get();
        Long userId = Long.valueOf(requestContext.getUserId());
        Boolean isWhite = CommonServiceHelper.noApprovaWhiteList((Long)userId, (String)"1");
        Object paramValue = ErCommonUtils.getEMParameter((long)requestContext.getOrgId(), (String)"syncvehiclebilltotrip");
        Object[] paramObj = new Object[]{userId, userId};
        QFilter qFilter = QFilter.of((String)"(applier=? or creator=?)", (Object[])paramObj);
        if (Objects.isNull(paramValue) || "0".equals(paramValue.toString())) {
            qFilter = isWhite.booleanValue() ? DailyVehicleSelectPlugin.returnQfilter(qFilter) : qFilter.and("billstatus", "=", (Object)"E");
        } else if ("1".equals(paramValue.toString())) {
            qFilter = DailyVehicleSelectPlugin.returnQfilter(qFilter);
        }
        qFilter.and("vehicletype", "=", (Object)vehicletype);
        return qFilter;
    }

    private static QFilter returnQfilter(QFilter qFilter) {
        ArrayList<String> billStatusList = new ArrayList<String>();
        billStatusList.add("E");
        billStatusList.add("B");
        billStatusList.add("C");
        qFilter = qFilter.and("billstatus", "in", billStatusList);
        return qFilter;
    }

    public void entryRowClick(RowClickEvent evt) {
        IDataModel model = ((CardEntry)evt.getSource()).getModel();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String key = (String)parameter.getCustomParams().get("key");
        Long billId = Long.valueOf((String)model.getValue("billid"));
        Map paraMap = TripCommonUtil.getBusinessSectionInfoByDaily((Long)billId);
        paraMap.put("key", key);
        paraMap.put("isPC", Boolean.FALSE);
        paraMap.put("formId", "er_externalsystem");
        paraMap.put("formName", ResManager.loadKDString((String)"\u7528\u8f66", (String)"DailyVehicleSelectPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
        paraMap.put("formType", "5");
        TripCommonUtil.openTripPage((IFormView)this.getView(), (Map)paraMap);
    }
}

