/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractMobListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.api.BizProcessStatus;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.commons.lang3.StringUtils;

public class ErBillAddWorkflowInfoMobPlugin
extends AbstractMobListPlugin
implements ClickListener {
    private static Log log = LogFactory.getLog(ErBillAddWorkflowInfoMobPlugin.class);
    private Map<String, String> auditorsNameMap = new HashMap<String, String>();
    private static Boolean isnoApprova;
    private static Boolean isEnableServer;
    private static String formId;

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs e) {
        BillList billList = (BillList)e.getSource();
        formId = billList.getBillFormId();
        e.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection billDatas = super.getData(arg0, arg1);
                List filterPkIds = billDatas.stream().filter(bill -> bill.containsProperty("billstatus") && !StringUtils.equalsAny((CharSequence)bill.get("billstatus").toString(), (CharSequence[])new CharSequence[]{"A", "D", "H", "I"})).map(bill -> bill.get("id").toString()).collect(Collectors.toList());
                if (!filterPkIds.isEmpty()) {
                    ErBillAddWorkflowInfoMobPlugin.this.getNextAuditor(filterPkIds);
                }
                if ("er_tripreqbill".equals(formId)) {
                    Long applierId = Long.valueOf(RequestContext.get().getUserId());
                    isnoApprova = CommonServiceHelper.noApprovaWhiteList((Long)applierId, (String)"1");
                    isEnableServer = ErBillAddWorkflowInfoMobPlugin.this.getIsEnableServer();
                }
                return billDatas;
            }
        });
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        if (e.getSource() instanceof ColumnDesc) {
            ColumnDesc columnDesc = (ColumnDesc)e.getSource();
            String colKey = columnDesc.getKey();
            if (formId.equals("er_tripreqbill")) {
                Object applier;
                DynamicObject rowData;
                if (colKey.equalsIgnoreCase("isenableserver")) {
                    e.setFormatValue((Object)isEnableServer);
                } else if (colKey.equalsIgnoreCase("isnoapprovebook") && (rowData = e.getRowData()) != null && (applier = rowData.get("applier")) != null) {
                    e.setFormatValue((Object)CommonServiceHelper.noApprovaWhiteList((Long)ErCommonUtils.getPk((Object)applier), (String)"1"));
                }
            }
            if (colKey.equalsIgnoreCase("nextauditor") && this.auditorsNameMap != null && this.auditorsNameMap.size() > 0) {
                String auditor = this.auditorsNameMap.get(e.getRowData().getPkValue().toString());
                e.setFormatValue((Object)auditor);
            }
        }
    }

    private Map<String, String> getNextAuditor(List<String> billIds) {
        long t1 = System.currentTimeMillis();
        this.auditorsNameMap = new HashMap<String, String>(billIds.size());
        Map auditorsStatusMap = WorkflowServiceHelper.getBizProcessStatus((String[])billIds.toArray(new String[billIds.size()]));
        auditorsStatusMap.forEach((k, v) -> {
            StringBuilder auditInfo = new StringBuilder();
            BizProcessStatus bizProcessStatus = (BizProcessStatus)v.get(0);
            String auditor = bizProcessStatus.getParticipantName();
            String nodeName = bizProcessStatus.getCurrentNodeName();
            String statusName = bizProcessStatus.getProcessStatusName();
            if (StringUtils.equals((CharSequence)bizProcessStatus.getProcessStatus(), (CharSequence)"2")) {
                auditInfo.append(statusName);
            } else if (StringUtils.isNotBlank((CharSequence)auditor) && StringUtils.isNotBlank((CharSequence)nodeName)) {
                auditInfo.append(auditor).append(" | ").append(nodeName);
            } else if (StringUtils.isNotBlank((CharSequence)auditor)) {
                auditInfo.append(auditor);
            } else if (StringUtils.isNotBlank((CharSequence)nodeName)) {
                auditInfo.append(nodeName);
            }
            this.auditorsNameMap.put((String)k, auditInfo.toString());
        });
        return this.auditorsNameMap;
    }

    private Boolean getIsEnableServer() {
        String enableKey = "trip_flag_isEnableServer";
        String isEnableServer = (String)ErCommonUtils.getKeyValueFromAppCache((String)enableKey, String.class);
        if (isEnableServer != null && (isEnableServer.equals("1") || isEnableServer.equals("true"))) {
            return true;
        }
        Boolean isEnable = TripCommonUtil.reqBookIsEnableServer((boolean)Boolean.FALSE);
        ErCommonUtils.putKeyValueToAppCache((String)enableKey, (Object)isEnable.toString());
        return isEnable;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_pushpulicreim"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection listSelectedRowCollection = list.getSelectedRows();
        if (listSelectedRowCollection.size() > 0) {
            switch (key) {
                case "btn_pushpulicreim": {
                    Set unitIdSet;
                    Long billId = (Long)listSelectedRowCollection.get(0).getPrimaryKeyValue();
                    QFilter qFilter = new QFilter("id", "=", (Object)billId);
                    DynamicObjectCollection bill = QueryServiceHelper.query((String)"er_applyprojectbill", (String)"expenseentryentity.entrywlunit", (QFilter[])new QFilter[]{qFilter});
                    if (bill != null && bill.size() > 0 && (unitIdSet = bill.stream().map(v -> v.getLong("expenseentryentity.entrywlunit") != 0L ? v.getLong("expenseentryentity.entrywlunit") : 0L).collect(Collectors.toSet())) != null && unitIdSet.size() > 1) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u4e0d\u652f\u6301\u7acb\u9879\u591a\u5f80\u6765\u5355\u4f4d\u62a5\u9500\uff0c\u8bf7\u524d\u5f80PC\u7aef\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ERDailyloanMobileListPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        evt.setCancel(true);
                        return;
                    }
                    bill = QueryServiceHelper.query((String)"er_applyprojectbill", (String)"expenseentryentity.entrycostcompany", (QFilter[])new QFilter[]{qFilter});
                    if (bill == null || bill.size() <= 0 || (unitIdSet = bill.stream().map(v -> v.getLong("expenseentryentity.entrycostcompany") != 0L ? v.getLong("expenseentryentity.entrycostcompany") : 0L).collect(Collectors.toSet())) == null || unitIdSet.size() <= 1) break;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u4e0d\u652f\u6301\u7acb\u9879\u591a\u6838\u7b97\u7ec4\u7ec7\u62a5\u9500\uff0c\u8bf7\u524d\u5f80PC\u7aef\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ERDailyloanMobileListPlugin_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
            }
        }
    }
}

