/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.list.MobileListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.impl.createInvoiceService.CreateInvoiceEntryServiceImpl;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.DailyBillServiceHelper;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.model.ChangeField;
import kd.fi.er.common.ErBillStatusEnum;
import kd.fi.er.common.model.invoice.InvoiceConfig;
import kd.fi.er.common.model.invoice.bo.InvoiceEntryBO;
import kd.fi.er.common.model.invoice.bo.InvoiceItemEntryBO;
import kd.fi.er.formplugin.daily.web.workflow.ErMobWorkFlowOtherViewEditUtils;
import kd.fi.er.formplugin.util.OffsetUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ExpenseRecordPlugin
extends AbstractMobFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(ExpenseRecordPlugin.class);
    private static final String[] requiredProps = new String[]{"orientryamount"};
    private static final String[] requiredIsvactaxProps = new String[]{"notaxamount", "orientryamount"};

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btn_save"});
        BasedataEdit expenseSelsect = (BasedataEdit)this.getView().getControl("expenseitem");
        expenseSelsect.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String key = ((Control)arg0.getSource()).getKey();
        if (StringUtils.equalsIgnoreCase((String)key, (String)"expenseitem")) {
            Object company;
            MobileListShowParameter listShowParameter = (MobileListShowParameter)arg0.getFormShowParameter();
            List listQFilter = listShowParameter.getListFilterParameter().getQFilters();
            listQFilter.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
            IFormView parenView = this.getView().getParentView();
            if (parenView != null && (company = parenView.getModel().getValue("company")) != null) {
                Long companyId = (Long)((DynamicObject)company).getPkValue();
                QFilter bdFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_tripexpenseitem", (Long)companyId);
                listQFilter.add(bdFilter);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        super.beforeClosed(e);
    }

    public void afterCreateNewData(EventObject e) {
        String pageStatus;
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        this.initHeadFieldValueByParentView();
        String billStatus = (String)model.getValue("billstatus");
        if (ErBillStatusEnum.B.toString().equals(billStatus) || ErBillStatusEnum.C.toString().equals(billStatus) || ErBillStatusEnum.E.toString().equals(billStatus) || ErBillStatusEnum.F.toString().equals(billStatus) || ErBillStatusEnum.G.toString().equals(billStatus) || ErBillStatusEnum.H.toString().equals(billStatus) || ErBillStatusEnum.I.toString().equals(billStatus)) {
            view.setStatus(OperationStatus.VIEW);
        }
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map mapCustomParam = showParameter.getCustomParams();
        boolean iscurrencyshowintripentry = !DailyBillServiceHelper.isNewTripReim((IDataModel)parentView.getParentView().getModel()) && SystemParamterUtil.getIsCurrencyShowinTripentry((long)ErCommonUtils.getPk((Object)parentView.getParentView().getModel().getValue("company")));
        model.setValue("iscurrencyshowintripentry", (Object)iscurrencyshowintripentry);
        if (mapCustomParam.containsKey("company") && model.getProperty("itemamountedit") != null) {
            boolean itemAmountEdit = SystemParamterUtil.isEnableItemAmountEdit((Long)Long.valueOf((String)mapCustomParam.get("company")));
            model.setValue("itemamountedit", (Object)itemAmountEdit);
        }
        boolean iscurrency = (Boolean)mapCustomParam.get("iscurrency");
        model.setValue("iscurrency", (Object)iscurrency);
        model.setValue("entrycurrency", mapCustomParam.get("entrycurrency"));
        BigDecimal exchangeRate = new BigDecimal(String.valueOf(mapCustomParam.get("exchangerate")));
        model.setValue("exchangerate", (Object)(BigDecimal.ZERO.compareTo(exchangeRate) == 0 ? BigDecimal.ONE : exchangeRate));
        model.setValue("detailquotetype", mapCustomParam.get("detailquotetype"));
        if (this.getModel().getProperty("automapinvoice") != null) {
            model.setValue("automapinvoice", parentView.getModel().getValue("automapinvoice"));
        }
        if ("0".equals(pageStatus = mapCustomParam.get("status").toString())) {
            Long expenseitemId = Long.valueOf(String.valueOf(mapCustomParam.get("expenseitem")));
            this.initNewTripReimbuserEntry(model, view, expenseitemId);
        } else if ("1".equals(pageStatus)) {
            this.initViewTripReimbuserEntry(model, view, mapCustomParam);
        }
        this.initExpenseId();
    }

    protected void initHeadFieldValueByParentView() {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IDataModel pModel = parentView.getModel();
            this.setValue(pModel, "currency", "iscurrency", "company", "costcompany", "billstatus", "isopentripstd", "tripstandcon", "isnoctrltripvhcctrlv", "istravelers", "bizdate");
        }
    }

    private void setValue(IDataModel pModel, String ... fields) {
        for (String field : fields) {
            if (pModel.getProperty(field) == null) continue;
            this.getModel().setValue(field, pModel.getValue(field));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initInvoiceExt();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map mapCustomParam = showParameter.getCustomParams();
        IDataModel model = this.getModel();
        ErMobWorkFlowOtherViewEditUtils.setWorkFlowEditView((IFormView)this.getView(), (Map)mapCustomParam, (IDataModel)model, (int)5);
    }

    private void initInvoiceExt() {
        FormShowParameter param = this.getView().getFormShowParameter();
        Object invoiceNo = param.getCustomParam("invoiceno");
        String itemForm = (String)this.getModel().getValue("itemfrom");
        if (itemForm.equals("0")) {
            this.getModel().setValue("invoiceno_ext", invoiceNo);
            this.getView().updateView("invoiceno_ext");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        Object oldPropValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        int parentIndex = valueSet[0].getParentRowIndex();
        IDataModel model = this.getModel();
        IDataModel reimburseBillModel = this.getView().getParentView().getParentView().getModel();
        Long companyId = (Long)reimburseBillModel.getValue("company_id");
        Long currencyId = (Long)reimburseBillModel.getValue("currency_Id");
        switch (propName) {
            case "entrycurrency": {
                DynamicObject currency = (DynamicObject)propValue;
                if (currency == null) {
                    model.setValue("entrycurrency", valueSet[0].getOldValue());
                    return;
                }
                Long orcCurrencyId = (Long)currency.getPkValue();
                if (orcCurrencyId.compareTo(currencyId) == 0) {
                    model.setValue("isentrycurrency", (Object)Boolean.FALSE);
                } else {
                    model.setValue("isentrycurrency", (Object)Boolean.TRUE);
                }
                Object costCompany = reimburseBillModel.getValue("costcompany");
                Map exchangeMap = CommonServiceHelper.getExchangeRateFromSysParams((Object)companyId, (Object)costCompany, (Long)orcCurrencyId, (Long)currencyId, (Object)model);
                String detailQuoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeMap.get("quoteType")), (Object)"0");
                BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeMap.get("exchangeRate")), (Object)BigDecimal.ONE);
                if (model.getProperty("detailquotetype") != null) {
                    model.setValue("detailquotetype", (Object)detailQuoteType);
                }
                model.setValue("exchangerate", (Object)exchangeRate);
                break;
            }
            case "exchangerate": {
                this.refreshEntryAmount(model, "orientryamount", "entryamount", "exchangerate", "detailquotetype");
                break;
            }
            case "taxamount": {
                AmountChangeUtil.updateTaxAmount((IFormView)this.getView(), (int)valueSet[0].getRowIndex(), (int)valueSet[0].getParentRowIndex(), (boolean)false);
                this.setDefaultApproveTax(valueSet[0].getRowIndex(), valueSet[0].getParentRowIndex());
                OffsetUtils.updateDeductibleTax((IFormView)this.getView(), (int)valueSet[0].getRowIndex(), (int)valueSet[0].getParentRowIndex(), (boolean)false, (String)propName);
                AmountChangeUtil.updateInOutAmount((IDataModel)this.getModel(), (int)valueSet[0].getRowIndex(), (int)valueSet[0].getParentRowIndex(), (ChangeField)ChangeField.TAX_AMOUNT);
                break;
            }
            case "airportconstructionfee": 
            case "taxrate": {
                AmountChangeUtil.updateTaxAmount((IFormView)this.getView(), (int)valueSet[0].getRowIndex(), (int)valueSet[0].getParentRowIndex(), (boolean)true);
                break;
            }
            case "expenseitem": {
                if (propValue == null) {
                    this.getModel().setValue("expenseitem", valueSet[0].getOldValue(), valueSet[0].getRowIndex());
                    return;
                }
                this.getModel().setValue("mulseatgrade", null, valueSet[0].getRowIndex());
                InvoiceUtils.updateTaxWhenItemChange((IFormView)this.getView(), (IDataModel)this.getModel(), (BigDecimal)((DynamicObject)propValue).getBigDecimal("taxrate"), (int)rowIndex, (int)parentIndex);
                break;
            }
            case "offset": {
                BigDecimal taxRate = (BigDecimal)this.getModel().getValue("taxrate", valueSet[0].getRowIndex(), valueSet[0].getParentRowIndex());
                OffsetUtils.updateDeductibleTax((IFormView)this.getView(), (int)valueSet[0].getRowIndex(), (int)valueSet[0].getParentRowIndex(), (taxRate.compareTo(BigDecimal.ZERO) != 0 ? 1 : 0) != 0, (String)propName);
                break;
            }
            case "orientryamount": {
                BigDecimal taxRate = (BigDecimal)this.getModel().getValue("taxrate", valueSet[0].getRowIndex(), valueSet[0].getParentRowIndex());
                this.refreshEntryAmount(model, "orientryamount", "entryamount", "exchangerate", "detailquotetype");
                AmountChangeUtil.updateTaxAmount((IFormView)this.getView(), (int)valueSet[0].getRowIndex(), (int)valueSet[0].getParentRowIndex(), (taxRate.compareTo(BigDecimal.ZERO) != 0 ? 1 : 0) != 0);
                AmountChangeUtil.updateTripApproveInfo((IDataModel)this.getModel(), (IFormView)this.getView(), (int)valueSet[0].getRowIndex(), (int)valueSet[0].getParentRowIndex(), (BigDecimal.ZERO.compareTo(taxRate) != 0 ? 1 : 0) != 0);
                OffsetUtils.updateDeductibleTax((IFormView)this.getView(), (int)valueSet[0].getRowIndex(), (int)valueSet[0].getParentRowIndex(), (taxRate.compareTo(BigDecimal.ZERO) != 0 ? 1 : 0) != 0, (String)propName);
                break;
            }
            case "invoiceno_ext": {
                this.setInvoiceNo(valueSet);
                break;
            }
            case "deductibletax": {
                BigDecimal taxAmount = (BigDecimal)this.getModel().getValue("taxamount", rowIndex, parentIndex);
                if (!OffsetUtils.checkDeductibletax((BigDecimal)taxAmount, (BigDecimal)((BigDecimal)propValue))) {
                    this.getModel().setValue("deductibletax", oldPropValue, rowIndex, parentIndex);
                    return;
                }
                AmountChangeUtil.updateInOutAmount((IDataModel)this.getModel(), (int)valueSet[0].getRowIndex(), (int)valueSet[0].getParentRowIndex(), (ChangeField)ChangeField.DEDUCTIBLE_TAX);
                break;
            }
            case "approvetax": {
                AmountChangeUtil.updateInOutAmount((IDataModel)this.getModel(), (int)valueSet[0].getRowIndex(), (int)valueSet[0].getParentRowIndex(), (ChangeField)ChangeField.APPROVE_TAX);
            }
        }
    }

    private void setInvoiceNo(ChangeData[] valueSet) {
        String itemForm = (String)this.getModel().getValue("itemfrom");
        if (itemForm.equals("0")) {
            this.getModel().setValue("invoiceno_entry", valueSet[0].getNewValue());
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map mapCustomParam = showParameter.getCustomParams();
        String pageStatus = mapCustomParam.get("status").toString();
        int index = (Integer)mapCustomParam.get("index");
        switch (key) {
            case "btn_save": {
                IDataModel model = this.getModel();
                DynamicObject dynObj = model.getDataEntity();
                boolean isvactax = (Boolean)model.getValue("isvactax");
                if (isvactax ? !CommonServiceHelper.requireValidate((DynamicObject)dynObj, (String[])requiredIsvactaxProps, (AbstractFormPlugin)this) : !CommonServiceHelper.requireValidate((DynamicObject)dynObj, (String[])requiredProps, (AbstractFormPlugin)this)) {
                    return;
                }
                IFormView parentView = this.getView().getParentView();
                IDataModel tripEntryModel = parentView.getModel();
                DynamicObjectCollection tripEntry = tripEntryModel.getEntryEntity("tripentry");
                DataEntityPropertyCollection pentryProps = ((DynamicObjectCollection)((DynamicObject)tripEntry.get(0)).get("entryentity")).getDynamicObjectType().getProperties();
                DynamicObject dataEntity = model.getDataEntity();
                DataEntityPropertyCollection entryProps = dataEntity.getDynamicObjectType().getProperties();
                int cou = 0;
                int parentIndex = tripEntryModel.getEntryCurrentRowIndex("tripentry");
                this.cacheToEntry();
                ActionLocalCache.get().put("isDeleteEntryEntity", (Object)true);
                if (!tripEntry.isEmpty()) {
                    if (this.haveInvoice()) {
                        tripEntryModel.setValue("tripcurrency", ErCommonUtils.getObjectValue((Object)model.getValue("entrycurrency")), 0);
                    }
                    if ("0".equals(pageStatus)) {
                        String formId = (String)tripEntryModel.getValue("formid");
                        if (StringUtils.isNotEmpty((String)formId)) {
                            this.setItemId(index, tripEntryModel);
                            for (IDataEntityProperty property : entryProps) {
                                IDataEntityProperty pProName;
                                String propertyName = property.getName();
                                if (pentryProps.get((Object)propertyName) == null || "id".equalsIgnoreCase(propertyName) || "seq".equalsIgnoreCase(propertyName) || (pProName = (IDataEntityProperty)pentryProps.get((Object)propertyName)) == null) continue;
                                if ("taxamount".equals(propertyName) || "orientryamount".equals(propertyName) || "entrycurrency".equals(propertyName)) {
                                    propertyName = this.relacePropertyName(propertyName, ++cou);
                                } else if ("offset".equals(propertyName)) {
                                    tripEntryModel.setValue(propertyName, (Object)((Boolean)model.getValue(propertyName) == false ? 1 : 0), index, parentIndex);
                                }
                                tripEntryModel.setValue(propertyName, ErCommonUtils.getObjectValue((Object)model.getValue(propertyName)), index, parentIndex);
                            }
                        }
                    } else if ("1".equals(pageStatus)) {
                        index = Integer.parseInt(mapCustomParam.get("index").toString());
                        this.refreshEntryAmount(model, "orientryamount", "entryamount", "exchangerate", "detailquotetype");
                        for (IDataEntityProperty property : entryProps) {
                            IDataEntityProperty pProName;
                            String propertyName = property.getName();
                            if ("id".equalsIgnoreCase(propertyName) || "seq".equalsIgnoreCase(propertyName) || "attribute".equalsIgnoreCase(propertyName) || (pProName = (IDataEntityProperty)pentryProps.get((Object)propertyName)) == null) continue;
                            if ("taxamount".equals(propertyName) || "orientryamount".equals(propertyName) || "entrycurrency".equals(propertyName)) {
                                propertyName = this.relacePropertyName(propertyName, ++cou);
                            }
                            if ("trip2travelers".equals(propertyName) || "isover".equals(propertyName)) continue;
                            tripEntryModel.setValue(propertyName, ErCommonUtils.getObjectValue((Object)model.getValue(propertyName)), index, parentIndex);
                        }
                        this.setItemId(index, tripEntryModel);
                    }
                }
                this.refreshTripEntryAmount(tripEntryModel);
                this.getView().returnDataToParent((Object)index);
                this.getView().sendFormAction(parentView);
                this.getView().close();
            }
        }
    }

    private String relacePropertyName(String propertyName, int cou) {
        if (cou == 1 && ("taxamount".equals(propertyName) || "orientryamount".equals(propertyName))) {
            propertyName = "entrycurrency";
        } else if (cou == 2 && ("taxamount".equals(propertyName) || "entrycurrency".equals(propertyName))) {
            propertyName = "orientryamount";
        } else if (cou == 3 && ("entrycurrency".equals(propertyName) || "orientryamount".equals(propertyName))) {
            propertyName = "taxamount";
        }
        return propertyName;
    }

    private void refreshTripEntryAmount(IDataModel model) {
        DynamicObjectCollection entryDatas = model.getEntryEntity("entryentity");
        BigDecimal tripAmount = BigDecimal.ZERO;
        for (DynamicObject entryData : entryDatas) {
            BigDecimal entryAmount = entryData.getBigDecimal("orientryamount");
            tripAmount = entryAmount.add(tripAmount);
        }
        int tripEntryIndex = model.getEntryCurrentRowIndex("tripentry");
        model.setValue("triporiamount", (Object)tripAmount, tripEntryIndex);
    }

    private void refreshEntryAmount(IDataModel model, String oriAmountField, String amountField, String exchangeRateField, String quoteTypeField) {
        BigDecimal oriAmount = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)model.getValue(oriAmountField)), (Object)BigDecimal.ZERO);
        BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)model.getValue(exchangeRateField)), (Object)BigDecimal.ONE);
        String detailQuoteType = (String)ObjectUtils.defaultIfNull((Object)((String)model.getValue(quoteTypeField)), (Object)"0");
        int currencyPrecision = AmountUtils.getCurrencyPrecision((IDataModel)model, (String)"currency");
        BigDecimal currencyAmount = AmountUtils.getCurrencyAmount((BigDecimal)oriAmount, (BigDecimal)exchangeRate, (int)currencyPrecision, (String)detailQuoteType);
        model.setValue(amountField, (Object)currencyAmount);
    }

    private void initViewTripReimbuserEntry(IDataModel model, IFormView view, Map<String, Object> mapCustomParam) {
        int index = Integer.parseInt(mapCustomParam.get("index").toString());
        this.fillEntryDynamicObject(model, view, index);
    }

    private void initNewTripReimbuserEntry(IDataModel model, IFormView view, Long expenseitemId) {
        DynamicObject tripDetail;
        DynamicObjectCollection pentryentity;
        DynamicObjectCollection tripEntry = (DynamicObjectCollection)view.getParentView().getModel().getDataEntity(true).get("tripentry");
        if (!tripEntry.isEmpty() && !(pentryentity = (DynamicObjectCollection)(tripDetail = (DynamicObject)tripEntry.get(0)).get("entryentity")).isEmpty()) {
            this.fillEntryDynamicObject(model, view, pentryentity.size() - 1);
            DynamicObject expenseItemIdInfo = this.queryExpenseItemInfomation(expenseitemId);
            String expenseitemIcon = expenseItemIdInfo.getString("expenseitemicon");
            model.setValue("pic", (Object)expenseitemIcon);
        }
    }

    private DynamicObject queryExpenseItemInfomation(long pk) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)"er_tripexpenseitem", (String)"id,number,name,expenseitemicon,isvactax");
    }

    private void fillEntryDynamicObject(IDataModel model, IFormView view, int index) {
        IFormView parentView = this.getView().getParentView();
        IDataModel tripEntryModel = parentView.getModel();
        DynamicObjectCollection tripEntry = tripEntryModel.getEntryEntity("tripentry");
        DynamicObject tripDetail = (DynamicObject)tripEntry.get(0);
        DynamicObjectCollection expenseEntry = (DynamicObjectCollection)tripDetail.get("entryentity");
        DynamicObject pentryentity = (DynamicObject)expenseEntry.get(index);
        DataEntityPropertyCollection pentryProps = expenseEntry.getDynamicObjectType().getProperties();
        DynamicObject dataEntity = model.getDataEntity();
        DataEntityPropertyCollection props = dataEntity.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : props) {
            String propertyName = property.getName();
            if (pentryProps.get((Object)propertyName) == null) continue;
            Object parentProperty = pentryentity.get(propertyName);
            if (parentProperty instanceof DynamicObjectCollection) {
                model.setValue(propertyName, parentProperty);
                continue;
            }
            model.setValue(propertyName, ErCommonUtils.getObjectValue((Object)pentryentity.get(propertyName)));
        }
        this.getModel().setValue("isopenhighseasontripstd", parentView.getModel().getValue("isopenhighseasontripstd"));
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        IDataModel model = this.getModel();
        if (StringUtils.equals((String)key, (String)"btn_save") && !CommonServiceHelper.requireValidate((DynamicObject)model.getDataEntity(), (String[])new String[]{"expenseitem"}, (AbstractFormPlugin)this)) {
            evt.setCancel(true);
            return;
        }
    }

    protected Set<String> getSerialNosByInvoiceNoAndCode(Set<String> invoiceNos, Set<String> invoiceCodes) {
        Set<Object> serialNos = Sets.newHashSet();
        if (invoiceNos.isEmpty() || invoiceCodes.isEmpty()) {
            logger.info("\u53d1\u7968\u53f7\u7801\u6216\u53d1\u7968\u4ee3\u7801\u4e3a\u7a7a, \u4e0d\u9700\u8981\u67e5\u8be2\u53d1\u7968\u5e8f\u5217\u53f7.");
            return serialNos;
        }
        DynamicObject dataEntity = this.getView().getParentView().getModel().getDataEntity(true);
        DynamicObjectCollection invoiceHeadEntryDOs = dataEntity.getDynamicObjectCollection("invoiceentry");
        DynamicObjectCollection invoiceMergeEntryDOs = dataEntity.getDynamicObjectCollection("invoicemerge");
        if (invoiceHeadEntryDOs.isEmpty() || invoiceMergeEntryDOs.isEmpty()) {
            logger.info("\u53d1\u7968\u4fe1\u606f\u5206\u5f55\u6216\u53d1\u7968\u5408\u5e76\u4fe1\u606f\u5206\u5f55\u4e3a\u7a7a, \u4e0d\u9700\u8981\u67e5\u8be2\u53d1\u7968\u5e8f\u5217\u53f7.");
            return serialNos;
        }
        Set keySerialNos = invoiceHeadEntryDOs.stream().filter(invoiceHead -> invoiceNos.contains(invoiceHead.getString("invoiceno")) && invoiceCodes.contains(invoiceHead.getString("invoicecode"))).map(invoiceHead -> invoiceHead.getString("serialno")).collect(Collectors.toSet());
        if (keySerialNos.isEmpty()) {
            logger.info("\u6839\u636e\u53d1\u7968\u53f7\u7801,\u53d1\u7968\u4ee3\u7801\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u53d1\u7968.\u53d1\u7968\u53f7\u7801:" + invoiceNos + ",\u53d1\u7968\u4ee3\u7801:" + invoiceCodes);
            return serialNos;
        }
        serialNos = invoiceMergeEntryDOs.stream().filter(invoiceMerge -> keySerialNos.contains(invoiceMerge.getString("keyserialno"))).map(invoiceMerge -> invoiceMerge.getString("serialno_merge")).collect(Collectors.toSet());
        return serialNos;
    }

    private void initExpenseId() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        IDataModel parentModel = parentView.getModel();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map mapCustomParam = showParameter.getCustomParams();
        String pageStatus = mapCustomParam.get("status").toString();
        Long enpenseid = 0L;
        if ("0".equals(pageStatus)) {
            enpenseid = ORM.create().genLongId(this.getView().getEntityId());
        } else if ("1".equals(pageStatus)) {
            int index = Integer.parseInt(mapCustomParam.get("index").toString());
            DynamicObject tipItemEntry = (DynamicObject)((DynamicObject)parentModel.getDataEntity(true).getDynamicObjectCollection("tripentry").get(0)).getDynamicObjectCollection("entryentity").get(index);
            enpenseid = (Long)tipItemEntry.getPkValue();
            if (enpenseid == null || enpenseid == 0L) {
                enpenseid = ORM.create().genLongId(this.getView().getEntityId());
                parentModel.setValue("id", (Object)enpenseid, 0, index);
            }
        }
        this.getModel().setValue("enpenseid", (Object)enpenseid);
    }

    private void cacheToEntry() {
        Long expenseId = (Long)this.getModel().getValue("enpenseid");
        IPageCache pageCache = this.getPageCache();
        String invoiceEntry = pageCache.get("invoiceentry" + expenseId);
        if (StringUtils.isBlank((String)invoiceEntry)) {
            return;
        }
        String invoiceItemEntry = pageCache.get("invoiceitementry" + expenseId);
        if (StringUtils.isBlank((String)invoiceItemEntry)) {
            return;
        }
        List invoiceEntryBOs = JSONArray.parseArray((String)invoiceEntry, InvoiceEntryBO.class);
        List invoiceItemEntryBOs = JSONArray.parseArray((String)invoiceItemEntry, InvoiceItemEntryBO.class);
        InvoiceContext invoiceContext = new InvoiceContext();
        this.buildInvoiceConfig(invoiceContext);
        invoiceContext.setInvoiceEntryBOs(invoiceEntryBOs);
        invoiceContext.setInvoiceItemEntryBOs(invoiceItemEntryBOs);
        CreateInvoiceEntryServiceImpl createInvoiceEntryServiceImpl = new CreateInvoiceEntryServiceImpl(invoiceContext, this.getView().getParentView().getModel());
        createInvoiceEntryServiceImpl.process();
    }

    protected void buildInvoiceConfig(InvoiceContext invoiceContext) {
        InvoiceConfig invoiceConfig = invoiceContext.getInvoiceConfig();
        invoiceConfig.setOrgOffset(this.isOrgOffset());
        invoiceConfig.setImportNonDeductionTaxAmout(this.isNonOffsetImportTaxAmout());
    }

    protected boolean isOrgOffset() {
        return InvoiceOffsetUtils.deductibleOfTaxPayer((Long)ErCommonUtils.getPk((Object)this.getCompany()), (Long)ErCommonUtils.getPk((Object)this.getCostCompanyDO()));
    }

    protected boolean isNonOffsetImportTaxAmout() {
        return KingdeeInvoiceCloudConfig.isNonOffsetImportTaxAmout((Long)ErCommonUtils.getPk((Object)this.getCostCompanyDO()));
    }

    protected DynamicObject getCompany() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        return this.getCompany(dataEntity);
    }

    protected DynamicObject getCompany(DynamicObject dataEntity) {
        IDataModel model;
        IFormView headView;
        IFormView view = this.getView();
        IFormView pView = view.getParentView();
        if (pView != null && (headView = pView.getParentView()) != null && (model = headView.getModel()).getDataEntityType().getProperty("company") != null) {
            return (DynamicObject)model.getValue("company");
        }
        return dataEntity.getDynamicObject("company");
    }

    private DynamicObject getCostCompanyDO() {
        IFormView billHeadView;
        IFormView pView;
        DynamicObject costCompanyDO = null;
        IFormView view = this.getView();
        if (view != null && (pView = view.getParentView()) != null && (billHeadView = pView.getParentView()) != null) {
            costCompanyDO = (DynamicObject)billHeadView.getModel().getValue("costcompany");
        }
        return costCompanyDO;
    }

    private Long currentItemId() {
        Long enpenseid = (Long)this.getModel().getValue("enpenseid");
        return enpenseid;
    }

    protected void setItemId(int index, IDataModel tripEntryModel) {
        DynamicObject tipItemEntry = (DynamicObject)((DynamicObject)tripEntryModel.getDataEntity(true).getDynamicObjectCollection("tripentry").get(0)).getDynamicObjectCollection("entryentity").get(index);
        if (tipItemEntry.getPkValue() == null || Long.valueOf(0L).compareTo((Long)tipItemEntry.getPkValue()) == 0) {
            tipItemEntry.set("id", ErCommonUtils.getObjectValue((Object)this.getModel().getValue("enpenseid")));
        }
    }

    private boolean isExpensePoolBill(String entityId) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)entityId)) {
            return false;
        }
        return ErEntityTypeUtils.isExpenseRecordBill((String)entityId) || ErEntityTypeUtils.isTripRecordBill((String)entityId);
    }

    private boolean haveInvoice() {
        Long expenseId = (Long)this.getModel().getValue("enpenseid");
        IPageCache pageCache = this.getPageCache();
        String invoiceEntry = pageCache.get("invoiceentry" + expenseId);
        String invoiceItemEntry = pageCache.get("invoiceitementry" + expenseId);
        return StringUtils.isNotEmpty((String)invoiceEntry) && StringUtils.isNotEmpty((String)invoiceItemEntry);
    }

    private void setDefaultApproveTax(int rowIndex, int parentIndex) {
        if (this.getModel().getProperty("approvetax") != null) {
            BigDecimal taxAmount = (BigDecimal)this.getModel().getValue("taxamount", rowIndex, parentIndex);
            this.getModel().setValue("approvetax", (Object)taxAmount, rowIndex, parentIndex);
        }
    }
}

