/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import java.util.EventObject;
import java.util.Map;
import kd.bos.base.AbstractMobBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;

public class MakingOutinVoicePlugin
extends AbstractMobBasePlugIn
implements ClickListener {
    public void initialize() {
        this.setCompanyF7Caption();
        this.addClickListeners(new String[]{"back"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        Long userId = CommonServiceHelper.getCurrentUserID();
        Long dptId = 0L;
        Map userMap = CommonServiceHelper.getUserMap((Long)userId);
        if (userMap != null && userMap.size() > 0 && userMap.get("org") != null) {
            DynamicObject dept = (DynamicObject)userMap.get("org");
            dptId = (Long)dept.getPkValue();
        }
        Map map = OrgUnitServiceHelper.getCompanyfromOrg((Long)dptId);
        long companyId = 0L;
        if (map.size() > 0) {
            companyId = (Long)map.get("id");
        }
        model.setValue("companyid", (Object)companyId);
        DynamicObject billingInfo = this.getDefaultMakeOutVoiceOrg(companyId);
        if (billingInfo != null) {
            this.initBillingInfomation(model, billingInfo);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        switch (propName) {
            case "companyid": {
                IDataModel model = this.getModel();
                if (propValue == null) {
                    model.setValue("taxpayerid", null);
                    model.setValue("address", null);
                    model.setValue("tel", null);
                    model.setValue("openbank", null);
                    model.setValue("account", null);
                    model.setValue("companyname", null);
                    return;
                }
                DynamicObject companyObj = (DynamicObject)propValue;
                long companyId = (Long)companyObj.getPkValue();
                DynamicObject billingInfo = this.getDefaultMakeOutVoiceOrg(companyId);
                if (billingInfo != null) {
                    this.initBillingInfomation(model, billingInfo);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u8be5\u516c\u53f8\u7684\u5f00\u7968\u4fe1\u606f\u6570\u636e\u3002", (String)"MakingOutinVoicePlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    protected void initBillingInfomation(IDataModel model, DynamicObject billingInfo) {
        String taxpayerid = billingInfo.getString("ftaxregnum");
        model.setValue("taxpayerid", (Object)taxpayerid);
        String address = billingInfo.getString("faddress");
        model.setValue("address", (Object)address);
        String tel = billingInfo.getString("phone");
        model.setValue("tel", (Object)tel);
        String openbank = billingInfo.getString("depositbank");
        model.setValue("openbank", (Object)openbank);
        String account = billingInfo.getString("bankaccount");
        model.setValue("account", (Object)account);
        String companyname = billingInfo.getString("ffirmname");
        model.setValue("companyname", (Object)companyname);
    }

    private void setCompanyF7Caption() {
        BasedataEdit companyF7 = (BasedataEdit)this.getControl("companyid");
        companyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u5f00\u7968\u4fe1\u606f", (String)"MakingOutinVoicePlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
        });
    }

    private DynamicObject getDefaultMakeOutVoiceOrg(Long companyId) {
        DynamicObject billingInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)companyId, (String)"bos_org", (String)"id,ffirmname,ftaxregnum,faddress,phone,depositbank,bankaccount,frepresentative");
        return billingInfo;
    }

    public void click(EventObject evt) {
        super.click(evt);
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("er_mainpage");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

