/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.expand.ErExpandServiceFacade;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.EntrustReimburseUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import org.apache.commons.lang.StringUtils;

public class SwitchApplierMobPlugin
extends AbstractMobBillPlugIn
implements RowClickEventListener {
    public static final String APPLIERENTRY = "applierentry";
    public static final String APPLIER = "applier";
    public static final String DEPT = "dept";
    public static final String COMPANY = "company";
    public static final String HEAD = "showhead";
    public static final String POSITION = "position";
    public static final String ISINCHARGE = "isincharge";
    public static final String ISPARTJOB = "ispartjob";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid applierEntry = (EntryGrid)this.getControl(APPLIERENTRY);
        applierEntry.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        this.returnData();
    }

    public void afterCreateNewData(EventObject e) {
        IFormView userInfoView;
        super.beforeBindData(e);
        String billtype = (String)this.getView().getFormShowParameter().getCustomParam("billtype");
        if (billtype == null || "".equals(billtype.trim())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5355\u636e\u7c7b\u578b\u3002", (String)"SwitchApplierMobPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            this.getView().close();
        }
        if ((userInfoView = this.getView().getParentView()) != null) {
            IFormView billView = userInfoView.getParentView();
            String parentBillType = "";
            Boolean isloan = false;
            if (billView != null && ErEntityTypeUtils.isTripReqBill((String)(parentBillType = billView.getEntityId()))) {
                isloan = (Boolean)billView.getModel().getValue("isloan");
            }
            if (StringUtils.isNotEmpty((String)parentBillType)) {
                billtype = parentBillType;
                if (isloan.booleanValue()) {
                    billtype = "er_loanbill";
                }
            }
        }
        Long applierId = CommonServiceHelper.getCurrentUserID();
        Set consignors = EntrustReimburseUtils.addConsignor((Long)applierId, (String)billtype);
        this.getPageCache().put("appliers", SerializationUtils.serializeToBase64((Object)consignors));
        List<Map<String, Object>> appliers = this.fetchData(consignors);
        this.fillUserInfo(appliers);
    }

    private List<Map<String, Object>> fetchData(Set<Long> applierIds) {
        String billtype = (String)this.getView().getFormShowParameter().getCustomParam("billtype");
        Object invokeExtService = ErExpandServiceFacade.get().invokeExtService("ext.service.er.switchApplierMob", "switchApplierMob", new Object[]{applierIds, billtype}, new Class[]{Set.class, String.class});
        if (invokeExtService != null && !"-1".equals(invokeExtService)) {
            return (List)invokeExtService;
        }
        ArrayList<Map<String, Object>> appliers = new ArrayList<Map<String, Object>>();
        for (Long applierId : applierIds) {
            DynamicObject[] userpositions = BusinessDataServiceHelper.load((String)"bos_userposition", (String)"user,org,position,orgstructure,isincharge,ispartjob", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)applierId)});
            boolean showHead = true;
            for (DynamicObject userposition : userpositions) {
                HashMap<String, Object> infos = new HashMap<String, Object>();
                DynamicObject bos_adminorg_structure = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_adminorg_structure", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ErCommonUtils.getPk((Object)userposition.getDynamicObject("orgstructure")))});
                if (bos_adminorg_structure.getBoolean("isfreeze")) continue;
                long org_id = userposition.getLong("org_id");
                infos.put(DEPT, org_id);
                infos.put(APPLIER, userposition.getLong("user_id"));
                infos.put(POSITION, userposition.get(POSITION));
                Long companyId = CoreBaseBillServiceHelper.initCompanyByDept((Long)org_id);
                infos.put(COMPANY, companyId);
                infos.put(ISINCHARGE, userposition.getBoolean(ISINCHARGE));
                infos.put(ISPARTJOB, userposition.getBoolean(ISPARTJOB));
                infos.put(HEAD, showHead);
                if (showHead) {
                    String applierPicUrl = ErCommonUtils.getUserImageFullPath((Long)userposition.getLong("user_id"));
                    infos.put("user_head_img", applierPicUrl);
                }
                showHead = false;
                appliers.add(infos);
            }
        }
        return appliers;
    }

    private void fillUserInfo(List<Map<String, Object>> appliers) {
        appliers.forEach(applier -> {
            int rowIndex = this.getModel().createNewEntryRow(APPLIERENTRY);
            this.getModel().setValue(APPLIER, applier.get(APPLIER), rowIndex);
            this.getModel().setValue(DEPT, applier.get(DEPT), rowIndex);
            this.getModel().setValue(COMPANY, applier.get(COMPANY), rowIndex);
            this.getModel().setValue(HEAD, applier.get(HEAD), rowIndex);
            this.getModel().setValue(POSITION, applier.get(POSITION), rowIndex);
            this.getModel().setValue("user_head_img", applier.get("user_head_img"), rowIndex);
        });
    }

    private void returnData() {
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        int rowIndex = this.getModel().getEntryCurrentRowIndex(APPLIERENTRY);
        DynamicObjectCollection applierEntry = this.getModel().getEntryEntity(APPLIERENTRY);
        DynamicObject applier = (DynamicObject)applierEntry.get(rowIndex);
        long companyId = applier.getLong("company_id");
        if (companyId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"SwitchApplierMobPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
        returnData.put(APPLIER, applier.getLong("applier_id"));
        returnData.put(DEPT, applier.getLong("dept_id"));
        returnData.put(COMPANY, companyId);
        returnData.put(POSITION, applier.get(POSITION));
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }
}

