/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.servicehelper.IntegralServiceHelper;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.util.TripReportUtil;
import kd.fi.er.model.FormModel;
import kd.fi.er.model.MainPageModel;
import org.apache.commons.lang.StringUtils;

public class TripReportMobileEdit
extends AbstractMobBillPlugIn
implements ClickListener,
RowClickEventListener,
TabSelectListener {
    private static Log logger = LogFactory.getLog(TripReportMobileEdit.class);
    protected static final Map<String, MainPageModel> controlMap = new HashMap<String, MainPageModel>();
    protected static final Map<String, MainPageModel> dailyControlMap = new HashMap<String, MainPageModel>();
    protected static final String ENTRY_NAME = "entryentity";
    protected static final String NOBODY_FLEX = "nobody_flex";
    protected static final String ONEBUTTON_FLEX = "onebutton_flex";

    public void initialize() {
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        Set<String> controlIdSet = controlMap.keySet();
        String[] controlIds = controlIdSet.toArray(new String[controlIdSet.size()]);
        this.addClickListeners(controlIds);
        this.addClickListeners(new String[]{"on", "off"});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("labelap1".equals(key)) {
            this.toGroupChat();
        }
        IDataModel model = this.getModel();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_NAME);
        int index = grid.getEntryState().getFocusRow();
        if (index != -1) {
            RequestContext requestContext = RequestContext.get();
            Long curUserId = Long.parseLong(requestContext.getUserId());
            Long userId = Long.parseLong(model.getValue("userid", index).toString());
            switch (key) {
                case "on": {
                    model.setValue("ispraise", (Object)"0", index);
                    IntegralServiceHelper.deletePraiseRecord((long)curUserId, (long)userId);
                    IntegralServiceHelper.insertUserScore((Long)userId, (int)0, (boolean)false, (boolean)true);
                    IntegralServiceHelper.deletePraiseIntegralRercord((long)userId);
                    break;
                }
                case "off": {
                    model.setValue("ispraise", (Object)"1", index);
                    IntegralServiceHelper.insertPraiseRecord((long)curUserId, (long)userId);
                    IntegralServiceHelper.insertUserScore((Long)curUserId, (int)0, (boolean)true, (boolean)false);
                    IntegralServiceHelper.insertPraiseIntegralRercord((Long)userId);
                }
            }
        }
        this.getView().updateView();
        FormModel formModel = null;
        boolean result = this.isDailyExpense(this.getView());
        MainPageModel mainPageModel = null;
        mainPageModel = result ? dailyControlMap.get(key) : controlMap.get(key);
        if (mainPageModel != null) {
            formModel = new FormModel(mainPageModel.getFormId(), mainPageModel.getFormName(), mainPageModel.getFormType(), mainPageModel.getCallBack().booleanValue(), mainPageModel.getCustomParam());
        }
        if (formModel == null) {
            return;
        }
        String formId = formModel.getFormId();
        if (StringUtils.isEmpty((String)formId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u656c\u8bf7\u671f\u5f85", (String)"TripReportMobileEdit_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        ShowPageUtils.showPage(formModel, (AbstractFormPlugin)this);
    }

    private boolean isDailyExpense(IFormView formView) {
        IFormView parentView = formView.getParentView();
        if (parentView == null) {
            return false;
        }
        if (StringUtils.equalsIgnoreCase((String)parentView.getEntityId(), (String)"er_mainpage_daily")) {
            return true;
        }
        return this.isDailyExpense(parentView);
    }

    public void afterCreateNewData(EventObject arg0) {
        super.afterCreateNewData(arg0);
        IDataModel thisModel = this.getModel();
        IFormView view = this.getView();
        this.initTimeLineTab();
        int peopleListCount = thisModel.getEntryRowCount(ENTRY_NAME);
        if (peopleListCount > 0) {
            for (int i = 0; i < peopleListCount; ++i) {
                thisModel.deleteEntryRow(ENTRY_NAME, i);
            }
        }
        TripReportUtil tripReportUtil = new TripReportUtil();
        List orderedList = tripReportUtil.getOrderedList(Boolean.TRUE);
        String description = "";
        if (!orderedList.isEmpty()) {
            for (int i = 0; i < orderedList.size(); ++i) {
                thisModel.createNewEntryRow(ENTRY_NAME);
                thisModel.setValue("userid", ((Map)orderedList.get(i)).get("userID"), i);
                thisModel.setValue("textfield_name", ((Map)orderedList.get(i)).get("textfield_name"), i);
                thisModel.setValue("textfield_city", ((Map)orderedList.get(i)).get("textfield_city"), i);
                thisModel.setValue("picturefield", ((Map)orderedList.get(i)).get("picturefield"), i);
                description = (String)((Map)orderedList.get(i)).get("description");
                description = description.length() > 15 ? description.substring(0, 15) + "..." : description;
                thisModel.setValue("description", (Object)description, i);
                logger.info("yzj chat information: name: " + (String)((Map)orderedList.get(i)).get("textfield_name") + " openid: " + (String)((Map)orderedList.get(i)).get("useropenid"));
                int isPraise = Integer.parseInt((String)((Map)orderedList.get(i)).get("isPraise"));
                thisModel.setValue("ispraise", (Object)isPraise, i);
            }
            Label totalamount = (Label)this.getView().getControl("label_number");
            totalamount.setText(orderedList.size() + "");
            view.setVisible(Boolean.FALSE, new String[]{NOBODY_FLEX});
            view.setVisible(Boolean.TRUE, new String[]{ENTRY_NAME});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{NOBODY_FLEX});
            view.setVisible(Boolean.FALSE, new String[]{ENTRY_NAME});
            view.setVisible(Boolean.FALSE, new String[]{ONEBUTTON_FLEX});
        }
    }

    private void initTimeLineTab() {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId("er_timeline");
        showParameter.setParentFormId("er_trip_report");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("flex_timeline");
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if ("er_addNew_dialog".equalsIgnoreCase(actionId)) {
            if (e.getReturnData() != null) {
                FormModel formModel = (FormModel)e.getReturnData();
                if (formModel == null) {
                    return;
                }
                String formId = formModel.getFormId();
                if (StringUtils.isEmpty((String)formId)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u656c\u8bf7\u671f\u5f85", (String)"TripReportMobileEdit_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
            }
        } else if ("er_groupchat_dialog".equals(actionId) && e.getReturnData() != null) {
            String type = e.getReturnData().toString();
            if (type.equals("citydinnerpart")) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u540c\u57ce\u7ea6\u996dtest", (String)"TripReportMobileEdit_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
            } else if (type.equals("handoutredenvelope")) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u53d1\u7ea2\u5305test", (String)"TripReportMobileEdit_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
            } else if (type.equals("chat")) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u95f2\u804atest", (String)"TripReportMobileEdit_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void tabSelected(TabSelectEvent arg0) {
    }

    public void toGroupChat() {
        HashMap customParam = new HashMap();
        TripReportUtil tripReportUtil = new TripReportUtil();
        List orderedList = tripReportUtil.getOrderedList(Boolean.FALSE);
        ArrayList user_openid_list = new ArrayList(orderedList.size());
        ArrayList user_city_list = new ArrayList(orderedList.size());
        for (int i = 0; i < orderedList.size(); ++i) {
            user_openid_list.add(((Map)orderedList.get(i)).get("useropenid"));
            user_city_list.add(((Map)orderedList.get(i)).get("textfield_city"));
        }
        customParam.put("user_openid_list", user_openid_list);
        customParam.put("user_city_list", user_city_list);
        FormModel formModel = new FormModel("er_groupchat_dialog", ResManager.loadKDString((String)"\u62a5\u544a", (String)"TripReportMobileEdit_6", (String)"fi-er-formplugin", (Object[])new Object[0]), "5", true, customParam);
        ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
    }

    static {
        controlMap.put("buttonswitch", new MainPageModel("er_timeline", ResManager.loadKDString((String)"\u4e2a\u4eba\u8db3\u8ff9", (String)"TripReportMobileEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]), "5"));
        controlMap.put("floatbuttonap", new MainPageModel("er_addNew_dialog", ResManager.loadKDString((String)"\u65b0\u589e", (String)"TripReportMobileEdit_1", (String)"fi-er-formplugin", (Object[])new Object[0]), "5", true));
        controlMap.put("labelap1", null);
        dailyControlMap.putAll(controlMap);
        dailyControlMap.put("floatbuttonap", new MainPageModel("er_addNew_dialog_daily", ResManager.loadKDString((String)"\u65b0\u589e", (String)"TripReportMobileEdit_1", (String)"fi-er-formplugin", (Object[])new Object[0]), "5", true));
    }
}

