/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.RedisModelCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.TripBillTravelerUtils;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.budget.BudgetCommonUtil;
import kd.fi.er.formplugin.mobile.CoreBaseBillEdit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class TripReqSection
extends AbstractMobBillPlugIn
implements ClickListener {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btn_save", "btn_addsection"});
        IFormView view = this.getView();
        MulBasedataEdit travelersF7 = (MulBasedataEdit)this.getControl("travelers");
        DynamicObject company = (DynamicObject)view.getParentView().getModel().getValue("company");
        DynamicObject org = (DynamicObject)view.getParentView().getModel().getValue("org");
        TripBillTravelerUtils.getF7FilterInfo((DynamicObject)company, (DynamicObject)org, (BasedataEdit)travelersF7);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter param = this.getView().getFormShowParameter();
        IDataModel model = this.getModel();
        IFormView parentView = this.getView().getParentView();
        IDataModel parentModel = parentView.getModel();
        model.setValue("currency", (Object)ErCommonUtils.getPk((Object)parentModel.getValue("currency")));
        model.setValue("billstatus", parentModel.getValue("billstatus"));
        CoreBaseBillEdit coreBaseBillEdit = new CoreBaseBillEdit();
        Boolean isCurrency = coreBaseBillEdit.refreshIsCurrency(parentModel);
        model.setValue("iscurrency", (Object)isCurrency);
        model.setValue("istravelers", parentModel.getValue("istravelers"));
        model.setValue("isloan", parentModel.getValue("isloan"));
        model.setValue("ismulwayto", parentModel.getValue("ismulwayto"));
        model.setValue("bizdate", parentModel.getValue("bizdate"));
        CommonServiceHelper.setMulWayToVisible((IDataModel)parentModel, (IFormView)this.getView());
        if (param.getCustomParam("entryedit") != null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_addsection"});
            int index = (Integer)param.getCustomParam("index");
            DynamicObject dobject = parentModel.getEntryRowEntity("tripentry", index);
            DynamicObjectCollection dc = model.getEntryEntity("tripentry");
            dc.add((Object)dobject);
            model.setValue("index", (Object)(index + 1), 0);
        } else {
            Long cityId = ((IMobileView)this.getView()).getCurrentCityId();
            int rowIndex = model.createNewEntryRow("tripentry");
            Object to = param.getCustomParam("to");
            Object date = param.getCustomParam("enddate");
            if (null != to) {
                cityId = Long.valueOf(to.toString());
            }
            if (null != date) {
                model.setValue("startdate", date, 0);
            }
            model.setValue("from", (Object)cityId, 0);
            int count = parentModel.getEntryRowCount("tripentry");
            model.setValue("index", (Object)(count + 1), rowIndex);
            this.initTripEntryDefaultData(model, rowIndex);
            Long currencyId = ErCommonUtils.getPk((Object)parentModel.getValue("currency"));
            model.setValue("rcurrency", (Object)currencyId, rowIndex);
            model.setValue("tripcurrency", (Object)currencyId, rowIndex);
            Long[] applierIds = new Long[]{ErCommonUtils.getPk((Object)parentModel.getValue("applier"))};
            model.setValue("travelers", (Object)applierIds, rowIndex);
            model.setValue("entrycostdept", parentModel.getValue("costdept"), rowIndex);
            model.setValue("entrycostcompany", parentModel.getValue("costcompany"), rowIndex);
            model.setValue("std_entrycostcenter", parentModel.getValue("std_costcenter"), rowIndex);
            model.setValue("company", parentModel.getValue("company"), rowIndex);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        boolean isQueryBudget = (Boolean)customParams.get("isquerybudget");
        BudgetCommonUtil.setIsQueryBudgetFlag(this.getPageCache(), isQueryBudget);
        Long companyId = ErCommonUtils.getPk((Object)this.getView().getParentView().getModel().getValue("company"));
        this.setTripExpenseItemShow(companyId, 0);
        this.setBudgetShow(0);
        this.setVehicleVisible();
        if (Objects.nonNull(this.getModel().getDataEntityType().getProperty("costorgusemode"))) {
            this.getModel().setValue("costorgusemode", this.getView().getParentView().getModel().getValue("costorgusemode"));
        }
        ShowPageUtils.setMobilePageFormStatus((IFormView)this.getView());
        if (StringUtils.equals((String)"1", (String)ErCommonUtils.getTripDateSelectRange((Long)companyId))) {
            DateTimeEdit tripDate = (DateTimeEdit)this.getControl("startdate");
            tripDate.setMinDate(ErCommonUtils.getDateFromLocalDate((LocalDate)LocalDate.now()));
            tripDate = (DateTimeEdit)this.getControl("enddate");
            tripDate.setMinDate(ErCommonUtils.getDateFromLocalDate((LocalDate)LocalDate.now()));
        }
    }

    private void setVehicleVisible() {
        String vihicleKey = null;
        vihicleKey = !this.readOnly() && this.getVihicleFromStdConfig() ? "vehicles" : "vehicle";
        CardEntry tripentry = (CardEntry)this.getControl("tripentry");
        int tripentryLen = this.getModel().getEntryRowCount("tripentry");
        for (int i = 0; i < tripentryLen; ++i) {
            tripentry.setChildVisible(false, i, new String[]{vihicleKey});
        }
    }

    protected boolean readOnly() {
        IFormView parentView = this.getView().getParentView();
        return parentView != null && !"A".equals(parentView.getModel().getValue("billstatus")) && !"D".equals(parentView.getModel().getValue("billstatus"));
    }

    protected boolean getVihicleFromStdConfig() {
        return StringUtils.equals((String)ErStdConfig.get((String)"notMultiVehicles"), (String)"true");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        int rowIndex = valueSet[0].getRowIndex();
        Object propValue = valueSet[0].getNewValue();
        switch (propName) {
            case "triporiamount": {
                BigDecimal tripOriAmount = (BigDecimal)propValue;
                BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)model.getValue("tripexchangerate", rowIndex)), (Object)BigDecimal.ONE);
                String tripQuoteType = (String)ObjectUtils.defaultIfNull((Object)((String)model.getValue("tripquotetype", rowIndex)), (Object)"0");
                BigDecimal tripAmount = AmountUtils.getCurrencyAmount((BigDecimal)tripOriAmount, (BigDecimal)exchangeRate, (int)AmountUtils.getCurrencyPrecision((IDataModel)model, (String)"currency"), (String)tripQuoteType);
                model.setValue("tripamount", (Object)tripAmount, rowIndex);
                break;
            }
            case "tripcurrency": {
                IDataModel parentModel = this.getView().getParentView().getModel();
                DynamicObject tripCurrency = (DynamicObject)propValue;
                DynamicObject currency = (DynamicObject)parentModel.getValue("currency");
                if (tripCurrency != null && currency != null) {
                    long sourceCurrencyId = tripCurrency.getLong("id");
                    long targetCurrencyId = currency.getLong("id");
                    long companyId = (Long)parentModel.getValue("company_Id");
                    Object costCompany = parentModel.getValue("costcompany");
                    Object bizdate = parentModel.getValue("bizdate");
                    Map exchangeMap = CommonServiceHelper.getExchangeRateFromSysParams((Object)companyId, (Object)costCompany, (Long)sourceCurrencyId, (Long)targetCurrencyId, (Object)bizdate);
                    String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeMap.get("quoteType")), (Object)"0");
                    BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeMap.get("exchangeRate")), (Object)BigDecimal.ONE);
                    if (this.getModel().getProperty("tripquotetype") != null) {
                        this.getModel().setValue("tripquotetype", (Object)quoteType, rowIndex);
                    }
                    this.getModel().setValue("tripexchangerate", (Object)exchangeRate, rowIndex);
                }
                if (tripCurrency != null || valueSet[0].getOldValue() == null) break;
                DynamicObject oldValue = (DynamicObject)valueSet[0].getOldValue();
                model.setValue("tripcurrency", (Object)ErCommonUtils.getPk((Object)oldValue), rowIndex);
                break;
            }
            case "tripexchangerate": {
                BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)propValue), (Object)BigDecimal.ONE);
                BigDecimal tripOriAmount = (BigDecimal)model.getValue("triporiamount");
                if (tripOriAmount.compareTo(BigDecimal.ZERO) == 0) break;
                String tripQuoteType = (String)ObjectUtils.defaultIfNull((Object)((String)model.getValue("tripquotetype", rowIndex)), (Object)"0");
                BigDecimal tripAmount = AmountUtils.getCurrencyAmount((BigDecimal)tripOriAmount, (BigDecimal)exchangeRate, (int)AmountUtils.getCurrencyPrecision((IDataModel)model, (String)"currency"), (String)tripQuoteType);
                model.setValue("tripamount", (Object)tripAmount, rowIndex);
                break;
            }
            case "startdate": {
                Date startDate = (Date)propValue;
                Date endDate = (Date)model.getValue("enddate");
                Long tripDays = CommonServiceHelper.calcDays((Date)startDate, (Date)endDate);
                model.setValue("tripday", (Object)tripDays, rowIndex);
                break;
            }
            case "enddate": {
                Date endDate = (Date)propValue;
                Date startDate = (Date)model.getValue("startdate");
                Long tripDays = CommonServiceHelper.calcDays((Date)startDate, (Date)endDate);
                model.setValue("tripday", (Object)tripDays, rowIndex);
                break;
            }
            case "tripexpenseitem": {
                if (!BudgetCommonUtil.getIsQueryBudgetFlag(this.getPageCache()) || propValue == null) break;
                BudgetCommonUtil.buildBudgetAmountField(this.getView(), rowIndex);
                break;
            }
            case "std_project": {
                if (!BudgetCommonUtil.getIsQueryBudgetFlag(this.getPageCache())) break;
                BudgetCommonUtil.buildBudgetAmountField(this.getView(), rowIndex);
                break;
            }
            case "vehicle": {
                if (!this.getVihicleFromStdConfig()) break;
                this.getModel().setValue("vehicles", propValue);
            }
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        IDataModel model = this.getModel();
        IDataModel parentModel = this.getView().getParentView().getModel();
        Long companyId = ErCommonUtils.getPk((Object)parentModel.getValue("company"));
        switch (key) {
            case "btn_save": {
                String error;
                StringBuilder requireds = new StringBuilder();
                requireds.append("from,to,startdate,enddate,vehicles");
                Boolean isLoan = (Boolean)model.getValue("isloan");
                if (isLoan.booleanValue() || BudgetCommonUtil.getIsQueryBudgetFlag(this.getPageCache()) || BudgetCommonUtil.getIsQueryEASBudgetFlag(this.getPageCache()) || BudgetCommonUtil.getIsTripReqShowExpenseitemFlag(this.getPageCache()) || this.getModel().getDataEntity(true).getBoolean("istravelers") || SystemParamterUtil.getTripexpenseitemMustInput((Long)companyId)) {
                    requireds.append(",tripexpenseitem");
                }
                DynamicObject dataEntity = model.getDataEntity(true);
                DynamicObjectCollection tripentry = dataEntity.getDynamicObjectCollection("tripentry");
                Boolean confirm = Boolean.FALSE;
                Boolean istravelers = (Boolean)this.getModel().getValue("istravelers");
                for (DynamicObject dobjet : tripentry) {
                    Object to;
                    String vehicles = (String)model.getValue("vehicles");
                    if (vehicles == null) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4ea4\u901a\u5de5\u5177\u201d\u3002", (String)"CommonServiceHelper_1", (String)"fi-er-business", (Object[])new Object[0]), new Object[0]));
                        return;
                    }
                    String[] split = vehicles.split(",");
                    if (split == null || split.length == 0) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4ea4\u901a\u5de5\u5177\u201d\u3002", (String)"CommonServiceHelper_1", (String)"fi-er-business", (Object[])new Object[0]), new Object[0]));
                        return;
                    }
                    DynamicObjectCollection travelers = dobjet.getDynamicObjectCollection("travelers");
                    if (istravelers.booleanValue() && (travelers == null || travelers.size() == 0)) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u51fa\u5dee\u4eba\u201d\u3002", (String)"TripReqSection_7", (String)"fi-er-formplugin", (Object[])new Object[0]), new Object[0]));
                        return;
                    }
                    if (!CommonServiceHelper.requireValidate((DynamicObject)dobjet, (String[])requireds.toString().split(","), (AbstractFormPlugin)this)) {
                        return;
                    }
                    Object from = dobjet.get("from");
                    if (from.equals(to = dobjet.get("to"))) {
                        confirm = Boolean.TRUE;
                    }
                    dobjet.set("triporiaccappamount", dobjet.get("triporiamount"));
                    dobjet.set("tripaccappamount", dobjet.get("tripamount"));
                    dobjet.set("oriaccbalanceamount", dobjet.get("triporiamount"));
                    dobjet.set("accbalanceamount", dobjet.get("tripamount"));
                }
                if (parentModel.getValue("istravelers") != null && !((Boolean)parentModel.getValue("istravelers")).booleanValue() && StringUtils.isNotBlank((String)(error = this.validateTripDate(parentModel)))) {
                    this.getView().showErrorNotification(error);
                    return;
                }
                if (confirm.booleanValue()) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u51fa\u53d1\u5730\u4e0e\u76ee\u7684\u5730\u76f8\u540c\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TripReqSection_0", (String)"fi-er-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("ok", (IFormPlugin)this));
                    break;
                }
                this.clickOk(model, parentModel, dataEntity, tripentry);
                break;
            }
            case "btn_addsection": {
                int tripentryCurIndex = model.getEntryCurrentRowIndex("tripentry");
                model.setValue("tripcurrency", (Object)ErCommonUtils.getPk((Object)parentModel.getValue("currency")), tripentryCurIndex);
                Long[] applierIds = new Long[]{ErCommonUtils.getPk((Object)parentModel.getValue("applier"))};
                model.setValue("travelers", (Object)applierIds, tripentryCurIndex);
                this.setTripExpenseItemShow(companyId, tripentryCurIndex);
                this.setBudgetShow(tripentryCurIndex);
                this.setVehicleVisible();
            }
        }
    }

    private void clickOk(IDataModel model, IDataModel parentModel, DynamicObject dataEntity, DynamicObjectCollection tripentry) {
        if (tripentry == null || tripentry.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u884c\u7a0b\u4fe1\u606f\u3002", (String)"TripReqSection_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        long firstPageCurrencyId = ErCommonUtils.getPk((Object)parentModel.getValue("currency"));
        long secondPageCurrencyId = ErCommonUtils.getPk((Object)model.getValue("currency"));
        IFormView parentView = this.getView().getParentView();
        DynamicObject parentDataEntity = parentModel.getDataEntity(true);
        DynamicObjectCollection partripentry = parentDataEntity.getDynamicObjectCollection("tripentry");
        if (partripentry.isEmpty() && firstPageCurrencyId != secondPageCurrencyId) {
            parentView.updateView();
            this.getView().sendFormAction(parentView);
            this.getView().close();
            return;
        }
        FormShowParameter param = this.getView().getFormShowParameter();
        String pageId = parentView.getPageId();
        if (param.getCustomParam("entryedit") != null) {
            int index = (Integer)param.getCustomParam("index");
            partripentry.remove(index);
            partripentry.addAll(index, (Collection)tripentry);
        } else {
            partripentry.addAll((Collection)tripentry);
        }
        RedisModelCache redisModelCache = new RedisModelCache(null, model.getDataEntityType(), pageId);
        redisModelCache.storeAll(dataEntity);
        parentView.updateView();
        this.getView().sendFormAction(parentView);
        this.getView().close();
    }

    private String validateTripDate(IDataModel parentModel) {
        DynamicObjectCollection parentTripEntry = parentModel.getEntryEntity("tripentry");
        int parentSize = parentTripEntry.size();
        DynamicObjectCollection curEntryEntity = this.getModel().getEntryEntity("tripentry");
        int curSize = curEntryEntity.size();
        TreeMap sortMap = new TreeMap();
        if (curSize > 0) {
            curEntryEntity.forEach(entity -> sortMap.put(entity.getInt("index"), entity));
        }
        if (parentSize > 0) {
            parentTripEntry.forEach(entity -> {
                if (!sortMap.containsKey(entity.getInt("seq"))) {
                    sortMap.put(entity.getInt("seq"), entity);
                }
            });
        }
        Date startDate = null;
        Date endDate = null;
        String tip = null;
        for (int i = 0; i < curEntryEntity.size(); ++i) {
            DynamicObject curTripEntry = (DynamicObject)curEntryEntity.get(i);
            int index = curTripEntry.getInt("index");
            DynamicObject lastTripEntry = (DynamicObject)sortMap.get(index - 1);
            if (lastTripEntry != null && (startDate = curTripEntry.getDate("startdate")).before(endDate = lastTripEntry.getDate("enddate"))) {
                tip = ResManager.loadKDString((String)"\u7b2c%1$s\u7a0b\u884c\u7a0b\u671f\u95f4\u4e0d\u80fd\u65e9\u4e8e\u7b2c%2$s\u7a0b\u884c\u7a0b\u671f\u95f4\u3002", (String)"TripReqSection_2", (String)"fi-er-formplugin", (Object[])new Object[0]);
                return String.format(tip, index, index - 1);
            }
            DynamicObject nextTripEntry = (DynamicObject)sortMap.get(index + 1);
            if (nextTripEntry == null) continue;
            endDate = curTripEntry.getDate("enddate");
            startDate = nextTripEntry.getDate("startdate");
            if (!startDate.before(endDate)) continue;
            tip = ResManager.loadKDString((String)"\u7b2c%1$s\u7a0b\u884c\u7a0b\u671f\u95f4\u4e0d\u80fd\u665a\u4e8e\u7b2c%2$s\u7a0b\u884c\u7a0b\u671f\u95f4\u3002", (String)"TripReqSection_4", (String)"fi-er-formplugin", (Object[])new Object[0]);
            return String.format(tip, index, index + 1);
        }
        return null;
    }

    private void setTripExpenseItemShow(Long companyId, int rowIndex) {
        Boolean isLoan = (Boolean)this.getModel().getValue("isloan");
        CardEntry tripCardEntry = (CardEntry)this.getControl("tripentry");
        if (isLoan.booleanValue() || BudgetCommonUtil.getIsQueryBudgetFlag(this.getPageCache()) || BudgetCommonUtil.getIsQueryEASBudgetFlag(this.getPageCache()) || BudgetCommonUtil.getIsTripReqShowExpenseitemFlag(this.getPageCache()) || this.getModel().getDataEntity(true).getBoolean("istravelers") || SystemParamterUtil.getTripexpenseitemMustInput((Long)companyId)) {
            tripCardEntry.setChildVisible(true, rowIndex, new String[]{"cardtripexpenseitem", "tripexpenseitem"});
            FieldEdit editor = (FieldEdit)this.getView().getControl("tripexpenseitem");
            editor.setMustInput(true);
        } else {
            tripCardEntry.setChildVisible(false, rowIndex, new String[]{"cardtripexpenseitem", "tripexpenseitem"});
        }
    }

    private void setBudgetShow(int rowIndex) {
        CardEntry tripCardEntry = (CardEntry)this.getControl("tripentry");
        if (tripCardEntry != null) {
            if (BudgetCommonUtil.getIsQueryBudgetFlag(this.getPageCache()) || BudgetCommonUtil.getIsQueryEASBudgetFlag(this.getPageCache())) {
                IFormView parentView = this.getView().getParentView();
                if (parentView != null) {
                    String budgeMsgValue = (String)ErCommonUtils.getEMParameter((long)ErCommonUtils.getPk((Object)parentView.getModel().getValue("company")), (String)"budgeMsgControl");
                    if (StringUtils.isNotEmpty((String)budgeMsgValue)) {
                        if ("0".equals(budgeMsgValue)) {
                            tripCardEntry.setChildVisible(true, rowIndex, new String[]{"cardbudget", "budgetamount"});
                            tripCardEntry.setChildVisible(false, rowIndex, new String[]{"cardbudget1", "budgetmsg"});
                        } else if ("1".equals(budgeMsgValue)) {
                            tripCardEntry.setChildVisible(false, rowIndex, new String[]{"cardbudget", "budgetamount"});
                            tripCardEntry.setChildVisible(true, rowIndex, new String[]{"cardbudget1", "budgetmsg"});
                        }
                    } else {
                        tripCardEntry.setChildVisible(false, rowIndex, new String[]{"cardbudget", "budgetamount"});
                        tripCardEntry.setChildVisible(false, rowIndex, new String[]{"cardbudget1", "budgetmsg"});
                    }
                } else {
                    tripCardEntry.setChildVisible(false, rowIndex, new String[]{"cardbudget", "budgetamount"});
                    tripCardEntry.setChildVisible(false, rowIndex, new String[]{"cardbudget1", "budgetmsg"});
                }
            } else {
                tripCardEntry.setChildVisible(false, rowIndex, new String[]{"cardbudget", "budgetamount"});
                tripCardEntry.setChildVisible(false, rowIndex, new String[]{"cardbudget1", "budgetmsg"});
            }
        }
    }

    private void initTripEntryDefaultData(IDataModel model, int rowIndex) {
        model.setValue("tripexchangerate", (Object)BigDecimal.ONE, rowIndex);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        int[] rowIndexs = e.getRowIndexs();
        int tripEntrySize = this.getModel().getEntryRowCount("tripentry");
        for (int rowIndex = rowIndexs[0]; rowIndex < tripEntrySize; ++rowIndex) {
            int index = (Integer)this.getModel().getValue("index", rowIndex);
            this.getModel().setValue("index", (Object)(index - 1), rowIndex);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        IDataModel model = this.getModel();
        IDataModel paremodel = this.getView().getParentView().getModel();
        int rowIndex = model.getEntryCurrentRowIndex("tripentry");
        int thisCount = model.getEntryRowCount("tripentry");
        DynamicObjectCollection tripentryCol = model.getEntryEntity("tripentry");
        int tripenytryCount = tripentryCol.size();
        if (thisCount == 0) {
            return;
        }
        if ("newtripentry".equalsIgnoreCase(afterDoOperationEventArgs.getOperateKey())) {
            if (tripenytryCount > 1) {
                Object lastCity = ((DynamicObject)tripentryCol.get(tripenytryCount - 2)).get("to_Id");
                Object nextStartDate = ((DynamicObject)tripentryCol.get(tripenytryCount - 2)).get("enddate");
                if (lastCity != null) {
                    model.setValue("from", lastCity, tripenytryCount - 1);
                }
                if (nextStartDate != null) {
                    model.setValue("startdate", nextStartDate, tripenytryCount - 1);
                }
            }
            int totalEntryCount = model.getEntryRowCount("tripentry") + paremodel.getEntryRowCount("tripentry");
            model.setValue("index", (Object)totalEntryCount, model.getEntryRowCount("tripentry") - 1);
            Long currencyId = ErCommonUtils.getPk((Object)paremodel.getValue("currency"));
            model.setValue("rcurrency", (Object)currencyId, rowIndex);
            model.setValue("tripcurrency", (Object)currencyId, rowIndex);
            this.initTripEntryDefaultData(model, rowIndex);
        }
        int tripEntryRowCount = model.getEntryRowCount("tripentry");
        int parentTripEntryRowCount = paremodel.getEntryRowCount("tripentry");
        if (Objects.equals(afterDoOperationEventArgs.getOperateKey(), "deletetripentry")) {
            for (int i = 0; i < tripEntryRowCount; ++i) {
                model.setValue("index", (Object)(parentTripEntryRowCount + i + 1), i);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            IFormView parentView = this.getView().getParentView();
            IDataModel parentModel = parentView.getModel();
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection tripentry = dataEntity.getDynamicObjectCollection("tripentry");
            this.clickOk(this.getModel(), parentModel, dataEntity, tripentry);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("people_choose".equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            ListSelectedRowCollection rowCollection = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            int index = this.getModel().getEntryCurrentRowIndex("tripentry");
            Object[] users = null;
            users = rowCollection != null ? rowCollection.stream().map(v -> v.getPrimaryKeyValue()).toArray() : new Object[]{};
            this.getModel().setValue("travelers", (Object)users, index);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        super.beforeClosed(e);
    }
}

