/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import java.text.SimpleDateFormat;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.model.FormModel;

public class TripTipsPagePlugin
extends AbstractMobBillPlugIn {
    private static Log logger = LogFactory.getLog(TripTipsPagePlugin.class);
    private static final String BTN_RETURN = "backmainpage";
    private static final String TRIPINFOFLEX = "tripinfoflex";
    private static final String TAKEOFFTIME = "takeofftime";

    public void initialize() {
        this.addClickListeners(new String[]{BTN_RETURN});
    }

    public void beforeBindData(EventObject eo) {
        boolean isTipReq;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        boolean bl = isTipReq = parameter.getCustomParams().get("isTipReq") == null ? Boolean.FALSE.booleanValue() : ((Boolean)parameter.getCustomParams().get("isTipReq")).booleanValue();
        if (isTipReq) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_RETURN});
            Map tripInfoMap = (Map)parameter.getCustomParams().get("tripInfoMap");
            if (tripInfoMap != null) {
                this.getView().setVisible(Boolean.TRUE, new String[]{TRIPINFOFLEX});
                SimpleDateFormat dfDate = new SimpleDateFormat(ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5", (String)"TripTipsPagePlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                SimpleDateFormat dfTime = new SimpleDateFormat("HH:mm");
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Label routeLabel = (Label)this.getControl("cityroute");
                Label airLine = (Label)this.getControl("airlineandno");
                Label takeofftime = (Label)this.getControl(TAKEOFFTIME);
                Label landingtime = (Label)this.getControl("landingtime");
                Label planedate = (Label)this.getControl("planedate");
                Label takeoffportname = (Label)this.getControl("takeoffportname");
                Label landingportname = (Label)this.getControl("landingportname");
                routeLabel.setText(tripInfoMap.get("fromcityname").toString() + "-" + tripInfoMap.get("tocityname").toString());
                airLine.setText(tripInfoMap.get("airlinename").toString() + tripInfoMap.get("flightno").toString());
                try {
                    takeofftime.setText(dfTime.format(dateFormat.parse(tripInfoMap.get(TAKEOFFTIME).toString())));
                    landingtime.setText(dfTime.format(dateFormat.parse(tripInfoMap.get("landingtime").toString())));
                    planedate.setText(dfDate.format(dateFormat.parse(tripInfoMap.get(TAKEOFFTIME).toString())));
                }
                catch (Exception e) {
                    logger.info("\u5929\u6c14\u4fe1\u606f\u7c7b\u578b\u8f6c\u6362\u9519\u8bef" + e.getMessage());
                }
                takeoffportname.setText(tripInfoMap.get("takeoffportname").toString());
                landingportname.setText(tripInfoMap.get("landingportname").toString());
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{TRIPINFOFLEX});
        }
    }

    public void click(EventObject e) {
        boolean result = this.isDailyExpense(this.getView());
        FormModel formModel = null;
        formModel = result ? new FormModel("er_mainpage_daily", ResManager.loadKDString((String)"\u9996\u9875", (String)"TripTipsPagePlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]), "11") : new FormModel("er_mainpage", ResManager.loadKDString((String)"\u9996\u9875", (String)"TripTipsPagePlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]), "11");
        formModel.setShowType(ShowType.Floating);
        ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.close();
        }
        this.getView().close();
    }

    private boolean isDailyExpense(IFormView formView) {
        IFormView parentView = formView.getParentView();
        if (parentView == null) {
            return false;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)parentView.getEntityId(), (CharSequence)"er_mainpage_daily")) {
            return true;
        }
        return this.isDailyExpense(parentView);
    }
}

