/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile.amount.query;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Month;
import java.time.Year;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.daily.service.ReimburseAmountControlService;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.ReimburseControlUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.constant.ErExpenseItemConstant;
import kd.fi.er.formplugin.mobile.amount.query.AmountControlName;
import kd.fi.er.formplugin.mobile.amount.query.AmountEntity;
import org.apache.commons.lang.StringUtils;

public class AmountQueryAndReimburseForMobUtils {
    private static Log logger = LogFactory.getLog(AmountQueryAndReimburseForMobUtils.class);
    private static final String CACHE_POSITION_COMPANY = "cachePositionCompany";
    private static final String CACHE_ALL_COMPANY = "cacheAllCompany";
    private static final String MAIN_POSITION_COMANY = "mainCompany";

    public static Map<String, AmountEntity> getDeptAmountInfo(Long companyId, String depts) {
        Map<Object, Object> deptAmountMap = Maps.newHashMap();
        if (StringUtils.isBlank((String)depts)) {
            return deptAmountMap;
        }
        List deptList = Arrays.stream(StringUtils.split((String)depts, (char)',')).map(dept -> Long.parseLong(dept)).collect(Collectors.toList());
        String[] regiom = new String[]{Year.now().toString()};
        logger.info("\u5f53\u524d\u90e8\u95e8\u989d\u5ea6\u67e5\u8be2\u6761\u4ef6: companyId->" + companyId + " depts->" + depts);
        QFilter[] qFilters = new QFilter[]{new QFilter("dept", "in", deptList), new QFilter("company", "=", (Object)companyId), new QFilter("auditstatus", "=", (Object)"1"), new QFilter("dateyear", "in", (Object)regiom)};
        String selectClumn = "id,expenseitem,expenseitem.reimburseamountctlmethod as controlmethod,expenseitem.reimburseamountctlcount as ctlcount,expenseitem.expenseitemicon as expenseimg,expenseitem.name as expensename,employee,currency,dateyear,totalamount as yeartotalamount,company,amounttype,dept";
        deptAmountMap = AmountQueryAndReimburseForMobUtils.selectAmountInfo(qFilters, selectClumn, "er_dept_reimctl", companyId);
        return deptAmountMap;
    }

    public static Map<String, AmountEntity> selectAmountInfo(QFilter[] qFilters, String selectClumn, String entityName, Long company) {
        HashMap deptAmountMap = Maps.newHashMap();
        IErDao dao = ErDaoFactory.getInstance((String)entityName);
        DataSet amountInfo = dao.queryDataSet(AmountQueryAndReimburseForMobUtils.class.getName(), selectClumn, qFilters);
        LocalDate currentLocalDate = ReimburseControlUtils.currentLocalDate();
        boolean allowPreviousYear = ReimburseControlUtils.isAllowPreviousYear((Long)company);
        Month deadlineMonth = ReimburseControlUtils.deadlineMonthOfAllowPreviousYes((Long)company);
        AmountEntity amountRow = null;
        for (Row row : amountInfo) {
            String year = row.getString("dateyear");
            String controlmethod = row.getString("controlmethod");
            YearMonth yearMonth = YearMonth.from(LocalDate.now());
            long currencyId = row.getLong("currency");
            long expenseItemId = row.getLong("expenseitem");
            long companyId = row.getLong("company");
            long deptId = row.getLong("dept");
            String expenseImgUrl = row.getString("expenseimg");
            String expenseNameLab = row.getString("expensename");
            Integer ctlcount = row.getInteger("ctlcount");
            if (ctlcount == null) {
                ctlcount = 0;
            }
            String controlMethodLab = AmountControlName.getName(controlmethod);
            if (ctlcount > 0) {
                String ctlcountstr = String.format(ResManager.loadKDString((String)"(%s\u6b21)", (String)"AmountQueryAndReimburseForMobUtils_10", (String)"fi-er-formplugin", (Object[])new Object[0]), ctlcount);
                controlMethodLab = controlMethodLab + ctlcountstr;
            }
            BigDecimal yearTotalAmount = row.getBigDecimal("yeartotalamount");
            String key = String.valueOf(expenseItemId).concat(controlmethod).concat(String.valueOf(currencyId)).concat(String.valueOf(deptId));
            ReimburseAmountControlService service = (ReimburseAmountControlService)ReimburseAmountControlService.controlServiceMap.get(ErExpenseItemConstant.ReimburseAmountCtlMethod.getEnumByValue((String)controlmethod));
            String yearTotalLab = null;
            String balanceLab = null;
            String usedLabe = null;
            BigDecimal balanceamount = BigDecimal.ZERO;
            BigDecimal usedAmount = BigDecimal.ZERO;
            if (controlmethod.equals(ErExpenseItemConstant.ReimburseAmountCtlMethod.Yearly.getValue()) || controlmethod.equals(ErExpenseItemConstant.ReimburseAmountCtlMethod.Accumulative.getValue())) {
                yearTotalLab = ResManager.loadKDString((String)"\u5e74\u603b\u989d", (String)"AmountQueryAndReimburseForMobUtils_0", (String)"fi-er-formplugin", (Object[])new Object[0]);
                balanceLab = ResManager.loadKDString((String)"\u53ef\u62a5\u9500", (String)"AmountQueryAndReimburseForMobUtils_1", (String)"fi-er-formplugin", (Object[])new Object[0]);
                usedLabe = ResManager.loadKDString((String)"\u5df2\u62a5\u9500", (String)"AmountQueryAndReimburseForMobUtils_2", (String)"fi-er-formplugin", (Object[])new Object[0]);
                usedAmount = service.getDeptReimbursedAmountByMonth(Long.valueOf(companyId), Long.valueOf(deptId), Long.valueOf(expenseItemId), Long.valueOf(currencyId), yearMonth, new ArrayList());
                balanceamount = service.getDeptReimburseBalanceAmount(Long.valueOf(companyId), Long.valueOf(deptId), Long.valueOf(expenseItemId), Long.valueOf(currencyId), yearMonth, new ArrayList());
                amountRow = new AmountEntity(expenseImgUrl, expenseItemId, currencyId, expenseNameLab, controlMethodLab, controlmethod, balanceLab, balanceamount, usedLabe, usedAmount, yearTotalLab, yearTotalAmount, "2", deptId);
            } else if (controlmethod.equals(ErExpenseItemConstant.ReimburseAmountCtlMethod.Monthly.getValue()) || controlmethod.equals(ErExpenseItemConstant.ReimburseAmountCtlMethod.MonthlyAndIndex.getValue())) {
                yearTotalLab = ResManager.loadKDString((String)"\u53ef\u62a5\u6708(\u53bb\u5e74)", (String)"AmountQueryAndReimburseForMobUtils_3", (String)"fi-er-formplugin", (Object[])new Object[0]);
                balanceLab = ResManager.loadKDString((String)"\u6708\u989d\u5ea6", (String)"AmountQueryAndReimburseForMobUtils_4", (String)"fi-er-formplugin", (Object[])new Object[0]);
                usedLabe = ResManager.loadKDString((String)"\u53ef\u62a5\u6708(\u4eca\u5e74)", (String)"AmountQueryAndReimburseForMobUtils_5", (String)"fi-er-formplugin", (Object[])new Object[0]);
                yearMonth = yearMonth.minusMonths(1L);
                if (!allowPreviousYear && year.equals(Year.now().minusYears(1L).toString())) continue;
                if (year.equals(Year.now().minusYears(1L).toString())) {
                    if (currentLocalDate.getMonthValue() > deadlineMonth.getValue()) continue;
                    yearMonth = YearMonth.of(Integer.parseInt(year), 12);
                }
                balanceamount = service.getDeptReimburseLimitAmountByMonth(Long.valueOf(companyId), Long.valueOf(deptId), Long.valueOf(expenseItemId), Long.valueOf(currencyId), yearMonth);
                amountRow = deptAmountMap.get(key) != null ? (AmountEntity)deptAmountMap.get(key) : new AmountEntity(expenseImgUrl, expenseItemId, currencyId, expenseNameLab, controlMethodLab, controlmethod, balanceLab, balanceamount, usedLabe, usedAmount, yearTotalLab, yearTotalAmount, "2", deptId);
                if (allowPreviousYear && currentLocalDate.getMonthValue() <= deadlineMonth.getValue()) {
                    amountRow.addLastyearmonths(AmountQueryAndReimburseForMobUtils.getUnreimbursedMonths(companyId, deptId, expenseItemId, currencyId, Year.now().minusYears(1L), ctlcount));
                }
                amountRow.addThisyearmonths(AmountQueryAndReimburseForMobUtils.getUnreimbursedMonths(companyId, deptId, expenseItemId, currencyId, Year.now(), ctlcount));
            } else if (ErExpenseItemConstant.ReimburseAmountCtlMethod.Quarterly.getValue().equals(controlmethod)) {
                yearTotalLab = ResManager.loadKDString((String)"\u53ef\u62a5\u5b63(\u53bb\u5e74)", (String)"AmountQueryAndReimburseForMobUtils_7", (String)"fi-er-formplugin", (Object[])new Object[0]);
                balanceLab = ResManager.loadKDString((String)"\u5b63\u989d\u5ea6", (String)"AmountQueryAndReimburseForMobUtils_8", (String)"fi-er-formplugin", (Object[])new Object[0]);
                usedLabe = ResManager.loadKDString((String)"\u53ef\u62a5\u5b63(\u4eca\u5e74)", (String)"AmountQueryAndReimburseForMobUtils_9", (String)"fi-er-formplugin", (Object[])new Object[0]);
                if (!allowPreviousYear && year.equals(Year.now().minusYears(1L).toString())) continue;
                if (year.equals(Year.now().minusYears(1L).toString())) {
                    if ((currentLocalDate.getMonth().firstMonthOfQuarter().getValue() + 2) / 3 > (deadlineMonth.firstMonthOfQuarter().getValue() + 2) / 3) continue;
                    yearMonth = YearMonth.of(Integer.parseInt(year), 12);
                }
                balanceamount = service.getDeptReimburseLimitAmountByMonth(Long.valueOf(companyId), Long.valueOf(deptId), Long.valueOf(expenseItemId), Long.valueOf(currencyId), yearMonth);
                amountRow = deptAmountMap.get(key) != null ? (AmountEntity)deptAmountMap.get(key) : new AmountEntity(expenseImgUrl, expenseItemId, currencyId, expenseNameLab, controlMethodLab, controlmethod, balanceLab, balanceamount, usedLabe, usedAmount, yearTotalLab, yearTotalAmount, "2", deptId);
                if (allowPreviousYear && currentLocalDate.getMonthValue() <= deadlineMonth.getValue()) {
                    amountRow.addLastyearmonths(AmountQueryAndReimburseForMobUtils.getUnreimbursedQuarters(companyId, deptId, expenseItemId, currencyId, Year.now().minusYears(1L), ctlcount));
                }
                amountRow.addThisyearmonths(AmountQueryAndReimburseForMobUtils.getUnreimbursedQuarters(companyId, deptId, expenseItemId, currencyId, Year.now(), ctlcount));
            } else {
                amountRow = new AmountEntity(expenseImgUrl, expenseItemId, currencyId, expenseNameLab, controlMethodLab, controlmethod, balanceLab, balanceamount, usedLabe, usedAmount, yearTotalLab, yearTotalAmount, "2", deptId);
            }
            deptAmountMap.put(key, amountRow);
        }
        return deptAmountMap;
    }

    public static List<String> getUnreimbursedMonths(Long companyId, Long deptId, Long expenseItemId, Long currencyId, Year year, Integer ctlcount) {
        int region = year.isBefore(Year.now()) ? 12 : YearMonth.now().getMonth().getValue() - 1;
        ReimburseAmountControlService service = (ReimburseAmountControlService)ReimburseAmountControlService.controlServiceMap.get(ErExpenseItemConstant.ReimburseAmountCtlMethod.Monthly);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i <= region; ++i) {
            YearMonth yearMonth = year.atMonth(i);
            BigDecimal balanceAmount = service.getDeptReimburseBalanceAmount(companyId, deptId, expenseItemId, currencyId, yearMonth, Collections.emptyList());
            if (BigDecimal.ZERO.compareTo(balanceAmount) >= 0 || AmountQueryAndReimburseForMobUtils.isOverExpItemCtlCount(service, yearMonth, companyId, currencyId, deptId, expenseItemId, ctlcount)) continue;
            list.add(String.valueOf(i));
        }
        return list;
    }

    protected static List<String> getUnreimbursedQuarters(Long companyId, Long userId, Long expenseItemId, Long currencyId, Year year, Integer ctlcount) {
        int region = year.isBefore(Year.now()) ? 4 : (YearMonth.now().getMonth().firstMonthOfQuarter().getValue() + 2) / 3;
        ReimburseAmountControlService service = (ReimburseAmountControlService)ReimburseAmountControlService.controlServiceMap.get(ErExpenseItemConstant.ReimburseAmountCtlMethod.Quarterly);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i <= region; ++i) {
            YearMonth yearMonth = year.atMonth(i * 3);
            BigDecimal balanceAmount = service.getDeptReimburseBalanceAmount(companyId, userId, expenseItemId, currencyId, yearMonth, Collections.emptyList());
            if (BigDecimal.ZERO.compareTo(balanceAmount) >= 0 || ctlcount != 0 && AmountQueryAndReimburseForMobUtils.isOverExpItemCtlCount(service, yearMonth, companyId, currencyId, userId, expenseItemId, ctlcount)) continue;
            list.add(String.valueOf(i));
        }
        return list;
    }

    private static boolean isOverExpItemCtlCount(ReimburseAmountControlService service, YearMonth yearMonth, Long companyId, Long currencyId, Long deptId, Long expenseItemId, Integer ctlcount) {
        Map reimburseBillHappenDatePeriod = service.getReimburseBillHappenDatePeriod(yearMonth);
        String quotaDateField = ErStdConfig.getQuotaDateField();
        String filterStr = "%s >= ? and %s <= ?";
        filterStr = String.format(filterStr, quotaDateField, quotaDateField);
        QFilter qFilter = QFilter.of((String)filterStr, (Object[])new Object[]{ErCommonUtils.getDateFromLocalDate((LocalDate)((LocalDate)reimburseBillHappenDatePeriod.get("start"))), ErCommonUtils.getDateFromLocalDate((LocalDate)((LocalDate)reimburseBillHappenDatePeriod.get("end")))});
        QFilter currencyQFilter = ReimburseControlUtils.getDeptCtlCurrency((Long)companyId).getCurrencyQFilter(currencyId);
        QFilter deptQFilter = ReimburseControlUtils.getReimCtlDeptQFilter((Long)companyId, (Long)deptId).and(currencyQFilter).and("expenseentryentity.expenseitem", "=", (Object)expenseItemId).and("billstatus", "not in", Arrays.asList("A", "D", "H"));
        DynamicObjectCollection dailyReimburseBills = QueryServiceHelper.query((String)"er_dailyreimbursebill", (String)"id", (QFilter[])new QFilter[]{qFilter, deptQFilter});
        return !dailyReimburseBills.isEmpty() && dailyReimburseBills.size() >= ctlcount;
    }

    public static QFilter getQFilter(DynamicObject rowData, IDataModel model) {
        Long expenseitemid = Long.parseLong(rowData.getString("expenseitemid"));
        DynamicObject currency = rowData.getDynamicObject("currency");
        DynamicObject dept = rowData.getDynamicObject("dept");
        DynamicObject company = (DynamicObject)model.getValue("org");
        String year = String.valueOf(LocalDate.now().getYear());
        LocalDate beginDate = LocalDate.of(Integer.parseInt(year), 1, 1);
        LocalDate endDate = LocalDate.of(Integer.parseInt(year), 12, 31);
        QFilter currencyQFilter = ReimburseControlUtils.getDeptCtlCurrency((Long)ErCommonUtils.getPk((Object)company)).getCurrencyQFilter(ErCommonUtils.getPk((Object)currency));
        QFilter qFilter = QFilter.of((String)"expenseentryentity.expenseitem= ? and expenseentryentity.happendate >= ? and expenseentryentity.happendate <= ? ", (Object[])new Object[]{expenseitemid, ErCommonUtils.getDateFromLocalDate((LocalDate)beginDate), ErCommonUtils.getDateFromLocalDate((LocalDate)endDate)});
        QFilter specialQFilter = ReimburseControlUtils.getReimCtlDeptQFilter((Long)((Long)company.getPkValue()), (Long)((Long)dept.getPkValue())).and(new QFilter("billstatus", "not in", Arrays.asList("A", "D", "H")));
        return qFilter.and(specialQFilter).and(currencyQFilter);
    }

    public static QFilter getQFilterPersonal(DynamicObject rowData, IDataModel model) {
        Long expenseitemid = Long.parseLong(rowData.getString("expenseitemid"));
        DynamicObject currency = rowData.getDynamicObject("currency");
        DynamicObject company = (DynamicObject)model.getValue("org");
        String year = String.valueOf(LocalDate.now().getYear());
        LocalDate beginDate = LocalDate.of(Integer.parseInt(year), 1, 1);
        LocalDate endDate = LocalDate.of(Integer.parseInt(year), 12, 31);
        QFilter currencyQFilter = ReimburseControlUtils.getPersonCtlCurrency((Long)ErCommonUtils.getPk((Object)company)).getCurrencyQFilter(ErCommonUtils.getPk((Object)currency));
        QFilter qFilter = QFilter.of((String)"expenseentryentity.reimburser=? and expenseentryentity.expenseitem= ? and expenseentryentity.happendate >= ? and expenseentryentity.happendate <= ? ", (Object[])new Object[]{CommonServiceHelper.getCurrentUserID(), expenseitemid, ErCommonUtils.getDateFromLocalDate((LocalDate)beginDate), ErCommonUtils.getDateFromLocalDate((LocalDate)endDate)});
        QFilter andQFilter = qFilter.and(new QFilter("billstatus", "not in", Arrays.asList("A", "D", "H"))).and(ReimburseControlUtils.getPersonReimCtlCompanyQFilter((Long)ErCommonUtils.getPk((Object)company))).and(currencyQFilter);
        return andQFilter;
    }

    public static void clearEntry(IDataModel model, String enteyName) {
        DynamicObjectCollection dyObjColl;
        DynamicObject dataEntry = model.getDataEntity(true);
        Object entry = dataEntry.get(enteyName);
        if (entry instanceof DynamicObjectCollection && (dyObjColl = (DynamicObjectCollection)entry) != null && !dyObjColl.isEmpty()) {
            int count = dyObjColl.size();
            for (int index = count - 1; index >= 0; --index) {
                model.deleteEntryRow(enteyName, index);
            }
        }
    }

    public static Set<Long> getUserAllDept(AbstractFormPlugin formPlugin) {
        DynamicObjectCollection personAmountCompany;
        IPageCache pageCache = formPlugin.getPageCache();
        String cacheNoPositionCompany = pageCache.get(CACHE_ALL_COMPANY);
        if (StringUtils.isNotBlank((String)cacheNoPositionCompany)) {
            return JSON.parseArray((String)cacheNoPositionCompany, Long.class).stream().collect(Collectors.toSet());
        }
        Long userid = CommonServiceHelper.getCurrentUserID();
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)userid, (String)"bos_user");
        HashSet allCompanyList = Sets.newHashSet();
        if (user != null) {
            DynamicObjectCollection userEntrys = user.getDynamicObjectCollection("entryentity");
            for (DynamicObject userEntry : userEntrys) {
                boolean isPartjob = userEntry.getBoolean("ispartjob");
                Long deptId = (Long)userEntry.getDynamicObject("dpt").getPkValue();
                Long copanyid = CoreBaseBillServiceHelper.initCompanyByDept((Long)deptId);
                if (copanyid == null || copanyid == 0L) continue;
                String caCheDepts = pageCache.get(copanyid.toString());
                caCheDepts = caCheDepts == null ? String.valueOf(deptId) : caCheDepts + "," + deptId;
                pageCache.put(copanyid.toString(), caCheDepts);
                if (!isPartjob) {
                    pageCache.put(MAIN_POSITION_COMANY, copanyid.toString());
                }
                allCompanyList.add(copanyid);
            }
        }
        allCompanyList.removeAll(allCompanyList.stream().filter(companyid -> !SystemParamterUtil.isEnableReimburseControlByCompany((Long)companyid)).collect(Collectors.toSet()));
        if (!allCompanyList.isEmpty()) {
            pageCache.put(CACHE_POSITION_COMPANY, JSON.toJSONString((Object)allCompanyList));
        }
        if ((personAmountCompany = QueryServiceHelper.query((String)"er_reimburseamount", (String)"company,expenseitem,expenseitem.reimburseamountctlmethod,dateyear", (QFilter[])new QFilter[]{new QFilter("employee_id", "=", (Object)userid).and("auditstatus", "=", (Object)"1")})) != null && personAmountCompany.size() > 0) {
            String yerNow = Year.now().toString();
            for (DynamicObject dynamicObject : personAmountCompany) {
                String year = dynamicObject.getString("dateyear");
                String rctrl = dynamicObject.getString("expenseitem.reimburseamountctlmethod");
                if (!StringUtils.equals((String)yerNow, (String)year) && !StringUtils.equals((String)rctrl, (String)ErExpenseItemConstant.ReimburseAmountCtlMethod.MonthlyAndIndex.getValue()) && !StringUtils.equals((String)rctrl, (String)ErExpenseItemConstant.ReimburseAmountCtlMethod.Monthly.getValue()) && !StringUtils.equals((String)rctrl, (String)ErExpenseItemConstant.ReimburseAmountCtlMethod.Quarterly.getValue())) continue;
                allCompanyList.add(dynamicObject.getLong("company"));
            }
        }
        if (!allCompanyList.isEmpty()) {
            pageCache.put(CACHE_ALL_COMPANY, JSON.toJSONString((Object)allCompanyList));
        }
        return allCompanyList;
    }

    public static Long initDefaultOrg(AbstractFormPlugin formPlugin) {
        List positionCompanyList;
        String companyId;
        IPageCache pageCache = formPlugin.getPageCache();
        Set<Long> allAmountOrg = AmountQueryAndReimburseForMobUtils.getUserAllDept(formPlugin);
        if (allAmountOrg.size() == 1) {
            formPlugin.getView().setEnable(Boolean.FALSE, new String[]{"org"});
        }
        if ((companyId = pageCache.get(MAIN_POSITION_COMANY)) != null && SystemParamterUtil.isEnableReimburseControlByCompany((Long)Long.parseLong(companyId))) {
            return Long.parseLong(companyId);
        }
        String cacheNoPositionCompany = pageCache.get(CACHE_POSITION_COMPANY);
        if (StringUtils.isNotBlank((String)cacheNoPositionCompany) && !(positionCompanyList = JSON.parseArray((String)cacheNoPositionCompany, Long.class)).isEmpty()) {
            return (Long)positionCompanyList.get(0);
        }
        return (Long)allAmountOrg.stream().findFirst().get();
    }

    public static Boolean isCanShowAmtQuery() {
        Long userid = CommonServiceHelper.getCurrentUserID();
        DynamicObject user = CommonServiceHelper.getUser((Long)userid);
        HashSet allCompanyList = Sets.newHashSet();
        if (user != null) {
            DynamicObjectCollection userEntrys = user.getDynamicObjectCollection("entryentity");
            List allOrgList = userEntrys.stream().map(userEntry -> (Long)userEntry.getDynamicObject("dpt").getPkValue()).collect(Collectors.toList());
            for (Long deptId : allOrgList) {
                Long copanyid = CoreBaseBillServiceHelper.initCompanyByDept((Long)deptId);
                if (copanyid == null || copanyid == 0L) continue;
                allCompanyList.add(copanyid);
            }
        }
        allCompanyList.removeAll(allCompanyList.stream().filter(companyid -> !SystemParamterUtil.isEnableReimburseControlByCompany((Long)companyid)).collect(Collectors.toSet()));
        if (!allCompanyList.isEmpty()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

