/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile.tripreim.list;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ContextMenuClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.MobileListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.common.ErBillStatusEnum;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.mobile.CoreBaseBillListNew;
import kd.fi.er.formplugin.mobile.MobileListStateInfo;
import kd.fi.er.formplugin.mobile.MultiLang;
import org.apache.commons.lang3.StringUtils;

public class GridTripReimburseBillMobList
extends CoreBaseBillListNew
implements RowClickEventListener {
    private static final String TRIP_REIMBURSE_BILL_GRID_MOB = "er_tripreim_grid_mb";
    private static Log log = LogFactory.getLog(GridTripReimburseBillMobList.class);
    private static final List<String> todoStateList = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"A", "B", "C", "D", "E1", "F"}));
    private static final List<String> didStateList = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"E2", "G", "H", "I"}));
    private static final MobileListStateInfo todoStateInfo = new MobileListStateInfo("todotab", todoStateList, new MultiLang(GridTripReimburseBillMobList.getAuditMsg(), "TripReimburseList_0", "fi-er-formplugin"));
    private static final MobileListStateInfo didStateInfo = new MobileListStateInfo("didtab", didStateList, new MultiLang(GridTripReimburseBillMobList.getCompleteMsg(), "TripReimburseList_1", "fi-er-formplugin"));
    private static final List<MobileListStateInfo> stateInfoList = Lists.newArrayListWithExpectedSize((int)2);

    public GridTripReimburseBillMobList(List<MobileListStateInfo> stateInfoList) {
        super(stateInfoList);
    }

    public GridTripReimburseBillMobList() {
        this(stateInfoList);
    }

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.FALSE, new String[]{"doingtab"});
    }

    public void contextMenuClick(ContextMenuClickEvent e) {
        super.contextMenuClick(e);
        log.info("new:log\u4e91\u4e4b\u5bb6ItemKey\uff1a" + e.getItemKey());
        if (StringUtils.equalsIgnoreCase((CharSequence)e.getItemKey().toLowerCase(), (CharSequence)"new_tripreimburse")) {
            log.info("contextMenuClick:new_tripreimburse");
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("formId", TRIP_REIMBURSE_BILL_GRID_MOB);
            paramMap.put("formName", ResManager.loadKDString((String)"\u5dee\u65c5\u62a5\u9500\u5355", (String)"GridTripReimburseBillMobList_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            paramMap.put("formType", "6");
            ShowPageUtils.showPage(paramMap, (AbstractFormPlugin)this);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        e.setCancel(true);
        BillShowParameter billShowParameter = e.getParameter();
        MobileListShowParameter mobparameter = (MobileListShowParameter)this.getView().getFormShowParameter();
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        Long billId = (Long)billShowParameter.getPkId();
        String formId = billShowParameter.getFormId();
        customParam.put("FormId", formId);
        customParam.put("Status", billShowParameter.getBillStatusValue());
        customParam.put("PageId", billShowParameter.getPageId());
        customParam.put("EntityName", this.getEntityName());
        customParam.put("MobileFormId", this.getFormIdByBillPkId(billId));
        customParam.put("billId", billId);
        billShowParameter.setPkId(null);
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setCustomParams(customParam);
        formShowParameter.setFormId("er_approvalrecord");
        formShowParameter.setCaption(FormMetadataCache.getFormConfig((String)formId).getCaption().getLocaleValue());
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        if (e.getParameter().getBillStatus() != BillOperationStatus.ADDNEW) {
            String billStatus = ((IListView)this.getView()).getCurrentSelectedRowInfo().getBillStatus();
            if (ErBillStatusEnum.C.toString().equals(billStatus) || ErBillStatusEnum.E.toString().equals(billStatus) || ErBillStatusEnum.F.toString().equals(billStatus) || ErBillStatusEnum.G.toString().equals(billStatus) || ErBillStatusEnum.H.toString().equals(billStatus) || ErBillStatusEnum.I.toString().equals(billStatus)) {
                e.getParameter().setBillStatus(BillOperationStatus.AUDIT);
            }
        }
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    @Override
    protected String getEntityName() {
        return "er_tripreimbursebill";
    }

    protected String getFormIdByBillPkId(Long billPkValue) {
        DynamicObject tripReimburseBillDO = BusinessDataServiceHelper.loadSingleFromCache((Object)billPkValue, (String)"er_tripreimbursebill", (String)"id, billkind");
        String billKind = tripReimburseBillDO.getString("billkind");
        String formId = "";
        formId = StringUtils.equals((CharSequence)billKind, (CharSequence)"0") ? "er_tripreimbursebill_mob" : TRIP_REIMBURSE_BILL_GRID_MOB;
        return formId;
    }

    private static String getAuditMsg() {
        return ResManager.loadKDString((String)"\u62a5\u9500\u4e2d", (String)"TripReimburseList_0", (String)"fi-er-formplugin", (Object[])new Object[0]);
    }

    private static String getCompleteMsg() {
        return ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"TripReimburseList_1", (String)"fi-er-formplugin", (Object[])new Object[0]);
    }

    static {
        stateInfoList.add(todoStateInfo);
        stateInfoList.add(didStateInfo);
    }
}

