/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile.tripstandard;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.tripstd.model.TripStandardDetail;
import kd.fi.er.business.tripstd.service.IErTripStdService;
import kd.fi.er.business.tripstd.service.imp.ErTripStdServiceImp;
import kd.fi.er.business.tripstd.service.imp.ErTripStdServiceProxy;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.TripHighSeasonStandardUtil;
import kd.fi.er.common.ControlMethodEnum;
import kd.fi.er.common.ErBillStatusEnum;
import kd.fi.er.common.constant.ErTripExpenseItemConstant;
import kd.fi.er.common.constant.formproperties.mainbill.trip.TripReimburseBill;
import kd.fi.er.common.enums.CreateAssignOtherNoEnum;
import kd.fi.er.common.type.SubsidiesDayParamEnum;
import kd.fi.er.formplugin.web.tripstandard.BeforeMulSeatgradeF7SelectListener;
import kd.fi.er.formplugin.web.tripstandard.util.PlaneSeatUtil;
import kd.fi.er.formplugin.web.tripstandard.util.TripStandardUtils;
import org.apache.commons.lang3.StringUtils;

public class TripStdDetailCtrlForGridStyleMobPlugin
extends AbstractMobBillPlugIn {
    private static Log logger = LogFactory.getLog(TripStdDetailCtrlForGridStyleMobPlugin.class);
    protected static final String TRIPSTD_SHOWSTR = "tripstdshowstr";
    protected static final String TRIPEXP_ATTRIBUTE = "attribute";
    private static String EXPENSE_ITEM_SUBSIDY = "1";
    protected static final String EXPENSE_ITEM_ACCOMMODATION = "5";
    protected static final String EXPENSE_ITEM_OTHER = "6";
    protected static final String[] ACCD_ALLOWANCE_ATTRIBUTE = new String[]{"5", "1"};
    protected static final String[] VEHIC_ATTRIBUTE = new String[]{"2", "4", "7"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit mulSeatGrade = (BasedataEdit)this.getView().getControl("mulseatgrade");
        if (mulSeatGrade != null) {
            mulSeatGrade.addBeforeF7SelectListener((BeforeF7SelectListener)new BeforeMulSeatgradeF7SelectListener("entryentity", "expenseitem"));
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter param = this.getView().getFormShowParameter();
        String billStatus = (String)this.getView().getParentView().getModel().getValue("billstatus");
        if (StringUtils.equalsAny((CharSequence)billStatus, (CharSequence[])new CharSequence[]{"A", "D"})) {
            Integer rowIndex = (Integer)param.getCustomParam("index");
            if (rowIndex == null || rowIndex == -1 || this.isNullRow(rowIndex)) {
                this.updateCalDayCount(0);
            }
            if (rowIndex != null && rowIndex != -1) {
                ActionLocalCache.get().put(CreateAssignOtherNoEnum.TRIPSTD_GRID_MOB.getVal(), (Object)true);
            }
            this.updateAllStd();
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection detailEntryCollction = dataEntity.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < detailEntryCollction.size(); ++i) {
                this.calcuHighSeasonDays(i, true);
            }
        }
    }

    public void beforeClick(BeforeClickEvent args) {
        super.beforeClick(args);
        Control source = (Control)args.getSource();
        String key = source.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"bar_save")) {
            IDataModel pModel = this.getView().getParentView().getModel();
            if (SystemParamterUtil.isOpenTripDateControl((Long)this.getCompanyId()) && !((Boolean)pModel.getValue("istravelers")).booleanValue() && ((Boolean)pModel.getValue("isopentripstd")).booleanValue()) {
                DynamicObjectCollection mainPageDetailEntry = ((DynamicObject)pModel.getDataEntity(true).getDynamicObjectCollection("tripentry").get(0)).getDynamicObjectCollection("entryentity");
                DynamicObject curDetailRow = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(0);
                if (!StringUtils.equals((CharSequence)ErTripExpenseItemConstant.Attribute.Subsidy.getValue(), (CharSequence)curDetailRow.getDynamicObject("expenseitem").getString(TRIPEXP_ATTRIBUTE))) {
                    return;
                }
                Integer index = (Integer)this.getView().getFormShowParameter().getCustomParam("index");
                String errRow = null;
                long curRowStartDate = curDetailRow.getDate("trip2startdate").getTime();
                if (index == null || index == -1) {
                    index = mainPageDetailEntry.size() - 1;
                }
                long expenseItemId = curDetailRow.getDynamicObject("expenseitem").getLong("id");
                Integer preIndex = null;
                for (int i = 0; i < mainPageDetailEntry.size(); ++i) {
                    DynamicObject row = (DynamicObject)mainPageDetailEntry.get(i);
                    if (index == i || row.getDynamicObject("expenseitem") == null || row.getDynamicObject("expenseitem").getLong("id") != expenseItemId || row.getDate("trip2startdate") == null || row.getDate("trip2enddate") == null || i >= index) continue;
                    preIndex = i;
                }
                if (preIndex != null && curRowStartDate < ((DynamicObject)mainPageDetailEntry.get(preIndex.intValue())).getDate("trip2enddate").getTime()) {
                    errRow = String.valueOf(preIndex + 1);
                }
                if (errRow != null) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s\u5df2\u5f00\u542f\u201c\u884c\u7a0b\u671f\u95f4\u63a7\u5236\u201d\u7cfb\u7edf\u53c2\u6570\u3002\u5f53\u524d\u660e\u7ec6\u884c\u4e0e\u7b2c %2$s \u660e\u7ec6\u884c\u7a0b\u65e5\u671f\u6709\u51b2\u7a81\uff0c \u8bf7\u91cd\u65b0\u8c03\u6574\u884c\u7a0b\u7684\u884c\u7a0b\u65e5\u671f\u3002", (String)"TripStdDetailCtrlForGridStyleMobPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]), ((DynamicObject)this.getModel().getValue("company")).getString("name"), errRow));
                    args.setCancel(true);
                }
            }
        }
    }

    private void setCalDayCountByDayCount(DynamicObject entry, int detailEntryIndex) {
        int tripDayCount = entry.getInt("daycount");
        BigDecimal stdDayCount = entry.getBigDecimal("caldaycount");
        if (tripDayCount != 0 && BigDecimal.ZERO.compareTo(stdDayCount) == 0) {
            this.updateCalDayCount(tripDayCount, detailEntryIndex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (propName) {
            case "trip2to": {
                Long companyId = this.getCompanyId();
                DynamicObject oldTripArea = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(rowIndex)).getDynamicObject("triparea");
                Object oldPkValue = oldTripArea == null ? null : oldTripArea.getPkValue();
                this.setTripArea(rowIndex, newValue, companyId, oldPkValue);
                break;
            }
            case "daycount": {
                int dayCount = newValue == null ? 0 : (Integer)newValue;
                break;
            }
            case "expenseitem": {
                this.getModel().beginInit();
                PlaneSeatUtil.refreshSeatGradeByTripExpItemChange((IFormView)this.getView(), (Object)oldValue, (Object)newValue, (int)rowIndex);
                this.updateCalDayCount(rowIndex);
                this.getView().updateView("mulseatgrade", rowIndex);
                this.getView().updateView("caldaycount", rowIndex);
                this.getModel().endInit();
                DynamicObject expenseItemDO = (DynamicObject)newValue;
                if ("0".equals(ErCommonUtils.getEMParameter((long)OrgUnitServiceHelper.getRootOrgId(), (String)"expenseitemchange")) && (null == expenseItemDO || EXPENSE_ITEM_OTHER.equals(expenseItemDO.getString(TRIPEXP_ATTRIBUTE)))) {
                    this.getModel().setValue("trip2from", null, rowIndex);
                    this.getModel().setValue("trip2to", null, rowIndex);
                    this.getModel().setValue("trip2startdate", null, rowIndex);
                    this.getModel().setValue("trip2enddate", null, rowIndex);
                }
                this.calcuHighSeasonDays(rowIndex, false);
                this.entryPropertyUpdateStd(rowIndex);
                break;
            }
            case "entrycurrency": {
                this.entryPropertyUpdateStd(rowIndex);
                break;
            }
            case "triparea": {
                this.calcuHighSeasonDays(rowIndex, false);
                this.entryPropertyUpdateStd(rowIndex);
                break;
            }
            case "trip2travelers": {
                this.entryPropertyUpdateStd(rowIndex);
                break;
            }
            case "caldaycount": {
                boolean caldaycountchange;
                BigDecimal calDayCount = this.calDayCount(rowIndex);
                if (((BigDecimal)newValue).compareTo(calDayCount) > 0 && !(caldaycountchange = SystemParamterUtil.isCalDayCountChange((Long)this.getCompanyId()))) {
                    this.getModel().setValue("caldaycount", oldValue, rowIndex);
                    return;
                }
                this.getModel().beginInit();
                if (TripHighSeasonStandardUtil.checkAndSetHighSeasonDay((IDataModel)this.getModel(), (int)rowIndex)) {
                    this.getView().updateView("highseasondaycount", rowIndex);
                }
                this.getModel().endInit();
                boolean flag = this.calculateAllowanceAndSet(rowIndex);
                this.getView().updateView("orientryamount", rowIndex);
                if (this.validateIsOverMaxCalDayCount(newValue, rowIndex) || flag) break;
                this.checkEntryStdIsOver(rowIndex);
                break;
            }
            case "mulseatgrade": 
            case "orientryamount": {
                this.checkEntryStdIsOver(rowIndex);
                break;
            }
            case "trip2startdate": 
            case "trip2enddate": {
                DynamicObjectCollection detailEntryCollction = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                int tripDayCount = ((DynamicObject)detailEntryCollction.get(rowIndex)).getInt("daycount");
                this.updateCalDayCount(tripDayCount, rowIndex);
                this.calcuHighSeasonDays(rowIndex, false);
                break;
            }
            case "highseasondaycount": {
                if (TripHighSeasonStandardUtil.checkAndSetHighSeasonDays((IFormView)this.getView(), (IDataModel)this.getModel(), (int)rowIndex, (BigDecimal)((BigDecimal)oldValue))) {
                    this.getView().updateView("highseasondaycount", rowIndex);
                }
                if (!this.isOpenHighSeasonStd() || !this.calculateAllowanceAndSet(rowIndex)) {
                    this.checkEntryStdIsOver(rowIndex);
                }
                this.getView().updateView("orientryamount", rowIndex);
                break;
            }
            case "isover": {
                if (!"0".equals(newValue)) break;
                this.getModel().setValue("overdesc", (Object)"", rowIndex);
            }
        }
    }

    protected void calcuHighSeasonDays(int curEntryIndex, boolean init) {
        if (!this.isOpenHighSeasonStd()) {
            return;
        }
        DynamicObject detail = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(curEntryIndex);
        DynamicObject area = detail.getDynamicObject("triparea");
        Date begin = detail.getDate("trip2startdate");
        Date end = detail.getDate("trip2enddate");
        DynamicObject expenseitem = detail.getDynamicObject("expenseitem");
        if (area != null && begin != null && end != null) {
            boolean oldHighSeason = (Boolean)this.getModel().getValue("highseason", curEntryIndex);
            BigDecimal highSeasonDays = BigDecimal.ZERO;
            if (expenseitem != null && Arrays.asList(ACCD_ALLOWANCE_ATTRIBUTE).contains(expenseitem.getString(TRIPEXP_ATTRIBUTE))) {
                DynamicObject preRow;
                Date preRowEndDate = null;
                if (this.isOpenTripDateControl() && (preRow = this.findPreRow(expenseitem, false)) != null) {
                    preRowEndDate = preRow.getDate("trip2enddate");
                }
                TripReimburseBill.objectThreadLocal.set(false);
                highSeasonDays = TripHighSeasonStandardUtil.getHighSeasonDays((Long)this.getCompanyId(), (Date)preRowEndDate, (Date)begin, (Date)end, (DynamicObject)area, (DynamicObject)expenseitem, (boolean)this.isOpenTripDateControl());
            }
            boolean isHighSeason = false;
            if (highSeasonDays != null && highSeasonDays.compareTo(BigDecimal.ZERO) > 0 || TripReimburseBill.objectThreadLocal.get() != null && ((Boolean)TripReimburseBill.objectThreadLocal.get()).booleanValue()) {
                isHighSeason = true;
            }
            TripReimburseBill.objectThreadLocal.remove();
            this.getModel().setValue("highseason", (Object)(isHighSeason ? "1" : "0"), curEntryIndex);
            if (!isHighSeason) {
                this.getModel().setValue("highseasondaycount", (Object)BigDecimal.ZERO, curEntryIndex);
                this.getModel().setValue("originhighseasondays", (Object)BigDecimal.ZERO, curEntryIndex);
            }
            if (!oldHighSeason && isHighSeason && init || !init || !isHighSeason) {
                this.getModel().setValue("highseasondaycount", (Object)highSeasonDays, curEntryIndex);
                this.getModel().setValue("originhighseasondays", (Object)highSeasonDays, curEntryIndex);
            }
            this.getView().updateView("highseasondaycount", curEntryIndex);
        }
    }

    private void setTripArea(int rowIndex, Object to, Long companyId, Object oldValuePk) {
        if (to == null) {
            this.getModel().setValue("triparea", null, rowIndex);
            return;
        }
        Long toCityId = (Long)((DynamicObject)to).getPkValue();
        ErTripStdServiceImp stdService = new ErTripStdServiceImp();
        String orgType = ErCommonUtils.getTripAreaOrgType();
        DynamicObject org = this.getModel().getDataEntity(true).getDynamicObject(orgType);
        DynamicObject tripArea = stdService.getTripAreaByCityIdAndCompanyId(toCityId, ErCommonUtils.getPk((Object)org));
        if (tripArea != null) {
            if (oldValuePk == null || oldValuePk != null && !tripArea.equals(oldValuePk)) {
                this.getModel().setValue("triparea", tripArea.getPkValue(), rowIndex);
            } else {
                this.getModel().setValue("triparea", null, rowIndex);
            }
        } else {
            this.getModel().setValue("triparea", null, rowIndex);
        }
    }

    private void updateCalDayCount(int curEntryIndex) {
        DynamicObject detailEntry = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(curEntryIndex);
        Long dayCount = CommonServiceHelper.calcDays((Date)detailEntry.getDate("trip2startdate"), (Date)detailEntry.getDate("trip2enddate"));
        this.updateCalDayCount(dayCount.intValue(), curEntryIndex);
    }

    private boolean validateIsOverMaxCalDayCount(Object newValue, int tripDetailRowIndex) {
        int dayCount;
        int maxDayCount;
        DynamicObject detailEntry;
        DynamicObject tripExpItem;
        DynamicObjectCollection detailEntryColl;
        boolean isOverMax = false;
        Long companyId = this.getCompanyId();
        SubsidiesDayParamEnum subsidiesDaysCalculationType = SystemParamterUtil.getSubsidiesDaysCalculationType((long)companyId);
        boolean caldaycountchange = SystemParamterUtil.isCalDayCountChange((Long)companyId);
        if (subsidiesDaysCalculationType == SubsidiesDayParamEnum.ADD_ONE_CONTROL && !caldaycountchange && (detailEntryColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity")).size() > tripDetailRowIndex && (tripExpItem = (detailEntry = (DynamicObject)detailEntryColl.get(tripDetailRowIndex)).getDynamicObject("expenseitem")) != null && tripExpItem.getString(TRIPEXP_ATTRIBUTE).equals(EXPENSE_ITEM_SUBSIDY) && ((BigDecimal)newValue).compareTo(BigDecimal.valueOf(maxDayCount = (dayCount = detailEntry.getInt("daycount")) + 1)) > 0) {
            isOverMax = true;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5c5e\u6027\u4e3a\u8865\u52a9\u7684\u5dee\u65c5\u660e\u7ec6\u6807\u51c6\u5929\u6570\u4e0d\u5141\u8bb8\u6539\u5927\u3002", (String)"TripStdDetailCtrlForGridStyleMobPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            this.updateCalDayCount(dayCount, tripDetailRowIndex);
        }
        return isOverMax;
    }

    private void updateCalDayCount(int dayCount, int curEntryIndex) {
        BigDecimal oldCalDayCount;
        String attributeType;
        if (!this.isOpenTripStd()) {
            return;
        }
        DynamicObject detailEntry = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(curEntryIndex);
        DynamicObject tripExp = detailEntry.getDynamicObject("expenseitem");
        BigDecimal caldaycount = new BigDecimal(dayCount);
        if (tripExp != null && StringUtils.equals((CharSequence)EXPENSE_ITEM_SUBSIDY, (CharSequence)(attributeType = tripExp.getString(TRIPEXP_ATTRIBUTE)))) {
            BigDecimal tripDailyDay = this.getTripDailyDay();
            caldaycount = caldaycount.add(tripDailyDay);
        }
        if ((oldCalDayCount = detailEntry.getBigDecimal("caldaycount")).compareTo(caldaycount) != 0) {
            this.getModel().setValue("caldaycount", (Object)caldaycount, curEntryIndex);
        }
    }

    private void entryPropertyUpdateStd(int curEntryIndex) {
        boolean isOpenTripStd = this.isOpenTripStd();
        if (!isOpenTripStd) {
            return;
        }
        IErTripStdService tripStdService = new ErTripStdServiceProxy((IErTripStdService)new ErTripStdServiceImp(), this.getModel().getDataEntity()).getInstance();
        DynamicObject detailEntry = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(curEntryIndex);
        if (this.isControlEntryStd(detailEntry, curEntryIndex)) {
            this.entryPropertyUpdateStd(tripStdService, detailEntry, curEntryIndex);
        }
    }

    private void entryPropertyUpdateStd(IErTripStdService tripStdService, DynamicObject entry, int curEntryIndex) {
        Long companyId = this.getCompanyId();
        DynamicObject tripExpenseItem = entry.getDynamicObject("expenseitem");
        if (tripExpenseItem == null) {
            return;
        }
        String attribute = tripExpenseItem.getString(TRIPEXP_ATTRIBUTE);
        IDataModel model = this.getModel();
        String billstatus = (String)model.getValue("billstatus");
        if (!ErBillStatusEnum.A.name().equals(billstatus) && !ErBillStatusEnum.D.name().equals(billstatus)) {
            this.setTripStdShowInfo(entry, attribute, curEntryIndex);
            return;
        }
        Set userSet = entry.getDynamicObjectCollection("trip2travelers").stream().filter(traveler -> traveler.get("fbasedataid") != null).map(traveler -> traveler.getLong("fbasedataid_id")).collect(Collectors.toSet());
        if (userSet.isEmpty()) {
            return;
        }
        List<Long> userList = userSet.stream().collect(Collectors.toList());
        if (Arrays.asList(ACCD_ALLOWANCE_ATTRIBUTE).contains(attribute)) {
            ControlMethodEnum tripStandCtrTypeEnum = SystemParamterUtil.getTripStandardControlLevel((long)companyId);
            String mulTraStdCtrType = SystemParamterUtil.getMultiTravelerStdControlType((long)companyId);
            this.updateAccdAndAllowanceStd(userList, tripStandCtrTypeEnum, mulTraStdCtrType, tripStdService, entry, tripExpenseItem, curEntryIndex);
        } else if (Arrays.asList(VEHIC_ATTRIBUTE).contains(attribute)) {
            ControlMethodEnum tripStandCtrTypeEnum = SystemParamterUtil.getVehicleStdControlLevel((long)companyId);
            this.updateTripVehicStd(userList, companyId, tripStandCtrTypeEnum, attribute, entry, curEntryIndex);
        } else {
            TripStandardUtils.resetStdDetail((IDataModel)this.getModel(), (int)curEntryIndex, (int)-1);
        }
        this.checkEntryStdIsOver(entry, attribute, curEntryIndex);
    }

    protected boolean checkEntryStdIsOver(int curEntryIndex) {
        DynamicObject detailEntry = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(curEntryIndex);
        DynamicObject tripExpenseItem = detailEntry.getDynamicObject("expenseitem");
        if (tripExpenseItem != null && (this.isOpenAccdAndAllowanceStd() || this.isOpenVehicStd())) {
            String attribute = tripExpenseItem.getString(TRIPEXP_ATTRIBUTE);
            return this.checkEntryStdIsOver(detailEntry, attribute, curEntryIndex);
        }
        return false;
    }

    protected boolean checkEntryStdIsOver(DynamicObject entry, String attribute, int curEntryIndex) {
        boolean isOverStd = false;
        if (Arrays.asList(ACCD_ALLOWANCE_ATTRIBUTE).contains(attribute) && this.isOpenAccdAndAllowanceStd()) {
            BigDecimal oriEntryAmount = entry.getBigDecimal("orientryamount");
            boolean userOutStdCtrl = entry.getBoolean("useroutstdctrl");
            BigDecimal oriMaxStdAmount = TripHighSeasonStandardUtil.getStandardamountTotal((boolean)this.isOpenHighSeasonStd(), (DynamicObject)entry);
            if (!userOutStdCtrl && oriEntryAmount.compareTo(oriMaxStdAmount) > 0) {
                this.getModel().setValue("tripstdsumupover", (Object)Boolean.TRUE, curEntryIndex);
                isOverStd = true;
            } else {
                this.getModel().setValue("tripstdsumupover", (Object)Boolean.FALSE, curEntryIndex);
            }
            if (userOutStdCtrl) {
                TripStandardUtils.resetStdDetail((IDataModel)this.getModel(), (int)curEntryIndex, (int)-1);
            }
        } else if (Arrays.asList(VEHIC_ATTRIBUTE).contains(attribute) && this.isOpenVehicStd()) {
            DynamicObjectCollection entrySeatGrade = entry.getDynamicObjectCollection("mulseatgrade");
            DynamicObjectCollection seatGradeStd = entry.getDynamicObjectCollection("stdseatgrade");
            isOverStd = TripStandardUtils.isOverVhcStd((DynamicObjectCollection)entrySeatGrade, (DynamicObjectCollection)seatGradeStd);
            this.getModel().setValue("isovervhcstd", (Object)isOverStd, curEntryIndex);
        }
        String isOver = isOverStd ? "1" : "0";
        this.getModel().setValue("isover", (Object)isOver, curEntryIndex);
        this.setTripStdShowInfo(entry, attribute, curEntryIndex);
        return isOverStd;
    }

    private void updateAccdAndAllowanceStd(List<Long> userIds, ControlMethodEnum controlMethodEnum, String mulTraStdCtrType, IErTripStdService tripStdService, DynamicObject entry, DynamicObject tripExpenseItem, int curEntryIndex) {
        IDataModel model = this.getModel();
        model.setValue("controlmethod", (Object)controlMethodEnum.getValue(), curEntryIndex);
        if (entry.getBoolean("isovervhcstd")) {
            model.setValue("isovervhcstd", (Object)Boolean.FALSE, curEntryIndex);
        }
        DynamicObject entryCurrency = this.getEntryCurrency(entry);
        DynamicObject tripArea = entry.getDynamicObject("triparea");
        TripStandardDetail tripStdDetail = null;
        if (entryCurrency != null && tripArea != null) {
            List tripStdDetailList = TripStandardUtils.getAccmodationStdFromPageCache(userIds, (AbstractFormPlugin)this, (String)mulTraStdCtrType, (Object)entryCurrency.getPkValue(), (Object)tripArea.getPkValue(), (DynamicObject)entry.getDynamicObject("expenseitem"), this.getExtMap(entry, -1, curEntryIndex));
            tripStdDetail = tripStdDetailList == null || tripStdDetailList.isEmpty() ? null : (TripStandardDetail)tripStdDetailList.get(0);
        }
        BigDecimal tripSTDAmount = tripStdDetail == null ? BigDecimal.ZERO : tripStdDetail.getStandardamount();
        BigDecimal highSeasonAmount = tripStdDetail == null ? BigDecimal.ZERO : tripStdDetail.getHighSeasonStandardamount();
        Boolean userOutStdCtrl = tripStdDetail == null ? Boolean.FALSE : tripStdDetail.getUserOutStdCtrl();
        String attribute = tripExpenseItem.getString(TRIPEXP_ATTRIBUTE);
        if (EXPENSE_ITEM_ACCOMMODATION.equals(attribute) && "max".equals(mulTraStdCtrType)) {
            tripSTDAmount = tripSTDAmount.multiply(BigDecimal.valueOf(userIds.size()));
            highSeasonAmount = highSeasonAmount.multiply(BigDecimal.valueOf(userIds.size()));
        }
        model.setValue("tripstandardamount", (Object)tripSTDAmount, curEntryIndex);
        model.setValue("hightripstandardamount", (Object)highSeasonAmount, curEntryIndex);
        BigDecimal caldaycount = entry.getBigDecimal("caldaycount");
        String ctrltype = tripExpenseItem.getString("ctrltype");
        BigDecimal oriMaxStdAmount = TripHighSeasonStandardUtil.getStandardamountTotal((boolean)this.isOpenHighSeasonStd(), (DynamicObject)((DynamicObject)model.getDataEntity(true).getDynamicObjectCollection("entryentity").get(curEntryIndex)));
        Boolean tripstdGridMob = (Boolean)ActionLocalCache.get().getDefaultIfNull(CreateAssignOtherNoEnum.TRIPSTD_GRID_MOB.getVal(), (Object)false);
        if (!userOutStdCtrl.booleanValue() && (StringUtils.equals((CharSequence)ctrltype, (CharSequence)"1") || StringUtils.equals((CharSequence)ctrltype, (CharSequence)"3")) && StringUtils.equals((CharSequence)EXPENSE_ITEM_SUBSIDY, (CharSequence)attribute) && !tripstdGridMob.booleanValue()) {
            this.getModel().setValue("orientryamount", (Object)oriMaxStdAmount, curEntryIndex);
        }
        model.setValue("isovervhcstd", (Object)Boolean.FALSE, curEntryIndex);
        model.setValue("useroutstdctrl", (Object)userOutStdCtrl, curEntryIndex);
        TripStandardUtils.setStdDetail((IDataModel)this.getModel(), (TripStandardDetail)tripStdDetail, (int)curEntryIndex, (int)-1);
    }

    protected DynamicObject getEntryCurrency(DynamicObject entry) {
        return entry.getDynamicObject("entrycurrency");
    }

    private void updateTripVehicStd(List<Long> userList, Long companyId, ControlMethodEnum tripStandCtrTypeEnum, String attribute, DynamicObject entry, int curEntryIndex) {
        IDataModel model = this.getModel();
        if (entry.getBoolean("tripstdsumupover")) {
            model.setValue("tripstdsumupover", (Object)Boolean.FALSE, curEntryIndex);
        }
        DynamicObjectCollection stdSeatGradeColl = entry.getDynamicObjectCollection("stdseatgrade");
        stdSeatGradeColl.clear();
        HashMap map = this.getExtMap(entry, -1, curEntryIndex);
        map = map == null ? new HashMap(4) : map;
        Map seatGradeStd = TripStandardUtils.getVhcSeatGradeStd(userList, (Long)companyId, (String)attribute, (IPageCache)this.getPageCache(), (AbstractFormPlugin)this, map);
        if (!seatGradeStd.isEmpty()) {
            for (Map.Entry seatGrade : seatGradeStd.entrySet()) {
                DynamicObject entrySeatGrade = stdSeatGradeColl.addNew();
                entrySeatGrade.set("fbasedataid", seatGrade.getValue());
            }
        }
        model.setValue("controlmethod", (Object)tripStandCtrTypeEnum.getValue(), curEntryIndex);
        if (entry.getBoolean("tripstdsumupover")) {
            model.setValue("tripstdsumupover", (Object)Boolean.FALSE, curEntryIndex);
        }
        TripStandardUtils.setStdDetail((IDataModel)this.getModel(), map, (int)curEntryIndex, (int)-1);
    }

    protected Map<String, Object> getExtMap(DynamicObject entry, int parentEntryIndex, int curEntryIndex) {
        return TripStandardUtils.buildExtMap((IFormView)this.getView(), (DynamicObject)entry, (int)parentEntryIndex, (int)curEntryIndex);
    }

    private void updateAllStd() {
        boolean isOpenTripStd = this.isOpenTripStd();
        if (isOpenTripStd) {
            IErTripStdService tripStdService = new ErTripStdServiceProxy((IErTripStdService)new ErTripStdServiceImp(), this.getModel().getDataEntity()).getInstance();
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection detailEntryCollction = dataEntity.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < detailEntryCollction.size(); ++i) {
                DynamicObject detailEntry = (DynamicObject)detailEntryCollction.get(i);
                this.setCalDayCountByDayCount(detailEntry, i);
                if (!this.isControlEntryStd(detailEntry, i)) continue;
                this.entryPropertyUpdateStd(tripStdService, detailEntry, i);
            }
        }
    }

    private void setTripStdShowInfo(DynamicObject entry, String attribute, int curEntryIndex) {
        this.getModel().setValue(TRIPSTD_SHOWSTR, (Object)TripStandardUtils.getTripStdShowInfoByDetailEntry((DynamicObject)entry, (String)attribute), curEntryIndex);
        this.getModel().setValue("highseasontripstdshow", (Object)TripStandardUtils.getTripStdShowInfoByDetailEntry(null, (DynamicObject)entry, (String)attribute, (String)"hightripstandardamount"), curEntryIndex);
    }

    private boolean isControlEntryStd(DynamicObject entry, int detailEntryIndex) {
        boolean isNeed = true;
        DynamicObject tripExpenseItem = entry.getDynamicObject("expenseitem");
        if (tripExpenseItem != null) {
            String attribute = tripExpenseItem.getString(TRIPEXP_ATTRIBUTE);
            isNeed = Arrays.asList(ACCD_ALLOWANCE_ATTRIBUTE).contains(attribute) ? isNeed && this.isOpenAccdAndAllowanceStd() : (Arrays.asList(VEHIC_ATTRIBUTE).contains(attribute) ? isNeed && this.isOpenVehicStd() : false);
            if (!Arrays.asList(ACCD_ALLOWANCE_ATTRIBUTE).contains(attribute)) {
                this.getModel().setValue("highseasondaycount", (Object)BigDecimal.ZERO, detailEntryIndex);
            }
        }
        if (!isNeed) {
            this.clearEntryStd(entry, detailEntryIndex);
        }
        return isNeed;
    }

    private void clearEntryStd(DynamicObject entry, int detailEntryIndex) {
        DynamicObjectCollection seatGrade;
        IDataModel model = this.getModel();
        if (entry.getBoolean("isovervhcstd")) {
            model.setValue("isovervhcstd", (Object)Boolean.FALSE, detailEntryIndex);
        }
        if (entry.getBigDecimal("tripstandardamount").compareTo(BigDecimal.ZERO) > 0) {
            model.setValue("tripstandardamount", (Object)BigDecimal.ZERO, detailEntryIndex);
        }
        if ((seatGrade = entry.getDynamicObjectCollection("stdseatgrade")) != null && seatGrade.size() > 0) {
            model.setValue("stdseatgrade", null, detailEntryIndex);
        }
        if (entry.getBoolean("tripstdsumupover")) {
            model.setValue("tripstdsumupover", (Object)Boolean.FALSE, detailEntryIndex);
        }
        if (entry.getBoolean("isover")) {
            model.setValue("isover", (Object)"0", detailEntryIndex);
        }
        if (StringUtils.isNotEmpty((CharSequence)entry.getString(TRIPSTD_SHOWSTR))) {
            model.setValue(TRIPSTD_SHOWSTR, null, detailEntryIndex);
        }
    }

    private boolean isOpenTripStd() {
        return this.getModel().getDataEntity(true).getBoolean("isopentripstd");
    }

    private Long getCompanyId() {
        DynamicObject company = this.getModel().getDataEntity(true).getDynamicObject("company");
        Long companyId = company == null ? Long.valueOf(0L) : (Long)company.getPkValue();
        return companyId;
    }

    protected boolean isOpenAccdAndAllowanceStd() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        return dataEntity.getBoolean("isopentripstd") && dataEntity.getBoolean("tripstandcon");
    }

    protected boolean isOpenHighSeasonStd() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        return this.isOpenAccdAndAllowanceStd() && dataEntity.getBoolean("isopenhighseasontripstd");
    }

    protected boolean isOpenVehicStd() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        return dataEntity.getBoolean("isopentripstd") && dataEntity.getBoolean("isnoctrltripvhcctrlv");
    }

    protected boolean calculateAllowanceAndSet(int rowIndex) {
        DynamicObject entry = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(rowIndex);
        if (!this.isOpenAccdAndAllowanceStd()) {
            return false;
        }
        DynamicObject tripExpenseItem = entry.getDynamicObject("expenseitem");
        if (tripExpenseItem == null) {
            return false;
        }
        String attribute = tripExpenseItem.getString(TRIPEXP_ATTRIBUTE);
        boolean userOutStdCtrl = entry.getBoolean("useroutstdctrl");
        String ctrltype = tripExpenseItem.getString("ctrltype");
        BigDecimal oriMaxStdAmount = TripHighSeasonStandardUtil.getStandardamountTotal((boolean)this.isOpenHighSeasonStd(), (DynamicObject)entry);
        if ((StringUtils.equals((CharSequence)ctrltype, (CharSequence)"1") || StringUtils.equals((CharSequence)ctrltype, (CharSequence)"3")) && StringUtils.equals((CharSequence)EXPENSE_ITEM_SUBSIDY, (CharSequence)attribute) && !userOutStdCtrl && oriMaxStdAmount.compareTo((BigDecimal)this.getModel().getValue("orientryamount")) != 0) {
            this.getModel().setValue("orientryamount", (Object)oriMaxStdAmount, rowIndex);
            return true;
        }
        return false;
    }

    private BigDecimal getTripDailyDay() {
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(0);
        if (dynamicObject != null && (dynamicObject.get("trip2startdate") == null || dynamicObject.get("trip2enddate") == null)) {
            return BigDecimal.ZERO;
        }
        if (!this.isOpenTripDateControl()) {
            return TripHighSeasonStandardUtil.getDelayDay((Long)this.getCompanyId());
        }
        DynamicObject curRow = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(0);
        if (!StringUtils.equals((CharSequence)ErTripExpenseItemConstant.Attribute.Subsidy.getValue(), (CharSequence)curRow.getDynamicObject("expenseitem").getString(TRIPEXP_ATTRIBUTE))) {
            return BigDecimal.ZERO;
        }
        DynamicObject preRow = this.findPreRow(curRow.getDynamicObject("expenseitem"), true);
        if (preRow == null) {
            return TripHighSeasonStandardUtil.getDelayDay((Long)this.getCompanyId());
        }
        return BigDecimal.ZERO;
    }

    private boolean isOpenTripDateControl() {
        return SystemParamterUtil.isOpenTripDateControl((Long)this.getCompanyId()) && ((Boolean)this.getModel().getValue("istravelers") == false || (Boolean)this.getModel().getValue("istravelers") != false && (Boolean)this.getModel().getValue("travelerssamestd") != false) && (Boolean)this.getModel().getValue("isopentripstd") != false;
    }

    private DynamicObject findPreRow(DynamicObject expenseItem, boolean bo) {
        DynamicObjectCollection detailEntry = ((DynamicObject)this.getView().getParentView().getModel().getDataEntity(true).getDynamicObjectCollection("tripentry").get(0)).getDynamicObjectCollection("entryentity");
        Integer index = (Integer)this.getView().getFormShowParameter().getCustomParam("index");
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(0);
        int curIndex = index == null || index == -1 ? detailEntry.size() : index.intValue();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        List preIndexs = IntStream.range(0, detailEntry.size()).filter(idx -> {
            try {
                return idx < curIndex && ((DynamicObject)detailEntry.get(idx)).getDynamicObject("expenseitem") != null && ErCommonUtils.getPk((Object)expenseItem).longValue() == ErCommonUtils.getPk((Object)((DynamicObject)detailEntry.get(idx)).getDynamicObject("expenseitem")).longValue() && ((DynamicObject)detailEntry.get(idx)).getDate("trip2startdate") != null && ((DynamicObject)detailEntry.get(idx)).getDate("trip2enddate") != null && (!bo || simpleDateFormat.parse(simpleDateFormat.format(((DynamicObject)detailEntry.get(idx)).getDate("trip2enddate"))).compareTo(simpleDateFormat.parse(simpleDateFormat.format(dynamicObject.getDate("trip2startdate")))) >= 0);
            }
            catch (ParseException e) {
                e.printStackTrace();
                logger.error((Throwable)e);
                return false;
            }
        }).boxed().collect(Collectors.toList());
        return preIndexs.isEmpty() ? null : (DynamicObject)detailEntry.get(((Integer)preIndexs.get(preIndexs.size() - 1)).intValue());
    }

    private boolean isNullRow(int rowIndex) {
        IDataModel model = this.getView().getParentView().getModel();
        return model.getValue("trip2from", rowIndex, 0) == null || model.getValue("trip2to", rowIndex, 0) == null || model.getValue("trip2startdate", rowIndex, 0) == null || model.getValue("trip2enddate", rowIndex, 0) == null;
    }

    private BigDecimal calDayCount(int index) {
        String attributeType;
        DynamicObject tripExp;
        DynamicObject detailEntry = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(index);
        Long dayCount = CommonServiceHelper.calcDays((Date)detailEntry.getDate("trip2startdate"), (Date)detailEntry.getDate("trip2enddate"));
        BigDecimal calDayCount = new BigDecimal(dayCount);
        boolean isOpenAccdAndAllowanceStd = this.isOpenAccdAndAllowanceStd();
        if (isOpenAccdAndAllowanceStd && (tripExp = detailEntry.getDynamicObject("expenseitem")) != null && StringUtils.equals((CharSequence)EXPENSE_ITEM_SUBSIDY, (CharSequence)(attributeType = tripExp.getString(TRIPEXP_ATTRIBUTE)))) {
            calDayCount = calDayCount.add(this.getTripDailyDay());
        }
        return calDayCount;
    }
}

