/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.pool;

import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class ExpensePoolBillListPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(ExpensePoolBillListPlugin.class);
    private static final String ER_EXPENSE_RECORDBILL = "er_expense_recordbill";
    private static final String ER_TRIP_RECORDBILL = "er_trip_recordbill";
    private static final String CREATE_BILL_ACTION = "CREATE_BILL_ACTION";

    public void registerListener(EventObject e) {
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "er_expense_recordbill": {
                this.showForm(ER_EXPENSE_RECORDBILL);
                break;
            }
            case "er_trip_recordbill": {
                this.showForm(ER_TRIP_RECORDBILL);
                break;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        HyperLinkClickEvent hyperLinkClickEvent = args.getHyperLinkClickEvent();
        if ("targetbillno".equals(hyperLinkClickEvent.getFieldName())) {
            args.setCancel(true);
            OperateOption operateOption = OperateOption.create();
            this.getView().invokeOperation("trackdown", operateOption);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    private void showForm(String formId) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId(formId);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CREATE_BILL_ACTION));
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)CREATE_BILL_ACTION)) {
            this.getView().invokeOperation("refresh");
        }
    }
}

