/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.pool;

import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.model.ChangeField;
import org.apache.commons.lang3.StringUtils;

public class PoolToExpenseBillPlugin
extends AbstractBillPlugIn {
    private static final Log logger = LogFactory.getLog(PoolToExpenseBillPlugin.class);
    private static final String OTHER_TRIP_ITEM = "6";
    private static final String STAY_TRIP_ITEM = "5";

    public void afterBindData(EventObject e) {
        IDataModel model = this.getView().getModel();
        String sourceFormId = CommonServiceHelper.getParentViewFormId((IFormView)this.getView());
        if (this.getModel().getDataEntity().getDataEntityState().isPushChanged() && StringUtils.equals((CharSequence)sourceFormId, (CharSequence)"er_expense_recordbill")) {
            DynamicObjectCollection tripentryCollection = model.getEntryEntity("tripentry");
            Object company = this.getModel().getValue("company");
            Object costCompany = this.getModel().getValue("costcompany");
            Long currency = ErCommonUtils.getPk((Object)this.getModel().getValue("currency"));
            logger.info("\u5f00\u59cb\u5faa\u73af");
            for (int i = 0; i < tripentryCollection.size(); ++i) {
                DynamicObject tripEntry = (DynamicObject)tripentryCollection.get(i);
                DynamicObjectCollection entryentity = tripEntry.getDynamicObjectCollection("entryentity");
                if (entryentity.isEmpty()) continue;
                boolean isPool = entryentity.stream().anyMatch(v -> v.getLong("wbsrcbillid") > 0L);
                if (!isPool) {
                    return;
                }
                entryentity.sort((u, v) -> {
                    Date uCreateTime = u.getDate("trip2startdate");
                    Date vCreateTime = v.getDate("trip2startdate");
                    if (uCreateTime != null && vCreateTime != null) {
                        return uCreateTime.compareTo(vCreateTime);
                    }
                    if (uCreateTime == null) {
                        return 1;
                    }
                    return -1;
                });
                Long tripCurrency = ErCommonUtils.getPk((Object)tripEntry.getDynamicObject("tripcurrency"));
                Map exchangeRateAndQuoteType = CommonServiceHelper.getExchangeRateFromSysParams((Object)company, (Object)costCompany, (Long)tripCurrency, (Long)currency, (Object)model);
                model.setValue("tripexchangerate", exchangeRateAndQuoteType.get("exchangeRate"), i);
                model.setValue("tripquotetype", exchangeRateAndQuoteType.get("quoteType"), i);
                Date checkindate = null;
                for (int j = 0; j < entryentity.size(); ++j) {
                    String attribute;
                    DynamicObject tripItem = (DynamicObject)entryentity.get(j);
                    if (checkindate == null) {
                        checkindate = tripItem.getDate("checkindate");
                    }
                    Long srcBillId = tripItem.getLong("wbsrcbillid");
                    DynamicObject expenseItem = tripItem.getDynamicObject("expenseitem");
                    if (srcBillId > 0L && expenseItem == null || !StringUtils.equals((CharSequence)STAY_TRIP_ITEM, (CharSequence)(attribute = expenseItem.getString("attribute")))) continue;
                    checkindate = tripItem.getDate("checkindate");
                    break;
                }
                Date checkoutdate = null;
                for (int j = entryentity.size() - 1; j >= 0; --j) {
                    DynamicObject tripItem = (DynamicObject)entryentity.get(j);
                    if (checkoutdate == null) {
                        checkoutdate = tripItem.getDate("checkoutdate");
                    }
                    Long srcBillId = tripItem.getLong("wbsrcbillid");
                    DynamicObject expenseItem = tripItem.getDynamicObject("expenseitem");
                    if (srcBillId > 0L && expenseItem != null) continue;
                }
                if (checkindate != null) {
                    model.setValue("startdate", (Object)checkindate, i);
                }
                if (checkoutdate != null) {
                    model.setValue("enddate", checkoutdate, i);
                }
                Date startdate = tripEntry.getDate("startdate");
                Date enddate = tripEntry.getDate("enddate");
                int betweenDay = this.getBetweenDays(startdate, enddate);
                model.setValue("tripday", (Object)betweenDay, i);
                StringBuilder sb = new StringBuilder(",");
                HashSet<String> vehiclesSet = new HashSet<String>();
                for (int k = 0; k < entryentity.size(); ++k) {
                    DynamicObject entity = (DynamicObject)entryentity.get(k);
                    Long entryCurrency = ErCommonUtils.getPk((Object)entity.getDynamicObject("entrycurrency"));
                    exchangeRateAndQuoteType = CommonServiceHelper.getExchangeRateFromSysParams((Object)company, (Object)costCompany, (Long)entryCurrency, (Long)tripCurrency, (Object)model);
                    model.setValue("exchangerate", exchangeRateAndQuoteType.get("exchangeRate"), k, i);
                    model.setValue("detailquotetype", exchangeRateAndQuoteType.get("quotetype"), k, i);
                    String attribute = entity.getString("expenseitem.attribute");
                    if ("2".equals(attribute)) {
                        vehiclesSet.add("1");
                    } else if ("7".equals(attribute)) {
                        vehiclesSet.add("4");
                    } else if ("4".equals(attribute)) {
                        vehiclesSet.add("2");
                    } else if ("3".equals(attribute)) {
                        vehiclesSet.add("3");
                    } else {
                        vehiclesSet.add(STAY_TRIP_ITEM);
                    }
                    AmountChangeUtil.updateInOutAmount((IDataModel)model, (int)k, (int)i, (ChangeField)ChangeField.All);
                }
                if (vehiclesSet.size() > 1) {
                    vehiclesSet.remove(STAY_TRIP_ITEM);
                }
                for (String vehicle : vehiclesSet) {
                    sb.append(vehicle).append(",");
                }
                model.setValue("vehicles", (Object)sb, i);
            }
            logger.info("\u7ed3\u675f\u5faa\u73af");
            AmountChangeUtil.recalcReimburseAmountField((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)true);
        }
    }

    private int getBetweenDays(Date date1, Date date2) {
        Calendar cal = Calendar.getInstance();
        if (null == date1 || null == date2) {
            return 0;
        }
        cal.setTime(date1);
        long time1 = cal.getTimeInMillis();
        cal.setTime(date2);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }
}

