/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.pool.botp;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.ConvertOpType;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.pool.reim.util.ReimBotpUtils;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.model.invoice.bill.BillExpenseInfoFildKeyType;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class AbstractExpensePoolToTripBotpPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(AbstractExpensePoolToTripBotpPlugin.class);
    private static final Set<String> NOTNEEDMAPFIELD = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"costcompany", "costdept"}));

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField("formgroup");
        e.addSrcField("startdate");
        e.addSrcField("tripfrom");
        e.addSrcField("tripto");
        e.addSrcField("tripcheckindate");
        e.addSrcField("tripdeparturedate");
        e.addSrcField("tripcityfield");
        e.addSrcField("expenseitem.attribute");
        e.addSrcField("formid");
        e.addSrcField("happendate");
        e.addSrcField("currency");
        e.addSrcField("applier");
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        Map fldProperties = e.getFldProperties();
        ExtendedDataEntity[] itemRows = e.getTargetExtDataEntitySet().FindByEntityKey("tripentry");
        this.printLogger("generate expense data\uff1a" + itemRows.length);
        Set mapFieldSet = this.getRule().getFieldMapPolicy().getFieldMaps().stream().map(item -> item.getTargetFieldKey()).collect(Collectors.toSet());
        ReimBotpUtils.handleHead(NOTNEEDMAPFIELD, (ExtendedDataEntity[])e.getTargetExtDataEntitySet().FindByEntityKey(this.getTargetNumber()), mapFieldSet);
        Map<Long, Set<Long>> targetCostDeptPkIds = this.getTargetCostDeptPkId(e.getTargetExtDataEntitySet());
        Map costDeptIdAndItemIdsMap = ReimBotpUtils.getCostAllowUseItemIds((String)this.getTargetNumber(), targetCostDeptPkIds);
        List relatedExpenseItemByBillType = CommonServiceHelper.getRelatedExpenseItemByBillType((String)"er_tripreimbursebill");
        for (int i = 0; i < itemRows.length; ++i) {
            List convertSource = (List)itemRows[i].getValue("ConvertSource");
            this.setTravelers(itemRows[i], fldProperties, convertSource);
            this.setCity(itemRows[i], fldProperties, convertSource);
            DynamicObject entrycostdept = itemRows[i].getDataEntity().getDynamicObject("entrycostdept");
            if (entrycostdept == null) continue;
            Set expenseItemIds = (Set)costDeptIdAndItemIdsMap.get(entrycostdept.getPkValue());
            List extItem = ReimBotpUtils.expenseOfWriteOffApply((DynamicObject)itemRows[i].getDataEntity());
            expenseItemIds.addAll(extItem);
            DynamicObject expenseItem = itemRows[i].getDataEntity().getDynamicObject("tripexpenseitem");
            if (expenseItem == null || expenseItemIds.contains(expenseItem.getPkValue()) && relatedExpenseItemByBillType.contains(expenseItem.getPkValue())) continue;
            itemRows[i].getDataEntity().set("tripexpenseitem", null);
        }
        this.refreshInvoiceEntry(e.getTargetExtDataEntitySet());
    }

    private void setTravelers(ExtendedDataEntity itemRow, Map<String, DynamicProperty> fldProperties, List<DynamicObject> convertSource) {
        long applicantId = (Long)convertSource.get(0).get((IDataEntityProperty)fldProperties.get("applier"));
        DynamicObjectCollection travelerSet = AbstractExpensePoolToTripBotpPlugin.generateMultiPropValue(itemRow.getDataEntity(), null, "travelers", applicantId);
        itemRow.getDataEntity().set("travelers", (Object)travelerSet);
    }

    private void setCity(ExtendedDataEntity itemRow, Map<String, DynamicProperty> fldProperties, List<DynamicObject> convertSource) {
        Object from = null;
        Object to = null;
        List<SrcModel> srcModels = this.handleFeeHappenedInfos(fldProperties, convertSource);
        srcModels.removeIf(srcModel -> (Long)srcModel.getCity() == 0L);
        logger.info("\u8d39\u7528\u6c60\u4e0b\u63a8\u5dee\u65c5\u62a5\u9500\u5355 \u8d39\u7528\u53d1\u751f\u4fe1\u606f:" + srcModels);
        if (!srcModels.isEmpty()) {
            from = srcModels.stream().min(Comparator.comparing(SrcModel::getDate)).get().getCity();
            to = srcModels.stream().max(Comparator.comparing(SrcModel::getDate)).get().getCity();
        }
        if (from != null) {
            itemRow.setValue("from_id", from);
        }
        if (to != null) {
            itemRow.setValue("to_id", to);
        }
    }

    private List<SrcModel> handleFeeHappenedInfos(Map<String, DynamicProperty> fldProperties, List<DynamicObject> convertSource) {
        ArrayList<SrcModel> srcModels = new ArrayList<SrcModel>();
        convertSource.forEach(src -> {
            Date tripDepartureDate;
            Date tripCheckInDate = src.getDate((IDataEntityProperty)fldProperties.get("tripcheckindate"));
            if (tripCheckInDate != null) {
                Object tripCityField = src.get((IDataEntityProperty)fldProperties.get("tripcityfield"));
                SrcModel srcModel = new SrcModel();
                srcModel.setDate(tripCheckInDate);
                srcModel.setCity(tripCityField);
                srcModels.add(srcModel);
            }
            if ((tripDepartureDate = src.getDate((IDataEntityProperty)fldProperties.get("tripdeparturedate"))) != null) {
                Object tripCityField = src.get((IDataEntityProperty)fldProperties.get("tripcityfield"));
                SrcModel srcModel = new SrcModel();
                srcModel.setCity(tripCityField);
                srcModel.setDate(tripDepartureDate);
                srcModels.add(srcModel);
                return;
            }
            Date startDate = src.getDate((IDataEntityProperty)fldProperties.get("startdate"));
            if (startDate != null) {
                Object tripFrom = src.get((IDataEntityProperty)fldProperties.get("tripfrom"));
                SrcModel srcModel = new SrcModel();
                srcModel.setDate(startDate);
                srcModel.setCity(tripFrom);
                srcModels.add(srcModel);
                return;
            }
            Date happenDate = src.getDate((IDataEntityProperty)fldProperties.get("happendate"));
            if (happenDate != null) {
                Object tripCityField = src.get((IDataEntityProperty)fldProperties.get("tripcityfield"));
                SrcModel srcModel = new SrcModel();
                srcModel.setDate(happenDate);
                srcModel.setCity(tripCityField);
                srcModels.add(srcModel);
                return;
            }
        });
        return srcModels;
    }

    protected void refreshInvoiceEntry(ExtendedDataEntitySet dataEntitySet) {
        ExtendedDataEntity[] extendedDataEntities = dataEntitySet.FindByEntityKey(this.getTargetNumber());
        this.setAndGetSelectedRowEntryId(extendedDataEntities);
        ExtendedDataEntity[] targetItemEntrys = dataEntitySet.FindByEntityKey("entryentity");
        if (targetItemEntrys == null || targetItemEntrys.length == 0) {
            return;
        }
        this.setAndGetSelectedRowEntryId(targetItemEntrys);
        Set convertItemIds = Arrays.stream(targetItemEntrys).map(item -> (Long)item.getDataEntity().getPkValue()).collect(Collectors.toSet());
        HashMap sItemIdAndTItemId = Maps.newHashMapWithExpectedSize((int)targetItemEntrys.length);
        for (int i = 0; i < extendedDataEntities.length; ++i) {
            DynamicObject targetBill = extendedDataEntities[i].getDataEntity();
            HashMap<Long, Long> iscurrencyMap = new HashMap<Long, Long>();
            DynamicObjectCollection tripentry = targetBill.getDynamicObjectCollection("tripentry");
            DynamicObject company = targetBill.getDynamicObject("company");
            DynamicObject costcompany = targetBill.getDynamicObject("costcompany");
            Long currencyId = BaseCurrencyServiceHelper.getBaseCurrencyId((Object)company, (Object)costcompany);
            iscurrencyMap.put(currencyId, currencyId);
            for (int k = 0; k < tripentry.size(); ++k) {
                DynamicObject item2 = (DynamicObject)tripentry.get(k);
                DynamicObjectCollection entryentity = (DynamicObjectCollection)item2.get("entryentity");
                for (int j = 0; j < entryentity.size(); ++j) {
                    DynamicObject entryentityItem = (DynamicObject)entryentity.get(j);
                    Long entrycurrency = entryentityItem.getLong("entrycurrency.id");
                    iscurrencyMap.put(entrycurrency, entrycurrency);
                    Long entryentityItemId = (Long)entryentityItem.getPkValue();
                    if (!convertItemIds.contains(entryentityItemId)) continue;
                    Long srcBillid = entryentityItem.getLong("wbsrcbillid");
                    entryentityItem.set("wbsrcbilltype", (Object)this.getSrcMainType().getName());
                    sItemIdAndTItemId.put(srcBillid, entryentityItemId);
                    String invoiceNo = entryentityItem.getString("invoiceno_entry");
                    if (!StringUtils.isNotBlank((CharSequence)invoiceNo)) continue;
                    entryentityItem.set("itemfrom", (Object)ItemFrom.InvoiceCloud.getValue());
                }
            }
            if (iscurrencyMap.size() >= 2) {
                targetBill.set("iscurrency", (Object)true);
            }
            ExtendedDataEntity[] targetInvoiceEntry = dataEntitySet.FindByEntityKey("invoiceentry");
            this.setAndGetSelectedRowEntryId(targetInvoiceEntry);
            Set convertInviceIds = Arrays.stream(targetInvoiceEntry).map(item -> (Long)item.getDataEntity().getPkValue()).collect(Collectors.toSet());
            this.printLogger("generate invoice data\uff1a" + targetInvoiceEntry.length);
            if (targetInvoiceEntry != null && targetInvoiceEntry.length != 0) {
                DynamicObjectCollection invoiceEntry = targetBill.getDynamicObjectCollection("invoiceentry");
                ExtendedDataEntity[] targetInvoiceItemEntry = dataEntitySet.FindByEntityKey("invoiceitementry");
                this.setAndGetSelectedRowEntryId(targetInvoiceItemEntry);
                Set convertInviceItemIds = Arrays.stream(targetInvoiceItemEntry).map(item -> (Long)item.getDataEntity().getPkValue()).collect(Collectors.toSet());
                HashMap sInvocieIdAndTInvocieId = Maps.newHashMapWithExpectedSize((int)targetInvoiceEntry.length);
                for (DynamicObject invoice : invoiceEntry) {
                    Long tarEntryid = (Long)invoice.getPkValue();
                    if (!convertInviceIds.contains(tarEntryid)) continue;
                    Long srcEntryid = invoice.getLong("invoicesrcentryid");
                    invoice.set("invoicesrcbilltype", (Object)this.getSrcMainType().getName());
                    sInvocieIdAndTInvocieId.put(srcEntryid, tarEntryid);
                }
                DynamicObjectCollection invoiceItemEntry = targetBill.getDynamicObjectCollection("invoiceitementry");
                for (DynamicObject invoiceItem : invoiceItemEntry) {
                    if (!convertInviceItemIds.contains(invoiceItem.getPkValue())) continue;
                    Long itemId = invoiceItem.getLong("itementryid");
                    Long targetItemEntryId = (Long)sItemIdAndTItemId.get(itemId);
                    invoiceItem.set("itementryid", (Object)targetItemEntryId);
                    Long invoiceId = invoiceItem.getLong("invoiceheadentryid");
                    Long targetInvoiceEntryId = (Long)sInvocieIdAndTInvocieId.get(invoiceId);
                    invoiceItem.set("invoiceheadentryid", (Object)targetInvoiceEntryId);
                }
                this.printLogger("expenseEntityMap: " + sItemIdAndTItemId + " , invoiceentryMapid\uff1a" + sInvocieIdAndTInvocieId);
            }
            targetBill.set("ismultravelers", (Object)SystemParamterUtil.getIsMulTravelers((long)((Long)company.getPkValue())));
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] extendedDataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(this.getTargetNumber());
        ExtendedDataEntity[] targetItemEntrys = e.getTargetExtDataEntitySet().FindByEntityKey("entryentity");
        if (targetItemEntrys == null || targetItemEntrys.length == 0) {
            return;
        }
        Set convertItemIds = Arrays.stream(targetItemEntrys).map(item -> (Long)item.getDataEntity().getPkValue()).collect(Collectors.toSet());
        ExtendedDataEntity[] targetInvoiceEntry = e.getTargetExtDataEntitySet().FindByEntityKey("invoiceentry");
        if (targetInvoiceEntry == null || targetInvoiceEntry.length == 0) {
            return;
        }
        for (int i = 0; i < extendedDataEntities.length; ++i) {
            DynamicObject targetBill = extendedDataEntities[i].getDataEntity();
            Map invoiceItemMap = InvoiceUtils.autoMapInvoiceMappingInfo((DynamicObject)targetBill);
            DynamicObjectCollection invoiceEntry = targetBill.getDynamicObjectCollection("invoiceentry");
            DynamicObjectCollection tripentry = targetBill.getDynamicObjectCollection("tripentry");
            for (int k = 0; k < tripentry.size(); ++k) {
                DynamicObject item2 = (DynamicObject)tripentry.get(k);
                DynamicObjectCollection entryentity = (DynamicObjectCollection)item2.get("entryentity");
                for (int j = 0; j < entryentity.size(); ++j) {
                    Set invoiceIds;
                    DynamicObject entryentityItem = (DynamicObject)entryentity.get(j);
                    Long entryentityItemId = (Long)entryentityItem.getPkValue();
                    if (!convertItemIds.contains(entryentityItemId) || (invoiceIds = (Set)invoiceItemMap.get(entryentityItemId)) == null) continue;
                    String type = invoiceEntry.stream().filter(itemTemp -> invoiceIds.contains(ErCommonUtils.getPk((Object)itemTemp))).findFirst().get().getString("invoicetype");
                    entryentityItem.set("invoicetypeitem", (Object)type);
                    InvoiceOffsetUtils.refreshItemsOffset((DynamicObject)targetBill, (BillExpenseInfoFildKeyType)BillExpenseInfoFildKeyType.TripReimburse, (int)j, (int)k);
                }
            }
        }
    }

    private void setAndGetSelectedRowEntryId(ExtendedDataEntity[] itemRows) {
        if (ArrayUtils.isEmpty((Object[])itemRows)) {
            return;
        }
        long[] ids = ORM.create().genLongIds(itemRows[0].getDataEntity().getDataEntityType(), itemRows.length);
        for (int i = 0; i < itemRows.length; ++i) {
            Long pkid = (Long)itemRows[i].getDataEntity().getPkValue();
            if (pkid != null && pkid != 0L) continue;
            itemRows[i].setValue("id", (Object)ids[i]);
        }
    }

    protected String getTargetNumber() {
        return this.getTgtMainType().getName();
    }

    protected Map<Long, Set<Long>> getTargetCostDeptPkId(ExtendedDataEntitySet dataEntitySet) {
        ExtendedDataEntity[] extendedDataEntities = dataEntitySet.FindByEntityKey(this.getTargetNumber());
        ExtendedDataEntity[] itemRows = dataEntitySet.FindByEntityKey("tripentry");
        HashMap targetCostDeptPkIds = Maps.newHashMapWithExpectedSize((int)itemRows.length);
        if (itemRows == null || itemRows.length == 0) {
            return targetCostDeptPkIds;
        }
        Set convertItemIds = Arrays.stream(itemRows).map(item -> (Long)item.getDataEntity().getPkValue()).collect(Collectors.toSet());
        boolean isDraw = ConvertOpType.Draw == this.getOpType();
        boolean isPush = ConvertOpType.Push == this.getOpType();
        for (int i = 0; i < extendedDataEntities.length; ++i) {
            DynamicObject targetBill = extendedDataEntities[i].getDataEntity();
            DynamicObject company = targetBill.getDynamicObject("company");
            if (company == null) {
                logger.info("\u4e0b\u6e38\u5355\u636e\u5355\u5934\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a");
                return targetCostDeptPkIds;
            }
            int showType = ErCommonUtils.getExpenseAssumeShowTypes((long)((Long)company.getPkValue()));
            DynamicObjectCollection entityColl = targetBill.getDynamicObjectCollection("tripentry");
            if (isDraw && showType == 1) {
                DynamicObject costcompany = targetBill.getDynamicObject("costcompany");
                DynamicObject costdept = targetBill.getDynamicObject("costdept");
                for (DynamicObject entity : entityColl) {
                    if (!convertItemIds.contains(ErCommonUtils.getPk((Object)entity))) continue;
                    entity.set("entrycostdept", (Object)costdept);
                    entity.set("entrycostcompany", (Object)costcompany);
                }
            }
            if (isPush || isDraw && showType == 2) {
                DynamicObject entrycostcompany = ((DynamicObject)entityColl.get(0)).getDynamicObject("entrycostcompany");
                DynamicObject entrycostdept = ((DynamicObject)entityColl.get(0)).getDynamicObject("entrycostdept");
                targetBill.set("costdept", (Object)entrycostdept);
                targetBill.set("costcompany", (Object)entrycostcompany);
            }
            for (DynamicObject entity : entityColl) {
                Long entryCompanyId = ErCommonUtils.getPk((Object)entity.getDynamicObject("entrycostcompany"));
                Long entryCostDeptId = ErCommonUtils.getPk((Object)entity.getDynamicObject("entrycostdept"));
                Set deptSet = (Set)targetCostDeptPkIds.get(entryCompanyId);
                if (entryCompanyId == null || entryCompanyId == 0L) continue;
                if (deptSet == null) {
                    deptSet = Sets.newHashSetWithExpectedSize((int)entityColl.size());
                    targetCostDeptPkIds.put(entryCompanyId, deptSet);
                }
                deptSet.add(entryCostDeptId);
            }
        }
        return targetCostDeptPkIds;
    }

    public static DynamicObjectCollection generateMultiPropValue(DynamicObject entity, DynamicObject subEntity, String propName, long pkValue) {
        IDataEntityProperty currentProperty;
        String formID = entity.getDataEntityType().getParent().getName();
        String entityName = entity.getDataEntityType().getName();
        if (subEntity != null) {
            IDataEntityProperty subEntry = (IDataEntityProperty)((EntryProp)EntityMetadataCache.getDataEntityType((String)formID).getProperties().get((Object)entityName)).getDynamicCollectionItemPropertyType().getProperties().get((Object)"entryentity");
            currentProperty = (IDataEntityProperty)((SubEntryProp)subEntry).getDynamicCollectionItemPropertyType().getProperties().get((Object)propName);
        } else {
            currentProperty = (IDataEntityProperty)((EntryProp)EntityMetadataCache.getDataEntityType((String)formID).getProperties().get((Object)entityName)).getDynamicCollectionItemPropertyType().getProperties().get((Object)propName);
        }
        DynamicObjectType currentProType = ((MulBasedataProp)currentProperty).getDynamicCollectionItemPropertyType();
        HashMap<Long, DynamicObject> finalUserIDSet = new HashMap<Long, DynamicObject>();
        DynamicObject newObj = new DynamicObject(currentProType);
        newObj.set("fbasedataid", (Object)pkValue);
        newObj.set("fbasedataid_id", (Object)pkValue);
        finalUserIDSet.put(pkValue, newObj);
        DynamicObjectCollection collection = new DynamicObjectCollection(currentProType, (Object)entity);
        for (Map.Entry entry : finalUserIDSet.entrySet()) {
            collection.add(entry.getValue());
        }
        return collection;
    }

    protected void printLogger(String info) {
        String fmt = "operationType\uff1a%s, sourcebill\uff1a%s, tagertbill\uff1a%s, botpRuleId:%s, information\uff1a%s";
        logger.info(String.format(fmt, this.getOpType(), this.getSrcMainType().getName(), this.getTgtMainType().getName(), this.getRule().getId(), info));
    }

    static class SrcModel {
        private Long srcId;
        private Date date;
        private Object city;

        SrcModel() {
        }

        public Long getSrcId() {
            return this.srcId;
        }

        public void setSrcId(Long srcId) {
            this.srcId = srcId;
        }

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public Object getCity() {
            return this.city;
        }

        public void setCity(Object city) {
            this.city = city;
        }

        public String toString() {
            return "SrcModel{srcId=" + this.srcId + ", date=" + this.date + ", city=" + this.city + '}';
        }
    }
}

