/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.pool.botp;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.formplugin.pool.botp.TripCardEntryBO;

public class ExpensePoolConvertTrip
extends AbstractConvertPlugIn {
    private static final int DayTimeStamp = 86400000;

    /*
     * WARNING - void declaration
     */
    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        Map<Integer, List<TripCardEntryBO>> tripGroup;
        Map<String, List<TripCardEntryBO>> tripCardEntryBOGroup;
        TripCardEntryBO tripCardEntryBO;
        super.afterGetSourceData(e);
        List sourceRows = e.getSourceRows();
        String expenseitemAttributeField = ((DynamicProperty)e.getFldProperties().get("expenseitem.attribute")).getName();
        String formgroupField = ((DynamicProperty)e.getFldProperties().get("formgroup")).getName();
        String expenseitemField = ((DynamicProperty)e.getFldProperties().get("expenseitem")).getName();
        String startdateField = ((DynamicProperty)e.getFldProperties().get("startdate")).getName();
        String tripfromField = ((DynamicProperty)e.getFldProperties().get("tripfrom")).getName();
        String triptoField = ((DynamicProperty)e.getFldProperties().get("tripto")).getName();
        String tripcheckindateField = ((DynamicProperty)e.getFldProperties().get("tripcheckindate")).getName();
        String tripdeparturedateField = ((DynamicProperty)e.getFldProperties().get("tripdeparturedate")).getName();
        String tripcityfieldField = ((DynamicProperty)e.getFldProperties().get("tripcityfield.name")).getName();
        String happendateField = ((DynamicProperty)e.getFldProperties().get("happendate")).getName();
        String formidField = ((DynamicProperty)e.getFldProperties().get("formid")).getName();
        String currencyField = ((DynamicProperty)e.getFldProperties().get("currency")).getName();
        ArrayList<TripCardEntryBO> tripCardEntryBOList = new ArrayList<TripCardEntryBO>();
        ArrayList<TripCardEntryBO> recordCardEntryBOList = new ArrayList<TripCardEntryBO>();
        for (DynamicObject srcBill : sourceRows) {
            String formid = srcBill.getString(formidField);
            if ("er_trip_recordbill".equals(formid)) {
                String expenseitemAttribute = srcBill.getString(expenseitemAttributeField);
                Integer formgroup = Math.toIntExact(srcBill.getLong(formgroupField));
                Long l = (Long)srcBill.get(expenseitemField);
                Date startdate = (Date)srcBill.get(startdateField);
                Long tripfrom = (Long)srcBill.get(tripfromField);
                Long tripto = (Long)srcBill.get(triptoField);
                Date tripcheckindate = (Date)srcBill.get(tripcheckindateField);
                Timestamp tripdeparturedate = (Timestamp)srcBill.get(tripdeparturedateField);
                String tripcityfield = srcBill.getString(tripcityfieldField);
                Date happendate = (Date)srcBill.get(happendateField);
                Long id = (Long)srcBill.get("id");
                Long currency = (Long)srcBill.get(currencyField);
                tripCardEntryBO = new TripCardEntryBO();
                tripCardEntryBO.setExpenseitemAttribute(expenseitemAttribute);
                tripCardEntryBO.setFormgroup(formgroup);
                tripCardEntryBO.setExpenseitem(l);
                tripCardEntryBO.setStartdate(startdate);
                tripCardEntryBO.setTripfrom(tripfrom);
                tripCardEntryBO.setTripto(tripto);
                tripCardEntryBO.setTripcheckindate(tripcheckindate);
                tripCardEntryBO.setTripdeparturedate(tripdeparturedate);
                tripCardEntryBO.setTripcityfield(tripcityfield);
                tripCardEntryBO.setHappendate(happendate);
                tripCardEntryBO.setId(id);
                tripCardEntryBO.setCurrency(currency);
                tripCardEntryBOList.add(tripCardEntryBO);
                continue;
            }
            TripCardEntryBO record2 = new TripCardEntryBO();
            Long id = (Long)srcBill.get("id");
            Long l = (Long)srcBill.get(expenseitemField);
            Long currency = (Long)srcBill.get(currencyField);
            Date happenDate = (Date)srcBill.get(happendateField);
            record2.setExpenseitem(l);
            record2.setId(id);
            record2.setCurrency(currency);
            record2.setHappendate(happenDate);
            recordCardEntryBOList.add(record2);
            srcBill.set(formgroupField, (Object)"er_expense_recordbill");
        }
        Map billMap = CoreBaseBillServiceHelper.createNewData((Long)Long.valueOf(RequestContext.get().getUserId()));
        Long company = (Long)billMap.get("company");
        if (SystemParamterUtil.getIsCurrencyShowinTripentry((long)company)) {
            Map<Long, List<TripCardEntryBO>> tripCardGroup = tripCardEntryBOList.stream().collect(Collectors.groupingBy(TripCardEntryBO::getCurrency));
            int group2 = 0;
            for (Map.Entry entry : tripCardGroup.entrySet()) {
                ++group2;
                Long currencyId = (Long)entry.getKey();
                List tripCardEntryBOEndList = (List)entry.getValue();
                for (TripCardEntryBO endListEntry : tripCardEntryBOEndList) {
                    endListEntry.setTemporary(currencyId);
                    endListEntry.setFormgroup(group2);
                }
            }
        }
        if ((tripCardEntryBOGroup = tripCardEntryBOList.stream().collect(Collectors.groupingBy(TripCardEntryBO::getExpenseitemAttribute))).containsKey("5")) {
            List<TripCardEntryBO> tripStay = tripCardEntryBOGroup.get("5");
            tripStay.sort(Comparator.comparing(TripCardEntryBO::getTripcheckindate));
            for (int i = 0; i < tripStay.size(); ++i) {
                int n = i + 1;
                int tripNextGroupNum = i + 2;
                TripCardEntryBO tripCardEntryBO2 = tripStay.get(i);
                Object tripCardEntryBONext = new TripCardEntryBO();
                Date endDate = tripCardEntryBO2.getTripdeparturedate();
                String city = tripCardEntryBO2.getTripcityfield();
                Integer formGroup = tripCardEntryBO2.getFormgroup();
                Long thisTripCurrency = tripCardEntryBO2.getCurrency();
                Date startDate = null;
                String cityNext = null;
                Long nextTripCurrency = null;
                if (formGroup == null || formGroup == 0) {
                    formGroup = n;
                }
                if (i < tripStay.size() - 1) {
                    tripCardEntryBONext = tripStay.get(i + 1);
                    startDate = ((TripCardEntryBO)tripCardEntryBONext).getTripcheckindate();
                    cityNext = ((TripCardEntryBO)tripCardEntryBONext).getTripcityfield();
                    nextTripCurrency = ((TripCardEntryBO)tripCardEntryBONext).getCurrency();
                }
                if (endDate != null && startDate != null) {
                    if (thisTripCurrency.equals(nextTripCurrency) && this.getBetweenDays(endDate, startDate) <= 1 && city.equals(cityNext)) {
                        tripCardEntryBO2.setFormgroup(formGroup);
                        ((TripCardEntryBO)tripCardEntryBONext).setFormgroup(formGroup);
                        continue;
                    }
                    tripCardEntryBO2.setFormgroup(formGroup);
                    ((TripCardEntryBO)tripCardEntryBONext).setFormgroup(tripNextGroupNum);
                    continue;
                }
                tripCardEntryBO2.setFormgroup(formGroup);
            }
            for (Map.Entry<String, List<TripCardEntryBO>> entry : tripCardEntryBOGroup.entrySet()) {
                String key = entry.getKey();
                if ("5".equals(key)) continue;
                List<TripCardEntryBO> value = entry.getValue();
                block5: for (TripCardEntryBO attribute : value) {
                    Long temporary = attribute.getTemporary();
                    Date startDate = attribute.getStartdate();
                    Date tripCardDate = startDate != null ? startDate : attribute.getHappendate();
                    Integer isFormGroup = 0;
                    for (int i = tripStay.size(); i > 0; --i) {
                        tripCardEntryBO = tripStay.get(i - 1);
                        Date tripCheckInDate = tripCardEntryBO.getTripcheckindate();
                        Long l = tripCardEntryBO.getTemporary();
                        int betweenDays = this.getBetweenDays(tripCardDate, tripCheckInDate);
                        if (betweenDays != 0 && betweenDays != 1 && betweenDays != -1 || !Objects.equals(temporary, l)) continue;
                        isFormGroup = tripCardEntryBO.getFormgroup();
                        break;
                    }
                    if (isFormGroup != null && isFormGroup != 0) {
                        attribute.setFormgroup(isFormGroup);
                        continue;
                    }
                    HashMap<String, String> betweenDayMap = new HashMap<String, String>();
                    for (int i = 0; i < tripStay.size(); ++i) {
                        TripCardEntryBO tripCardEntryBO3 = tripStay.get(i);
                        Date date = tripCardEntryBO3.getTripcheckindate();
                        String betweenDay = this.getStrBetweenDays(tripCardDate, date);
                        betweenDayMap.put(String.valueOf(i), betweenDay);
                    }
                    ArrayList listEntry = new ArrayList();
                    listEntry.addAll(betweenDayMap.entrySet());
                    Collections.sort(listEntry, Comparator.comparing(Map.Entry::getValue));
                    for (Map.Entry entry2 : listEntry) {
                        TripCardEntryBO tripCardEntryOther = tripStay.get(Integer.parseInt((String)entry2.getKey()));
                        if (!Objects.equals(temporary, tripCardEntryOther.getTemporary())) continue;
                        attribute.setFormgroup(tripCardEntryOther.getFormgroup());
                        continue block5;
                    }
                }
            }
        }
        if (CollectionUtils.isEmpty(tripCardEntryBOList) && SystemParamterUtil.getIsCurrencyShowinTripentry((long)company)) {
            Map<Long, List<TripCardEntryBO>> recordCurrencyGroup = recordCardEntryBOList.stream().collect(Collectors.groupingBy(TripCardEntryBO::getCurrency));
            boolean bl = false;
            for (Map.Entry<Long, List<TripCardEntryBO>> longListEntry : recordCurrencyGroup.entrySet()) {
                void var22_35;
                void groupId = ++var22_35;
                longListEntry.getValue().forEach(arg_0 -> ExpensePoolConvertTrip.lambda$afterGetSourceData$0((int)groupId, arg_0));
            }
            tripGroup = recordCardEntryBOList.stream().collect(Collectors.groupingBy(TripCardEntryBO::getFormgroup));
        } else {
            tripGroup = tripCardEntryBOList.stream().collect(Collectors.groupingBy(TripCardEntryBO::getFormgroup));
        }
        HashMap tripDateGroup = new HashMap();
        tripGroup.forEach((group, entities) -> {
            HashMap<String, Comparable<Date>> map = new HashMap<String, Comparable<Date>>();
            Set inDateList = entities.stream().map(TripCardEntryBO::getTripcheckindate).collect(Collectors.toSet());
            Set outDateList = entities.stream().map(TripCardEntryBO::getTripdeparturedate).collect(Collectors.toSet());
            Set startDateList = entities.stream().map(TripCardEntryBO::getStartdate).collect(Collectors.toSet());
            Set happenDate = entities.stream().map(TripCardEntryBO::getHappendate).collect(Collectors.toSet());
            Long currency = ((TripCardEntryBO)entities.get(0)).getCurrency();
            HashSet<Object> allDate = new HashSet<Object>();
            allDate.addAll(inDateList);
            allDate.addAll(outDateList);
            allDate.addAll(startDateList);
            allDate.addAll(happenDate);
            allDate.removeIf(date -> null == date);
            Date startDate = (Date)allDate.stream().min(Date::compareTo).get();
            Date endDate = (Date)allDate.stream().max(Date::compareTo).get();
            map.put("startDate", startDate);
            map.put("endDate", endDate);
            map.put("currency", currency);
            tripDateGroup.put(group, map);
        });
        LinkedHashMap linkedHashMap = tripDateGroup.entrySet().stream().sorted(Map.Entry.comparingByValue((value1, value2) -> {
            Date startDate1 = (Date)value1.get("startDate");
            Date startDate2 = (Date)value2.get("startDate");
            return startDate1.compareTo(startDate2);
        })).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e2, LinkedHashMap::new));
        List<DynamicObject> recordBillList = sourceRows.stream().filter(bill -> "er_expense_recordbill".equals(bill.getString(formidField))).collect(Collectors.toList());
        recordBillList.forEach(recordBill -> {
            boolean inPeriod = this.isInPeriod((DynamicObject)recordBill, tripDateGroupLinkMap, happendateField, formgroupField, currencyField);
            if (!inPeriod) {
                // empty if block
            }
        });
        for (DynamicObject srcBill : sourceRows) {
            String formid = srcBill.getString(formidField);
            if (!"er_trip_recordbill".equals(formid)) continue;
            Long id = (Long)srcBill.get("id");
            block11: for (Map.Entry<String, List<TripCardEntryBO>> entry : tripCardEntryBOGroup.entrySet()) {
                List<TripCardEntryBO> tripCardEntryBOEndList = entry.getValue();
                for (TripCardEntryBO endListEntry : tripCardEntryBOEndList) {
                    if (!Objects.equals(endListEntry.getId(), id)) continue;
                    srcBill.set(formgroupField, (Object)endListEntry.getFormgroup());
                    continue block11;
                }
            }
        }
    }

    private boolean isInPeriod(DynamicObject recordBill, Map<Integer, Map<String, Object>> tripDateGroup, String happenDateField, String formGroupField, String currencyField) {
        Date endDate;
        Long tripCurrency;
        Date startDate;
        Map<String, Object> value;
        Integer key;
        Date happenDate = (Date)recordBill.get(happenDateField);
        Long currency = (Long)recordBill.get(currencyField);
        ArrayList<Boolean> haveFind = new ArrayList<Boolean>(1);
        for (Map.Entry<Integer, Map<String, Object>> entry : tripDateGroup.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            startDate = (Date)value.get("startDate");
            Date endDate2 = (Date)value.get("endDate");
            Long tripCurrency2 = (Long)value.get("currency");
            if (!tripCurrency2.equals(currency) || happenDate.compareTo(startDate) < 0 || happenDate.compareTo(endDate2) > 0) continue;
            recordBill.set(formGroupField, (Object)key);
            haveFind.add(true);
            break;
        }
        if (!CollectionUtils.isEmpty(haveFind)) {
            return true;
        }
        for (Map.Entry<Integer, Map<String, Object>> entry : tripDateGroup.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            startDate = (Date)value.get("startDate");
            tripCurrency = (Long)value.get("currency");
            if (!tripCurrency.equals(currency) || !startDate.after(happenDate) || this.getBetweenDays(startDate, happenDate) > 1) continue;
            recordBill.set(formGroupField, (Object)key);
            haveFind.add(true);
            break;
        }
        if (!CollectionUtils.isEmpty(haveFind)) {
            return true;
        }
        for (Map.Entry<Integer, Map<String, Object>> entry : tripDateGroup.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            endDate = (Date)value.get("endDate");
            tripCurrency = (Long)value.get("currency");
            if (!tripCurrency.equals(currency) || !endDate.before(happenDate) || this.getBetweenDays(happenDate, endDate) > 1) continue;
            recordBill.set(formGroupField, (Object)key);
            haveFind.add(true);
            break;
        }
        if (!CollectionUtils.isEmpty(haveFind)) {
            return true;
        }
        for (Map.Entry<Integer, Map<String, Object>> entry : tripDateGroup.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            startDate = (Date)value.get("startDate");
            tripCurrency = (Long)value.get("currency");
            if (!tripCurrency.equals(currency) || !startDate.after(happenDate)) continue;
            recordBill.set(formGroupField, (Object)key);
            haveFind.add(true);
            break;
        }
        if (!CollectionUtils.isEmpty(haveFind)) {
            return true;
        }
        for (Map.Entry<Integer, Map<String, Object>> entry : tripDateGroup.entrySet()) {
            Integer group = entry.getKey();
            Map<String, Object> period = entry.getValue();
            endDate = (Date)period.get("endDate");
            tripCurrency = (Long)period.get("currency");
            if (!tripCurrency.equals(currency) || !endDate.before(happenDate)) continue;
            recordBill.set(formGroupField, (Object)group);
            haveFind.add(true);
            break;
        }
        return !CollectionUtils.isEmpty(haveFind);
    }

    private int getBetweenDays(Date date1, Date date2) {
        return (int)((date1.getTime() - date2.getTime()) / 86400000L);
    }

    private String getStrBetweenDays(Date date1, Date date2) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        long time1 = cal.getTimeInMillis();
        cal.setTime(date2);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return String.valueOf(between_days);
    }

    public void afterConvert(AfterConvertEventArgs e) {
        int i;
        ExtendedDataEntitySet dataEntitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] extendedDataEntities = dataEntitySet.FindByEntityKey(this.getTgtMainType().getName());
        ExtendedDataEntity[] tripItemEntrys = dataEntitySet.FindByEntityKey("tripentry");
        if (tripItemEntrys == null || tripItemEntrys.length == 0) {
            return;
        }
        for (i = 0; i < tripItemEntrys.length; ++i) {
            DynamicObject tripBill = tripItemEntrys[i].getDataEntity();
            DynamicObjectCollection entryentityCollection = (DynamicObjectCollection)tripBill.get("entryentity");
            entryentityCollection.sort((u, v) -> {
                Date uCreateTime = u.getDate("trip2startdate");
                Date vCreateTime = v.getDate("trip2startdate");
                if (uCreateTime != null && vCreateTime != null) {
                    return uCreateTime.compareTo(vCreateTime);
                }
                if (uCreateTime == null && vCreateTime != null) {
                    return 1;
                }
                if (uCreateTime != null && vCreateTime == null) {
                    return -1;
                }
                if (uCreateTime == null && vCreateTime == null) {
                    return -1;
                }
                if (uCreateTime == null && vCreateTime != null) {
                    return 1;
                }
                if (uCreateTime != null && vCreateTime == null) {
                    return -1;
                }
                return uCreateTime.compareTo(vCreateTime);
            });
            DynamicObject entryentityFirst = (DynamicObject)entryentityCollection.get(0);
            DynamicObject entryentityLast = (DynamicObject)entryentityCollection.get(entryentityCollection.size() - 1);
            Date trip2startdate = entryentityFirst.getDate("trip2startdate");
            Date trip2enddate = entryentityLast.getDate("trip2enddate");
            tripBill.set("startdate", (Object)trip2startdate);
            tripBill.set("enddate", (Object)trip2enddate);
        }
        for (i = 0; i < extendedDataEntities.length; ++i) {
            DynamicObject targetBill = extendedDataEntities[i].getDataEntity();
            DynamicObjectCollection tripentrySort = (DynamicObjectCollection)targetBill.get("tripentry");
            tripentrySort.sort((u, v) -> {
                Date uCreateTime = u.getDate("startdate");
                Date vCreateTime = v.getDate("startdate");
                if (uCreateTime != null && vCreateTime != null) {
                    return uCreateTime.compareTo(vCreateTime);
                }
                if (uCreateTime == null && vCreateTime != null) {
                    return 1;
                }
                if (uCreateTime != null && vCreateTime == null) {
                    return -1;
                }
                if (uCreateTime == null && vCreateTime == null) {
                    return -1;
                }
                if (uCreateTime == null && vCreateTime != null) {
                    return 1;
                }
                if (uCreateTime != null && vCreateTime == null) {
                    return -1;
                }
                return uCreateTime.compareTo(vCreateTime);
            });
            int seq = 1;
            for (DynamicObject entry : tripentrySort) {
                entry.set("seq", (Object)seq++);
            }
        }
    }
}

