/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.pool.botp.mobile;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.model.ChangeField;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class PoolToExpenseMobPlugin
extends AbstractMobBillPlugIn {
    private static final String OTHER_TRIP_ITEM = "6";
    private static final String STAY_TRIP_ITEM = "5";

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData changeValue = e.getChangeSet()[0];
        int rowIndex = changeValue.getRowIndex();
        int parentIndex = changeValue.getParentRowIndex();
        Object propValue = changeValue.getNewValue();
        IDataModel model = this.getModel();
        switch (key) {
            case "tripcurrency": {
                if (propValue == null) {
                    propValue = propValue == null ? changeValue.getOldValue() : propValue;
                    model.setValue("tripcurrency", propValue, rowIndex, parentIndex);
                }
                Map currentEntryExchangeRate = AmountChangeUtil.getCurrentEntryExchangeRate((long)ErCommonUtils.getPk((Object)propValue), (IDataModel)model);
                String tripQuoteType = (String)ObjectUtils.defaultIfNull((Object)((String)currentEntryExchangeRate.get("quoteType")), (Object)"0");
                BigDecimal entryExchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)currentEntryExchangeRate.get("exchangeRate")), (Object)BigDecimal.ONE);
                if (model.getProperty("tripquotetype") != null) {
                    model.setValue("tripquotetype", (Object)tripQuoteType, rowIndex, parentIndex);
                }
                model.setValue("tripexchangerate", (Object)entryExchangeRate, rowIndex, parentIndex);
                break;
            }
            case "entrycurrency": {
                if (propValue == null) {
                    propValue = propValue == null ? changeValue.getOldValue() : propValue;
                    model.setValue("entrycurrency", propValue, rowIndex, parentIndex);
                }
                Map currentDetailExchangeRate = AmountChangeUtil.getCurrentEntryExchangeRate((long)ErCommonUtils.getPk((Object)propValue), (IDataModel)model);
                String detailQuoteType = (String)ObjectUtils.defaultIfNull((Object)((String)currentDetailExchangeRate.get("quoteType")), (Object)"0");
                BigDecimal detailExchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)currentDetailExchangeRate.get("exchangeRate")), (Object)BigDecimal.ONE);
                if (model.getProperty("detailquotetype") != null) {
                    model.setValue("detailquotetype", (Object)detailQuoteType, rowIndex, parentIndex);
                }
                model.setValue("exchangerate", (Object)detailExchangeRate, rowIndex, parentIndex);
            }
        }
    }

    public void afterBindData(EventObject e) {
        IDataModel model = this.getView().getModel();
        String isNotFirst = this.getPageCache().get("isNotFirst");
        Object company = this.getModel().getValue("company");
        Object costCompany = this.getModel().getValue("costcompany");
        Long currency = ErCommonUtils.getPk((Object)this.getModel().getValue("currency"));
        String sourceFormId = CommonServiceHelper.getParentViewFormId((IFormView)this.getView());
        if (this.getModel().getDataEntity().getDataEntityState().isPushChanged() && StringUtils.equals((CharSequence)sourceFormId, (CharSequence)"er_expense_list_card_mb") && StringUtils.isBlank((CharSequence)isNotFirst)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"next"});
            DynamicObjectCollection tripentryCollection = model.getEntryEntity("tripentry");
            for (int i = 0; i < tripentryCollection.size(); ++i) {
                DynamicObject tripEntry = (DynamicObject)tripentryCollection.get(i);
                Long tripCurrency = ErCommonUtils.getPk((Object)tripEntry.getDynamicObject("tripcurrency"));
                Map exchangeRateAndQuoteType = CommonServiceHelper.getExchangeRateFromSysParams((Object)company, (Object)costCompany, (Long)tripCurrency, (Long)currency, (Object)model);
                model.setValue("tripexchangerate", exchangeRateAndQuoteType.get("exchangeRate"), i);
                model.setValue("tripquotetype", exchangeRateAndQuoteType.get("quoteType"), i);
                DynamicObjectCollection entryentity = tripEntry.getDynamicObjectCollection("entryentity");
                if (entryentity.isEmpty()) continue;
                boolean isPool = entryentity.stream().anyMatch(v -> v.getLong("wbsrcbillid") > 0L);
                if (!isPool) {
                    return;
                }
                entryentity.sort((u, v) -> {
                    Date uCreateTime = u.getDate("trip2startdate");
                    Date vCreateTime = v.getDate("trip2startdate");
                    if (uCreateTime != null && vCreateTime != null) {
                        return uCreateTime.compareTo(vCreateTime);
                    }
                    if (uCreateTime == null && vCreateTime != null) {
                        return 1;
                    }
                    if (uCreateTime != null && vCreateTime == null) {
                        return -1;
                    }
                    if (uCreateTime == null && vCreateTime == null) {
                        return -1;
                    }
                    if (uCreateTime == null && vCreateTime != null) {
                        return 1;
                    }
                    if (uCreateTime != null && vCreateTime == null) {
                        return -1;
                    }
                    return uCreateTime.compareTo(vCreateTime);
                });
                Date checkindate = null;
                for (int j = 0; j < entryentity.size(); ++j) {
                    String attribute;
                    DynamicObject tripItem = (DynamicObject)entryentity.get(j);
                    if (checkindate == null) {
                        checkindate = tripItem.getDate("checkindate");
                    }
                    Long srcbillId = tripItem.getLong("wbsrcbillid");
                    DynamicObject expenseItem = tripItem.getDynamicObject("expenseitem");
                    if (srcbillId > 0L && expenseItem == null || !StringUtils.equals((CharSequence)STAY_TRIP_ITEM, (CharSequence)(attribute = expenseItem.getString("attribute")))) continue;
                    checkindate = tripItem.getDate("checkindate");
                    break;
                }
                Date checkoutdate = null;
                for (int j = entryentity.size() - 1; j >= 0; --j) {
                    DynamicObject tripItem = (DynamicObject)entryentity.get(j);
                    if (checkoutdate == null) {
                        checkoutdate = tripItem.getDate("checkoutdate");
                    }
                    Long srcbillId = tripItem.getLong("wbsrcbillid");
                    DynamicObject expenseItem = tripItem.getDynamicObject("expenseitem");
                    if (srcbillId > 0L && expenseItem != null) continue;
                }
                if (checkindate != null) {
                    model.setValue("startdate", (Object)checkindate, i);
                }
                if (checkoutdate != null) {
                    model.setValue("enddate", checkoutdate, i);
                }
                Date startdate = tripEntry.getDate("startdate");
                Date enddate = tripEntry.getDate("enddate");
                int betweenDay = this.getBetweenDays(startdate, enddate);
                model.setValue("tripday", (Object)betweenDay, i);
                BigDecimal totalAmount = new BigDecimal(0);
                StringBuilder sb = new StringBuilder(",");
                HashSet<String> vehiclesSet = new HashSet<String>();
                for (int k = 0; k < entryentity.size(); ++k) {
                    DynamicObject entity = (DynamicObject)entryentity.get(k);
                    Long entryCurrency = ErCommonUtils.getPk((Object)entity.getDynamicObject("entrycurrency"));
                    exchangeRateAndQuoteType = CommonServiceHelper.getExchangeRateFromSysParams((Object)company, (Object)costCompany, (Long)entryCurrency, (Long)tripCurrency, (Object)model);
                    model.setValue("exchangerate", exchangeRateAndQuoteType.get("exchangeRate"), k, i);
                    model.setValue("detailquotetype", exchangeRateAndQuoteType.get("quotetype"), k, i);
                    String attribute = entity.getString("expenseitem.attribute");
                    Object mulseatgrade = ObjectUtils.clone((Object)entity.get("mulseatgrade"));
                    if ("2".equals(attribute)) {
                        vehiclesSet.add("1");
                    } else if ("7".equals(attribute)) {
                        vehiclesSet.add("4");
                    } else if ("4".equals(attribute)) {
                        vehiclesSet.add("2");
                    } else if ("3".equals(attribute)) {
                        vehiclesSet.add("3");
                    } else {
                        vehiclesSet.add(STAY_TRIP_ITEM);
                    }
                    model.setValue("mulseatgrade", mulseatgrade, k, i);
                    if (vehiclesSet.size() > 1) {
                        vehiclesSet.remove(STAY_TRIP_ITEM);
                    }
                    for (String key : vehiclesSet) {
                        sb.append(key).append(",");
                    }
                    model.setValue("vehicles", (Object)sb, i);
                    AmountChangeUtil.updateInOutAmount((IDataModel)model, (int)k, (int)i, (ChangeField)ChangeField.All);
                }
            }
            this.getPageCache().put("isNotFirst", "isNotFirst");
        }
    }

    private int getBetweenDays(Date date1, Date date2) {
        Calendar cal = Calendar.getInstance();
        if (null == date1 || null == date2) {
            return 0;
        }
        cal.setTime(date1);
        long time1 = cal.getTimeInMillis();
        cal.setTime(date2);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }
}

