/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.pool.botp.mobile;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleCache;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.DrawArgs;
import kd.bos.entity.cache.RedisModelCache;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.fi.er.business.daily.reimburse.WriteOffTypeEnum;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.ReimburseUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.formplugin.daily.mobile.common.CommonUtilHelper;
import kd.fi.er.formplugin.daily.mobile.util.CommonViewControlUtil;
import kd.fi.er.formplugin.daily.web.util.WriteOffMoneyUtils;
import kd.fi.er.formplugin.pool.botp.model.BotpDrawParam;
import kd.fi.er.model.FormModel;
import org.apache.commons.lang3.ObjectUtils;

public class RecordPushTripReimburseBillListMobPlugin
extends AbstractMobBillPlugIn {
    private static final Log logger = LogFactory.getLog(RecordPushTripReimburseBillListMobPlugin.class);
    private static final String RECORDPOOLDRAW = "recordpooldraw";
    private static final String RECORDLIST = "er_trip_pool_list_card_mb";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{RECORDPOOLDRAW});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "recordpooldraw": {
                ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry").get(0)).getDataEntityState().setPushChanged(true);
                this.openSelectRecordList();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnObj;
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)RECORDLIST) && (returnObj = closedCallBackEvent.getReturnData()) instanceof BotpDrawParam) {
            BotpDrawParam bdp = (BotpDrawParam)returnObj;
            this.drawRecordToDaily(bdp);
        }
    }

    private void openSelectRecordList() {
        DynamicObject entryCostCompany;
        Map billMap;
        Long company;
        BotpDrawParam bdp = new BotpDrawParam();
        bdp.setSourceEntityNumber("er_expense_recordbill");
        bdp.setTargetEntityNumber("er_tripreimbursebill");
        bdp.setSrcSelectedRecordId(this.getFilterBill());
        FormModel formModel = new FormModel(RECORDLIST, ResManager.loadKDString((String)"\u9009\u62e9\u8d39\u7528\u8bb0\u5f55", (String)"RecordPushTripReimburseBillListMobPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]), "5", true);
        FormShowParameter formShowParameter = formModel.getFormShowParameter();
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, RECORDLIST));
        formShowParameter.setCustomParam("botpDrawParam", (Object)bdp);
        formShowParameter.setCustomParam("checkRightAppId", (Object)"exp");
        if (formShowParameter.getAppId() == null) {
            formShowParameter.setAppId("18X6P1ZSXS44");
        }
        if (SystemParamterUtil.getIsCurrencyShowinTripentry((long)(company = (Long)(billMap = CoreBaseBillServiceHelper.createNewData((Long)Long.valueOf(RequestContext.get().getUserId()))).get("company")))) {
            DynamicObject tripcurrency = (DynamicObject)this.getModel().getValue("tripcurrency");
            formShowParameter.setCustomParam("currencyId", tripcurrency.getPkValue());
        }
        DynamicObject applicant = (DynamicObject)this.getView().getParentView().getModel().getValue("applier");
        formShowParameter.setCustomParam("applicant", applicant.getPkValue());
        company = company != null ? company.longValue() : RequestContext.get().getOrgId();
        String isShowType = (String)ErCommonUtils.getEMParameter((long)company, (String)"expensesassumeshowtypes");
        if (StringUtils.equals((CharSequence)"1", (CharSequence)isShowType)) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex("tripentry");
            entryCostCompany = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry").get(currentRowIndex)).getDynamicObject("entrycostcompany");
        } else {
            entryCostCompany = this.getModel().getDataEntity(true).getDynamicObject("costcompany");
        }
        if (ObjectUtils.isNotEmpty((Object)entryCostCompany)) {
            formShowParameter.setCustomParam("costCompany", entryCostCompany.getPkValue());
        }
        this.getView().showForm(formShowParameter);
    }

    protected Set<Long> getFilterBill() {
        DynamicObjectCollection entryentity;
        HashSet srcRecordId = Sets.newHashSet();
        IDataModel parenView = this.getView().getParentView().getModel();
        DynamicObjectCollection itemColl = parenView.getEntryEntity("tripentry");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("tripentry");
        if (entryEntity == null || entryEntity.size() < 1) {
            return srcRecordId;
        }
        for (DynamicObject row : itemColl) {
            entryentity = (DynamicObjectCollection)row.get("entryentity");
            srcRecordId.addAll(entryentity.stream().map(item -> item.getLong("wbsrcbillid")).collect(Collectors.toSet()));
        }
        for (DynamicObject row : entryEntity) {
            entryentity = (DynamicObjectCollection)row.get("entryentity");
            srcRecordId.addAll(entryentity.stream().map(item -> item.getLong("wbsrcbillid")).collect(Collectors.toSet()));
        }
        return srcRecordId;
    }

    private void drawRecordToDaily(BotpDrawParam bdp) {
        Object refProvider;
        IDataModel model = this.getModel();
        ListSelectedRowCollection selectedRowsColl = bdp.getSelectedRowsColl();
        String sourceEntityNumber = bdp.getSourceEntityNumber();
        String targetEntityNumber = bdp.getTargetEntityNumber();
        if (ErEntityTypeUtils.isTripReimburseBill((String)targetEntityNumber)) {
            targetEntityNumber = "er_tripreimbursebill";
        }
        String ruleId = this.getRuleId(sourceEntityNumber, targetEntityNumber);
        String targetPageId = this.getView().getPageId();
        DrawArgs drawArg = new DrawArgs(sourceEntityNumber, targetEntityNumber, ruleId, (List)selectedRowsColl, targetPageId);
        drawArg.setAppId("18X6P1ZSXS44");
        ConvertOperationResult result = ConvertServiceHelper.draw((DrawArgs)drawArg);
        ArrayList dataEntitysDyn = new ArrayList();
        if (result.isSuccess()) {
            refProvider = new IRefrencedataProvider(){

                public void fillReferenceData(Object[] dataEntitys, IDataEntityType type) {
                    BusinessDataReader.loadRefence((Object[])dataEntitys, (IDataEntityType)type);
                }
            };
            List dataEntitys = result.loadTargetDataObjects(refProvider, (MainEntityType)((BillEntityType)this.getModel().getDataEntityType()));
            dataEntitysDyn.addAll(dataEntitys);
            result.release(refProvider, (MainEntityType)((BillEntityType)this.getModel().getDataEntityType()));
        }
        if (!dataEntitysDyn.isEmpty()) {
            ((IBillModel)model).push(dataEntitysDyn.get(0));
            refProvider = new IRefrencedataProvider(){

                public void fillReferenceData(Object[] dataEntitys, IDataEntityType type) {
                    BusinessDataReader.loadRefence((Object[])dataEntitys, (IDataEntityType)type);
                }
            };
            RedisModelCache modelCache = new RedisModelCache(refProvider, (MainEntityType)((BillEntityType)this.getModel().getDataEntityType()), this.getView().getPageId());
            modelCache.release();
            DynamicObjectCollection tripentrys = model.getDataEntity(true).getDynamicObjectCollection("tripentry");
            if (CollectionUtils.isEmpty((Collection)tripentrys)) {
                logger.error("RecordPushTripReimburseBillListMobPlugin botp \u8f6c\u6362\u9519\u8bef,\u884c\u7a0b\u660e\u7ec6\u4e3a\u7a7a!");
                return;
            }
            if (tripentrys.size() > 1) {
                Object startdate = ((DynamicObject)tripentrys.get(0)).get("startdate");
                Object enddate = ((DynamicObject)tripentrys.get(0)).get("enddate");
                for (int i = 1; i < tripentrys.size(); ++i) {
                    DynamicObject tripentry = (DynamicObject)tripentrys.get(i);
                    DynamicObjectCollection entryentitys = (DynamicObjectCollection)tripentry.get("entryentity");
                    for (int j = 0; j < entryentitys.size(); ++j) {
                        int index = model.createNewEntryRow("entryentity");
                        DynamicObject entryentity = (DynamicObject)entryentitys.get(j);
                        entryentity.getDynamicObjectType().getProperties().forEach(prop -> {
                            String propName = prop.getName();
                            if (!propName.equalsIgnoreCase("seq") && !propName.equalsIgnoreCase("id")) {
                                model.setValue(propName, entryentity.get(propName), index);
                            }
                        });
                        Object taxamount = entryentity.get("taxamount");
                        Object orientryamount = entryentity.get("orientryamount");
                        Object airportconstructionfee = entryentity.get("airportconstructionfee");
                        Object mulseatgrade = ObjectUtils.clone((Object)entryentity.get("mulseatgrade"));
                        Object wbsrcbillid = entryentity.get("wbsrcbillid");
                        Object entrycurrency = entryentity.get("entrycurrency");
                        Object taxrate = entryentity.get("taxrate");
                        ((DynamicObject)((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry").get(0)).getDynamicObjectCollection("entryentity").get(index)).set("id", entryentity.get("id"));
                        model.setValue("entrycurrency", null, index, 0);
                        model.setValue("orientryamount", (Object)0, index, 0);
                        model.setValue("entrycurrency", entrycurrency, index, 0);
                        model.setValue("orientryamount", orientryamount, index, 0);
                        model.setValue("airportconstructionfee", airportconstructionfee, index, 0);
                        model.setValue("mulseatgrade", mulseatgrade, index, 0);
                        model.setValue("wbsrcbillid", wbsrcbillid, index, 0);
                        model.setValue("taxrate", taxrate, index, 0);
                        model.setValue("taxamount", taxamount, index, 0);
                        model.setValue("trip2startdate", startdate, index, 0);
                        model.setValue("trip2enddate", enddate, index, 0);
                    }
                }
                this.getModel().setValue("enddate", null, 0);
                this.getModel().setValue("enddate", enddate, 0);
            }
            int[] tripsize = new int[tripentrys.size() - 1];
            for (int i = 1; i < tripentrys.size(); ++i) {
                tripsize[i - 1] = i;
            }
            InvoiceUtils.outLog((IDataModel)model, (String)"tripentry", (int[])tripsize);
            this.getModel().deleteEntryRows("tripentry", tripsize);
            this.getView().updateView("tripentry");
        }
    }

    private String getRuleId(String sourceEntityNumber, String targetEntityNumber) {
        List loadRules = ConvertRuleCache.loadRules((String)sourceEntityNumber, (String)targetEntityNumber);
        if (!loadRules.isEmpty()) {
            for (ConvertRuleElement rule : loadRules) {
                if (!rule.isEnabled() || !rule.getName().getLocaleValue_zh_CN().contains("\u4e0a\u62c9")) continue;
                return rule.getId();
            }
        }
        return null;
    }

    protected void refreshAccount() {
        IDataModel model = this.getModel();
        String writeOffType = null;
        model.beginInit();
        writeOffType = (String)model.getValue("writeofftype");
        WriteOffMoneyUtils.sortWriteOffEntry((IFormView)this.getView());
        WriteOffMoneyUtils.writeOffMoney((IDataModel)model, (String)writeOffType, (IFormView)this.getView());
        if (WriteOffTypeEnum.ORGI_WO.getValue().equalsIgnoreCase(writeOffType)) {
            int i;
            if (model.getEntryRowCount("writeoffmoney") > 0) {
                for (i = 0; i < model.getEntryRowCount("writeoffmoney"); ++i) {
                    BigDecimal woAmount = (BigDecimal)model.getValue("accloanamount", i);
                    AmountUtils.refreshCurrAmount((IDataModel)model, (BigDecimal)woAmount, (String)"curraccloanamount", (String)"loanexchangerate", (String)"writeoffquotetype", (int)i);
                }
            }
            if (model.getEntryRowCount("writeoffapply") > 0) {
                for (i = 0; i < model.getEntryRowCount("writeoffapply"); ++i) {
                    BigDecimal woApplyAmount = (BigDecimal)model.getValue("reimbursedamount", i);
                    AmountUtils.refreshCurrAmount((IDataModel)model, (BigDecimal)woApplyAmount, (String)"reimbursedcurramount", (String)"applyexchangerate", (String)"writeoffapplyquotetype", (int)i);
                }
            }
        }
        model.endInit();
        CommonUtilHelper.setWriteOffAmountLable(model, this.getView(), new boolean[0]);
        BigDecimal totalOffsetAmount = ReimburseUtils.sumOffsetAmount((IDataModel)model, (IFormView)this.getView());
        model.setValue("totaloffsetamount", (Object)totalOffsetAmount);
        WriteOffMoneyUtils.refreshReceiveAmount((IDataModel)this.getModel(), (String)writeOffType, (IFormView)this.getView());
        CommonViewControlUtil.expensePageRules(model, this.getView());
        CommonViewControlUtil.setExpenseAmount(model, this.getView());
    }
}

