/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.pool.mobile;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;

public class ExpensePoolInfoBillMobPlugin
extends AbstractMobBillPlugIn {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        IFormView pView = this.getView().getParentView();
        IDataModel pvModel = pView.getModel();
        model.setValue("expenseamount", pvModel.getValue("expenseamount"));
        model.setValue("taxrate", pvModel.getValue("taxrate"));
        model.setValue("taxamount", pvModel.getValue("taxamount"));
        model.setValue("orientryamount", pvModel.getValue("orientryamount"));
        model.setValue("currency", pvModel.getValue("currency"));
        model.setValue("happendate", pvModel.getValue("happendate"));
        model.setValue("expenseitem", pvModel.getValue("expenseitem"));
        model.setValue("airportconstructionfee", pvModel.getValue("airportconstructionfee"));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"mbaritemap"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "mbaritemap": {
                this.clickOk();
            }
        }
    }

    private void clickOk() {
        this.getView().getModel().setDataChanged(false);
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put("currency", this.getModel().getValue("currency"));
        returnMap.put("expenseamount", this.getModel().getValue("expenseamount"));
        returnMap.put("taxrate", this.getModel().getValue("taxrate"));
        returnMap.put("taxamount", this.getModel().getValue("taxamount"));
        returnMap.put("happendate", this.getModel().getValue("happendate"));
        returnMap.put("airportconstructionfee", this.getModel().getValue("airportconstructionfee"));
        this.getView().returnDataToParent(returnMap);
        this.getView().sendFormAction(this.getView().getParentView());
        this.getView().close();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "taxamount": {
                this.whenTaxAmountChanged();
                break;
            }
            case "expenseamount": {
                this.whenTaxRateOrExpenseAppAmoutChanged();
                break;
            }
            case "airportconstructionfee": {
                this.whenTaxRateOrExpenseAppAmoutChanged();
                break;
            }
            case "taxrate": {
                this.whenTaxRateOrExpenseAppAmoutChanged();
                break;
            }
        }
    }

    private void whenTaxAmountChanged() {
        IDataModel dataModel = this.getModel();
        BigDecimal expenseAmountAppOri = (BigDecimal)dataModel.getValue("expenseamount");
        BigDecimal taxAmount = (BigDecimal)dataModel.getValue("taxamount");
        BigDecimal noTaxAmount = expenseAmountAppOri.subtract(taxAmount);
        dataModel.beginInit();
        dataModel.setValue("orientryamount", (Object)noTaxAmount);
        dataModel.endInit();
        this.getView().updateView("orientryamount");
    }

    private void whenTaxRateOrExpenseAppAmoutChanged() {
        IDataModel dataModel = this.getModel();
        BigDecimal expenseAmount = (BigDecimal)dataModel.getValue("expenseamount");
        BigDecimal expenseTaxrate = (BigDecimal)dataModel.getValue("taxrate");
        expenseTaxrate = expenseTaxrate.divide(BigDecimal.valueOf(100L), 4, RoundingMode.HALF_EVEN);
        DynamicObject expenseCurrencyDO = (DynamicObject)dataModel.getValue("currency");
        int precision = expenseCurrencyDO.getInt("amtprecision");
        BigDecimal airportConstructionAmount = (BigDecimal)dataModel.getValue("airportconstructionfee");
        BigDecimal taxAmount = expenseAmount.subtract(airportConstructionAmount).multiply(expenseTaxrate).divide(BigDecimal.ONE.add(expenseTaxrate), precision, RoundingMode.HALF_EVEN);
        BigDecimal noTaxAmount = expenseAmount.subtract(taxAmount);
        dataModel.setValue("taxamount", (Object)taxAmount);
        dataModel.setValue("orientryamount", (Object)noTaxAmount);
        this.getView().updateView("taxamount");
        this.getView().updateView("orientryamount");
    }
}

