/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.project;

import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeProjectF7SelectListener;

public abstract class AbstractEntryProjectPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(AbstractEntryProjectPlugin.class);
    private static final String PC_BILL_FLAG = "bill";
    private static final String IS_AFTERADDROW = "isAfterAddRow";
    protected static final String PARAM_PROJECT = "project";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit projectEdit = (BasedataEdit)this.getView().getControl("std_project");
        if (null != projectEdit) {
            projectEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Long userId = this.getFilterUserID(beforeF7SelectEvent.getRow());
        Long companyId = this.getCompanyID();
        if (companyId == null || companyId.compareTo(0L) <= 0) {
            companyId = CommonServiceHelper.getCompanyIdByUserId((Long)userId);
        }
        BeforeProjectF7SelectListener.beforeProjectF7Select(beforeF7SelectEvent, companyId, userId);
    }

    protected Long getFilterUserID(int rowIndex) {
        DynamicObject user = this.isPCBill() ? this.getUserFromBillModel(rowIndex) : this.getUserFromMobAndFormModel(rowIndex);
        if (user != null) {
            return (Long)user.getPkValue();
        }
        return 0L;
    }

    protected Long getCompanyID() {
        DynamicObject company = null;
        if (this.isPCBill()) {
            company = (DynamicObject)this.getModel().getValue("company");
        } else {
            String pageID = this.getView().getFormShowParameter().getParentPageId();
            if (!StringUtils.isEmpty((CharSequence)pageID)) {
                company = (DynamicObject)this.getView().getViewNoPlugin(pageID).getModel().getValue("company");
            }
        }
        if (company != null) {
            return (Long)company.getPkValue();
        }
        return 0L;
    }

    private boolean isPCBill() {
        String modelType = this.getView().getFormShowParameter().getFormConfig().getModelType();
        return modelType.equalsIgnoreCase(PC_BILL_FLAG);
    }

    private DynamicObject getUserFromBillModel(int rowIndex) {
        DynamicObject user;
        IDataModel model = this.getModel();
        if (this.isFilterUserFromEntry().booleanValue()) {
            user = (DynamicObject)model.getValue(this.getFilterUserPropertyName(), rowIndex);
            if (user == null) {
                user = (DynamicObject)model.getValue("applier");
            }
        } else {
            user = (DynamicObject)model.getValue(this.getFilterUserPropertyName());
        }
        return user;
    }

    private DynamicObject getUserFromMobAndFormModel(int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject user = null;
        if (this.isFilterUserFromEntry().booleanValue()) {
            user = (DynamicObject)model.getValue(this.getFilterUserPropertyName(), rowIndex);
            model = this.getView().getParentView().getModel();
            if (user == null) {
                user = (DynamicObject)model.getValue("applier");
            }
        } else {
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                model = parentView.getModel();
                user = (DynamicObject)model.getValue(this.getFilterUserPropertyName());
            }
        }
        return user;
    }

    protected Boolean isFilterUserFromEntry() {
        return Boolean.FALSE;
    }

    protected String getFilterUserPropertyName() {
        return "applier";
    }

    private Set<Long> getProjectIDByUser(Long userID) {
        Object result = null;
        try {
            result = DispatchServiceHelper.invokeBizService((String)"pmgt", (String)"pmas", (String)"ProjectService", (String)"getPermissionProjects", (Object[])new Object[]{String.valueOf(userID)});
        }
        catch (KDBizException e) {
            logger.error("\u8c03\u7528\u9879\u76ee\u4e91\u6839\u636e\u4eba\u5458\u83b7\u53d6\u9879\u76eeID\u51fa\u9519:" + (Object)((Object)e));
        }
        return (Set)result;
    }

    public void afterCreateNewData(EventObject e) {
        this.setProjectAfterCreateNewData();
    }

    protected abstract String getEntryNumOfProject();

    protected void setProjectAfterCreateNewData() {
        Map paraMap = this.getView().getFormShowParameter().getCustomParams();
        Object projectId = paraMap.get(PARAM_PROJECT);
        if (projectId != null) {
            IDataModel model = this.getModel();
            int entrySize = model.getEntryRowCount(this.getEntryNumOfProject());
            for (int i = 0; i < entrySize; ++i) {
                model.setValue("std_project", projectId, i);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        int rowIndex = valueSet[0].getRowIndex();
        IPageCache pageCache = this.getPageCache();
        if (fieldName.equalsIgnoreCase("entrycostcompany") && !Boolean.parseBoolean(pageCache.get(IS_AFTERADDROW))) {
            this.clearExpenseEntryProject(rowIndex);
            pageCache.put(IS_AFTERADDROW, null);
        }
    }

    protected void clearExpenseEntryProject(int rowIndex) {
        IDataModel model = this.getModel();
        Object project = model.getValue("std_project", rowIndex);
        if (project == null) {
            return;
        }
        model.setValue("std_project", null, rowIndex);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        Map paraMap = this.getView().getFormShowParameter().getCustomParams();
        Object projectId = paraMap.get(PARAM_PROJECT);
        if (projectId != null && entryName.equals(this.getEntryNumOfProject())) {
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            IDataModel model = this.getModel();
            for (RowDataEntity rowData : rowDataEntities) {
                Object project = rowData.getDataEntity().get("std_project");
                if (project != null) continue;
                int index = rowData.getRowIndex();
                model.setValue("std_project", projectId, index);
            }
            this.getPageCache().put(IS_AFTERADDROW, "true");
        }
    }
}

