/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.project;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.fi.er.business.pub.PublicBillUtil;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.sysparam.UnitShowTypeEnum;
import org.apache.commons.lang3.StringUtils;

public class ErProjectUnitPlugIn
extends AbstractBillPlugIn {
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.setFirstErItem("wltype");
        this.setFirstErProjectItem("wlunit");
    }

    public void setFirstErItem(String type) {
        String item;
        DynamicObject total = this.getModel().getDataEntity(true);
        String wltype = total.getString(type);
        DynamicObjectCollection expenseentryentity = total.getDynamicObjectCollection("expenseentryentity");
        if (expenseentryentity.size() > 0 && !Objects.isNull(item = ((DynamicObject)expenseentryentity.get(0)).getString(PublicBillUtil.getProp((String)type))) && !item.equals(wltype)) {
            this.getModel().setValue(type, (Object)item);
        }
    }

    public void setFirstErProjectItem(String type) {
        DynamicObject item;
        DynamicObjectCollection expenseentryentity;
        DynamicObject total = this.getModel().getDataEntity(true);
        DynamicObject wltype = total.getDynamicObject(type);
        if (Objects.isNull(wltype) && (expenseentryentity = total.getDynamicObjectCollection("expenseentryentity")).size() > 0 && !Objects.isNull(item = ((DynamicObject)expenseentryentity.get(0)).getDynamicObject(PublicBillUtil.getProp((String)type)))) {
            this.getModel().setValue(type, item.getPkValue());
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        this.refreshUnitShow(company);
    }

    private void refreshUnitShow(DynamicObject company) {
        UnitShowTypeEnum type = SystemParamterUtil.getUnitShowTypes((Long)(company == null ? Long.valueOf(0L) : (Long)company.getPkValue()));
        if (this.getModel().getProperty("unitshowtypes") != null && type != null) {
            this.getModel().setValue("unitshowtypes", (Object)type.getValue());
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryProp = e.getEntryProp().getName();
        if (entryProp.equals("expenseentryentity") && PublicBillUtil.isHeadUnit((IDataModel)this.getModel())) {
            this.refreshEntryUnitByHead();
        }
    }

    private void refreshEntryUnitByHead() {
        this.setEntryUnit("wltype", this.getModel().getValue("wltype"));
        this.setEntryUnit("wlunit", this.getModel().getValue("wlunit"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        int rowIndex = changeSet[0].getRowIndex();
        switch (key) {
            case "company": {
                this.refreshUnitShow((DynamicObject)newValue);
                this.refreshEntryUnitByHead();
                break;
            }
            case "entrywlunit": 
            case "entrywltype": {
                PublicBillUtil.setHeadUnit((int)rowIndex, (IFormView)this.getView(), (Object)newValue, (String)key);
                if (!"entrywltype".equals(key)) break;
                this.getModel().beginInit();
                if (rowIndex == 0) {
                    this.getModel().setValue("wlunit", (Object)"");
                    this.getView().updateView("wlunit");
                }
                this.getModel().endInit();
                break;
            }
            case "wlunit": 
            case "wltype": {
                if (PublicBillUtil.isHeadUnit((IDataModel)this.getModel())) {
                    this.setEntryUnit(key, newValue);
                }
                if (!"wltype".equals(key) || !PublicBillUtil.isHeadUnit((IDataModel)this.getModel())) break;
                this.getModel().beginInit();
                int count = this.getModel().getEntryRowCount("expenseentryentity");
                for (int index = 0; index < count; ++index) {
                    this.getModel().setValue("entrywlunit", (Object)"", index);
                    this.getView().updateView("entrywlunit", index);
                }
                this.getModel().endInit();
                break;
            }
        }
    }

    private void setEntryUnit(String key, Object newValue) {
        this.getModel().beginInit();
        int count = this.getModel().getEntryRowCount("expenseentryentity");
        for (int index = 0; index < count; ++index) {
            this.getModel().setValue(PublicBillUtil.getProp((String)key), newValue, index);
            this.getView().updateView(PublicBillUtil.getProp((String)key), index);
        }
        this.getModel().endInit();
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        UnitShowTypeEnum type = SystemParamterUtil.getUnitShowTypes((Long)(company == null ? Long.valueOf(0L) : (Long)company.getPkValue()));
        if ("expenseentryentity".equals(entryName)) {
            int[] rowIndexs;
            for (int row : rowIndexs = e.getRowIndexs()) {
                if (row != 0) continue;
                int count = this.getModel().getEntryRowCount("expenseentryentity");
                if (count <= 0 || !StringUtils.equals((CharSequence)type.getValue(), (CharSequence)"0")) break;
                Object entrywltype = this.getModel().getValue("entrywltype", 0);
                Object entrywlunit = this.getModel().getValue("entrywlunit", 0);
                if (entrywltype == null) break;
                this.getModel().beginInit();
                this.getModel().setValue("wltype", entrywltype);
                this.getModel().setValue("wlunit", entrywlunit);
                this.getModel().endInit();
                this.getView().updateView("wltype");
                this.getView().updateView("wlunit");
                break;
            }
        }
    }
}

