/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.publicbiz.basedata;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.utils.ErStdConfig;

public class ProjectTypeEdit
extends AbstractBasePlugIn
implements ItemClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"editbilltype"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initErBillType();
    }

    private void initErBillType() {
        DynamicObject[] billTypes = BusinessDataServiceHelper.load((String)"er_billtype", (String)"id,bizappid.id", (QFilter[])new QFilter("enable", "=", (Object)Boolean.TRUE).toArray());
        this.getModel().deleteEntryData("billtypeentry");
        DynamicObjectCollection relbills = (DynamicObjectCollection)this.getModel().getValue("relbill");
        List relbillids = relbills.stream().map(e -> (Long)e.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
        this.getModel().beginInit();
        for (DynamicObject billType : billTypes) {
            int rowIndex = this.getModel().createNewEntryRow("billtypeentry");
            this.getModel().setValue("billtypenumber", billType.getPkValue(), rowIndex);
            this.getModel().setValue("billtypename", billType.getPkValue(), rowIndex);
            this.getModel().setValue("bizappid", billType.get("bizappid.id"), rowIndex);
            if (!relbillids.contains(billType.getPkValue())) continue;
            this.getModel().setValue("setrelate", (Object)true, rowIndex);
        }
        this.getModel().endInit();
        EntryGrid entry = (EntryGrid)this.getControl("billtypeentry");
        entry.setPageIndex(1);
        this.getView().updateView("billtypeentry");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        switch (propName) {
            case "setrelate": {
                int billtypeentryindex = model.getEntryCurrentRowIndex("billtypeentry");
                DynamicObject billtypeentry = model.getEntryRowEntity("billtypeentry", billtypeentryindex);
                DynamicObjectCollection relbills = (DynamicObjectCollection)this.getModel().getValue("relbill");
                Set relbillids = relbills.stream().map(a -> (Long)a.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
                Long currbilltypeid = (Long)billtypeentry.get("billtypenumber.id");
                if (Boolean.TRUE.equals(newValue)) {
                    relbillids.add(currbilltypeid);
                } else {
                    relbillids.remove(currbilltypeid);
                }
                model.setValue("relbill", (Object)relbillids.toArray());
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "editbilltype": {
                this.openEditBillType();
                break;
            }
        }
    }

    private void openEditBillType() {
        ListShowParameter formShowParameter;
        ListShowParameter listShowParameter = formShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("er_billtype");
        listShowParameter.setFormId("bos_list");
        listShowParameter.setLookUp(false);
        listShowParameter.setListFilterParameter(null);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u8d39\u7528\u5355\u636e\u7c7b\u578b", (String)"ProjectTypeEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "er_billtype"));
        formShowParameter.setShowTitle(true);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("er_billtype".equalsIgnoreCase(closedCallBackEvent.getActionId())) {
            this.initErBillType();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        Object source = args.getSource();
        switch (operateKey) {
            case "save": {
                if (!ErStdConfig.getBoolean((String)"projecttype.expensetemset")) break;
                DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                Set itemset = entrys.stream().map(v -> (DynamicObject)v.get("expenseitem") != null ? ((DynamicObject)v.get("expenseitem")).getPkValue() : null).collect(Collectors.toSet());
                QFilter qFilter = new QFilter("entryentity.expenseitem", "in", itemset);
                qFilter.and("id", "not in", this.getModel().getValue("id"));
                DynamicObject[] expenseitemcount = BusinessDataServiceHelper.load((String)"er_projecttype", (String)"id,entryentity,entryentity.expenseitem", (QFilter[])new QFilter[]{qFilter});
                HashSet expenseitem = new HashSet(expenseitemcount.length);
                if (expenseitemcount.length <= 0) break;
                args.setCancel(true);
                Arrays.stream(expenseitemcount).forEach(k -> k.getDynamicObjectCollection("entryentity").forEach(b -> {
                    if (b.get("expenseitem") != null && itemset.contains(((DynamicObject)b.get("expenseitem")).getPkValue())) {
                        expenseitem.add(b.get("expenseitem") != null ? ((DynamicObject)b.get("expenseitem")).get("number") : null);
                    }
                }));
                String infostr = String.format(ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u7f16\u7801\u201c%s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"ProjectTypeEdit_1", (String)"fi-er-formplugin", (Object[])new Object[0]), ((Object)expenseitem).toString());
                this.getView().showTipNotification(infostr);
                return;
            }
        }
    }
}

